unit uGraphUtils;
//--------------------------------------------------------------------
//Unti utilitaire: GraphUtils
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:23 Novembre 2002
//--------------------------------------------------------------------

//Fonctions utiles pour graphiques
//Ce fichier contient des procdures et des classes d'utilit gnrale
//Si vous chercher du code utile pour faire un copier coller vers une
//de vos application, c'est l'endroit idal pour regarder

//Par: Tommy Brire                          Creer le: 19 Juillet 2001
//                               Dernire mise  jour: 27 Octobre 2002
interface

Uses Windows, Classes, graphics, Clipbrd, SysUtils, Dialogs;

//Fontion utile pas seulement a ce programme
function CreerRect(X1, Y1, X2, Y2:Integer):TRect;
Function AjouterEspacement(const Rect:TRect; const Espacement:SmallInt):TRect;
Function Couleur32BitA16Bit(Const Color : TColor):Word;
Function Couleur16BitA32Bit(Const Color : Word):TColor;
function Convertir(Const Source:TBitmap; const Format:TPixelFormat):TBitmap;
Procedure Interpolation16Bit(Const ImageSource:TBitmap;Var Dest:TBitmap; const Largeur, Hauteur:Integer);
Procedure Interpolation24Bit(Const ImageSource:TBitmap;Var Dest:TBitmap; const Largeur, Hauteur:Integer);
Procedure Interpolation32Bit(Const ImageSource:TBitmap;Var Dest:TBitmap; const Largeur, Hauteur:Integer);
procedure echanger(var x,y:Integer);
Function FTRunc(Const Don : Single) : Byte;
Function FTruncDW(Const Don : Single) : LongInt;
Function FTruncDWS(Const Don : Single) : LongInt;

Type
  PTBitmap = ^TBitmap;

  PByte = ^Byte;

  RGB = record
    rouge, vert, bleu : Byte;
  end;

  WRGB = record
    rouge, vert, bleu : Word;
  end;

  SWRGB = record
    rouge, vert, bleu : SmallInt;
  end;

Function Dimensionner(Source: TBitmap; Const Format:TPixelFormat;
         Const Palette:HPalette; Const Largeur, Hauteur: Integer):TBitmap;
procedure WRGBDiv(var Coul : WRGB; const diviseur : word);
procedure SWRGBDiv(var Coul : WRGB; const diviseur : word); overload;
procedure SWRGBDiv(var Coul : SWRGB; const diviseur : word); overload;
procedure SWRGBMul(var Coul : WRGB; const multiplicateur : word); overload;
procedure SWRGBMul(var Coul : SWRGB; const multiplicateur : word); overload;
procedure SWRGBSoustraire(Var Coul : SWRGB; const coul2 : SWRGB);
Function ColorToWRGB(Coul : TColor) : WRGB;
Function ColorToSWRGB(Coul : TColor) : SWRGB;
Function WRGBToColor(Coul : WRGB) : TColor;
Function SoustraireCoul(Const col1, col2 : TColor) : TColor;
Function MaxChangeCol(Const col : TColor) : smallInt; overload;
Function MaxChangeCol(Const col : SWRGB) : smallInt; overload;
Function SoustraireCoulR(Const col1, col2 : TColor) : TColor;
Function AdditionnerCoulR(Const col1, col2 : TColor) : TColor;
//Function SoustraireCoul(Const col1, col2 : TColor) : TColor;
Function mulCoul(Const Coul : TColor; Const qtMul : Byte) : TColor;
Function AdditionnerCoul(Const col1, col2 : TColor) : TColor;
Function divCoul(Const Coul : TColor; Const qtDiv : Byte) : TColor;

implementation
//*****************ATTENTION**************************
//****************************************************
//Contrairement a TRUNC de delphi, mes fonctions de troncature n'on pas
//une fiabilit de 100%(Je veux dire que la rponse peu tre erron)

{C'est la version non assembleur de la super fonction
 de Troncature.
 Est seulement ici pour consultation par le programmeur
Function FTrunc(Const Don : Single) : Byte;
Var Expo : Byte;
    Pt   : ^Byte;
 Begin
   //Pt     := Pointer(LongInt(@Don) + 2);
   Pt     := @Don;
   Inc(Pt);
   Inc(Pt);
   Result := Pt^;
   Inc(Pt);
   Expo   := (Pt^ shl 1) + (Result shr 7) - 127;
   Result := ((Result Or 128) shr (7 - Expo));
 End;}

//Cette super fonction permet de rapidement obtenir
//la partie entire d'une donne
//Pour que a soit vite, il n'y a pas de gestion d'erreur et
//C'EST EN ASSEMBLEUR!
Function FTrunc(Const Don : Single) : Byte;
// but can freely modify the EAX, ECX, and EDX registers
 ASM
     //A optimis extration du chiffre a virgule
     Mov CX, [EBP + $0A]

     //Extraction de la mantisse
     Mov AL, CL

     //Dans CX, on l'exposant en notation phoqu,
     //on fait un rol pour qu'il soit dans cl
     ROL CX, 9
     SUB CL, 135//On lui enleve 127 parce dans ce systme l'expo est add de 127
                //Et, en mme temps, on lui soustrait les qt qui devrait normalement
                //tre ajout aprs (1 pour le changement de signe et 7 pour)
     //XOR CL, $FF
     NOT CL

     OR AL, 128
     SHR AL, CL
 End;

//Cette super fonction permet de rapidement obtenir
//la partie entire d'une donne
//Pour que a soit vite, il n'y a pas de gestion d'erreur et
//C'EST EN ASSEMBLEUR!
{Function FTruncDW(Const Don : Single) : LongInt;
 ASM
     //A optimis extration du chiffre a virgule
     Mov ECX, Don
     //Extraction de la mantisse
     Mov EAX, ECX
     ROL ECX, 16


     //Dans CX, on l'exposant en notation phoqu,
     //on fait un rol pour qu'il soit dans cl
     ROL CX, 9
     SUB CL, 151//On lui enleve 127 parce dans ce systme l'expo est add de 127
                //Et, en mme temps, on lui soustrait les qt qui devrait normalement
                //tre ajout aprs (1 pour le changement de signe et 31 pour)
     XOR CL, $FF//On a un ngatif, alors on l'inverse pout faire un positif(1 ajout a l'tape d'avant)

     OR EAX, (128 shl 16)
     AND EAX, $00FFFFFF;//On enlve la mantisse pour viter les chiffres phoqu
     SHR EAX, CL
 End;}

//Cette super fonction permet de rapidement obtenir
//la partie entire d'une donne
//Pour que a soit vite, il n'y a pas de gestion d'erreur et
//C'EST EN ASSEMBLEUR!
Function FTruncDW(Const Don : Single) : LongInt;
 ASM
     Mov EAX, Don
     Mov ECX, EAX
     ROL ECX, 16

     //Dans CX, on l'exposant en notation phoqu,
     //on fait un rol pour qu'il soit dans cl
     ROL CX, 9
     SUB CL, 159//On lui enleve 127 parce dans ce systme l'expo est add de 127
                //Et, en mme temps, on lui soustrait les qt qui devrait normalement
                //tre ajout aprs (1 pour le changement de signe et 39 pour)
     NOT CL//On a un ngatif, alors on l'inverse pout faire un positif(1 ajout a l'tape d'avant)

     OR EAX, (128 shl 16)
     SHL EAX, 8

     SHR EAX, CL
 End;

//Avec gestion des ngatifs et des chiffres entre -1 et 1!
//Cette fonction est la plus lente, mais c'est elle qui gre le plus de cas
//(est la plus fiable de mes procdure de troncature)
//C'EST EN ASSEMBLEUR!
Function FTruncDWS(Const Don : Single) : LongInt;
 ASM
     Mov EAX, Don
     Mov ECX, EAX
     ROL ECX, 16

     //Dans CX, on l'exposant en notation phoqu,
     //on fait un rol pour qu'il soit dans cl
     ROL CX, 9
     SUB CL, 159//On lui enleve 127 parce dans ce systme l'expo est add de 127
                //Et, en mme temps, on lui soustrait les qt qui devrait normalement
                //tre ajout aprs (1 pour le changement de signe et 39 pour)
     NOT CL     //On a un ngatif, alors on l'inverse pout faire un positif(1 ajout a l'tape d'avant)

     //Correction des chiffres trop petit
     CMP CL, 32
     JB @OK
     XOR EAX, EAX//On a un chiffre < 1 alors on met eax  zro en utilisant moyen optimis!
     JMP @fin
     @OK:

     OR EAX, (128 shl 16)
     SHL EAX, 8

     SHR EAX, CL

     SHR CH, 1//Vrifie si c'est un ngatif
     JNC @fin
     NOT EAX
     ADD EAX, 1
     @fin:
 End;

//chande deux valeurs
procedure echanger(var x,y:Integer);
var i:integer;
begin
  i:=X;
  X:=Y;
  Y:=i;
end;

//Cre un rectangle avec la Fonction rect
//S'assure que X1<X2 et Y1<Y2 et change les valeur en cas de besoin
function CreerRect(X1, Y1, X2, Y2:Integer):TRect;
begin
  if X1>X2 then
     echanger(X1,X2);
  if Y1>Y2 then
     echanger(Y1,Y2);
  Result:=Rect(X1, Y1, X2, Y2);
end;

//Ajoute un espace autour d'un rectangle
function AjouterEspacement(Const Rect:TRect; const Espacement:SmallInt):TRect;
begin
  Result.Left   := Rect.Left   - Espacement;
  Result.Top    := Rect.Top    - Espacement;
  Result.Right  := Rect.Right  + Espacement;
  Result.Bottom := Rect.Bottom + Espacement;
end;

//Convertit une couleur 32Bit en couleur 16Bit
Function Couleur32BitA16Bit(Const Color : TColor):Word;
Var PByte : ^Byte;
Const Rouge = 31 / 255;
      Vert  = 63 / 255;
      Bleu  = 31 / 255;
 Begin
   PByte := @Color;
   Result := Round(PByte^ * Rouge) SHL 11;
   Inc(PByte);
   Result := Result + Round(PByte^ * Vert) SHL 5;
   Inc(PByte);
   Result := Result + Round(PByte^ * Bleu);
 End;

//Convertit une couleur 32Bit en couleur 16Bit
Function Couleur16BitA32Bit(Const Color : Word):TColor;
Var PByte : ^Byte;
Const Rouge = 255 / 31 / 2048;
      Vert  = 255 / 63 / 32;
      Bleu  = 255 / 31;
 Begin
   //PByte^ := Round((Color And $001F) * 255/31);//Rouge
   //PByte^ := Round(((Color And $07E0) SHR 5)* 255/63);//Vert
   //PByte^ := Round(((Color And $F800) SHR 11)* 255/31);//Bleu
   //Versin optimis
   PByte := @Result;
   PByte^ := Round((Color And $F800) * Rouge);
   Inc(PByte);
   PByte^ := Round((Color And $07E0) * Vert);
   Inc(PByte);
   PByte^ := Round((Color And $001F) * Bleu);
   Inc(PByte);
   PByte^ := 0;
 End;

//Transforme la couleur en WRGB
Function ColorToWRGB(Coul : TColor) : WRGB;
Var P : PByte;
 begin
   P := @Coul;
   result.rouge := P^ shl 8;
   Inc(P);
   result.vert  := P^ shl 8;
   Inc(P);
   result.bleu  := P^ shl 8;
 end;

//Transforme la couleur en SWRGB
Function ColorToSWRGB(Coul : TColor) : SWRGB;
Var P : PByte;
 begin
   P := @Coul;
   result.rouge := P^ shl 7;
   Inc(P);
   result.vert  := P^ shl 7;
   Inc(P);
   result.bleu  := P^ shl 7;
 end;

//Transforme la couleur sour format WRGB en TCOLOR
Function WRGBToColor(Coul : WRGB) : TColor;
Var P : PByte;
 begin
   P := @result;
   P^ := Coul.rouge shr 8;
   Inc(P);
   P^ := Coul.vert  shr 8;
   Inc(P);
   P^ := Coul.bleu  shr 8;
   Inc(P);
   P^ := 0;
 end;

//divise une couleur WRGB par diviseur
procedure WRGBDiv(var Coul : WRGB; const diviseur : word);
 begin
   Coul.rouge := Coul.rouge div diviseur;
   Coul.vert  := Coul.vert  div diviseur;
   Coul.bleu  := Coul.bleu  div diviseur;
 end;

//divise une couleur WRGB par diviseur
//Cette version prend en compte le signe!
// utiliser pour les delta
procedure SWRGBDiv(var Coul : WRGB; const diviseur : word);
 begin
   with SWRGB(Coul) do
    begin
      rouge := rouge div diviseur;
      vert  := vert  div diviseur;
      bleu  := bleu  div diviseur;
    end;
 end;

//divise une couleur WRGB par diviseur
//Cette version prend en compte le signe!
// utiliser pour les delta
procedure SWRGBDiv(var Coul : SWRGB; const diviseur : word);
 begin
   with coul do
    begin
      rouge := rouge div diviseur;
      vert  := vert  div diviseur;
      bleu  := bleu  div diviseur;
    end;
 end;

//multiplie une couleur WRGB par multiplicateur
//Cette version prend en compte le signe!
// utiliser pour les delta
procedure SWRGBMul(var Coul : WRGB; const multiplicateur : word);
 begin
   with SWRGB(Coul) do
    begin
      rouge := rouge * multiplicateur;
      vert  := vert  * multiplicateur;
      bleu  := bleu  * multiplicateur;
    end;
 end;

procedure SWRGBMul(var Coul : SWRGB; const multiplicateur : word);
 begin
   with SWRGB(Coul) do
    begin
      rouge := rouge * multiplicateur;
      vert  := vert  * multiplicateur;
      bleu  := bleu  * multiplicateur;
    end;
 end;

//Effectue une soustration
procedure SWRGBSoustraire(Var Coul : SWRGB; const coul2 : SWRGB);
 begin
   dec(coul.Rouge, coul2.rouge);
   dec(coul.VERT,  coul2.Vert);
   dec(coul.Bleu, coul2.Bleu);
 end;

Function divCoul(Const Coul : TColor; Const qtDiv : Byte) : TColor;
Var pSource, pDest : PByte;
    I : Byte;
 Begin
   PSource := @Coul;
   PDest   := @Result;
   For I := 1 to 3 Do
    Begin
      pDest^ := pSource^ div qtDiv;
      Inc(pSource);
      Inc(pdest);
    End;
   pDest^ := 0;
 End;

//Retourne la couleur multipli par: qtMul / 255
Function mulCoul(Const Coul : TColor; Const qtMul : Byte) : TColor;
Var pSource, pDest : PByte;
    I : Byte;
 Begin
   PSource := @Coul;
   PDest   := @Result;
   For I := 1 to 3 Do
    Begin
      pDest^ := (pSource^ * qtMul) shr 8;
      Inc(pSource);
      Inc(pdest);
    End;
   pDest^ := 0;
 End;

//Additionne deux couleurs
Function AdditionnerCoul(Const col1, col2 : TColor) : TColor;
Var pc1, pc2, pDest : PByte;
    I : Byte;
 Begin
   Pc1  := @Col1;
   Pc2  := @Col2;
   pDest := @Result;
   For I := 1 to 3 Do
    Begin
      pDest^ := pc1^ + pc2^;
      Inc(pc1);
      Inc(pc2);
      Inc(pdest);
    End;
   pDest^ := 0;
 End;

//Additionne deux couleurs
Function AdditionnerCoulR(Const col1, col2 : TColor) : TColor;
Var pc1, pc2, pDest : PByte;
    I : Byte;
 Begin
   Pc1  := @Col1;
   Pc2  := @Col2;
   pDest := @Result;
   For I := 1 to 3 Do
    Begin
      pDest^ := pc1^ + pc2^;
      if pDest^ < pc1^ Then//Vrification dbordement
         pDest^ := 255;
      Inc(pc1);
      Inc(pc2);
      Inc(pdest);
    End;
   pDest^ := 0;
 End;

//Additionne deux couleurs
Function SoustraireCoul(Const col1, col2 : TColor) : TColor;
Var pc1, pc2, pDest : PByte;
    I : Byte;
 Begin
   Pc1  := @Col1;
   Pc2  := @Col2;
   pDest := @Result;
   For I := 1 to 3 Do
    Begin
      pDest^ := pc1^ - pc2^;
      Inc(pc1);
      Inc(pc2);
      Inc(pdest);
    End;
   pDest^ := 0;
 End;

//Additionne deux couleurs
Function SoustraireCoulR(Const col1, col2 : TColor) : TColor;
Var pc1, pc2, pDest : PByte;
    I : Byte;
 Begin
   Pc1  := @Col1;
   Pc2  := @Col2;
   pDest := @Result;
   For I := 1 to 3 Do
    Begin
      pDest^ := pc1^ - pc2^;
      if pDest^ > pc1^ Then//Vrification dbordement
         pDest^ := 0;
      Inc(pc1);
      Inc(pc2);
      Inc(pdest);
    End;
   pDest^ := 0;
 End;

//Retourne le plus grand changement de couleur
Function MaxChangeCol(Const col : TColor) : smallInt;
Var p : ^ShortInt;
    I : Byte;
 Begin
   P  := @Col;
   result := 0;
   For I := 1 to 3 Do
    Begin
      inc(p);
      if ABS(p^)>result then
         result := ABS(p^);
    End;
 End;

//Retourne le plus grand changement de couleur
Function MaxChangeCol(Const col : SWRGB) : smallInt;
Var p : ^SmallInt;
    I : Byte;
    dif : smallInt;
 Begin
   P  := @Col;
   dif := 0;
   For I := 1 to 3 Do
    Begin
      inc(p);
      if ABS(p^)>dif then
         dif := ABS(p^);
    End;
   result := (dif shr 7);
 End;

//Retourne un nouveau bitmap contenant l'image dans le format spcifi
function Convertir(Const Source:TBitmap; const Format:TPixelFormat):TBitmap;
begin
  result:=TBitmap.Create;
  result.PixelFormat := Format;
  result.Height      := Source.Height;
  result.Width       := Source.Width;
  result.Canvas.Draw(0, 0, Source);
end;

//Cette fonction retourne en sortie l'image
//dans le format ,la largeur et la hauteur voulu
//NOTE: si le format est 16bit, 24bit ou 32 bit, l'image sera interpol
Function Dimensionner(Source: TBitmap; Const Format:TPixelFormat;
Const Palette:HPalette; Const Largeur, Hauteur: Integer):TBitmap;
Begin
  If Source.PixelFormat <> pf24Bit Then//La source doit tre en 24 Bit pour
   Begin                               //pouvoir faire l'interpolation
     Source := Convertir(Source, pf24Bit);//Est-ce Ok de faire a?
   End;
  Result        := TBitmap.Create;
  Result.HandleType := bmDDB;
  Result.PixelFormat := Format;
  Result.Palette := Palette;
  Result.IgnorePalette := False;
  Result.Width  := Largeur;
  Result.Height := Hauteur;
  If (Source.Width = Largeur) And (Source.Height = Hauteur) Then
   Begin
     Result.Canvas.Draw(0, 0, Source);
   End
  Else
   Begin
     Case Format of
       pf16Bit:
         Interpolation16Bit(Source, Result, Largeur, Hauteur);
       pf24Bit:
         Interpolation24Bit(Source, Result, Largeur, Hauteur);
       pf32Bit:
         Interpolation32Bit(Source, Result, Largeur, Hauteur);
     Else
       Result.Canvas.StretchDraw(Rect(0, 0, Largeur, Hauteur), Source);
     End
   End;
End;

//Cette procdure retourne une image ayant la hauteur voulu
//Utilise l'interpolation!
//Shma de couleurs 16Bit
//*2048 Rouge  5 Bit
//*32 Vert     6 Bit
//*0 Bleu      5 Bit
Procedure Interpolation16Bit(Const ImageSource:TBitmap; Var Dest:TBitmap; const Largeur, Hauteur:Integer);
var pbaSUp, pbaSDown:PByteArray;
    pwaDest:PWordArray;
    SourceX, SourceY, IncY, IncX, qtUp, qtDown, qtGauche, qtDroite:Double;
    DestX, DestY, TempX, Couleur:Word;
begin
  If (Hauteur <> Dest.Height) Or (Largeur <> Dest.Width) Or (Dest.PixelFormat <> pf16Bit) Then
   Begin
     MessageDlg('Beep ! ! 1', mtError, [mbOk], 0);
     Exit;
   End;
   //Dest.PixelFormat;
  IncY := ImageSource.Height / Hauteur;//La longueur des pas  faire dans l'image
  IncX := ImageSource.Width / Largeur;//source
  DestY:=0;
  SourceY:=0;
  while DestY < Hauteur do
   begin
     TempX:=Trunc(SourceY);
     pbaSUp:=ImageSource.ScanLine[TempX];
     Inc(TempX);
     if TempX>=ImageSource.Height then
        Dec(TempX);
     pbaSDown:= ImageSource.ScanLine[TempX];
     pwaDest := Dest.ScanLine[DestY];
     qtDown  := SourceY-Trunc(SourceY);
     qtUp    := 1-qtDown;
     DestX   := 0;
     SourceX := 0;
     while DestX < Largeur do
      begin
        TempX    := Trunc(SourceX);
        qtDroite := SourceX-TempX;
        qtGauche := 1-QtDroite;
        TempX    := TempX*3;

        //Calcul de la couleur interpol
        Couleur:=Trunc(((pbaSUp[TempX]*qtUp + pbaSDown[TempX]*qtDown)*qtGauche +
                        (pbaSUp[TempX+3]*qtUp + pbaSDown[TempX+3]*qtDown)*qtDroite) *31/255);//Bleu
        Inc(TempX);
        Couleur:=Couleur + Trunc(((pbaSUp[TempX]*qtUp + pbaSDown[TempX]*qtDown)*qtGauche +
                                  (pbaSUp[TempX+3]*qtUp + pbaSDown[TempX+3]*qtDown)*qtDroite)*63/255)*32;//Vert
        Inc(TempX);
        Couleur:=Couleur + Trunc(((pbaSUp[TempX]*qtUp + pbaSDown[TempX]*qtDown)*qtGauche +
                                  (pbaSUp[TempX+3]*qtUp + pbaSDown[TempX+3]*qtDown)*qtDroite)*31/255)*2048;//Rouge
        pwaDest[DestX] := Couleur;

        SourceX:=SourceX + IncX;//On passe au prochain point
        Inc(DestX);
      end;
     SourceY := SourceY + IncY;//On passe a la prochaine ligne
     Inc(DestY);
   end;
end;

//Cette procdure retourne une image ayant la hauteur voulu
//Utilise l'interpolation!
//Shma de couleurs 24Bit
//* Rouge, Vert, Bleu
Procedure Interpolation24Bit(Const ImageSource:TBitmap; Var Dest:TBitmap; const Largeur, Hauteur:Integer);
var pbaSUp, pbaSDown, pbaDest:PByteArray;
    SourceX, SourceY, IncY, IncX, qtUp, qtDown, qtGauche, qtDroite:Double;
    DestY, DestX, TempX, Largeur3:Word;
begin
  If (Hauteur <> Dest.Height) Or (Largeur <> Dest.Width) Or (Dest.PixelFormat <> pf24Bit) Then
   Begin
     MessageDlg('Beep ! ! 1', mtError, [mbOk], 0);
     Exit;
   End;
  IncY := ImageSource.Height / Hauteur;//La longueur des pas  faire dans l'image
  IncX := ImageSource.Width / Largeur;//source
  Largeur3 := Largeur * 3;
  DestY:=0;
  SourceY:=0;
  while DestY < Hauteur do
   begin
     TempX:=Trunc(SourceY);
     pbaSUp:=ImageSource.ScanLine[TempX];
     Inc(TempX);
     if TempX>=ImageSource.Height then
        Dec(TempX);
     pbaSDown:= ImageSource.ScanLine[TempX];
     pbaDest := Dest.ScanLine[DestY];
     qtDown  := SourceY-Trunc(SourceY);
     qtUp    := 1-qtDown;
     DestX := 0;
     SourceX := 0;
     while DestX < Largeur3 do
      begin
        TempX    := Trunc(SourceX);
        qtDroite := SourceX-TempX;
        qtGauche := 1-QtDroite;
        TempX := TempX * 3;

        //Calcul de la couleur interpol
        pbaDest[DestX] := Trunc(((pbaSUp[TempX]*qtUp + pbaSDown[TempX]*qtDown)*qtGauche +
                          (pbaSUp[TempX+3]*qtUp + pbaSDown[TempX+3]*qtDown)*qtDroite));//Bleu
        Inc(TempX);
        Inc(DestX);
        pbaDest[DestX] := Trunc(((pbaSUp[TempX]*qtUp + pbaSDown[TempX]*qtDown)*qtGauche +
                                  (pbaSUp[TempX+3]*qtUp + pbaSDown[TempX+3]*qtDown)*qtDroite));//Vert
        Inc(TempX);
        Inc(DestX);
        pbaDest[DestX] := Trunc(((pbaSUp[TempX]*qtUp + pbaSDown[TempX]*qtDown)*qtGauche +
                                  (pbaSUp[TempX+3]*qtUp + pbaSDown[TempX+3]*qtDown)*qtDroite));//Rouge
        SourceX:=SourceX + IncX;//On passe au prochain point
        Inc(DestX);
      end;
     SourceY := SourceY + IncY;//On passe a la prochaine ligne
     Inc(DestY);
   end;
end;

//Cette procdure retourne une image ayant la hauteur voulu
//Utilise l'interpolation!
//Shma de couleurs 32Bit
//* Rouge, Vert, Bleu
Procedure Interpolation32Bit(Const ImageSource:TBitmap; Var Dest:TBitmap; const Largeur, Hauteur:Integer);
var pbaSUp, pbaSDown, pbaDest:PByteArray;
    SourceX, SourceY, IncY, IncX, qtUp, qtDown, qtGauche, qtDroite:Double;
    DestX, DestY, TempX, Largeur4:Word;
begin
  If (Hauteur <> Dest.Height) Or (Largeur <> Dest.Width) Or (Dest.PixelFormat <> pf32Bit) Then
   Begin
     MessageDlg('Beep ! ! 1', mtError, [mbOk], 0);
     Exit;
   End;
  Largeur4 := Largeur * 4;
  IncY := ImageSource.Height / Hauteur;//La longueur des pas  faire dans l'image
  IncX := ImageSource.Width / Largeur;//source
  DestY:=0;
  SourceY:=0;
  while DestY < Hauteur do
   begin
     TempX:=Trunc(SourceY);
     pbaSUp:=ImageSource.ScanLine[TempX];
     Inc(TempX);
     if TempX>=ImageSource.Height then
        Dec(TempX);
     pbaSDown:= ImageSource.ScanLine[TempX];
     pbaDest := Dest.ScanLine[DestY];
     qtDown  := SourceY-Trunc(SourceY);
     qtUp    := 1-qtDown;
     DestX := 0;
     SourceX := 0;
     while DestX < Largeur4 do
      begin
        TempX    := Trunc(SourceX);
        qtDroite := SourceX-TempX;
        qtGauche := 1-QtDroite;
        TempX := TempX * 3;

        //Calcul de la couleur interpol
        pbaDest[DestX] := Trunc((pbaSUp[TempX]*qtUp + pbaSDown[TempX]*qtDown)*qtGauche +
                          (pbaSUp[TempX+3]*qtUp + pbaSDown[TempX+3]*qtDown)*qtDroite);//Bleu
        Inc(TempX);
        Inc(DestX);
        pbaDest[DestX] := Trunc((pbaSUp[TempX]*qtUp + pbaSDown[TempX]*qtDown)*qtGauche +
                                  (pbaSUp[TempX+3]*qtUp + pbaSDown[TempX+3]*qtDown)*qtDroite);//Vert
        Inc(TempX);
        Inc(DestX);
        pbaDest[DestX] := Trunc((pbaSUp[TempX]*qtUp + pbaSDown[TempX]*qtDown)*qtGauche +
                                  (pbaSUp[TempX+3]*qtUp + pbaSDown[TempX+3]*qtDown)*qtDroite);//Rouge
        SourceX:=SourceX + IncX;//On passe au prochain point
        Inc(DestX);
        Inc(DestX);
      end;
     SourceY := SourceY + IncY;//On passe a la prochaine ligne
     Inc(DestY);
   end;
end;

end.
