unit uGraphFonc;
//--------------------------------------------------------------------
//Unti utilitaire: GraphFond
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:17 Janvier 2003
//--------------------------------------------------------------------

//Cette unit contient des fonctions graphiques permettant de produire
//des effets spciaux sur les images

interface

uses sysutils, windows, classes, graphics, uGraphUtils;

type
  tTomDegrade = record
    Haut, Bas, Dif : TColor
  end;

Function ZoomImage16(ImageSource : TBitmap; const Largeur, Hauteur:Word): TBitmap;
Function ZoomImage24(ImageSource : TBitmap; const Largeur, Hauteur:Word): TBitmap;
procedure Ombrer24(Image : tBitmap; tCol : tColor; lg : LongINt; dim : Byte);
procedure LumiereSpot(Image : tBitmap; spotx, spoty, lg : LongInt);
procedure CoulSpot24(Image : tBitmap; spotx, spoty, lg : LongInt);
procedure LumiereSpotAvance(Image : tBitmap; spotx, spoty, lg : LongInt);
procedure LumiereSpotAvanceI(Image : tBitmap; spotx, spoty, lg : LongInt);
procedure LumiereSpot24(Image : tBitmap; spotx, spoty, lg : LongInt);

procedure Degrade(Const Canvas : TCanvas; Zone : TRect; Const Couls : tTomDegrade); overload;
procedure Degrade(Const Canvas : TCanvas; Zone : TRect; Const Couls : tTomDegrade;
                  const clipRect : tRect); overload;
procedure DegradeBMP(Const BMP : TBitmap; Zone : TRect; Const Couls : tTomDegrade); overload;
procedure DegradeBMP(Const BMP : TBitmap; Zone : TRect;
          Const Couls : tTomDegrade; const ClipRect : TRect); overload;
procedure TransRect24(buffer : tBitmap; const rect : tRect; nCoul : tColor);
procedure TransRect24Safe(buffer : tBitmap; rect : tRect; const nCoul : tColor);
function ValiderRect(var rect : tREct; const width, height : LongINt) : Boolean;
Procedure DessinerBouton(Canvas : TCanvas; const Zone : TRect; Col : TColor);

implementation

//Effectue un dgrad
Procedure DegradeEtroit(Const Canvas : TCanvas; Const Rect : TRect;
          Coul, deltax, deltay : SWRGB); overload;
Var X, Y : LongInt;
    C : SWRGB;
 Begin
   Y := Rect.Top;
   While Y < Rect.Bottom Do
    Begin
      X := Rect.Left;
      c := coul;
      While X < Rect.Right Do
       Begin
         canvas.Pixels[x, y] := ((c.rouge shr 7) and $000000FF) +
                                ((c.vert  shl 1) and $0000FF00) +
                                ((c.bleu  shl 9) and $00FF0000);
         inc(c.rouge, deltax.rouge);
         inc(c.vert , deltax.vert );
         inc(c.bleu , deltax.bleu );
         Inc(X);
       End;
      Inc(Y);
      inc(coul.rouge, deltay.rouge);
      inc(coul.vert , deltay.vert );
      inc(coul.bleu , deltay.bleu );
    End;
 End;

//Procedure de dgrad optimis pour les BMP 32 bit
Procedure DegradeEtroitBMP32(Const BMP : TBitmap; Const Rect : TRect;
          Coul, deltax, deltay : SWRGB); overload;
Var X, Y : LongInt;
    c : SWRGB;
    Mem : PByte;
 Begin
   Y := Rect.Top;
   While Y < Rect.Bottom Do
    Begin
      X := Rect.Left;
      Mem := pointer(longint(BMP.Scanline[Y])+4*x);
      c := coul;
      While X < rect.Right Do
       Begin
         Mem^ := C.bleu shr 7;
         inc(Mem);
         Mem^ := C.vert  shr 7;
         inc(Mem);
         Mem^ := C.rouge  shr 7;
         inc(Mem);
         Mem^ := 0;
         inc(Mem);
         inc(c.rouge, deltax.rouge);
         inc(c.vert , deltax.vert );
         inc(c.bleu , deltax.bleu );
         Inc(X);
       End;
      Inc(Y);
      inc(coul.rouge, deltay.rouge);
      inc(coul.vert , deltay.vert );
      inc(coul.bleu , deltay.bleu );
    End;
 End;

//Procedure de dgrad optimis pour les BMP 24 bit
Procedure DegradeEtroitBMP24(Const BMP : TBitmap; Const Rect : TRect;
          Coul, deltax, deltay : SWRGB); overload;
Var X, Y : LongInt;
    c : SWRGB;
    Mem : PByte;
 Begin
   Y := Rect.Top;
   While Y < Rect.Bottom Do
    Begin
      X := Rect.Left;
      Mem := pointer(longint(BMP.Scanline[Y])+3*x);
      c := coul;
      While X < rect.Right Do
       Begin
         Mem^ := (C.bleu shr 7);
         inc(Mem);
         Mem^ := (C.vert  shr 7);
         inc(Mem);
         Mem^ := (C.rouge  shr 7);
         inc(Mem);
         inc(c.rouge, deltax.rouge);
         inc(c.vert , deltax.vert );
         inc(c.bleu , deltax.bleu );
         Inc(X);
       End;
      Inc(Y);
      inc(coul.rouge, deltay.rouge);
      inc(coul.vert , deltay.vert );
      inc(coul.bleu , deltay.bleu );
    End;
 End;

//Procedure de dgrad optimis pour les BMP 32 bit
Procedure DegradeBMP32(Const BMP : TBitmap; Const Rect : TRect;
          Coul, deltax, deltay : SWRGB;
          stepX, stepY : Word); overload;
Var Y : LongInt;
    c : SWRGB;
    Mem, pcoul : PByte;
    fstep, fLigne, binLargeur : LongWord;
 Begin
   binLargeur := (rect.Right - rect.Left) * 4;
   Y := Rect.Top;
   While Y < Rect.Bottom Do
    Begin
      Mem := pointer(longint(BMP.Scanline[Y])+4*rect.Left);
      fLigne := longWord(Mem) + binLargeur;
      c := coul;
      While longWord(Mem) < fLigne Do
       Begin
         pcoul := Mem;
         Mem^ := C.bleu shr 7;
         inc(Mem);
         Mem^ := C.vert  shr 7;
         inc(Mem);
         Mem^ := C.rouge  shr 7;
         inc(Mem);
         Mem^ := 0;
         inc(Mem);
         fstep := longWord(pcoul) + 4 * stepx;
         if fstep>fligne then
            fstep:=fligne;
         while (longWord(Mem) + 4 <= fStep) do
          begin
           pLongWord(Mem)^ := pLongWord(pcoul)^;
           inc(Mem, 4);
          end;
         inc(c.rouge, deltax.rouge);
         inc(c.vert , deltax.vert );
         inc(c.bleu , deltax.bleu );
       End;
      Inc(Y);
      inc(coul.rouge, deltay.rouge);
      inc(coul.vert , deltay.vert );
      inc(coul.bleu , deltay.bleu );
    End;
 End;

//Procedure de dgrad optimis pour les BMP 24 bit
Procedure DegradeBMP24(Const BMP : TBitmap; Const Rect : TRect;
          Coul, deltax, deltay : SWRGB;
          stepX, stepY : Word); overload;
Var Y, fCopie : LongInt;
    c : SWRGB;
    Mem, pcoul : PByte;
    fstep, fligne, binLargeur, bindeb : LongWord;
 Begin
   binLargeur := (rect.Right - rect.Left) * 3;
   binDeb     := 3*rect.Left;
   Y := Rect.Top;
   While Y < Rect.Bottom Do
    Begin
      Mem := pointer(longWord(BMP.Scanline[Y])+binDeb);
      fLigne := longWord(Mem) + binLargeur;
      c := coul;
      While longWord(Mem) < fLigne Do
       Begin
         pCoul := Mem;
         //calculer la couleur  appliquer...
         Mem^ := (C.bleu shr 7);
         inc(Mem);
         Mem^ := (C.vert  shr 7);
         inc(Mem);
         Mem^ := (C.rouge  shr 7);
         inc(Mem);
         //reproduire cette couleur
         fstep := longWord(pcoul) + 3 * stepx;
         if fstep>fligne then
            fstep:=fligne;
         while (longWord(Mem) + 3 <= fStep) do
          begin
            pWord(Mem)^ := pWord(pcoul)^;
            inc(Mem, 2);
            inc(pcoul, 2);
            Mem^ := pcoul^;
            dec(pcoul, 2);
            inc(Mem);
          end;

         //Pass  la prochaine couleur
         inc(c.rouge, deltax.rouge);
         inc(c.vert , deltax.vert );
         inc(c.bleu , deltax.bleu );
       End;
      fCopie := Y + stepY;
      Inc(Y);

      //copyer les lignes:
      if fCopie > rect.Bottom then
         fCopie := rect.Bottom;
      while y < fcopie do
       begin
         move(pointer(longword(BMP.ScanLine[y - 1]) + binDeb)^,
              pointer(longword(BMP.ScanLine[y]) + binDeb)^, binLargeur);
         inc(y);
       end;
      inc(coul.rouge, deltay.rouge);
      inc(coul.vert , deltay.vert );
      inc(coul.bleu , deltay.bleu );
    End;
 End;

// terminer et intgrer a dgrade pour plus de vitesse
Procedure DegradeLarge(Const Canvas : TCanvas; Const rect : TRect;
          coul : SWRGB; const deltax, deltaY : SWRGB; const StepX, StepY : LongInt); overload;
var c : SWRGB;
    x, y : Longint;
 Begin
   Y := Rect.Top;
   While Y <= Rect.Bottom Do
    Begin
      c := coul;

      X := Rect.Left;
      While X < rect.Right Do
       Begin
         canvas.Brush.Color := ((c.rouge shr 7) and $000000FF) +
                               ((c.vert  shl 1) and $0000FF00) +
                               ((c.bleu  shl 9) and $00FF0000);
         Canvas.FillRect(classes.rect(x, y, x+stepX,y+StepY));
         Inc(X, stepX);
         inc(c.rouge, deltax.rouge);
         inc(c.vert , deltax.vert );
         inc(c.bleu , deltax.bleu );
       End;
      Inc(Y, StepY);
      inc(coul.rouge, deltay.rouge);
      inc(coul.vert , deltay.vert );
      inc(coul.bleu , deltay.bleu );

    End;
 End;

//Cette fonction calcule les paramtres ncessaires au dgrad
function DegradeCalculerParametres(var rect : TRect; const Couls : tTomDegrade;
         const clipRect : tRect;
         var coul, deltay, deltax : SWRGB; var largeur, hauteur : LongInt) : Boolean;
var tmp : LongINt;
    tCoul : SWRGB;
 begin
   result := false;
   Largeur := Rect.Right - Rect.Left;
   Hauteur := Rect.Bottom - Rect.Top;

   If (Largeur > 0) and (Hauteur > 0) Then
    Begin

       coul   := ColorToSWRGB(couls.haut);
       deltay := ColorToSWRGB(Couls.Bas);
       SWRGBSoustraire(deltay, ColorToSWRGB(Couls.Haut));
       deltax := ColorToSWRGB(couls.dif);

       //Ajustement des limites...
       if rect.Left < clipRect.Left then
        begin
          tmp := (clipRect.Left - rect.Left);
          with coul do
           begin
             tCoul := SWRGB(deltax);
             SWRGBDiv(tCoul, largeur);
             rouge := rouge + (tCoul.rouge * tmp);
             vert  := vert  + (tCoul.vert  * tmp);
             bleu  := bleu  + (tCoul.bleu  * tmp);
           end;
          rect.Left := clipRect.Left;
        end;

       if rect.Top < clipRect.Top then
        begin
          tmp := (clipRect.Top - rect.Top);
          with coul do
           begin
             tCoul := SWRGB(deltay);
             SWRGBDiv(tCoul, hauteur);
             rouge := rouge + smallInt(tCoul.rouge) * tmp;
             vert  := vert  + smallInt(tCoul.vert ) * tmp;
             bleu  := bleu  + smallInt(tCoul.bleu ) * tmp;
           end;
          rect.Top := clipRect.Top;
        end;
       if rect.Right > clipRect.Right then
          rect.Right := clipRect.Right;
       if rect.Bottom > clipRect.Bottom then
          rect.Bottom := clipRect.Bottom;

       //if rect.Right > Width then
       //   rect.Right := Width;
       //if rect.Bottom > Height then
       //   rect.Bottom := Height;

       if (rect.Left < 0) or (rect.top < 0) then
          raise exception.Create('Affichage bizarre dans le vide');

       result := (rect.Left < rect.Right) and
                 (rect.Top  < rect.Bottom);
    end;
 end;

//Cette procdure calcule les deltas  appliquer pour passer d'un pixel
// un autre
//En plus de calculer des deltas, calcule des sauts pour optimisation
//retourne vrai si stepx ou stepy est diffrent de zro
function DegradeCalculerSaut(var coul, deltax, deltay : SWRGB;
          const Largeur, hauteur : LongInt; var StepX, stepY : LongINt) : Boolean;
 begin
   StepX := MaxChangeCol(deltax);
   SWRGBDiv(deltax, Largeur);
   if StepX > 0 then
    begin
      If (Largeur > StepX) then
       begin
         stepX := Largeur div StepX;
         SWRGBMul(deltax, stepX);
       end
      else
       begin
         stepX := 1;
       end;
    end
   else
    begin
      stepX := largeur;
      deltax.rouge := 0;
      deltax.vert := 0;
      deltax.bleu := 0;
    end;

   if StepX > 1 then
    begin
      StepY := MaxChangeCol(deltay);
      SWRGBDiv(deltay, hauteur);
      if StepY > 0 then
       begin
         If Hauteur > StepY then
          begin
            StepY := Hauteur div StepY;
            SWRGBMul(deltay, stepY);
          end
         else
            StepY := 1;
       end
      else
       begin
         stepY := hauteur;
         deltay.rouge := 0;
         deltay.vert  := 0;
         deltay.bleu  := 0;
       end;
      result := true;
    end
   else
    begin
      SWRGBDiv(deltay, hauteur);
      result := false;
    end;
 end;

//C'est un systme lent de dgrad, utilisez DegradeBMP pour de meilleur rsultats
//Effectue un dgrad
//Cette procdure effectue la prparation et appelle
//dgrade troit ou dgrade large
//NOTE: Avec certain paramtres, donne des rsultats amusants  cause des
//      dbordements de capacits
//      (c'est pas grave, a fait juste des couleurs bizarres!)
procedure Degrade(Const Canvas : TCanvas; Zone : TRect; Const Couls : tTomDegrade);
Var Largeur, Hauteur, stepx, stepy : LongInt;
    coul : SWRGB;
    deltaY, deltaX : SWRGB;
 Begin
   If DegradeCalculerParametres(Zone, couls, rect(0, 0, Zone.Right, Zone.Bottom),
   coul, deltax, deltay, largeur, hauteur) then
    begin
      if degradeCalculerSaut(coul, deltax, deltay, largeur, hauteur, stepx, stepy) then
         degradeLarge(canvas, zone, coul, deltax, deltay, stepX, stepY)
      else
         degradeEtroit(canvas, Zone, Coul, deltax, deltay)
    end;
 End;

procedure Degrade(Const Canvas : TCanvas; Zone : TRect; Const Couls : tTomDegrade;
                  const clipRect : tRect);
Var Largeur, Hauteur, stepx, stepy : LongInt;
    coul : SWRGB;
    deltaY, deltaX : SWRGB;
    vRect : tRect;
 Begin
   IntersectREct(vRect, clipRect, rect(0, 0, zone.right, zone.bottom));
   If DegradeCalculerParametres(Zone, couls, vRect,
   coul, deltax, deltay, largeur, hauteur) then
    begin
      if degradeCalculerSaut(coul, deltax, deltay, largeur, hauteur, stepx, stepy) then
         degradeLarge(canvas, zone, coul, deltax, deltay, stepX, stepY)
      else
         degradeEtroit(canvas, Zone, Coul, deltax, deltay)
    end;
 End;

//Cette procdure effectue le choix de la procdure optimis  utiliser
//pour le dgrad: appeler  la fin de DegradeBMP
//ATTENTION: Ne pas appeler directement, la prparation doit avoir t faite
procedure DegradeBMPLancer(Const BMP : TBitmap; Rect : TRect;
          var Coul, deltax, deltay : SWRGB; const largeur, hauteur : LongInt);
var StepX, StepY : LongInt;
 begin
   if DegradeCalculerSaut(coul, deltax, deltay, largeur, hauteur, stepx, stepy) then
    begin
      case BMP.PixelFormat of//gestion de plusieurs profondeurs de bmp
       pf32Bit: DegradeBMP32(BMP, rect, Coul, deltax, deltay, stepX, stepY);
       pf24Bit: DegradeBMP24(BMP, rect, Coul, deltax, deltay, stepX, stepY)
       //Aucune procdure optimis pour le faire... alors, on doit utiliser le moyen TRS LENT
       else raise Exception.Create('DegradeBMPLancer->Format non gr');
      end;
    end
   else
    begin
      case BMP.PixelFormat of//gestion de plusieurs profondeurs de bmp
       pf32Bit: DegradeEtroitBMP32(BMP, rect, Coul, deltax, deltay);
       pf24Bit: DegradeEtroitBMP24(BMP, rect, Coul, deltax, deltay);
       //Aucune procdure optimis pour le faire... alors, on doit utiliser le moyen TRS LENT
       else raise Exception.Create('DegradeBMPLancer->Format non gr');
      end;
    end;
 end;

//Pour des performances optimales, effectuez vaut dgrads dans des BMP
//(Dans les BMP, j'ai un accs direct  la mmoire, pas besoin d'utiliser le
//lent PIXEL[])
procedure DegradeBMP(Const BMP : TBitmap; Zone : TRect; Const Couls : tTomDegrade); overload;
Var Largeur, Hauteur : LongInt;
    coul : SWRGB;
    deltaY, deltaX : SWRGB;
 Begin
   if not (BMP.PixelFormat in [pf24Bit, pf16Bit]) then
    begin//Si le BMP est dans un format non gr...
      Degrade(BMP.Canvas, zone, couls);
      exit;
    end;

    if DegradeCalculerParametres(zone, couls, rect(0, 0, bmp.Width, bmp.Height), coul, deltay, deltax, largeur, hauteur) then
       DegradeBMPLancer(BMP, zone, coul, deltax, deltay, largeur, hauteur);

 End;

//Pour des performances optimales, effectuez vaut dgrads dans des BMP
//(Dans les BMP, j'ai un accs direct  la mmoire,
//Cette version de Degrade n'affiche que ce qui est contenu dans ClipRect
procedure DegradeBMP(Const BMP : TBitmap; zone : TRect;
          Const Couls : tTomDegrade; const ClipRect : TRect); overload;
Var Largeur, Hauteur : LongInt;
    coul : SWRGB;
    deltaY, deltaX : SWRGB;
    vClip : tRect;
 Begin
   if not (BMP.PixelFormat in [pf24Bit, pf16Bit]) then
    begin//Si le BMP est dans un format non gr...
      Degrade(BMP.Canvas, zone, couls);
      exit;
    end;

    IntersectRect(vClip, ClipRect, rect(0, 0, bmp.Width, bmp.Height));
    if DegradeCalculerParametres(zone, couls, vclip, coul, deltay, deltax, largeur, hauteur) then
     begin


       DegradeBMPLancer(BMP, zone, coul, deltax, deltay, largeur, hauteur);
     end;
{   Largeur := Rect.Right - Rect.Left;
   Hauteur := Rect.Bottom - Rect.Top;

   If (Largeur > 0) and (Hauteur > 0) Then
    Begin

       coul   := ColorToSWRGB(couls.haut);
       deltay := ColorToSWRGB(Couls.Bas);
       SWRGBSoustraire(deltay, ColorToSWRGB(Couls.Haut));
       deltax := ColorToSWRGB(couls.dif);}


       {if (rect.Left < 0) or (rect.top < 0) then
          raise exception.Create('Affichage bizarre dans le vide');
       if rect.Right  > BMP.Width then
          rect.Right  := BMP.Width;
       if rect.Bottom > BMP.Height then
          rect.Bottom := BMP.Height;
       if (rect.left < rect.right) and
          (rect.top < rect.bottom) then}
          //              DegradeBMPLancer(BMP, rect, coul, deltax, deltay, largeur, hauteur);
    //End;
 End;

//Dessine un bouton
Procedure DessinerBouton(Canvas : TCanvas; const Zone : TRect; Col : TColor);
 Begin
   //Bordure 1
   Canvas.Pen.Color := Col;
   Canvas.Pen.Color := SoustraireCoulR(Col, $001F1F1F);
   Canvas.MoveTo(zone.Left, zone.Top + 3);
   Canvas.LineTo(zone.Left, zone.Bottom - 3);
   Canvas.Pen.Color := SoustraireCoulR(Col, $002F2F2F);
   Canvas.MoveTo(zone.Left + 3, zone.Bottom);
   Canvas.LineTo(zone.Right - 3, zone.Bottom);
   Canvas.Pen.Color := AdditionnerCoul(Col, $000F0F0F);
   Canvas.MoveTo(zone.Right, zone.Bottom - 3);
   Canvas.LineTo(zone.Right, zone.Top + 3);
   Canvas.Pen.Color := AdditionnerCoul(Col, $00101010);
   Canvas.MoveTo(zone.Right - 3, zone.Top);
   Canvas.LineTo(zone.left + 3, zone.Top);

   //bordure 2
   Canvas.Pen.Color := SoustraireCoulR(Col, $000F0F0F);
   Canvas.MoveTo(zone.Left + 1, zone.Top + 1);
   Canvas.LineTo(zone.Left + 1, zone.Bottom - 1);
   Canvas.Pen.Color := SoustraireCoulR(Col, $001F1F1F);
   Canvas.MoveTo(zone.Left + 1, zone.Bottom - 1);
   Canvas.LineTo(zone.Right - 1, zone.Bottom - 1);
   Canvas.Pen.Color := AdditionnerCoulR(Col, $00080808);
   Canvas.MoveTo(zone.Right - 1, zone.Bottom - 1);
   Canvas.LineTo(zone.Right - 1, zone.Top + 1);
   Canvas.Pen.Color := AdditionnerCoulR(Col, $000A0A0A);
   Canvas.MoveTo(zone.Right - 1, zone.Top + 1);
   Canvas.LineTo(zone.Left  + 1, zone.Top + 1);
   //intrieur
   Canvas.Brush.Color := Col;
   Canvas.FillRect(Rect(zone.Left + 2, zone.Top + 2, zone.Right - 1, zone.Bottom - 1));
 End;

//Dessine un rectangle transparent
//ATTENTION AUCUNE VALIDATION
procedure TransRect24(buffer : tBitmap; const rect : tRect; nCoul : tColor);
const lCol = 3;
var pSource, pDest, pFin : pByte;
    y : LongInt;
 begin
   nCoul := DivCoul(ncoul, 2);//On divise tout de suite, c'est plus performant

   y := Rect.Top;
   while y < Rect.Bottom do
    begin
      pDest := PByte(longInt(Buffer.ScanLine[y]) + Rect.Left * lCol);
      pFin := PByte(LongInt(Buffer.ScanLine[y]) + Rect.Right * lCol);
      while longInt(pDest) < LongInt(pFin) do
       begin
         pSource := @nCoul;
         inc(pSource, 2);
         while LongINt(pSource) >= LongInt(@nCoul) do
          begin
            pDest^ := (pDest^ shr 1) + (pSource^);
            inc(pDest);
            dec(pSource);
          end;
       end;
      inc(y);
    end;
 end;

//Super fonction modifie le rectangle pour qu'il respecte les limites
//retourne vrai si tous est ok, faux si a va pas (probablement rectangle nul)
function ValiderRect(var rect : tREct; const width, height : LongINt) : Boolean;
 begin
   if rect.Left < 0 then
      rect.Left := 0;
   if rect.Right < Width then
      rect.Right := Width;
   if rect.Top < 0 then
      rect.Top := 0;
   if rect.Bottom > Height then
      rect.Bottom := Height;
   result := (rect.Left < rect.Right) and (rect.Top < rect.Bottom);
 end;

//Cette procdure valide le rect aant d'appeler TransRect24
//Donc, on a pas de plantage
procedure TransRect24Safe(buffer : tBitmap; rect : tRect; const nCoul : tColor);
 begin
   if ValiderRect(rect, buffer.width, buffer.Height) then
      TransRect24(buffer, rect, nCoul);
 end;

//Retourne une Texture16Bit de la grandeur voulu
Function ZoomImage16(ImageSource : TBitmap; const Largeur, Hauteur:Word): TBitmap;
var HAGAS, HADRS, BAGAS, BADRS: ^Word;
    pDest : ^Word;
    Sx, Sy, difX, DifY, qtUp, qtDown, qtG, qtD:Double;
    x, y, TempX, TempNextX, Couleur:Word;
    SourceRange, NextSourceRange : PWordArray;
begin
  If ImageSource <> nil Then
   Begin
     result := tBitmap.Create;
     result.PixelFormat := pf16Bit;
     result.Width  := Largeur;
     result.Height := Hauteur;

     difY := ImageSource.Height / Hauteur;
     difX := ImageSource.Width  / Largeur;
     y:=0;
     Sy:=0;

     While y < Hauteur do
      begin
        pDest := result.ScanLine[y];
        qtDown := Sy - Trunc(Sy);
        qtUp   := 1 - qtDown;
        SourceRange := ImageSource.ScanLine[trunc(sy)];
        If Sy < ImageSource.Height - 1 Then
           NextSourceRange := ImageSource.ScanLine[trunc(Sy + 1)]
        Else
           NextSourceRange := ImageSource.ScanLine[0];

        X := 0;
        Sx:=0;
        While x < result.Width do
         begin
           TempX := Trunc(Sx);
           qtD := Sx - TempX;
           qtG := 1  - QtD;
           TempNextX := TempX + 1;
           If TempNextX >= (ImageSource.Width) Then
              TempNextX := 0;

           HAGAS := @SourceRange[TempX];
           HADRS := @SourceRange[TempNextX];
           BAGAS := @NextSourceRange[TempX];
           BADRS := @NextSourceRange[TempNextX];

           Couleur:=Trunc(( ( (HAGAS^ And $001F) * qtUp +
                              (BAGAS^ And $001F) * qtDown) * qtG +
                            ( (HADRS^ And $001F) * qtUp +
                              (BADRS^ And $001F) * qtDown) * qtD));//Bleu
           Couleur :=Couleur + Trunc(( ( (HAGAS^ And $07E0) * qtUp +
                                         (BAGAS^ And $07E0) * qtDown)*qtG +
                                       ( (HADRS^ And $07E0) * qtUp +
                                         (BADRS^ And $07E0) * qtDown)*qtD)) And $07E0;//Vert
           Couleur:=Couleur + Trunc(( ( (HAGAS^ And $F800) *qtUp +
                                        (BAGAS^ And $F800) *qtDown)*qtG +
                                      ( (HADRS^ And $F800) *qtUp +
                                        (BADRS^ And $F800) *qtDown)*qtD)) And $F800;//Rouge
           pDest^ := Couleur;
           Sx := Sx + difX;
           Inc(pDest);
           Inc(X);
         end;
        Sy :=Sy + difY;
        Inc(y);
      End;
   End
  Else
    raise Exception.Create('Erreur! pas image source');
End;

//Retourne une Texture16Bit de la grandeur voulu
Function ZoomImage24(ImageSource : TBitmap; const Largeur, Hauteur:Word): TBitmap;
var HAGAS, HADRS, BAGAS, BADRS: ^Byte;
    pDest : ^Byte;
    Sx, Sy, difX, DifY, qtUp, qtDown, qtG, qtD:Double;
    x, y, TempX, TempNextX:Word;
    SourceRange, NextSourceRange : PByteArray;
begin
  If ImageSource <> nil Then
   Begin
     result := tBitmap.Create;
     result.PixelFormat := pf24Bit;
     result.Width  := Largeur;
     result.Height := Hauteur;

     difY := ImageSource.Height / Hauteur;
     difX := ImageSource.Width  / Largeur;
     y:=0;
     Sy:=0;

     While y < Hauteur do
      begin
        pDest := result.ScanLine[y];
        qtDown := Sy - FTruncDWS(Sy);
        qtUp   := 1 - qtDown;
        SourceRange := ImageSource.ScanLine[FtruncDWS(sy)];
        If Sy < ImageSource.Height - 1 Then
           NextSourceRange := ImageSource.ScanLine[FtruncDWS(Sy + 1)]
        Else
           NextSourceRange := ImageSource.ScanLine[0];

        X := 0;
        Sx:=0;
        While x < result.Width do
         begin
           TempX := FTruncDWS(Sx);
           qtD := Sx - TempX;
           qtG := 1  - QtD;
           TempNextX := TempX + 1;
           If TempNextX >= (ImageSource.Width) Then
              TempNextX := 0;

           HAGAS := @SourceRange[TempX * 3];
           HADRS := @SourceRange[TempNextX * 3];
           BAGAS := @NextSourceRange[TempX * 3];
           BADRS := @NextSourceRange[TempNextX * 3];

           pDest^:=FTrunc(( ( (HAGAS^) * qtUp +
                              (BAGAS^) * qtDown) * qtG +
                            ( (HADRS^) * qtUp +
                              (BADRS^) * qtDown) * qtD));//Bleu
           Inc(pDest);
           Inc(HAGAS);
           Inc(HADRS);
           Inc(BAGAS);
           Inc(BADRS);
           pDest^:=FTrunc(( ( (HAGAS^) * qtUp +
                                         (BAGAS^) * qtDown)*qtG +
                                       ( (HADRS^) * qtUp +
                                         (BADRS^) * qtDown)*qtD));//Vert
           Inc(pDest);
           Inc(HAGAS);
           Inc(HADRS);
           Inc(BAGAS);
           Inc(BADRS);
           pDest^:=FTrunc(( ( (HAGAS^) *qtUp +
                                        (BAGAS^) *qtDown)*qtG +
                                      ( (HADRS^) *qtUp +
                                        (BADRS^) *qtDown)*qtD));//Rouge
           Inc(pDest);
           Sx := Sx + difX;
           Inc(X);
         end;
        Sy := Sy + difY;
        Inc(y);
      End;
   End
  Else
    raise Exception.Create('Erreur! pas image source');
End;

procedure Ombrer24(Image : tBitmap; tCol : tColor; lg : LongINt; dim : Byte);
var ligne, source : PByteArray;
    pt : pByte;
    x, y : LongInt;
    trans : LongWord;
 begin
   trans := (tCol and $00FFFFFF);
   y := Image.Height;
   while y > lg  do
    begin
      dec(y);
      ligne  := Image.ScanLine[y];
      source := Image.ScanLine[y - lg];
      x := lg;
      while x < Image.Width - 1 do
       begin
         if ((pLongWord(@source[(x - lg) * 3])^ and $00FFFFFF) <> trans) and
            ((pLongWord(@ligne[(x) * 3])^ and $00FFFFFF) = trans)then
          begin
            pt := @(ligne[x * 3]);
            if pt^ > dim then
               pt^ := pt^ - dim
            else
               pt^ := 0;
            inc(pt);
            if pt^ > dim then
               pt^ := pt^ - dim
            else
               pt^ := 0;
            inc(pt);
            if pt^ > dim then
               pt^ := pt^ - dim
            else
               pt^ := 0;
          end;
         inc(x);
       end;
    end;
 end;

//Dessine un spot de lumire sur l'image
procedure LumiereSpot(Image : tBitmap; spotx, spoty, lg : LongInt);
var x, y : LongInt;
 begin
   for y := 0 to Image.Height - 1 do
    begin
      for x := 0 to Image.Width - 1 do
       begin
         Image.Canvas.Pixels[x, y] := AdditionnerCoulR(Image.Canvas.Pixels[x, y],
         $00010101 * trunc(SQRT(SQR(x - spotx) + SQR(y - spoty)) / lg * 128 ));
       end;
    end;
 end;

//Dessine un spot de lumire sur l'image
procedure CoulSpot24(Image : tBitmap; spotx, spoty, lg : LongInt);
var x, y : LongInt;
    pt : pByte;
    t, i : Byte;
 begin
   for y := 0 to Image.Height - 1 do
    begin
      for x := 0 to Image.Width - 1 do
       begin
         t := trunc((SQR(x - spotx) + SQR(y - spoty)) / lg );
         pt := Image.ScanLine[y];
         Inc(pt, x * 3);
         For I := 1 to 3 Do
          Begin
            if t > pt^ Then//Vrification dbordement
               pt^ := 0
            else
               pt^ := pt^ - t;
            Inc(pt);
          End;

       end;
    end;
 end;

//Dessine un spot de lumire sur l'image
procedure LumiereSpotAvance(Image : tBitmap; spotx, spoty, lg : LongInt);
var x, y, tmp : LongInt;
    pt : pByte;
    t, i : Byte;
 begin
   for y := 0 to Image.Height - 1 do
    begin
      for x := 0 to Image.Width - 1 do
       begin
         tmp := trunc((SQR(x - spotx) + SQR(y - spoty)) / lg );
         if tmp > high(byte) then
           t := 255
         else
           t := tmp;
         pt := Image.ScanLine[y];
         Inc(pt, x * 3);
         For I := 1 to 3 Do
          Begin
            if t > pt^ Then//Vrification dbordement
               pt^ := 0
            else
               pt^ := pt^ - t;
            Inc(pt);
          End;

       end;
    end;
 end;

//Dessine un spot de lumire sur l'image
procedure LumiereSpotAvanceI(Image : tBitmap; spotx, spoty, lg : LongInt);
var x, y, tmp : LongInt;
    pt : pByte;
    t, i : Byte;
 begin
   for y := 0 to Image.Height - 1 do
    begin
      for x := 0 to Image.Width - 1 do
       begin
         tmp := trunc((SQR(x - spotx) + SQR(y - spoty)) / lg );
         if tmp > high(byte) then
           t := 255
         else
           t := tmp;
         pt := Image.ScanLine[y];
         Inc(pt, x * 3);
         For I := 1 to 3 Do
          Begin
            if t > 255-pt^ Then//Vrification dbordement
               pt^ := 255
            else
               pt^ := pt^ + t;
            Inc(pt);
          End;

       end;
    end;
 end;

//Dessine un spot de lumire sur l'image
procedure LumiereSpot24(Image : tBitmap; spotx, spoty, lg : LongInt);
var x, y : LongInt;
    pt : pByte;
    t, i : Byte;
 begin
   for y := 0 to Image.Height - 1 do
    begin
      for x := 0 to Image.Width - 1 do
       begin
         t := trunc(SQRT(SQR(x - spotx) + SQR(y - spoty)) / lg * 128 );
         pt := Image.ScanLine[y];
         Inc(pt, x * 3);
         For I := 1 to 3 Do
          Begin
            if t > pt^ Then//Vrification dbordement
               pt^ := 0
            else
               pt^ := pt^ - t;
            Inc(pt);
          End;

       end;
    end;
 end;

end.
