unit uGraphCompo;
//--------------------------------------------------------------------
//Unti utilitaire: GraphCompo
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:17 Janvier 2003
//--------------------------------------------------------------------

//Contient des composants graphiques
//Mon beau scroll bar...
//Et surtout, mon super systme de dgrad!
//En envoyant des mauvais paramtres aux procdures de dgrad, on obtient des
//rsultats amusant...(rayures, couleur bizarre, etc)  exprimenter!
//Faut juste s'arranger pour ne pas faire planter
//A faire: Grer autre profondeurs...

//Tommy Brire

interface

uses Controls, messages, classes, windows, sysutils, forms, graphics, ExtCtrls,
     uGraphUtils, uGraphFonc;

type
  TBordureType = (bordNormal, bordTransparent);
  PByte = ^Byte;
  TCOlorArray = Array[0..8136] of TColor;

  TPosChangeEvent = procedure(Sender : TObject; var NPos : LongInt) of object;

  //Super systme graphique de dgrad
  //Modifie le comportement de base!
  //Accs directe au bitmap buffer
  TBufferedControl = class(TCustomControl)
    private
      procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
      procedure RetirerBuf;
    protected
      Buffer : TBitmap;
      memory : Pointer;
      NbBitParPixel : Word;
      procedure WMEraseBkgnd(var Message: TWmEraseBkgnd); message WM_ERASEBKGND;
      procedure CreateParams(var Params: TCreateParams); override;
      procedure PreparePaint; virtual;
   public
      procedure AfterConstruction; override;
      procedure BeforeDestruction; override;
   published
      property DoubleBuffered;
  end;


  //Fond avec dgradde couleur
  TDegradeControl = class(TBufferedControl)
    private
      procedure SetRemplissage(const Value: tTomDegrade);
      procedure SetRemplissageBas(const Value: TColor);
      procedure SetRemplissageDif(const Value: TColor);
      procedure SetRemplissageHaut(const Value: TColor);
      procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure SetDegradeActif(const Value: Boolean);
    protected
      FRemplissage : tTomDegrade;
      fDegradeActif : Boolean;
      procedure WMEraseBkgnd(var Message: TWmEraseBkgnd); message WM_ERASEBKGND;
      procedure CreateParams(var Params : TCreateParams); override;
    public
      procedure AfterConstruction; override;
    published
      property Remplissage : tTomDegrade read FRemplissage write SetRemplissage;
      property CouleurHaut : TColor read FRemplissage.Haut write SetRemplissageHaut;
      property CouleurBas : TColor read FRemplissage.Bas write SetRemplissageBas;
      property VariationLaterale : TColor read FRemplissage.Dif write SetRemplissageDif;
      property Align;
      property Color;
      property DegradeActif : Boolean read fDegradeActif write SetDegradeActif;
  end;

  //Ajout des proprits pour que tDEgradeControl fonctionne comme un TPanel
  tDegradePanel = class(tDegradeControl)
    private
    FAlignment: TAlignment;
      procedure SetAlignment(Value: TAlignment);
    protected
      procedure CreateParams(var Params: TCreateParams); override;
    published
      property Align;
      property Alignment: TAlignment read FAlignment write SetAlignment default taCenter;
      property Anchors;
      property AutoSize;
      property BevelInner;
      property BevelOuter;
      property BevelWidth;
      property BiDiMode;
      property BorderWidth;
      property Caption;
      property Color;
      property Constraints;
      property Ctl3D;
      property UseDockManager default True;
      property DockSite;
      property DragCursor;
      property DragKind;
      property DragMode;
      property Enabled;
      property Font;
      property ParentBiDiMode;
      property ParentColor;
      property ParentCtl3D;
      property ParentFont;
      property ParentShowHint;
      property PopupMenu;
      property ShowHint;
      property TabOrder;
      property TabStop;
      property Visible;
      property OnCanResize;
      property OnClick;
      property OnConstrainedResize;
      property OnContextPopup;
      property OnDockDrop;
      property OnDockOver;
      property OnDblClick;
      property OnDragDrop;
      property OnDragOver;
      property OnEndDock;
      property OnEndDrag;
      property OnEnter;
      property OnExit;
      property OnGetSiteInfo;
      property OnMouseDown;
      property OnMouseMove;
      property OnMouseUp;
      property OnResize;
      property OnStartDock;
      property OnStartDrag;
      property OnUnDock;
  end;

  TDegradeScrollBar = class(TDegradeControl)
   private
     FPos, FMin, FMax, FPageSize, Step, LargeStep : LongInt;
     BGauche : Boolean;
     DebPos, DebMousePos : LongInt;
     lgBarre, PosBarre : LongInt;
     PosToScreen, ScreenToPos : Single;//Ce sont les vecteurs qui permettent de convertir une coordonne cran en coordonn de position
     procedure CNHScroll(var Message: TWMHScroll); message CN_HSCROLL;
     procedure CNVScroll(var Message: TWMHScroll); message CN_VSCROLL;
     procedure Scroll(const Qt: Integer);
     procedure SetPosition(NPos: Integer);
     procedure SetMax(const Value: LongInt);
     procedure SetMin(const Value: LongInt);
     procedure Recalculer;
     procedure SurPosChange(var NPos: Integer);
     procedure SetFlecheDim(const Value: Byte);
     procedure setPageSize(const Value: LongInt);
     procedure AfficherEnGris(Canvas : TCanvas);
     procedure SetColBouton(const Value: TColor);
     procedure SetColFleche(const Value: TColor);
     procedure SetCouleurDesactiver(const Value: TColor);
   protected
     fFocusSurClique : Boolean;
     FlecheDim : Byte;
     ColBouton, ColFleche, colDesactiver : TColor;
     bType : TBordureType;
     FonPosChange : TPosChangeEvent;
     FonApresPosChange : TNotifyEvent;
     procedure Paint; override;
     procedure resize; override;
     function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
     function DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
     procedure CNKeyDown(var Message: TWMKeyDown); message CN_KEYDOWN;
   public
     constructor Create(AOwner: TComponent); override;
     destructor Destroy; override;
     procedure AfterConstruction; override;
     procedure MouseDown(Button: TMouseButton;
               Shift: TShiftState; X, Y: Integer); override;
     procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X,
               Y: Integer); override;
     procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
   published
     property FocusSurClique : Boolean read fFocusSurClique write fFocusSurClique;
     property CouleurBoutons : TColor read ColBouton write SetColBouton;
     property CouleurFleche : TColor read ColFleche write SetColFleche;
     property CouleurDesactiver : TColor read ColDesactiver write SetCouleurDesactiver;
     property FlecheLg : Byte read FlecheDim write SetFlecheDim;
     property Position : LongInt read FPos write SetPosition;
     property Min : LongInt read FMin write SetMin;
     property Max : LongInt read FMax write SetMax;
     property pageSize : LongInt read FPageSize write setPageSize;
     property SmallChange : LongInt read Step write Step;
     property LargeChange : LongInt read LargeStep write LargeStep;
     property OnPosChange : TPosChangeEvent read FOnPosChange write FOnPosChange;
     property OnApresPosChange : TNotifyEvent read FOnApresPosChange write FOnApresPosChange;
  End;

  tDegradeList = class(tDegradeControl)
   private
     fAutoHeight, fInverse, fVerrouillerSurClique: Boolean;
    fCouleurText: TColor;
     procedure SetAutoHeight(const Value: Boolean);
     procedure AjusterHauteur;
     procedure WMSize(var message : TWMSize); message WM_SIZE;
     procedure DessinerFondNouveau(const rect: tREct);
     procedure SetCouleurText(const Value: TColor);
     procedure SetlCoul(const Value: TColor);
     procedure SetnCoul(const Value: TColor);
     procedure SetselCoul(const Value: TColor);
   protected
     hLigne : LongInt;
     lCoul, selCoul, nCoul : tColor;
     //FAutoSize : Boolean;
     Selection : LongInt;
     fSurNouveau, fSurSelection, fSurApercu, fSurVideApercu : TNotifyEvent;
     procedure CreateParams(var Params: TCreateParams); override;
     procedure Paint; override;
     function ObtenirHauteurEl : LongInt; virtual;
     procedure PreparerAffichage; virtual;
     procedure AfficherEl(id: Longword; const rect: tREct; const Sel : Boolean); virtual;
     procedure ApresAffichage; virtual;
     procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
     procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
     procedure KeyDown(var Key: Word; Shift: TShiftState); override;
     procedure ApresScroll(Sender: Tobject = nil);
     procedure DessinerSelection(const rect: tREct); dynamic;
     procedure ChoisirItem; virtual;
     procedure PreVisualiserItem; virtual;
     procedure SetSelection(const Value: longInt);
     procedure PreparePaint; override;
     function DoMouseWheelDown(Shift: TShiftState; MousePos: TPoint): Boolean; override;
     function DoMouseWheelUp(Shift: TShiftState; MousePos: TPoint): Boolean; override;
   public
     Scroll : tDegradeScrollBar;
     SelLock : Boolean;
     function Count : LongInt; virtual;
     function HauteurEl : LongINt;
     procedure AfterConstruction; override;
     function  Cherche(Const Chaine : String) : boolean; virtual;
     constructor Create(AOwner: TComponent); override;
     procedure DefaultHandler(var Message); override;
     procedure CNKeyDown(var Message: TWMKeyDown); message CN_KEYDOWN;
     procedure MouseWheelHandler(var Message: TMessage) ; override;
     procedure DataAChange; dynamic;
     function VraiIdSel: LongInt;
   published
     property SurNouveau    : TNotifyEvent read fSurNouveau write fSurNouveau;
     property SurSelection  : TNotifyEvent read fSurSelection write fSurSelection;
     property SurApercu     : TNotifyEvent read fSurApercu write fSurApercu;
     property SurVideApercu : TNotifyEvent read fSurVideApercu write fSurVideApercu;
     property CouleurLigne : TColor read lCoul write SetlCoul;
     property CouleurSelection : TColor read selCoul write SetselCoul;
     property CouleurNouveau : TColor read nCoul write SetnCoul;
     property CouleurText : TColor read fCouleurText write SetCouleurText;
     property ItemIndex : longInt read Selection write SetSelection;
     property AutoHeight : Boolean read fAutoHeight write SetAutoHeight;
     property Inverse : Boolean read fInverse write fInverse;
     property VerrouillerSurClique : Boolean read fVerrouillerSurClique write fVerrouillerSurClique;
  End;

  tFlecheBouton = class(TGraphicControl)
  private
    procedure SetDesactiver(const Value: tColor);
    procedure SetFleche(const Value: tColor);
   protected
     //fOnClick : tNotifyEvent;
     fcolFleche, fColDesactiver : tColor;
     procedure Paint; override;
   public
     procedure AfterConstruction; override;
   published
     property OnClick;// read fOnClick write fOnClick;
     property colFleche : tColor read fcolFleche write SetFleche;
     property CouleurDesactiver : tColor read fColDesactiver write SetDesactiver;
  end;

implementation

uses uFiltreEdit;

{ tDegradeScrollBar }

procedure TDegradeScrollBar.AfficherEnGris(Canvas : TCanvas);
 begin
   DessinerBouton(Canvas, Rect(1, 1, FlecheLg, FlecheLg + 1), colDesactiver);
   DessinerBouton(Canvas, Rect(1, Height - FlecheLg - 1, FlecheLg, Height - 1), colDesactiver);
   DessinerBouton(Canvas, Rect(1, FlecheLg + 2, FlecheLg, Height - FlecheLg - 2), colDesactiver);
 end;

procedure DessinerFleche(Canvas : TCanvas; Rect : TRect; col : TColor); overload;
 begin
   Canvas.Pen.Color   := AdditionnerCoulR(col, $00101010);
   Canvas.Brush.Color := col;
   Canvas.Polygon([Point(Rect.Left, Rect.Top), Point(Rect.Right, Rect.Top),
                   Point((Rect.Right + Rect.Left) div 2, Rect.Bottom)]);

 end;

procedure DessinerFleche(Canvas : TCanvas; Rect : TRect; col, c2 : TColor); overload;
 begin
   Canvas.Pen.Color   := c2;
   Canvas.Brush.Color := col;
   Canvas.Polygon([Point(Rect.Left, Rect.Top), Point(Rect.Right, Rect.Top),
                   Point((Rect.Right + Rect.Left) div 2, Rect.Bottom)]);

 end;

//Affiche quelque chose
Procedure tDegradeScrollBar.Paint;
var colBordureFleche : TColor;
 Begin
   If Enabled and (pageSize < max - min) then
    begin
       colBordureFleche := divCoul(colFleche, 2) + divCoul(ColBouton, 2);

       DessinerBouton(Canvas, Rect(1, 1, FlecheLg, FlecheLg + 1), ColBouton);
       DessinerBouton(Canvas, Rect(1, Height - FlecheLg - 1, FlecheLg, Height - 1), ColBouton);
       DessinerFleche(Canvas, Rect(4, flecheLg - 3, flecheLg - 4, 3), ColFleche, colBordurefleche);
       DessinerFleche(Canvas, Rect(4, Height - FlecheLg + 3, flecheLg - 3, Height - 4), colFleche, colBordurefleche);

       DessinerBouton(Canvas, Rect(1, PosBarre, FlecheLg, PosBarre + lgBarre), ColBouton);
    end
   else
    begin
      AfficherEnGris(Canvas);
    end;
 End;

constructor tDegradeScrollBar.Create(AOwner: TComponent);
 begin
   inherited;
//   Buffer := TBitmap.Create;
//   Buffer.PixelFormat := pf24Bit;//C'est plus simple de toujours travailler en 24Bit

   TabStop := True;
   ControlStyle := [csCaptureMouse, csClickEvents, csOpaque, csReplicatable];
//   DoubleBuffered := True;

   FlecheLg := 15;
   bType := bordTransparent;
   //lf.AdjustSize

   FPageSize := 10;
   FMax := 10;
   step := 1;
   LargeStep := 1;

   Align := alLeft;
   Width := FlecheLg + 2;
   //Recalculer;
 end;

destructor tDegradeScrollBar.destroy;
 begin
   //FCanvas.Free;
   inherited;
 end;

//action sur Scroll
procedure tDegradeScrollBar.CNHScroll(var Message: TWMHScroll);
 begin
   raise exception.Create('Scroll')
 end;

//Actions sur Scroll
procedure tDegradeScrollBar.CNVScroll(var Message: TWMHScroll);
 begin
   raise exception.Create('Scroll')
 end;

procedure tDegradeScrollBar.Scroll(Const Qt : LongInt);
 Begin
//   FScrollChose.ScrollBy(OldPos - Value, 0) else
   Position := Position + Qt;
 End;

procedure tDegradeScrollBar.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
 begin
   If Button = mbLeft Then
    Begin
       If Y <= FlecheLg Then
          Scroll(-step)
       Else if Y >= Height - FlecheLg Then
          Scroll(step)
       Else
        Begin
          If Y < PosBarre Then
             Scroll(-LargeStep)
          Else If Y > PosBarre + lgBarre Then
             Scroll(LargeStep)
          Else
           Begin
             DebPos := FPos;
             DebMousePos := Y;
             BGauche := True;
           End;
        End;
    End;
   if (fPageSize < (fMax - fMin)) and fFocusSurClique then
      SetFocus;
   inherited;
 end;

procedure tDegradeScrollBar.MouseUp(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
 Begin
   If Button = mbLeft Then
    Begin
      BGauche := False;
    End;
   inherited;
 End;

//Dplacement avec la souris!
procedure tDegradeScrollBar.MouseMove(Shift: TShiftState; X, Y: Integer);
 begin
   If BGauche Then
    Begin
      Position := DebPos + Trunc((Y - DebMousePos) * ScreenToPos)
    End;
   inherited;
 end;


{procedure tDegradeScrollBar.KeyDown(var Key: Word; Shift: TShiftState);
 Begin
   case Key of
    VK_UP: Begin
       Scroll(-Step);
       key := 0;
     End;
    VK_DOWN: Begin
       Scroll(Step);
       key := 0;
     End;
    VK_PRIOR: Begin
       Scroll(-LargeStep);
       key := 0;
     End;
    VK_NEXT: Begin
       Scroll(LargeStep);
       key := 0;
     End;
   end;
   inherited;
 End;}

{procedure tDegradeScrollBar.KeyPress(var Key: Char);
 begin
   inherited;

 end;}

//Cette procdure met  jour certaine donnes interne quand il y un changement
//de Min, Max ou Pos
Procedure tDegradeScrollBar.Recalculer;
Var MZone : TRect;
    DifMinMax, LgDZone : LongInt;
 Begin
   MZone := Rect(1, FlecheLg + 1, Width - 1,Height - FlecheLg - 1);
   DifMinMax := Max - Min;
   LgDZone   := MZone.Bottom - MZone.Top;
   If (LgDZone > 0) And (DifMinMax > 0) Then
    Begin
      PosToScreen := LgDZone / DifMinMax;
      ScreenToPos := DifMinMax / lgDZone;
    End
   Else
    Begin
      PosToScreen := 0;
      ScreenToPos := 0;
    End;
   lgBarre := Trunc(FPageSize * PosToScreen);
   PosBarre := Trunc(FPos * PosToScreen + MZone.Top);
   If lgBarre < 10 Then
      lgBarre := 10;

   refresh;
 End;

//Accompli des actions sur les changements de position
//ajustement de NPOs possible
Procedure tDegradeScrollBar.SurPosChange(Var NPos : LongInt);
 begin
   if assigned(FonPosChange) Then
      FonPosChange(Self, NPos);
 end;

//Change la position du curseur
//Envoi vnements, vrifie erreurs
Procedure tDegradeScrollBar.SetPosition(NPos : LongInt);
 Begin
   If (NPos <> FPos) and (pageSize < max - min) Then
    Begin
       If NPos < Min Then
          NPos := Min
       Else If NPos + FPageSize > Max Then
            NPos := Max - FPageSize;
       SurPosChange(NPos);
       FPos := NPos;
       Recalculer;
       if Assigned(FOnApresPosChange) Then
          FOnApresPosChange(Self);
    End;
 End;

procedure tDegradeScrollBar.SetMax(const Value: LongInt);
 begin
   If Value < Min Then
      Raise Exception.Create('Le maximum ne peut tre plus petit que le minimum');
   FMax := Value;
   if position + pageSize > fMax then
      position := fMax - PageSize;
   Recalculer;
 end;

procedure tDegradeScrollBar.SetMin(const Value: LongInt);
 begin
   If Value > Max Then
      Raise Exception.Create('Le minimum ne peut tre plus grand que le maximum');
   FMin := Value;
   if Position < min then
      position := min;
   Recalculer;
 end;

procedure tDegradeScrollBar.resize;
 begin
   inherited;
   //Self.Height := Parent.ClientHeight - Self.Top;
   recalculer;
 end;

procedure tDegradeScrollBar.SetFlecheDim(const Value: Byte);
 begin
   if (Value > 4) and (Value < 40) then
    begin
      FlecheDim := Value;
      width := flecheDim;
    end;
 end;

{Procedure tDegradeScrollBar.SetParent(AParent : TWincontrol);
 Begin
   If (AParent is TScrollingWinControl) or (AParent = nil) Then
    Begin
      FScrollChose := AParent as TScrollingWinControl;
    End
   Else ShowMessage('Parent pas Scrolling');
   inherited;

   {If Parent <> nil Then
    Begin
      CouleurBord := Parent.Brush.Color + $00010101;}{
       FScrollChose.ScrollBy(0, NPos - FPos);

 End;}
procedure tDegradeScrollBar.setPageSize(const Value: LongInt);
 begin
   FPageSize := Value;
   if position + fPageSize > fMax then
      Position := fMax - fPageSize;
   recalculer;
 end;

procedure tDegradeScrollBar.AfterConstruction;
 begin
   inherited;
   CouleurHaut        :=  $00500808;
   CouleurBas         :=  $00084040;
   VariationLaterale  :=  $002F0F20;

   colBouton := $00450088;
   colFleche := $00100050;
   colDesactiver := $00B0B0B0;

   FocusSurClique := true;

 end;

procedure tDegradeScrollBar.SetColBouton(const Value: TColor);
 begin
   ColBouton := Value;
   Refresh;
 end;

procedure tDegradeScrollBar.SetColFleche(const Value: TColor);
 begin
   ColFleche := Value;
   Refresh;
 end;

procedure tDegradeScrollBar.SetCouleurDesactiver(const Value: TColor);
 begin
   ColDesactiver := Value;
   Refresh;
 end;

{ tTomList }

procedure tDegradeList.AfterConstruction;
 begin
   inherited;
   Selection := 0;

   FRemplissage.Haut :=  $00550808;
   FRemplissage.Bas  :=  $00805060;
   FRemplissage.Dif  :=  $002F0F20;
   fCouleurText := clWhite;

   nCoul := $00777777;

   TabStop := True;
   Width := 150;

   Scroll := tDegradeScrollBar.Create(self);
   scroll.Parent := Self;
   scroll.OnApresPosChange := ApresScroll;
 end;

//Cette fonction retourne la hauteur total d'un lment avec les lignes de
//sparation comprise
function tDegradeList.HauteurEl;
 begin
   result := hLigne + 1;
 end;

//raffichage aprs scrolling
procedure tDegradeList.ApresScroll(Sender : Tobject = nil);
 begin
   refresh;
 end;

//On modifie les proprits de la liste
Procedure tDegradeList.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  begin
    WindowClass.style := CS_DBLCLKS;
    Style := Style or (cs_VREDRAW or cs_HREDRAW or WS_CLIPCHILDREN);
  end;
end;

// surcharger
procedure tDegradeList.PreparerAffichage;
 begin
   //Count  = nombre d'lment
   //hLigne = hauteur d'un lment
   hLigne := ObtenirHauteurEl;
 end;

procedure tDegradeList.DessinerSelection(const rect : tREct);
 begin
   canvas.Brush.Color := SelCoul;
   canvas.FillRect(Rect);
 end;

procedure tDegradeList.DessinerFondNouveau(const rect : tREct);
 begin
   if (Buffer <> nil) and (Buffer.PixelFormat = pf24Bit) then
    begin
      TransRect24Safe(buffer, rect, nCoul);
    end
   else
    begin
      canvas.Brush.Color := NCoul;
      canvas.FillRect(Rect);
    end;
 end;

// surcharger
procedure tDegradeList.AfficherEl(id : Longword; const rect : tREct; const Sel : Boolean);
 begin
   if Sel Then
    begin
      DessinerSelection(rect);
    end
   else if (id = 0) and assigned(surNouveau) then
    begin
      DessinerFondNouveau(rect);
    end;
   Canvas.Font.Color := fCouleurText;
 end;

//Cette procdure peut tre surcharg pour effectuer des action aprs affichage
procedure tDegradeList.ApresAffichage;
 begin
 end;

//Ajustement de la hauteur avant affichage
//(la hauteur ne peut tre ajust dans paint)
procedure tDegradeList.PreparePaint;
 begin
   AjusterHauteur;
 end;

//Affichage des lments de la liste
procedure tDegradeList.Paint;
Var I, y, hRect : LongInt;
 begin
   PreparerAffichage;

   hRect := HauteurEl;
   i := Scroll.Position div (hRect);
   y := - scroll.Position + (hRect) * i;
   while i < count Do
    Begin
      canvas.pen.Color := CouleurText;
      canvas.brush.Style := bsClear;
      AfficherEl(I, rect(Scroll.Width + 2, y, width, y + hLigne), i = selection);
      inc(I);
      inc(y, hLigne);
      canvas.pen.Color := lCoul;
      canvas.MoveTo(Scroll.Width + 4, y);
      canvas.LineTo(width - 4, y);
      inc(y);
    End;

   ApresAffichage;
 end;

//doit tre surcharg par les classes descendantes
function tDegradeList.ObtenirHauteurEl: LongInt;
 begin
   result := 0;
 end;

procedure tDegradeList.ChoisirItem;
 begin
   if fVerrouillerSurClique then
    begin
      selLock := true;
      //enabled := false;
    end;
 end;

//On ne fait rien, cette procdure doit tre surcnarg
//par les objets descendants
procedure tDegradeList.PreVisualiserItem;
 begin
 end;

//Sur clique de la souris, choisir l'item
procedure tDegradeList.MouseDown(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
 begin
   inherited;
   if (not SelLock) then
    begin
      Selection := (y + Scroll.Position) div (HauteurEl);
      If Selection in [0..Count-1] then
         ChoisirItem;
    end;
 end;

//Prvisualisation des items sur mouvements de la souris
procedure tDegradeList.MouseMove(Shift: TShiftState; X, Y: Integer);
var AncSelection : LongInt;
 begin
   inherited;
   if (not SelLock) then
    begin
      AncSelection := Selection;
      Selection := (y + Scroll.Position) div (HauteurEl);
      refresh;
      If (Selection in [0..Count-1]) and (Selection <> AncSelection) then
         PreVisualiserItem;
    end;
 end;

//Mise  jours de la scroll bar et raffichage quand les donnes changent
procedure tDegradeList.DataAChange;
 begin
   hLigne      := ObtenirHauteurEl;
   scroll.Min  := 0;
   scroll.Max  := HauteurEl * count;
   scroll.Step := HauteurEl;
   scroll.pageSize  := Height;
   scroll.LargeStep := Height;
   refresh;
 end;

procedure tDegradeList.KeyDown(var Key: Word; Shift: TShiftState);
 begin
 end;

// cause du nouveau, la slection peut varier
//Cette fonction ajuste la slection pour que le nouveau ne soit as pris en compte
//-1 PAs de slection
//0 Nouveau
//1 lment un
function tDegradeList.VraiIdSel : LongInt;
 begin
   result := selection;
   if (not Assigned(SurNouveau)) and (selection >= 0) then
      inc(result);
 end;


//Change la slection active!
procedure tDegradeList.SetSelection(const Value: longInt);
var maxPos, minPos : LongINt;
 begin
   if Count = 0 then
      exit;

   Selection := Value;
   if selection < 0 then
      selection := Count + (selection mod Count)
   else
      selection := selection mod Count;
   MinPos := ((selection + 1) * (HauteurEl)) - Height;
   MaxPos := ((selection - 1) * (HauteurEl)) + Height;
   if Scroll.Position > MaxPos then
      Scroll.Position := MaxPos
   else if Scroll.Position < MinPos then
      Scroll.Position := MinPos;
   refresh;
   preVisualiserItem;
 end;

procedure tDegradeList.DefaultHandler(var Message);
 begin
   case TMessage(Message).Msg of
     WM_SETFOCUS:
       if (Win32Platform = VER_PLATFORM_WIN32_WINDOWS) and
         not IsWindow(TWMSetFocus(Message).FocusedWnd) then
         TWMSetFocus(Message).FocusedWnd := 0;
   end;
   inherited;
 end;

//Gestion de l'appuie d'une touche(Avec CN_KEY_DOWN on a toutes les touches)
procedure tDegradeList.CNKeyDown(var Message: TWMKeyDown);
 begin
   if selLock then
    begin
      inherited;
      exit;
    end;

   case Message.CharCode of
    VK_DOWN: begin
      itemIndex := ItemIndex + 1;
      Message.CharCode := 0;
    end;
    VK_UP: begin
      itemIndex := itemIndex - 1;
      Message.CharCode := 0;
    end;
    VK_RETURN: begin
      ChoisirItem;
      Message.CharCode := 0;
    end;
   else
      inherited;
   end;
 end;

constructor tDegradeList.Create(AOwner: TComponent);
 begin
   inherited;
   ControlStyle := ControlStyle + [csClickEvents, csOpaque, csReplicatable];
 end;

function TDegradeScrollBar.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 begin
   if fPos + pageSize < max then
    begin
      position := position + self.Step;
      result := true;
    end
   else
      result := false;
 end;

function TDegradeScrollBar.DoMouseWheelUp(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 begin
   if fPos > min then
    begin
      position := position - self.Step;
      result := true;
    end
   else
      result := false;
 end;

procedure TDegradeScrollBar.CNKeyDown(var Message: TWMKeyDown);
 begin
   case Message.CharCode of
    VK_DOWN: begin
      position := position + STEP;
      Message.CharCode := 0;
    end;
    VK_UP: begin
      position := position - STEP;
      Message.CharCode := 0;
    end
    else
      inherited;
   end;
 end;

{ TBufferedControl }

procedure TBufferedControl.AfterConstruction;
 begin
   inherited;
   FDoubleBuffered := True;
   Buffer := TBitmap.Create;
   width  := 15;
   Height := 15;
 end;

procedure TBufferedControl.BeforeDestruction;
 begin
   inherited;
   Buffer.Free;
 end;

//Ajout du paramtre WS_CLIPCHILDREN
procedure TBufferedControl.CreateParams(var Params: TCreateParams);
 begin
   inherited CreateParams(Params);
   with Params do
   begin
     WindowClass.style := CS_DBLCLKS;
     Style := Style or (WS_CLIPCHILDREN);
   end;

 end;

//Cette procdure permet au contrle descendant d'effectuer des modifications
//avant que le buffer ne soit dimensionn pour l'affichage
procedure TBufferedControl.PreparePaint;
 begin
 end;

procedure TBufferedControl.RetirerBuf;
 begin
   Buffer.Free;
   Buffer := nil;
 end;

//C'est un simple petit systme pour viter que l'arrire plan soit
//dessin n'importe quand
procedure TBufferedControl.WMEraseBkgnd(var Message: TWmEraseBkgnd);
 begin
   if ((TMessage(Message).wParam = TMessage(Message).lParam)) then
    begin
      FillRect(Message.DC, ClientRect, Brush.Handle);
      Canvas.Brush.Color := clBlack;
      FrameRect(Message.DC, rect(0, 0, width, height), Canvas.Brush.Handle)
    end;
   Message.Result := 1;
 end;

//Gestion personnalis de l'affichage!
//Buffer est utilis pour toute les oprations d'affichage
//Le format du Buffer est toujour pf24Bit ( amliorer?)
procedure TBufferedControl.WMPaint(var Message: TWMPaint);
var
  DC, MemDC: HDC;
  OldBitmap: HBITMAP;
  PS: TPaintStruct;
  persoDC : Boolean;
begin
  if (not DoubleBuffered) or (Message. DC <> 0) then
  begin
    if Message.DC = 0 then
     begin
       persoDC := true;
       DC := BeginPaint(Handle, PS);
       Message.DC := DC;
     end
    else
      persoDC := false;

    if not fDoubleBuffered then
     begin
       retirerBuf;//On ne peut pas utiliser le buffer...
       Perform(WM_ERASEBKGND, Message.DC, Message.DC);//Ncessaire pour dgrad
     end;
    if not (csCustomPaint in ControlState) and (ControlCount = 0) then
      inherited
    else
      PaintHandler(Message);

    if persoDC then
     begin
       EndPaint(Handle, PS);
       //deleteDC
     end;

  end
  else
  begin
    PreparePaint;
    If Buffer = nil Then
       Buffer := TBitmap.Create;
    Buffer.PixelFormat := pf24Bit;
    Buffer.Width := Width;
    Buffer.Height := Height;
    //Buffer.Dormant
    MemDC := CreateCompatibleDC(0);
    OldBitmap := SelectObject(MemDC, Buffer.Handle);
    try
      DC := BeginPaint(Handle, PS);
      Message.Unused := Buffer.Handle;
      Perform(WM_ERASEBKGND, MemDC, MemDC);
      Message.DC := MemDC;
      WMPaint(Message);
      Message.DC := 0;
      BitBlt(DC, 0, 0, ClientRect.Right, ClientRect.Bottom, MemDC, 0, 0, SRCCOPY);
      EndPaint(Handle, PS);
    finally
      SelectObject(MemDC, OldBitmap);
      DeleteDC(MemDC);
      retirerBuf;// cause trop de ralentissent...
    end;
  end;
end;

{ TDegradeControl }

procedure TDegradeControl.AfterConstruction;
 begin
   inherited;
   FRemplissage.Haut :=  $00550808;
   FRemplissage.Bas  :=  $00D00000;
   FRemplissage.Dif  :=  $002F0F20;
   DegradeActif := true;
end;

//Cette objet doit tre compltement redessiner sur redimensionnement
//Et a fait pas beau quand on dessine par dessus les contrles enfants...
procedure TDegradeControl.CreateParams(var Params: TCreateParams);
 begin
   inherited CreateParams(Params);
   with Params do
   begin
     WindowClass.style := cs_DBLCLKS;
     Style := Style or cs_VREDRAW or cs_HREDRAW or ws_CLIPCHILDREN;
  end;

 end;

procedure TDegradeControl.SetDegradeActif(const Value: Boolean);
 begin
   fDegradeActif := Value;
   repaint;
 end;

procedure TDegradeControl.SetRemplissage(const Value: tTomDegrade);
 begin
   FRemplissage := Value;
   refresh;
 end;

procedure TDegradeControl.SetRemplissageBas(const Value: TColor);
 begin
   FRemplissage.Bas := Value;
   refresh;
 end;

procedure TDegradeControl.SetRemplissageDif(const Value: TColor);
 begin
   FRemplissage.Dif := Value;
   refresh;
 end;

procedure TDegradeControl.SetRemplissageHaut(const Value: TColor);
 begin
   FRemplissage.Haut := Value;
   refresh;
 end;

//Cette procdure est appel pour dessiner l'arrire plan
procedure TDegradeControl.WMEraseBkgnd(var Message: TWmEraseBkgnd);
 begin
   { Affiche l'arrire plan n'est affich que si c'est nous qui l'avons demand
     c'est que si c'est windows qui nous appelle, on ne sera probeblement pas
     dans un tat permettant d'afficher correctement}
   if ((TMessage(Message).wParam = TMessage(Message).lParam)) then
    begin
      if fDegradeActif then
       begin
         If Buffer <> nil then
            DegradeBMP(Buffer, ClientRect, Remplissage, Canvas.ClipRect)
         else//S'il n'y pas de Buffer, utiliser le vieux systme lent
            Degrade(Canvas, ClientRect, Remplissage, Canvas.ClipRect);
       end
      else
         FillRect(Message.DC, ClientRect, Brush.Handle);
    end;
   Message.Result := 1;
 end;

{TDegradePanel}
//Cette procdure est appel pour dessiner l'arrire plan
procedure tDegradePanel.CreateParams(var Params: TCreateParams);
 begin
   inherited;
   ControlStyle := [csAcceptsControls, csCaptureMouse, csClickEvents,
    csOpaque, csDoubleClicks, csReplicatable];

 end;

procedure tDegradePanel.SetAlignment(Value: TAlignment);
 begin
   FAlignment := Value;
   Invalidate;
 end;

//refraichissement sur changement de grandeur
procedure TDegradeControl.WMSize(var Message: TWMSize);
 begin
   inherited;
   refresh;
 end;

//Cette procdure ajuste la hauteur si besoin
procedure tDegradeList.AjusterHauteur;
var cHeight , limite: LongInt;
 begin
   if (fAutoHeight) and (parent <> nil) then
    begin
      cHeight := Count * HauteurEl;
      if fInverse then
         limite  := top + height
      else
         limite  := parent.Height - top;
      if cHeight > limite then
         cHeight := limite;
      if cHeight < 5 then
         cHeight := 5;
      if cHeight <> Height then
       begin
         if fInverse then
            top := (top + height) - cHeight;
         Height  := cHeight;
       end;
    end;
 end;

//Active le systme automatis de slection de la hauteur
procedure tDegradeList.SetAutoHeight(const Value: Boolean);
 begin
   fAutoHeight := Value;
   AjusterHauteur;
 end;

//Par  la recherche d'un lment ayant la chaine cherche...
//Be fait rien,  surcharger
function tDegradeList.Cherche(const Chaine: String) : boolean;
 begin
   result := false;
 end;

// surcharg
function tDegradeList.Count: LongInt;
 begin
   result := 0;
 end;

//Quand redimendionnement, on doit absolument mettre  jour les donnes 
procedure tDegradeList.WMSize(var message: TWMSize);
 begin
   inherited;
   DataAChange;
 end;

function tDegradeList.DoMouseWheelDown(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 begin
   result := Scroll.DoMouseWheelDown(Shift, MousePos);
 end;

function tDegradeList.DoMouseWheelUp(Shift: TShiftState;
  MousePos: TPoint): Boolean;
 begin
   result := Scroll.DoMouseWheelUp(Shift, MousePos);
 end;

//J'override cette procdure pour utiliser l'vnement avant qu'il se rande
// la forme principale
procedure tDegradeList.MouseWheelHandler(var Message: TMessage);
 begin
   with Message do
    begin
      Result := Perform(CM_MOUSEWHEEL, WParam, LParam);
      if Result=0 then
         inherited;
    end;
 end;

{ tFlecheBouton }
//Initialiser!
procedure tFlecheBouton.AfterConstruction;
 begin
   inherited;
   color     := $00450088;
   colFleche := $00100050;
   fColDesactiver := $00B0B0B0;

 end;

procedure tFlecheBouton.Paint;
var Brect: tREct;
 begin
   inherited;
   bRect := ClientRect;
   dec(bRect.Bottom);
   dec(bRect.Right);
   if Enabled then
    begin
      DessinerBouton(Canvas, bRect, color);
      Inc(brect.Top, 1);
      DessinerFleche(Canvas, AjouterEspacement(bRect, -1), colFleche);
    end
   else
      DessinerBouton(Canvas, bRect, fColDesactiver);
 end;

procedure tFlecheBouton.SetDesactiver(const Value: tColor);
 begin
   fColDesactiver := Value;
   repaint;
 end;

procedure tFlecheBouton.SetFleche(const Value: tColor);
 begin
   fcolFleche := Value;
   repaint;
 end;

procedure tDegradeList.SetCouleurText(const Value: TColor);
 begin
   fCouleurText := Value;
   repaint;
 end;

procedure tDegradeList.SetlCoul(const Value: TColor);
 begin
   lCoul := Value;
   repaint;
 end;

procedure tDegradeList.SetnCoul(const Value: TColor);
 begin
   nCoul := Value;
   repaint;
 end;

procedure tDegradeList.SetselCoul(const Value: TColor);
 begin
   selCoul := Value;
   repaint;
 end;

end.
