unit uGestionExecUtils;
//--------------------------------------------------------------------
//Unti utilitaire: uGestionExecUtils
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:23 Novembre 2002
//--------------------------------------------------------------------

//Cette unit contient des objet et fonction utilitaires grer excution
//d'un programme

//tCallParal : Appelle une procdureObj en parallle
//             l'objet peut tre utiliser pour faire un contrle de la progression
//             ATTENTION: Ne pas tenter de faire afficher des botes de dialogues
//                        Dans la procdure appel
//                        A risque de faire planter

interface

uses classes, syncObjs, sysUtils, dialogs, windows;

const TimeOut = 1000;

type
  tProcedureObj = Procedure of object;

  //Sert  excuter une procdure d'objet en parallle
  tCallParal = class(tThread)
   protected
     fSynchronizeEnCours : Boolean;
     AAppeler : tProcedureObj;
     Procedure CallAAppeler;
   public
     CallProcedure, CallFin : tProcedureObj;
     Constructor Create(Proc : tProcedureObj); overload;
     Constructor Create(Proc, ProcFin: tProcedureObj); overload;
     Procedure Execute; override;
     Procedure AppelSecure(Proc : tProcedureObj);
   published
     property SynchronizeEnCours : Boolean read fSynchronizeEnCours;
  End;

  //Semblable au prcdent saut que ne se supprime pas
  tTravailParal = class(tThread)
   protected
     Procedure Execute; override;
   public
     CallProcedure, CallFin : tProcedureObj;
     Constructor Create(Proc : tProcedureObj);
  end;

  //Lanceur de travail pouvant tre appel plusieurs fois mais n'effectuant
  //la tche qu'avec un seul exemplaire de lui mme
  tGestionnaireTravailParal = class(tTravailParal)
   private
     DemandeTraitement : tCriticalSection;
     Terminer : tEvent;
     TraitementARefaire : Boolean;
     msg : String;
     procedure AfficherMsg;
    procedure VerifierArret;
   protected
     Procedure Execute; override;
   public
     CallAvant : tProcedureObj;
     procedure RefaireJOB;
     procedure AfterConstruction; override;
     procedure BeforeDestruction; override;
  end;

implementation

//Initialisation de l'appel de la procdure en parallle
constructor tCallParal.Create(Proc: tProcedureObj);
 begin
   CallProcedure := Proc;
   CallFin := nil;
   FreeOnTerminate := True;
   Inherited Create(False);
 end;

//Initialisation de l'appel de la procdure en parallle
procedure tCallParal.AppelSecure(Proc: tProcedureObj);
 begin
   AAppeler := Proc;
   fSynchronizeEnCours := true;
   synchronize(CallAAppeler);
   fSynchronizeEnCours := false;
 end;

procedure tCallParal.CallAAppeler;
 begin
   if (not terminated) and assigned(AAppeler) then
      AAppeler;
 end;

constructor tCallParal.Create(Proc, ProcFin: tProcedureObj);
 begin
   CallProcedure := Proc;
   CallFin := ProcFin;
   FreeOnTerminate := True;
   Inherited Create(False);
 end;

//Appel de la procdure en parallle
procedure tCallParal.Execute;
 begin
   if assigned(CallProcedure) then
      CallProcedure;
   if assigned(CallFin) then
      synchronize(callFin);
 end;


{ tTravailParal }

constructor tTravailParal.Create(Proc: tProcedureObj);
var osInfo : OSVERSIONINFO;
 begin
   CallProcedure := Proc;
   FreeOnTerminate := False;
   osInfo.dwOSVersionInfoSize := sizeOf(osInfo);
   Inherited Create(true);
   if GetVersionEx(osInfo) then
    begin
      //if osInfo.dwPlatformId = VER_PLATFORM_WIN32_NT then
         Priority := tpLower;//PRIORITY ne fonctionne que sous NT!
    end;
 end;

procedure tTravailParal.Execute;
 begin
   if assigned(CallProcedure) then
      CallProcedure;
   if assigned(CallFin) then
      synchronize(CallFin);
 end;

{ tGestionnaireTravailParal }

procedure tGestionnaireTravailParal.AfterConstruction;
 begin
   inherited;
   DemandeTraitement := tCriticalSection.Create;
   Terminer := tEvent.Create(nil, true, true, '');
   TraitementARefaire := false;
 end;

//libration  la destruction
procedure tGestionnaireTravailParal.BeforeDestruction;
var waitr : TWaitResult;
 begin
   demandeTraitement.Enter;
   try
      TraitementARefaire := false;
      Terminate;
      resume;
   finally
      demandeTraitement.Leave;
   end;
   waitr := Terminer.WaitFor(timeOut);
   if waitr <> wrSignaled then
    begin
      resume;
      if terminer.WaitFor(timeOut) <> wrSignaled then
         msg := 'Erreur  l''attente de la teminiason du processus';
    end;
   inherited;
   DemandeTraitement.free;
   Terminer.Free;
 end;

//affiche un message d'erreur
procedure tGestionnaireTravailParal.AfficherMsg;
 begin
   ShowMessage(msg);
   msg := '';
 end;

//Cette procdure est appel et synchronis
procedure tGestionnaireTravailParal.VerifierArret;
 begin
   if Terminated then
      suspend;
 end;

//Effectue le travail
procedure tGestionnaireTravailParal.Execute;
 begin
   while not terminated do
    begin
      demandeTraitement.Enter;
      try
        while TraitementARefaire do
         begin
           TraitementARefaire := False;
           demandeTraitement.Leave;
           try
             if assigned(CallAvant) then
                synchronize(CallAvant);
             inherited;
           except
             On E : Exception do
              begin
                msg := e.Message;
                synchronize(AfficherMsg);
              end;
           end;
           demandeTraitement.Enter;
         end;
      finally
        demandeTraitement.Leave;
      end;
      synchronize(VerifierArret);
    end;
   Terminer.SetEvent;
 end;

procedure tGestionnaireTravailParal.RefaireJOB;
 begin
   try
     demandeTraitement.Enter;
     TraitementARefaire := True;
     terminer.ResetEvent;
     resume;
   finally
     demandeTraitement.Leave;
   end;
 end;

end.
