unit uFunEffet;
//--------------------------------------------------------------------
//Unti utilitaire: uFunEffet
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:8 Dcembre 2002
//--------------------------------------------------------------------

//Cette unti permet de produire des effets graphiques intressent
//Contient: tProjecteurImage
//       Une image dans le noir avec un spot pour l'clairer
//       Gestion tirement et transparence

interface
uses extctrls, Graphics, Controls, classes, uGraphCompo, uGraphFonc;

type
 tProjecteurImage = class(tImage)
  private
    procedure SetRemplissage(const Value: tTomDegrade);
    procedure SetRemplissageBas(const Value: TColor);
    procedure SetRemplissageDif(const Value: TColor);
    procedure SetRemplissageHaut(const Value: TColor);
    procedure ActualiserImg;
  protected
    FRemplissage : tTomDegrade;
    fDegradeActif : Boolean;

    Buffer : tBitmap;
    procedure Paint; override;
  public
  published
    property Remplissage : tTomDegrade read FRemplissage write SetRemplissage;
    property CouleurHaut : TColor read FRemplissage.Haut write SetRemplissageHaut;
    property CouleurBas : TColor read FRemplissage.Bas write SetRemplissageBas;
    property VariationLaterale : TColor read FRemplissage.Dif write SetRemplissageDif;
    property DegradeActif : Boolean read fDegradeActif write fDegradeActif;
 end;

implementation

{ tProjecteurImage }

procedure tProjecteurImage.ActualiserImg;
 begin
   Buffer.PixelFormat := pf24Bit;
   Buffer.Width := Width;
   Buffer.Height := Height;
   uGraphFonc.DegradeBMP(Buffer, rect(0, 0, width, height), fRemplissage);


 end;

procedure tProjecteurImage.Paint;
 begin
   ActualiserImg;

   with (self as TGraphicControl).Canvas do
        Draw(0, 0, Buffer);
 end;

procedure tProjecteurImage.SetRemplissage(const Value: tTomDegrade);
begin
  FRemplissage := Value;
end;

procedure tProjecteurImage.SetRemplissageBas(const Value: TColor);
begin
  FRemplissage.Bas := Value;
end;

procedure tProjecteurImage.SetRemplissageDif(const Value: TColor);
begin
  FRemplissage.Dif := Value;
end;

procedure tProjecteurImage.SetRemplissageHaut(const Value: TColor);
begin
  FRemplissage.Haut := Value;
end;

end.
