unit uFiltreEdit;
//--------------------------------------------------------------------
//Unti utilitaire: FiltreEdit
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:17 Janvier 2003
//--------------------------------------------------------------------

//Cette unit contient un Edit modifi pour que la touche
//entr provoque un effet similaire  la touche TAB
//Cet Edit possde aussi un systme de filtrage
//NOTE: Si on veut, on peut forcer le contrle  pass  un objet spcifique au
//lieu de faire tab

//Enlever le "NO" pour activer le log de dbogage
{$DEFINE NODEBUG}

interface

uses stdctrls, Controls, classes, db, sysUtils, Windows, dialogs, messages,
     graphics, uJChaine, uGraphCompo, uBDUtils, uBDCompo;

const MinEspacePourListe = 100;
      LectureImpossible = 'Lecture impossible : ';
      FlottantInvalide = 'Nombre invalide';
      DateInvalide = 'Date invalide';
type
  tTomFiltre = (tfInconnu, tfNormal, tfEntier, tfFlottant, tfBoolean, tfDate);
  TChangement = record
    Champs, NValeur : String;
  end;
  TChangementList = Array of TChangement;

  tFiltreEdit = class(TEdit)
  private
    FSurEntrer: tNotifyEvent;
    fCoulSurErreur: tColor;
    fCoulSurChange: tColor;
    fCoulSurOk: tColor;
    FDinaCoul: Boolean;
    { Private declarations }
    procedure SetFiltre(const Value: tTomFiltre);
    function ValiderDonnee(var Msg : String; const AutoCorriger : Boolean) : Boolean;
    procedure SetSurEntrer(const Value: tNotifyEvent);
  protected
    { Protected declarations }
    NextFocus : TWinControl;
    fSelectSurEntrer, SelectAllActif : Boolean;
    fFiltre : tTomFiltre;
    FPasNegatif : Boolean;
    TextSurEntrer : String;
    Procedure SetNextFocus(Control : TWinControl);
    procedure keyPress(var Key: Char); override;
    procedure DoExit; override;
    procedure DoEnter; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure CNKeyDown(var Message: TWMKeyDown); message CN_KEYDOWN;
    procedure VerifierColorier(const AfficherErreur : Boolean); virtual;
    procedure FaireEntrer;
  public
    { Public declarations }
    procedure AfterConstruction; override;
  published
    { Published declarations }
    property NextTab : TWinControl read NextFocus write SetNextFocus default nil;
    property SelectSurEntrer : Boolean read fSelectSurEntrer write fSelectSurEntrer;
    property Filtre : tTomFiltre read fFiltre write SetFiltre default tfNormal;
    property PasNegatif : Boolean read FPasNegatif write FPasNegatif;
    property SurEntrer : tNotifyEvent read FSurEntrer write SetSurEntrer;
    property CoulSurErreur : tColor read fCoulSurErreur write fCoulSurErreur;
    property CoulSurOk : tColor read fCoulSurOk write fCoulSurOk;
    property CoulSurChange : tColor read fCoulSurChange write fCoulSurChange;
    property DinaCoul : Boolean read FDinaCoul write fDinaCoul;
  end;

  tFiltreBDEdit = class(tFiltreEdit)
   private
     DebVal, FChampSource : String;
     FDataSource : TDataSource;
     procedure ChangeDataSource(NDataSource : TDataSource);
     procedure SetChampSource(const Value: String);
     procedure SetDataType(Value: TFieldType);
     function  ValiderDonnee(var Msg : String; const AutoCorriger : Boolean) : Boolean;
   protected
     fObligatoire : boolean;
     DataType   : TFieldType;
     Connection : tObject;
     procedure SetParent(AParent: TWinControl); override;
     procedure VerifierColorier(const AfficherErreur : Boolean); override;
     procedure DoExit; override;
   public
     procedure BeforeDestruction; override;
     Procedure Change; override;
     procedure AnnulerModifications;
     procedure Nouveau;
     procedure LireEnr; dynamic;
     Function Modifie : Boolean;
     function SQLValeur : String; dynamic;
     procedure VerifierChampSource; dynamic;
     procedure ExtraireChangements(var list : tChangementList); dynamic;
     procedure MiseAJourBD(Sender : tObject); dynamic;
   published
     property Obligatoire : boolean read fObligatoire write fObligatoire;
     property DataSource  : TDataSource read FDataSource write ChangeDataSource;
     property ChampSource : String read FChampSource write SetChampSource;
  end;

  tFiltreComboBD = class(tFiltreBDEdit)
   private
     procedure ActualiserBtn;
     function  ReadChampAffiche: String;
     function  ReadDataBaseName: String;
     function  ReadOrdreTri: String;
     function  ReadTableName: String;
     procedure SetChampAffiche(const Value: String);
     procedure SetDataBaseName(const Value: String);
     procedure SetOrdreTri(const Value: String);
     procedure SetTableName(const Value: String);
     procedure SurCliqueBouton(Sender : tObject);
     function  ReadListeVisible: Boolean;
     procedure SetListeVisible(const Value: Boolean);
     procedure SurChoisirItem(Sender: tObject);
     function  GetOnNouveau: tNotifyEvent;
     procedure SetOnNouveau(const Value: tNotifyEvent);
    procedure ActualiserTexte;
   protected
     bouton : tFlecheBouton;
     list : tDegradeList;
     fChampUtilise : String;
     DebSel, vSel : LongInt;
     procedure AdjustClientRect(var Rect: TRect); override;
     procedure SetParent(AParent: TWinControl); override;
     procedure Resize; override;
     procedure DoExit; override;
     procedure DoEnter; override;
     procedure CNKeyDown(var Message: TWMKeyDown); message CN_KEYDOWN;
     procedure SetEnabled(value : boolean); override;
   public
     procedure AfterConstruction; override;
     procedure Change; override;
     procedure MouseWheelHandler(var Message: TMessage) ; override;
     procedure LireEnr; override;
     procedure VerifierChampSource; override;
     procedure ExtraireChangements(var list : tChangementList); override;
     procedure MiseAJourBD(Sender : tObject); override;
   published
     property OnNouveau : tNotifyEvent read GEtOnNouveau write SetOnNouveau;
     property ListeVisible : Boolean read ReadListeVisible write SetListeVisible;
     property ChampAffiche : String read ReadChampAffiche write SetChampAffiche;
     property ChampUtilise : String read fChampUtilise    write fChampUtilise;
     property OrdreTri     : String read ReadOrdreTri     write SetOrdreTri;
     property DataBaseName : String read ReadDataBaseName write SetDataBaseName;
     property TableName    : String read ReadTableName    write SetTableName;
     property ListeDeroulante : tDegradeList read list;
  end;

function SimulerTab(Parent, PointDepart : TWinControl) : Boolean;
function DansListeChangement(const el : String;
         const Changement : tChangementList) : Boolean;
function TrouveDansListeChangement(const el : String;
         const Changement : tChangementList) : LongInt;

implementation

uses uAutoBDGraphique;//Est-ce OK?

//Cette fonction retourne vrai si l'lment el est dans la liste de changement
function DansListeChangement(const el : String;
         const Changement : tChangementList) : Boolean;
 begin
   result := (TrouveDansListechangement(el, Changement) >= 0);
 end;

//Cette fonction retourne la position de l'lment dans la liste de changement
//retourne -1 dans le cas contraire
function TrouveDansListeChangement(const el : String;
         const Changement : tChangementList) : LongInt;
 begin
   result := 0;
   while (result < Length(Changement)) and
   (UpperCase(Changement[result].Champs) <> UpperCase(el)) do
      inc(result);
   if result >= length(Changement) then
      result := -1;
 end;

//C'est le seul moyen que j'ai trouv pour faire un Tab
//retourne vrai en cas de succs
function SimulerTab(Parent, PointDepart : TWinControl) : Boolean;
Var TabList : TList;
    CurControl : TWinControl;
    StartIndex, I : LongInt;
 Begin
   result := False;
   If Parent <> Nil Then
    Begin
      TabList := TList.Create;
      try
        Parent.GetTabOrderList(TabList);
        if TabList.Count > 0 then
         begin
           StartIndex := TabList.IndexOf(PointDepart);
           if StartIndex = -1 then
              StartIndex := TabList.Count - 1;
           I := StartIndex;
           repeat
             Inc(I);
             If (I = StartIndex) Then Exit;//On est revenu au dpart on quitte
             if I >= TabList.Count then
              begin
                If SimulerTab(Parent.Parent, PointDepart) then
                   exit
                else
                  I := 0;
              end;
             CurControl := TabList[I];
           until (CurControl.CanFocus and CurControl.TabStop);
           result := True;
           CurControl.SetFocus;
         end;
      finally
        TabList.Free;
      end;
    End;
 End;

{tFiltreEdit }

procedure tFiltreEdit.SetNextFocus(Control: TWinControl);
 begin
   NextFocus := Control;
 end;

//Vrifie les donnes
//retourne vrai si pas d'erreurs
//Si il y une erreur, il y aura un message d'erreur
//Si le paramtre AutoCorriger vaut vrai, certain correctif seront apport...
function tFiltreEdit.ValiderDonnee(var Msg : String; const AutoCorriger : Boolean) : Boolean;
Var tFiltrer, filtre1 : String;
 begin
   {$IFDEF Debug}
   debug('Valider donnes DBUT');
   {$ENDIF}
   result := false;
   Msg := '';

   //Filtrage des caractre mchants(pas accept par SQL)
   filtre1 := RetirerDeChaine(text, ['"', '''']);
   tFiltrer:= filtre1;

   case Filtre of
     tfNormal : begin
     end;
     tfEntier : begin
       tFiltrer := Filtrer(filtre1, '0', '9');
       while ((length(tFiltrer) > 0) and (tFiltrer[1] = '0')) do
          tFiltrer := copy(tFiltrer, 2, length(tFiltrer) - 1);
       if (Length(filtre1) > 0) and (filtre1[1] = '-') then
          tFiltrer := '-' + tFiltrer;
     end;
     tfFlottant : begin
        tFiltrer := ValiderFlottant(filtre1, result);
        If not result Then
         begin
           msg := FlottantInvalide;
           exit;
         end;
      end;
     tfBoolean: begin
        if (upperCase(filtre1) <> 'VRAI') and (upperCase(filtre1) <> 'FAUX') then
           tFiltrer := 'FAUX';
      end;
     tfDate :
      begin
        try
          if (filtre1 <> '') then
             StrToDate(filtre1);
        except
         on E:exception do
          begin
            msg := DateInvalide;
            exit;
          end;
        end;
      end;
   end;
   if (tFiltrer <> text) and AutoCorriger Then
      text := tFiltrer;
   result := true;
   {$IFDEF Debug}
   debug('Valider donnes SORTIE');
   {$ENDIF}
 end;

procedure tFiltreEdit.SetFiltre(const Value: tTomFiltre);
var msg : String;
 begin
   {$IFDEF Debug}
   debug('SetFiltre DBUT');
   {$ENDIF}
   fFiltre := Value;
   if not ValiderDonnee(msg, true) then
      text := '';
   {$IFDEF Debug}
   debug('SetFiltre Fin');
   {$ENDIF}
 end;

procedure tFiltreEdit.keyPress(var Key: Char);
 begin
   {$IFDEF Debug}
   debug('tFiltreBDEdit.keyPress Dbut');
   {$ENDIF}
   //Filtrage des caractre mchants(pas accept par SQL)
   if key in ['"', ''''] then
      key := #0
   //Filtrage des ngatifs
   else if FPasNegatif and (key = '-') then
      key := #0;

   //Filtrage selon le type de filtre
   case fFiltre of
    tfFlottant: obligerChiffre(self, key);
    tfEntier: Begin
       if not (key in ['0'..'9', #8]) then
          key := #0;
     End;
    tfDate: begin
     end;
    tfBoolean: begin
      if (upCase(key) = 'V') or (upCase(key) = 'T') or
         ((upperCase(text) = 'FAUX') and (key = ' '))  then
         text := 'Vrai'
      else
         text := 'Faux';
      key := #0;
    end;
   end;

   inherited;
   {$IFDEF Debug}
   debug('tFiltreBDEdit.keyPress FIN');
   {$ENDIF}
 end;

//Quand on sort du tFiltreEdit, valide les donnes
procedure tFiltreEdit.Doexit;
 begin
   inherited;
   VerifierColorier(true);
 end;

procedure tFiltreEdit.DoEnter;
 begin
   inherited;
   TextSurEntrer := text;
   If SelectSurEntrer then
      SelectAllActif := true;
 end;

//Gestion de la slection total du edit sur clique
procedure tFiltreEdit.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
 begin
   inherited;
   if SelectAllActif then
    begin
      SelectAll;
      SelectAllActif := false;
    end;
 end;

//Initialisation
procedure tFiltreEdit.AfterConstruction;
 begin
   inherited;
   {$IFDEF Debug}
   debug('AfterConstruction DBUT');
   {$ENDIF}
   SelectSurEntrer := true;
   fCoulSurErreur  := clMaroon;
   fCoulSurOk      := clWhite;
   fCoulSurChange  := clGreen;
   {$IFDEF Debug}
   debug('AfterConstruction FIN');
   {$ENDIF}
 end;
 
{ tFiltreBDEdit }
//Reprend l'ancienn valeur lue prcdemment
//(avant que l'utilisateur ne la change, au dernier lireEnr)
procedure tFiltreBDEdit.AnnulerModifications;
 begin
   Text := DebVal;
 end;

//Si connection, prvient le controle connect que il y eu un changement
procedure tFiltreBDEdit.Change;
 begin
   inherited;
   if Connection <> nil then
    begin
      (Connection as tDegradeBDPanel).EditAChanger(self);
    end;
 end;


//Change la source de donnes du controle
procedure tFiltreBDEdit.ChangeDataSource(NDataSource: TDataSource);
 begin
   {$IFDEF Debug}
   debug('tFiltreBDEdit.ChangeDataSource Dbut');
   {$ENDIF}
   FDataSource := NDataSource;
   LireEnr;
   {$IFDEF Debug}
   debug('tFiltreBDEdit.ChangeDataSource FIN');
   {$ENDIF}
 end;

//Place dans DataType le type de donnes de la BD
//si le fitre n'est pas configur, le configure
procedure tFiltreBDEdit.SetDataType(Value : TFieldType);
 begin
   {$IFDEF Debug}
   debug('tFiltreBDEdit.SetDataType Dbut');
   {$ENDIF}
   if DataType <> Value Then
    begin
      if (filtre = tfInconnu) and (not (csLoading in ComponentState)) then
       begin
         case value of
          ftSmallint, ftInteger, ftWord, ftLargeInt, ftAutoInc, ftBytes:
                                     filtre := tfEntier;
          ftFloat:                   filtre := tfFlottant;
          ftCurrency:                filtre := tfFlottant;
          ftFixedChar, ftWideString: filtre := tfNormal;
          ftBoolean:                 filtre := tfBoolean;
          ftDate:                    filtre := tfDate;
          else
            filtre := tfNormal;
         end;
       end;
      DataType := value;
    end;
   {$IFDEF Debug}
   debug('tFiltreBDEdit.SetDataType Fin');
   {$ENDIF}
 end;

//Charge les donnes provenant de la base de donnes
procedure tFiltreBDEdit.LireEnr;
Var Field : TField;
 begin
   {$IFDEF Debug}
   debug('tFiltreBDEdit.LireEnr Dbut');
   {$ENDIF}
   try
     If (ChampSource <> '') and DataSourceOuvert(DataSource) Then
      Begin
        Field := DataSource.DataSet.FindField(ChampSource);
        If Field <> nil Then
         Begin
           DebVal := Field.AsString;
           if (DataType = ftString) then
            begin
              MaxLength := Field.Size;
              //ajustement de la valeur pour satisfaire le filtre
              if (fFiltre = tfFlottant) then
               begin
                 ChTxtVersWinFormat(DebVal);
               end;
            end
           else
              MaxLength := 0;

           Text := DebVal;
           SetDataType(Field.DataType);
           VerifierColorier(false);
         End
        Else
          Text := 'ERREUR!';
      End;
   Except
     On E:Exception Do
      Begin
        MessageDlg(LectureImpossible +  ' "' + E.Message + '"', mtError, [mbOk], 0);
      End;
   End;
   {$IFDEF Debug}
   debug('tFiltreBDEdit.LireEnr FIN');
   {$ENDIF}
 end;

//Retourne vrai si les donnes ont t mofifi depuis le dernier chargement
function tFiltreBDEdit.Modifie: Boolean;
 begin
   Result := (DebVal <> Text) And (Enabled = True);
 end;

//Met les donnes  zro
procedure tFiltreBDEdit.Nouveau;
 begin
   DebVal := '';
   Text   := '';
   if Obligatoire then
      color := fCoulSurErreur
   else
      color := fCoulSurOk;
 end;

procedure tFiltreBDEdit.SetChampSource(const Value: String);
 begin
   {$IFDEF Debug}
   debug('tFiltreBDEdit.SetChampSource Dbut');
   {$ENDIF}
   FChampSource := Value;
   VerifierChampSource;
   LireEnr;
   {$IFDEF Debug}
   debug('tFiltreBDEdit.SetChampSource Fin');
   {$ENDIF}
 end;

//Quand un TomBDEdit est plac, on le configure automatiquement
procedure tFiltreBDEdit.SetParent(AParent: TWinControl);
var Parent : tWinControl;
 begin
   {$IFDEF Debug}
   debug('tFiltreBDEdit.SetParent Dbut');
   {$ENDIF}
   if Connection <> nil then
    Begin
      {$IFDEF Debug}
      debug('tFiltreBDEdit -> Connection <> nil');
      {$ENDIF}
      (Connection as tDegradeBDPanel).RetirerTomBD(Self);
      Connection := nil;
    End;

   inherited;

   //Parcour de la hirarchie  la recherche de tDegradeBDPanel
   Parent := AParent;
   while (Parent <> nil) and (not (Parent is tDegradeBDPanel)) do
         Parent := Parent.Parent;

   If (Parent <> nil) and (Parent is tDegradeBDPanel) Then
    Begin
      (Parent as tDegradeBDPanel).AjouterTomBD(Self);
      Connection := Parent;
    End;
   {$IFDEF Debug}
   debug('tFiltreBDEdit.SetParent Fin');
   {$ENDIF}
 end;

//Merveilleuse fonction retournant le champs sous forme utilisable en SQL
function tFiltreBDEdit.SQLValeur: String;
var Msg : String;
 begin
   {$IFDEF Debug}
   debug('tFiltreBDEdit.SQLValeur DBUT');
   {$ENDIF}
   if ValiderDonnee(Msg, true) then
    begin
      result := formatSQL(DataType, text);
      if fFiltre = tfFlottant then
         ChTxtVersSQLFormat(result);//Pour tre certain d'avoir le bon format
    end
   else
      raise Exception.Create(text + '-> ' + Msg);
   {$IFDEF Debug}
   debug('tFiltreBDEdit.SQLValeur FIN');
   {$ENDIF}
 end;

//Validation supplmentaire, on vrifie si les donnes sont dans l'intervalle
//de leur type
function tFiltreBDEdit.ValiderDonnee(var Msg : String; const AutoCorriger : Boolean) : Boolean;
Var Max : String;
 begin
   {$IFDEF Debug}
   debug('tFiltreBDEdit.ValiderDonnee Dbut');
   {$ENDIF}
   result := inherited ValiderDonnee(Msg, AutoCorriger);
   if result and DefoncerMax(text, DataType, MAX) then
    begin
      msg := ' est plus grand que la valeur maximale de ' + MAX;
      result := true;
    end;
   {$IFDEF Debug}
   debug('tFiltreBDEdit.ValiderDonnee Fin');
   {$ENDIF}
 end;

//Validation du champSource
//Raise un exception si erreur
procedure tFiltreBDEdit.VerifierChampSource;
 begin
   if (pos(ChampSource, ',') > 0) or (pos(ChampSource, ' ') > 0) or
      (pos(ChampSource, '(') > 0) or (pos(ChampSource, ')') > 0) then
      raise Exception.Create('CHAMPSOURCE INCORRECT->Ce contrle ne prend pas en charge de multiples champs!'+
                            ('-- Modifiez la proprit champSource!'));
 end;

//Cette procdure extrait toutes les valeurs que le contrle possde
//(C'est que certains contrles, comme les comboBox, peuvent contenir des valeurs
//pour plusieurs champs
//Les valeurs sont ajoutes  la liste
procedure tFiltreBDEdit.ExtraireChangements(var list: tChangementList);
var lg : LongINt;
 begin
   VerifierChampSource;

   lg := Length(list);
   SetLength(list, lg + 1);
   list[lg].Champs  := ChampSource;
   list[lg].NValeur := SQLValeur;
 end;

//Ne fait rien, destin  tre surcharg
procedure tFiltreBDEdit.MiseAJourBD(Sender: tObject);
 begin

 end;

//Cette procdure effectue la gestion du changement de contrle sur entrer
procedure tFiltreEdit.FaireEntrer;
 begin
   {$IFDEF Debug}
   debug('Faire Entrer');
   {$ENDIF}
      if Assigned(fSurEntrer) then
         fSurEntrer(self)
      else If NextFocus = nil Then
       Begin
         SimulerTab(Parent, self);
       End
      Else
       Begin
         NextFocus.SetFocus;
       End;
 end;

//Gestion de la touche entr
//CNKEYDown est appel avant tous les autres
procedure tFiltreEdit.CNKeyDown(var Message: TWMKeyDown);
 begin
   if message.CharCode = VK_ESCAPE Then
    begin
      text := TextSurEntrer;
      message.CharCode := VK_RETURN;
    end;

   If (message.CharCode in [VK_RETURN, VK_TAB])  Then
    Begin
      message.KeyData := 0;
      FaireEntrer;
    End
   else
     inherited;
 end;

procedure tFiltreEdit.SetSurEntrer(const Value: tNotifyEvent);
begin
  FSurEntrer := Value;
end;

//Destruction des connections, on ne veut plus rien avoir!
procedure tFiltreBDEdit.BeforeDestruction;
 begin
   inherited;
   {$IFDEF Debug}
   debug('tFiltreBDEdit.BeforeDestruction Dbut');
   {$ENDIF}
   if Connection <> nil then
      (Connection as tDegradeBDPanel).RetirerTomBD(Self);
   {$IFDEF Debug}
   debug('tFiltreBDEdit.BeforeDestruction Fin');
   {$ENDIF}
 end;

//Vrification erreur + vrification couleur
procedure tFiltreEdit.VerifierColorier(const AfficherErreur : Boolean);
var msg : String;
 begin
   if not ValiderDonnee(msg, false) then
    begin
      if AfficherErreur then
         MessageDlg(Msg, mtError, [mbOk], 0);
      color := fCoulSurErreur;
    end
   else
     color := fCoulSurOk;
 end;

{ tFiltreComboBD }

procedure tFiltreComboBD.AdjustClientRect(var Rect: TRect);
 begin
   rect.Right := bouton.Left;
   inherited;
 end;

procedure tFiltreComboBD.AfterConstruction;
 begin
   inherited;
   bouton := tFlecheBouton.Create(self);
   bouton.OnClick := SurCliqueBouton;
   list   := tDegradeListBD.Create(self);
   list.Visible := false;
   list.tabStop := false;
   list.SetSubComponent(true);
   (list as tDegradeListBD).SurSelection := SurChoisirItem;
   (list as tDegradeListBD).SurDoitMettreAJour := MiseAJourBD;
 end;

//Actualise la position de notre bouton suiveur
procedure tFiltreComboBD.ActualiserBtn;
 begin
   if bouton <> nil then
    begin
      bouton.left   := left + width;
      bouton.Top    := top;
      bouton.Height := Height;
      bouton.Width  := 10;
    end;
 end;

procedure tFiltreComboBD.Resize;
 begin
   inherited;
   actualiserBtn;
 end;

procedure tFiltreComboBD.SetParent(AParent: TWinControl);
 begin
   inherited;
   if (AParent <> nil) and (bouton <> nil) then
    begin
      bouton.Parent := AParent;
      list.Parent   := AParent;
      actualiserBtn;
    end;
 end;

function tFiltreComboBD.ReadChampAffiche: String;
 begin
   result := (list as tDegradeListBD).ChampSource;
 end;

function tFiltreComboBD.ReadDataBaseName: String;
 begin
   result := (list as tDegradeListBD).DataBaseName;
 end;

function tFiltreComboBD.ReadOrdreTri: String;
 begin
   result := (list as tDegradeListBD).OrdreTri;
 end;

function tFiltreComboBD.ReadTableName: String;
 begin
   result := (list as tDegradeListBD).TableName;
 end;

procedure tFiltreComboBD.SetChampAffiche(const Value: String);
 begin
   (list as tDegradeListBD).ChampSource := value;
 end;

procedure tFiltreComboBD.SetDataBaseName(const Value: String);
 begin
   (list as tDegradeListBD).DataBaseName := value;
 end;

procedure tFiltreComboBD.SetOrdreTri(const Value: String);
 begin
   (list as tDegradeListBD).OrdreTri := value;
 end;

procedure tFiltreComboBD.SetTableName(const Value: String);
 begin
   (list as tDegradeListBD).TableName := value;
 end;

//On  cliqu sur le bouton pour faire apparatre la liste...
procedure tFiltreComboBD.SurCliqueBouton(Sender: tObject);
 begin
   if enabled and visible then
    begin
      ListeVisible := true;
      self.SetFocus;
    end;
 end;

//Cette procdure actualise le texte et la slection
procedure tFiltreComboBD.ActualiserTexte;
var data : tDataSet;
 begin
   if (list <> nil) and DataSourceOuvert((list as tDegradeListBD).dataSource) then
    begin
      data := (list as tDegradeListBD).DataSource.DataSet;
      text := AffText(data, ChampAffiche);
      vSel := list.ItemIndex;
    end;
 end;

//L'utilisateur  choisi un item
procedure tFiltreComboBD.SurChoisirItem(Sender: tObject);
 begin
   if (list <> nil) and DataSourceOuvert((list as tDegradeListBD).dataSource) then
    begin
      ActualiserTexte;
      ListeVisible := false;
      FaireEntrer;
    end;
 end;

//Lit l'tat de la liste
function tFiltreComboBD.ReadListeVisible: Boolean;
 begin
   result := list.Visible;
 end;

procedure tFiltreComboBD.SetListeVisible(const Value: Boolean);
var Espace : LongInt;
 begin
   if value then
    begin
      espace := parent.Height - (top + Height);

      list.Parent     := parent;
      list.Left       := left;
      list.Width      := width + bouton.Width;
      if (Parent.Height > espace) and (espace < MinEspacePourListe) then
       begin
         list.Top := top - list.Height;
         list.Inverse := true;
       end
      else
         list.top        := top + Height;
      list.AutoHeight := True;
      list.SelLock    := False;
      //list.Cherche(Text);
      list.Scroll.FocusSurClique := false;
    end;

   list.Visible := value;
 end;

//Ajustement des valeurs sur sortie
procedure tFiltreComboBD.DoExit;
 begin
   listeVisible := false;
   (list as tDegradeListBD).itemIndex := vSel;
   text := (list as tDegradeListBD).Text;
   inherited;
 end;

procedure tFiltreComboBD.DoEnter;
 begin
   inherited;
   debSel := (list as tDEgradeListBD).ItemIndex;
   ListeVisible := true;
 end;

procedure tFiltreComboBD.CNKeyDown(var Message: TWMKeyDown);
 begin
   if (list.Focused = false) and (Message.CharCode in [VK_DOWN, VK_UP, VK_RETURN, VK_TAB]) then
      list.CNKeyDown(message)
   else
    begin
      If (message.CharCode in [VK_RETURN, VK_TAB])  Then
       Begin
         if ListeVisible = true then
            SurChoisirItem(self);
       end
      else if (message.CharCode = VK_ESCAPE) then
       begin
         vSel := DebSel;
       end;

      inherited;
    End

 end;

procedure tFiltreComboBD.Change;
 begin
   inherited;
   list.Cherche(text);
 end;

//Le message est envoy directement  destination...
procedure tFiltreComboBD.MouseWheelHandler(var Message: TMessage);
 begin
   if list <> nil then
    begin
      list.MouseWheelHandler(message);
    end;
 end;

procedure tFiltreComboBD.SetEnabled(value: boolean);
 begin
   inherited;
   bouton.Enabled := value;
 end;

//Les donnes des combos sont stocques de faon spciales...
procedure tFiltreComboBD.LireEnr;
 begin
   try
     If (ChampAffiche <> '') and (ChampSource <> '') and (ChampUtilise <> '') and
        DataSourceOuvert(DataSource) Then
      Begin
        if (list as tDEgradeListBD).ChercheAvance(dataSource.DataSet, fChampUtilise, ChampSource) then
           ActualiserTexte
        else text := '';
        debVal := text;
        SetDataType(ftString);
        MaxLength := 0;
      End;
   Except
     On E:Exception Do
      Begin
        MessageDlg(LectureImpossible + ' "' + E.Message + '"', mtError, [mbOk], 0);
      End;
   End;
   VerifierColorier(false);

 end;

//On extrait toutes nos donnes!
procedure tFiltreComboBD.ExtraireChangements(var list: tChangementList);
var listeChamp, Externe : StringArray;
    data : tDataSet;
    lg, i : LongInt;
 begin
   data := (self.list as tDegradeListBD).DataSource.DataSet;
   listeChamp := ExtraireEls(ChampSource);
   Externe    := ExtraireEls(ChampUtilise);
   if Length(listeChamp) <> length(Externe) then
      raise Exception.Create(ChampSource + ' est incompatible avec ' + ChampUtilise);
   lg := Length(list);
   SetLength(list, lg + Length(ListeChamp));
   i := 0;
   while i < length(listeChamp) do
    begin
      list[lg].Champs  := listeChamp[i];
      list[lg].NValeur := formatSQL((data.FieldByName(Externe[i])));
      inc(i);
      inc(lg);
    end;
 end;

//On vite que la vrification du descendant ne soit effectu
procedure tFiltreComboBD.VerifierChampSource;
 begin

 end;

//Les donnes semblent avoir chang, nous allons devoir mettre  jour
//Esprons que tout se passera bien...
procedure tFiltreComboBD.MiseAJourBD(Sender: tObject);
 begin
   (list as tDegradeListBD).MiseAjour;
 end;

//Obtient la procdure devant tre appel si l'utilisateur choisi
//nouveau
function tFiltreComboBD.GEtOnNouveau: tNotifyEvent;
 begin
   result := list.SurNouveau;
 end;

//Choisi la procdure  appeler si l'utilisateur choisi nouveau
//NOTE: Nouveau n'est pas dans le menu si OnNouveau = nil
procedure tFiltreComboBD.SetOnNouveau(const Value: tNotifyEvent);
 begin
   list.SurNouveau := Value;
 end;

//Gestion du changement de couleur
//et vrification des erreurs
procedure tFiltreBDEdit.VerifierColorier(const AfficherErreur : Boolean);
var msg : String;
 begin
   if not ValiderDonnee(msg, false) then
    begin
      if AfficherErreur then
         MessageDlg(Msg, mtError, [mbOk], 0);
      color := fCoulSurErreur;
    end
   else if fDinaCoul then
    begin
      if (fObligatoire and (text = '')) then
        color := fCoulSurErreur
      else if text <> debVal then
        color := fCoulSurChange
      else
        color := fCoulSurOk;
    end;
 end;

//Sur sortie d'un BDEdit, certaine action peuvent tre lances...
procedure tFiltreBDEdit.DoExit;
 begin
   inherited;
   if Connection <> nil then
    begin
      (Connection as tDegradeBDPanel).EditSortie(self);
    end;
 end;

end.
