unit uBDUtils;
//--------------------------------------------------------------------
//Unti utilitaire: uBDUtils
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:23 Novembre 2002
//--------------------------------------------------------------------

//Cette unit contient des procdures utilitaires pour base de donnes

interface

uses db, Classes, uJChaine, sysUtils, DBTables, uBDConvertisseur;

type
  TExecuteRequeteEvent = procedure(const Requete : String) of object;

const TypeChiffre = [ftSmallint	, ftInteger, ftWord, ftLargeInt, ftAutoInc, ftBytes, ftFloat,
     ftCurrency];

Function DataSourceOuvert(DataSource : TSuperQuery) : Boolean; overload;
Function DataSourceOuvert(DataSource : TDataSource) : Boolean; overload;
Function DataSourceOuvert(DataSource : TDataSet) : Boolean; overload;
function CleValeur(const ClePrimaire : String; query : tDataSet) : String;
function CleCondition(const ClePrimaire : String; query : tDataSet) : String;
function AffText(const Data : TDataSet; const ChampsSource : String) : String;
procedure SupprimerEnr(const table, cle : String; data : tDataSet;
          const execProc : TExecuteRequeteEvent);
function formatSQL(DataType : TFieldType; const txt : String) : String; overload;
function formatSQL(field : TField) : String; overload;
function DefoncerMax(const chiffre : String; const DataType : TFieldType;
                     var MAX : String) : boolean;
procedure DeplacerEnr(const Source, Dest, cle : String; DataSource : tDataSet;
          const execProc : TExecuteRequeteEvent); overload;
procedure DeplacerEnr(const Source, Dest, cle, cleValeur : String; DataSource : tDataSet;
          const execProc : TExecuteRequeteEvent); overload;
procedure DeplacerEnrs(const Source, Dest, LesCleValeur : String;
                       data : tDataSet; query : tQuery); overload;
procedure DeplacerEnrs(const Source, Dest, LesCleValeur : String;
                       query : tSuperQuery); overload;
procedure CopyEnr(const Source, Dest, cle : String; DataSource : tDataSet;
          const execProc : TExecuteRequeteEvent); overload;
procedure CopyEnr(const Source, Dest, cle, cleValeur : String; DataSource : tDataSet;
          const execProc : TExecuteRequeteEvent); overload;
function REqueteAUnEl(const REquete, DataBaseName : String) : Boolean; overload;
function REqueteAUnEl(const REquete : String; query : tQuery) : Boolean; overload;
function REqueteAUnEl(const REquete : String; query : tSuperQuery) : Boolean; overload;
procedure MassCopy(const Source, Dest, LesCleValeur : String; query : tSuperQuery); overload;
procedure MassCopy(const Source, Dest, LesCleValeur : String; DataSource : tDataSet;
          query : tQuery); overload;
procedure MassEfface(const table, LesCleValeurs : String; const query : tSuperQuery); overload;
procedure MassEfface(const table, LesCleValeurs : String; const query : tQuery); overload;
function GetDataBaseDir(const DataBaseName : String) : String;
function EFloatVertFixFloat(const Ch : String) : String;

implementation

//Cette procdure utilise le BDE pour connaitre le dossier de la BD
function GetDataBaseDir(const DataBaseName : String) : String;
var Params: TStringList;
 begin
   result := '';
   if DBTables.Session.IsAlias(DataBaseName) then
    begin
      Params := tStringList.Create;
      try
         DBTables.Session.GetAliasParams(DataBaseName, Params);
         result := copy(Params.Strings[0], 6, high(longInt));
      finally
         Params.Free;
      end;
    end
   else
     Raise exception.Create(DataBaseName + ' n''est pas un ALIAS valide');
 end;

//Cette procdure effectue la requte et retourne vrai si le rsultat comporte
//un lment ou plus. C'est utile pour dterminer s'il existe un enregistrement
//ayant tel ou tel condition
function REqueteAUnEl(const REquete : String; query : tQuery) : Boolean;
 begin
   Query.SQL.Clear;
   Query.SQL.Add(REquete);
   Query.Open;
   result := Query.REcordCount >= 1;
 end;

//Cette procdure effectue la requte et retourne vrai si le rsultat comporte
//un lment ou plus. C'est utile pour dterminer s'il existe un enregistrement
//ayant tel ou tel condition
function REqueteAUnEl(const REquete : String; query : tSuperQuery) : Boolean;
 begin
   Query.RequeteSelection(Requete);
//   result := not Query.data.Fields[0].IsNull;
   result := not query.Data.IsEmpty;
//   result := true;
 end;

//Cette procdure effectue la requte et retourne vrai si le rsultat comporte
//un lment ou plus. C'est utile pour dterminer s'il existe un enregistrement
//ayant tel ou tel condition
function REqueteAUnEl(const REquete, DataBaseName : String) : Boolean;
var tmpQuery : tQuery;
 begin
   tmpQuery := tQuery.Create(nil);
   try
      tmpQuery.DataBaseName := dataBaseName;
      result := requeteAUnEl(Requete, tmpQuery);
   finally
      tmpQuery.Free;
   end;
 end;

//Cette merveilleuse fonction retourne vrai si le chiffre sous format txt est plus
//grand que le maximum
//le paramtre MAX retourne le maximum du type en chaine, pour que vous
//affichiez un message d'erreur
//NOTE: ne fonctionne qu'avec les entiers positifs sans espaces
//Si DataType n'est pas un entier, sort en retournant faux
function DefoncerMax(const chiffre : String; const DataType : TFieldType;
                     var MAX : String) : boolean;
 begin
   result := false;
   case DataType of
     ftSmallint: MAX := '32767';
     ftInteger:  MAX := '2147483647';
     ftWord:     MAX := '65535';
     ftLargeInt: MAX := '2147483647';
     ftAutoInc:  MAX := '4294967295';
     ftBytes:    MAX := '255';
     //ftCurrency: MAX := '';
     else
       Exit;
   end;
   if (Length(chiffre) >= length(Max)) and (chiffre[1]<>'-') then
    begin
      if Length(Chiffre) = Length(Max) then
       begin
         result := CHPlusGrand(chiffre, max);
       end
      else
         result := true;
    end;
 end;

//Cette fonction s'assure que le flottant n'est pas en exposant
//(Pas en exposant)
function EFloatVertFixFloat(const Ch : String) : String;
Var FForme : Double;
 begin
   If (Length(Ch) > 4) and (Pos('E', Ch) > 0) then
    begin
      FForme := StrToFloat(Ch);
      Result := FloatToStrF(FForme, ffFixed, 15, 8);
    end
   else
     result := Ch;
 end;

//retourne le texte du field sous format acceptable par SQL
function formatSQL(DataType : TFieldType; const txt : String) : String;
var MAX : String;
    vPos : LongINt;
 Begin
   case DataType of
     ftSmallint	, ftInteger, ftWord, ftLargeInt, ftAutoInc, ftBytes, ftFloat,
     ftCurrency:
      Begin
        result := txt;
        if DataType = ftFloat then
           result := EFloatVertFixFloat(result);
        if (DataType <> ftCurrency) And DefoncerMax(txt, DataType, MAX) then
           raise Exception.Create(txt + ' est plus grand que la valeur maximale de ' + MAX);
        vPos := Pos(DecimalSeparator, result);
        if vPos > 0 then
           result[vPos] := '.';
      End;
     ftBoolean: begin
        if (UpperCase(txt) = 'VRAI') or (UpperCase(txt) = 'TRUE') then
          result := 'True'
        else
          result := 'False';
     end;
     ftString:
      Begin
        result := '"' + txt + '"';
      End
     Else
       result := txt;
   end;
 End;

//retourne le texte du field sous format acceptable par SQL
function formatSQL(field : TField) : String; overload;
 Begin
   result := formatSQL(field.DataType, field.AsString);
 End;

//Cette fonction retourne vrai si le dataset point par le datasource est ouvert
//Retourne faux si un nil est rencontr avant ou que le dataset est ferm
Function DataSourceOuvert(DataSource : TSuperQuery) : Boolean;
 Begin
   Result := (DataSource <> nil) and
             (DataSource.ConfOk) and
             (DataSource.Data <> nil) and
             (DataSource.Data.Active);
 End;

//Cette fonction retourne vrai si le dataset point par le datasource est ouvert
//Retourne faux si un nil est rencontr avant ou que le dataset est ferm
Function DataSourceOuvert(DataSource : TDataSource) : Boolean;
 Begin
   Result := (DataSource = nil) or
             (DataSource.DataSet = nil) or
             (DataSource.DataSet.Active = False);
   Result := Not Result;
 End;

//Cette fonction retourne vrai si le dataset point par le datasource est ouvert
//Retourne faux si un nil est rencontr avant ou que le dataset est ferm
Function DataSourceOuvert(DataSource : TDataSet) : Boolean;
 Begin
   Result := (DataSource = nil) or
             (DataSource.Active = False);
   Result := Not Result;
 End;

//Cette fonction retourne les valeurs des cls primaires
//Le retour de cette fonction est utilisable dans une requte select
function CleValeur(const ClePrimaire : String; query : tDataSet) : String;
Var cle : String;
    pos : longInt;
    DoitFaireV : Boolean;
 Begin
   result := '';
   pos := 1;
   doitFaireV := False;
   while lireUnEl(ClePrimaire, cle, pos) do
    Begin
      if doitFaireV Then
         result := result + ' and ';
      result := result + cle + ' = ' + formatSQL(query.FieldByName(cle));
      doitFAireV := TRue;
    end;
 End;

//Cette fonction retourne la condition pour trouver l'lment actuel avec
//sa cl primaire
function CleCondition(const ClePrimaire : String; query : tDataSet) : String;
 Begin
   result := ' Where ' + CleValeur(ClePrimaire, query);
 End;

//Cette function retourne le texte  afficher pour reprsenter l'lment
//slectionn dans la le DataSource
//C'est  dire que les champs de champsSource sont extraits des donnes
function AffText(const Data : TDataSet; const ChampsSource : String) : String;
Var pos : LongInt;
    lecture : String;
    Field : TField;
 begin
   if ChampsSource <> '' Then
    begin
      try
        result := '';
        pos := 1;
        while lireUnEl(ChampsSource, lecture, pos) do
         begin
           field := data.findField(lecture);
           if field <> nil then
              result := result + field.AsString
           else
              result := result + '!ERR!' + lecture;

           while (pos<=length(ChampsSource)) and
                 (ChampsSource[pos] in [' ', ',', '(', ')']) do
           begin
             result := result + ChampsSource[pos];
             inc(pos);
           end;
         end;
      except
        on E : Exception do
           result := result + '!' + e.Message;
      end;
    end
   else
     result := 'ERREUR! Champ source non spcifi';

 end;

//Cette procdure effectue une suppression
//ATTENTION les validations doivent tre faites au pralable
procedure SupprimerEnr(const table, cle : String; data : tDataSet;
          const execProc : TExecuteRequeteEvent);
Var requete : String;
 begin
   requete := 'Delete from ' + Table +
              CleCondition(Cle, data);
   ExecProc(Requete);
 end;

//retourne la liste de tous les champs
//du dataSEt
//Les champs sont spar par des virgules
function ListeChamps(data : tDataSet) : String;
var i : LongInt;
    virgule : boolean;
 begin
   result := '';
   virgule := false;
   i := 0;
   while i < data.FieldCount do
    begin
      if virgule then
         result := result + ', ';
      result := result + data.Fields[i].FieldName;
      virgule := true;
      inc(i);
    end;
 end;


//Cette procdure copie les donnes de source vers destination
procedure CopyEnr(const Source, Dest, cle : String; DataSource : tDataSet;
          const execProc : TExecuteRequeteEvent);

Var requete : String;
 begin
   requete := 'INSERT INTO ' + Dest + ' ' +
              '(' + ListeChamps(DataSource) + ')' +
              'SELECT * from ' + Source +
              CleCondition(Cle, DataSource);
   execProc(Requete);
 end;

//Dplace les donnes de source vers Dest
procedure DeplacerEnr(const Source, Dest, cle : String; DataSource : tDataSet;
          const execProc : TExecuteRequeteEvent);
 begin
   CopyEnr(Source, Dest, cle, dataSource, execProc);
   SupprimerEnr(Source, cle, dataSource, execProc);
 end;

//Cette procdure copie les donnes de source vers destination
procedure CopyEnr(const Source, Dest, cle, cleValeur : String; DataSource : tDataSet;
          const execProc : TExecuteRequeteEvent);

Var requete : String;
 begin
   requete := 'INSERT INTO ' + Dest + ' ' +
              '(' + ListeChamps(DataSource) + ')' +
              'SELECT * from ' + Source + ' '+
              'WHERE ' + CleValeur;
   execProc(Requete);
 end;

//Dplace les donnes de source vers Dest
procedure DeplacerEnr(const Source, Dest, cle, cleValeur : String; DataSource : tDataSet;
          const execProc : TExecuteRequeteEvent);
 begin
   CopyEnr(Source, Dest, cle, dataSource, execProc);
   SupprimerEnr(Source, cle, dataSource, execProc);
 end;

//Cette procdure copie les donnes de source vers destination
//NOTE: les donnes doivent tre dans le query!
procedure MassCopy(const Source, Dest, LesCleValeur : String; DataSource : tDataSet;
          query : tQuery);
Var requete : String;
 begin
   requete := 'INSERT INTO ' + Dest + ' ' +
              '(' + ListeChamps(DataSource) + ') ' +
              'SELECT * from ' + Source + ' WHERE ' +
              LesCleValeur;
   query.SQL.Clear;
   query.SQL.Add(requete);
   query.ExecSQL;
 end;

//Cette procdure effectue une suppression
//ATTENTION les validations doivent tre faites au pralable
procedure MassEfface(const table, LesCleValeurs : String; const query : tQuery);
Var requete : String;
 begin
   requete := 'Delete from ' + Table + ' WHERE '+
              LesCleValeurs;
   query.SQL.Clear;
   query.SQL.Add(requete);
   query.ExecSQL;
 end;

//Dplaces plusieurs enregistrements  la fois
procedure DeplacerEnrs(const Source, Dest, LesCleValeur : String;
                       data : tDataSet; query : tQuery);
 begin
   MassCopy(Source, Dest, LesCleValeur, data, query);
   MassEfface(Source, LesCleValeur, query);
 end;

//Cette procdure copie les donnes de source vers destination
//NOTE: les donnes doivent tre dans le query!
procedure MassCopy(const Source, Dest, LesCleValeur : String; query : tSuperQuery);
Var requete : String;
 begin
   requete := 'INSERT INTO ' + Dest + ' ' +
              '(' + ListeChamps(query.Data) + ') ' +
              'SELECT * from ' + Source + ' WHERE ' +
              LesCleValeur;
   query.EffectuerRequete(Requete);
 end;

//Cette procdure effectue une suppression
//ATTENTION les validations doivent tre faites au pralable
procedure MassEfface(const table, LesCleValeurs : String; const query : tSuperQuery);
Var requete : String;
 begin
   requete := 'Delete from ' + Table + ' WHERE '+
              LesCleValeurs;
   query.EffectuerRequete(requete);
 end;

//Dplaces plusieurs enregistrements  la fois
procedure DeplacerEnrs(const Source, Dest, LesCleValeur : String;
                       query : tSuperQuery);
 begin
   MassCopy(Source, Dest, LesCleValeur, query);
   MassEfface(Source, LesCleValeur, query);
 end;


end.
