unit uBDConvertisseur;
//--------------------------------------------------------------------
//Unit: uBDConvertisseur(Cette super unit permet de changer facilement
//l'objet de base de donnes
//Programmeur(s): Tommy Brire
//Date de cration:26 Avril 2003
//Date de la dernire MAJ:28 Mai 2003
//--------------------------------------------------------------------

//Pour faire une requte modification, appelez frmMain.EffectuerRequete

interface

uses db, dbTables, sqlexpr, sysutils, classes, iniFiles, uJChaine;

const
  DependanceFic = 'dependance.ini';

type
 tSuperQuery = class;

 tSuperDataBase = class(tComponent)
  private
  protected
    fDataBaseName: string;
    function CorrigerRequete(const Requete : String): String; virtual;
    function GetDirectory : String; virtual; abstract;
  public
    procedure RequeteAction(const Requete : String); virtual; abstract;
    procedure RequeteSelection(query : tDataSet; const Requete : String); virtual; abstract;
    function CreerSupQuery : tSuperQuery;
    function CreerQuery : tDataSet; virtual; abstract;
    function ConfOk : Boolean; virtual; abstract;
    function RequeteAUnEl(const Requete : String) : Boolean;
  published
    property DataBaseName : string read fDataBaseName write fDataBaseName;
    property Directory : String read GetDirectory;
 end;

 tSuperDataBaseBDE = class(tSuperDataBase)
  private
  protected
    queAction : tQuery;
    session : tSession;
    function GetPossedeSession: boolean;
    function GetSessionName: String;
    procedure SetSessionName(const Value: String);
    procedure SetPossedeSession(const Value: boolean);
    function GetDirectory : String; override;
    //function CorrigerRequete(const Requete : String) : String; override;
  public
    procedure BeforeDestruction; override;
    procedure RequeteAction(const Requete : String); override;
    procedure RequeteSelection(query : tDataSet; const Requete : String); override;
    function CreerQuery : tDataSet; override;
    function ConfOk : Boolean; override;
  published
    property SessionName : String read GetSessionName write SetSessionName;
    property PossedeSession : boolean read GetPossedeSession write SetPossedeSession;
 end;

 tSuperDataBaseDBEXPRESS = class(tSuperDataBase)
  private
    function CorrigerInsert(const Requete: String): String;
  protected
    queAction : tsqlQuery;
    fConnection: tsqlConnection;
    function GetDirectory : String; override;
    function CorrigerRequete(const Requete : String) : String; override;
  public
    procedure BeforeDestruction; override;
    procedure RequeteAction(const Requete : String); override;
    procedure RequeteSelection(query : tDataSet; const Requete : String); override;
    function CreerQuery : tDataSet; override;
    function ConfOk : Boolean; override;
  published
    property Connection : tsqlConnection read fConnection write fConnection;
 end;

 tSuperQuery = class(tComponent)
  private
    fDataBase: tSuperDataBase;
    fData: tDataSet;
    procedure SetDataBase(const Value: tSuperDataBase);
    procedure VerifierDataBase;
    function GetDataBaseName: String;
    function GetRecNo: Integer;
    function GetFieldValue(const FieldName: string): Variant;
    procedure SetFieldValue(const FieldName: string; const Value: Variant);
  public
    Requete : String;
    procedure BeforeDestruction; override;
    procedure First;
    procedure Next;
    procedure MoveBy(Count : LongInt);
    function FieldByName(FieldName: STring): tField;
    function FieldCount : Integer;
    function ConfOk : Boolean;
    property FieldValues[const FieldName: string]: Variant read GetFieldValue write SetFieldValue; default;
  published
    procedure EffectuerRequete(const Requete : String);
    procedure RequeteSelection(const Requete : String);
    procedure ActualiserRequete;
    property DataBaseName : String read GetDataBaseName;
    property RecNo : Integer read GetRecNo;
    property DataBase : tSuperDataBase read fDataBase write SetDataBase;
    property Data : tDataSet read fData;
 end;

procedure Register;
Function LireClePrimaire(const TableName : String; DataBase : tSuperDataBase) : String;
function OuvrirBDInfo(var ini : tIniFile; DataBase : tSuperDataBase) : Boolean;

implementation

uses uBDUtils;

procedure Register;
 begin
   RegisterComponents('AutoBDGraphique', [tSuperDataBaseBDE, tSuperDataBaseDBEXPRESS, tSuperQuery]);
 end;

//Cette fonction ouvre le fichier ini d'information
//Avertissement: le ini pass en paramtre ne doit pas contenir d'objet
//               si cette fonction retourne vrai, Vous tre responsable
//               de la libration du ini
function OuvrirBDInfo(var ini : tIniFile; DataBase : tSuperDataBase) : Boolean;
 begin
   ini := nil;
   if (DataBase <> nil) and DataBase.ConfOk then
    begin
      ini := tIniFile.Create(Database.Directory + '\' + DependanceFic);
      result := true;
    end
   else
     result := false;
 end;

Function LireClePrimaire(const TableName : String; DataBase : tSuperDataBase) : String;
var ini : tIniFile;
 begin
   if OuvrirBDInfo(ini, DataBase) then
    begin
      try
        result := ini.ReadString(tableName, 'clePrim', '');
      finally
        ini.free;
      end;
    end;
 end;

{ tSuperQuery }

procedure tSuperQuery.VerifierDataBase;
 begin
   if fDataBase = nil then
      raise exception.Create('tSuperQuery.ActualiserRequete: Proprit DATABASE non dfini');
 end;

procedure tSuperQuery.ActualiserRequete;
 begin
   VerifierDataBase;
   fDataBase.RequeteSelection(fData, Requete)
 end;

procedure tSuperQuery.BeforeDestruction;
 begin
  // inherited;
   fData.Free;
 end;

//Cette procdure effectue une requte action sans
//changer les donnes contenu dans le dataset
procedure tSuperQuery.EffectuerRequete(const Requete: String);
 begin
   VerifierDataBase;
   DataBase.RequeteAction(Requete);
 end;

procedure tSuperQuery.RequeteSelection(const Requete: String);
 begin
   self.Requete := requete;
   ActualiserRequete;
 end;

procedure tSuperQuery.SetDataBase(const Value: tSuperDataBase);
 begin
   fDataBase := Value;
   fData.Free;
   fData := nil;
   if Value <> nil then
      fData := fDataBase.CreerQuery;
 end;

function tSuperQuery.FieldByName(FieldName: STring): tField;
 begin
   VerifierDataBase;
   result := fData.FieldByName(FieldName);
 end;

procedure tSuperQuery.First;
 begin
   VerifierDataBase;
   fData.First;
 end;

function tSuperQuery.GetDataBaseName: String;
 begin
   if DataBase <> nil then
      result := DataBase.DataBaseName
   else
      result := '';
 end;

procedure tSuperQuery.Next;
 begin
   VerifierDataBase;
   fData.Next;
 end;

function tSuperQuery.GetRecNo: Integer;
 begin
   VerifierDataBase;
   result := data.RecNo;
 end;

procedure tSuperQuery.MoveBy(Count: Integer);
 begin
   data.MoveBy(Count);
 end;

function tSuperQuery.FieldCount: Integer;
 begin
   VerifierDataBase;
   result := data.FieldCount;
 end;

function tSuperQuery.GetFieldValue(const FieldName: string): Variant;
 begin
   VerifierDataBase;
   result := data.FieldValues[fieldName];
 end;

procedure tSuperQuery.SetFieldValue(const FieldName: string;
  const Value: Variant);
 begin
   VerifierDataBase;
   data.FieldValues[fieldName] := Value;
 end;

{ tSuperDataBase }

//Permet la correction de la requte dans le cas ou des spcifit
//de moteur de base de donnes l'empcheraient de fonctionner
function tSuperDataBase.CorrigerRequete(const Requete: String): String;
 begin
   //Aucune correction ncessaire pour la classe de base
   result := requete;
 end;

//Cration d'un tSupQuery avec la proprit DataBase pointant sur nous
function tSuperDataBase.CreerSupQuery: tSuperQuery;
 begin
   result := tSuperQuery.Create(nil);
   result.DataBase := self;
 end;

//Effectue la requte slection
//retourne vrai si elle plus qu'un lment
function tSuperDataBase.RequeteAUnEl(const Requete: String): Boolean;
var tmp : tSuperQuery;
 begin
   tmp := self.CreerSupQuery;
   try
     result := uBDUtils.RequeteAUnEl(Requete, tmp);
   finally
     tmp.free;
   end;
 end;

//Cette fonction retourne vrai si ce composant est prt  effectuer des
//opration, c'est  dire qu'il est configur
function tSuperQuery.ConfOk: Boolean;
 begin
   result := (fDataBase <> nil) and (fDataBase.ConfOk);
 end;

{ tSuperDataBaseDBEXPRESS }

procedure tSuperDataBaseDBEXPRESS.BeforeDestruction;
 begin
   queAction.Free;
 end;

//Cette fonction retourne vrai si la connection est configur
function tSuperDataBaseDBEXPRESS.ConfOk: Boolean;
 begin
   result := connection <> nil;
 end;

//Cette procdure effectue des opration de correction de requte sur insertion
function tSuperDataBaseDBEXPRESS.CorrigerInsert(const Requete : String) : String;
var i, deb, fin : LongInt;
    bout : String;
const ldeb = ' INTO ';
 begin
   deb := pos(ldeb, Requete);
   if (deb < 0) or (deb > 10) then
      raise exception.Create('Mauvaise requte INSERT -> PAS de INTO');
   deb := deb + length(ldeb);

   i := deb;
   while (i < length(requete)) and (requete[i] = ' ') do
     inc(i);
   while (i < length(requete)) and (requete[i] <> ' ') do
     inc(i);
   while (i < length(requete)) and (requete[i] = ' ') do
     inc(i);
   if requete[i] = '(' then
    begin
      fin := pos(')', Requete);
      bout := uJChaine.RetirerDeChaine(copy(Requete, deb, fin - deb), ['"']);
      result := copy(requete, 1, deb - 1) + bout + copy(requete, fin, length(requete));
    end;
 end;

//correction ncessaire pour que la requte soit compatible DBExpress
function tSuperDataBaseDBEXPRESS.CorrigerRequete(
  const Requete: String): String;
var Operation : String;
const update = 'UPDATE';
      insert = 'INSERT';
 begin
   result := uJChaine.ChangerMotDeCommande(requete, 'AS', '');
   Operation := uppercase(Copy(Requete, 1, Length('UPDATE')));
   If Operation = insert then
      result := CorrigerInsert(result);
   result := inherited CorrigerRequete(result);
 end;

//Effectue la cration d'un tQuery
function tSuperDataBaseDBEXPRESS.CreerQuery: tDataSet;
var query : tsqlQuery;
 begin
   query := tsqlQuery.Create(nil);
   query.SQLConnection := Connection;
   result := query;
 end;

//Effectue une requte action  l'aide du query action interne
function tSuperDataBaseDBEXPRESS.GetDirectory: String;
var i : LongInt;
 begin
   result := '';
   try
     i := fConnection.Params.IndexOfName('DATABASE');
     if i >= 0 then
        result := ExtractFileDir(expandFileName(fConnection.Params.names[i]));
   except
     On e : exception do
      begin
      end;
   end;
 end;

procedure tSuperDataBaseDBEXPRESS.RequeteAction(const Requete: String);
 begin
   //inherited;
   if queAction = nil then
      queAction := tsqlQuery(CreerQuery);
   queAction.Active := false;
   queAction.SQLConnection := self.Connection;

   queAction.SQL.Clear;
   queAction.SQL.Add(CorrigerRequete(Requete));
   queAction.ExecSQL;
 end;

//Effectue une requte slection avec l'objet tquey pass en paramtre
procedure tSuperDataBaseDBEXPRESS.RequeteSelection(query: tDataSet;
  const Requete: String);
var que : tsqlQuery;
 begin
   que := query as tsqlQuery;
   que.Active := false;
   que.SQLConnection := self.Connection;
   que.SQL.Clear;
   que.SQL.Add(CorrigerRequete(Requete));
   que.Open;
 end;

{ tSuperDataBaseBDE }

procedure tSuperDataBaseBDE.BeforeDestruction;
 begin
   queAction.Free;
   PossedeSession := false;
 end;

//retourne vrai si databasename ok
function tSuperDataBaseBDE.ConfOk: Boolean;
 begin
   result := databasename <> '';
 end;

//Effectue la cration d'un tQuery
function tSuperDataBaseBDE.CreerQuery: tDataSet;
var query : tQuery;
 begin
   query := tQuery.Create(nil);
   query.DataBaseName := DataBaseName;
   if Self.SessionName <> '' then
      query.SessionName := self.session.SessionName;
   result := query;
 end;

//Effectue une requte action  l'aide du query action interne
function tSuperDataBaseBDE.GetDirectory: String;
 begin
//   if queAction = nil then
//      queAction := tQuery(CreerQuery);
//   if queAction.Database = nil then
//      queAction.
   result := '';
   try
     if DataBaseName <> '' then
        result := uBDUtils.GetDataBaseDir(DataBaseName)
   except
     on e : exception do
        result := e.Message;
   end;
 end;

function tSuperDataBaseBDE.GetPossedeSession: boolean;
 begin
   result := session <> nil;
 end;

function tSuperDataBaseBDE.GetSessionName: String;
 begin
   If PossedeSession then
      result := session.SessionName
   else
      result := '';
 end;

procedure tSuperDataBaseBDE.RequeteAction(const Requete: String);
 begin
   if queAction = nil then
      queAction := tQuery(CreerQuery);

   queAction.SQL.Clear;
   queAction.SQL.Add(Requete);
   queAction.ExecSQL;
 end;

//Effectue une requte slection avec l'objet tquey pass en paramtre
procedure tSuperDataBaseBDE.RequeteSelection(query: tDataSet;
  const Requete: String);
var que : tQuery;
 begin
   que := query as tQuery;
   que.SQL.Clear;
   que.SQL.Add(Requete);
   que.Open;
 end;

procedure tSuperDataBaseBDE.SetPossedeSession(const Value: boolean);
 begin
   If Value then
    begin
      if session = nil then
       begin
         session := tSession.Create(nil);
         session.AutoSessionName := true;
       end;
    end
   else
    begin
      if session <> nil then
       begin
         session.Free;
         session := nil;
       end;
    end;
 end;

procedure tSuperDataBaseBDE.SetSessionName(const Value: String);
 begin
//   If Session. = false then
//    begin
//      PossedeSession := true;
//      Session.SessionName := Value;
//    end;
 end;

end.
