unit uBDCompo;
//--------------------------------------------------------------------
//Unti utilitaire: uBDCompo
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:23 Novembre 2002
//--------------------------------------------------------------------

//Cette unit contient des composants de base de donnes

interface

uses uGraphCompo, dbtables, classes, windows, db, uBDUtils, uJChaine, sysUtils;

const NouveauStr = 'Modifier cette liste';

type
  tDegradeListBD = class(tDegradeList)
   private
     procedure SetChampSource(const Value: String);
     procedure SetDataSource(const Value: TDataSource);
     procedure AllerASelection;
     function ReadDataBaseName: String;
     procedure SetDataBaseName(const Value: String);
     procedure SetTableName(const Value: String);
     procedure SetOrdreTri(const Value: String);
     procedure MiseAJourAvant;
     procedure MiseAJourApres;
     procedure MiseAJourOuverture;
   protected
     Requete, SelEl : String;
     FQuery : TQuery;

     FChampSource, FOrdreTri : String;
     FDataSource, dataSInterne: TDataSource;
     FTableName : String;
     //fAutoHeight : Boolean;
     fSurDoitMettreAjour : tNotifyEvent;
     procedure preparerAffichage; override;
     procedure ApresAffichage; override;
     procedure AfficherEl(id: Longword; const rect: tREct; const Sel : Boolean); override;
     function obtenirHauteurEl : LongInt; override;
     procedure BDChange;
     procedure ChoisirItem; override;
     procedure PreVisualiserItem; override;
     procedure SetOdreTri(Value : String);
   public
     function Count : longint; override;
     procedure MiseAJour;
     procedure DoitMettreAJour(Sender : TObject);
     function  Cherche(const Chaine : String) : Boolean; override;
     function ChercheAvance(const DataSet : tDataSet;
              const champExterne, champInterne : String) : Boolean; overload;
     function RequeteElementSelection: String;
     function Text : String;
   published
     property SurDoitMettreAjour : tNotifyEvent read fSurDoitMettreAjour write fSurDoitMettreAjour;
     property DataSource : TDataSource read FDataSource write SetDataSource;
     property ChampSource : String read FChampSource write SetChampSource;
     property DataBaseName : String read ReadDataBaseName write SetDataBaseName;
     property TableName : String read FTableName write SetTableName;
     property OrdreTri : String read FOrdreTri write SetOrdreTri;
  End;

implementation

{ tDegradeListBD }

procedure tDegradeListBD.AfficherEl(id: Longword; const rect: tREct; const Sel : Boolean);
Var Data : TDataSet;
    vid : longWord;
    ajust : LongInt;
    txt : String;
 begin
   inherited;
   Data := FDataSource.DataSet;
   if not Assigned(SurNouveau) then
      inc(id);
   if id = 0 then
    begin
      txt := NouveauStr;
    end
   else
    begin
      vid := id - 1;
      if Data.Bof and (vid > 0) Then
       Begin
         data.MoveBy(vid);
       end;
      txt := affText(Data, FChampSource);
      Data.Next;
    end;
   ajust := hligne div 4;
   Canvas.TextOut(rect.Left, rect.top + ajust, txt)
 end;

procedure tDegradeListBD.BDChange;
 begin
   //fait rien pour l'instant
 end;

procedure tDegradeListBD.AllerASelection;
Var Data : TDataSet;
 begin
   if (VraiIdSel > 0) and DataSourceOuvert(FDataSource) then
    begin
      Data := FDataSource.DataSet;
      Data.First;
      Data.MoveBy(VraiIdSel - 1)
    end;
 end;

//Quand l'utilisateur clique sur un item de la liste, on
//envoi on envoi un message  l'aide des vnements
procedure tDegradeListBD.ChoisirItem;
 begin
   inherited;
   if DataSourceOuvert(FDataSource) then
    begin
      if (selection = 0) and assigned(SurNouveau) then
       begin
         SurNouveau(self)
       end
      else
       begin
         AllerASelection;
         if assigned(SurSelection) then
            SurSelection(self);
       end;
    end;
 end;

//Cette procdure retourne la fin de larequte SQL correpondant  la slection
//Tout se qui suit le where
function tDegradeListBD.RequeteElementSelection : String;
 begin
   AllerASelection;
   Result := CleCondition(ChampSource, fQuery);
 end;


//Met  jour la proprit QueryDeSelection
//Et appelle la procdure d'aperu
procedure tDegradeListBD.PreVisualiserItem;
 begin
   inherited;
   if DataSourceOuvert(FDataSource) then
    begin
      if (VraiIdSel > 0) then
       begin
         AllerASelection;
         if assigned(SurApercu) then
            SurApercu(self);
       end
      else
         if assigned(SurVideApercu) and assigned(SurNouveau) then
            SurVideApercu(Self);
    end;
 end;

//Cette procdure retourne la hauteur de l'lment pour que l'anctre
//puisse grer l'affichage
function tDegradeListBD.obtenirHauteurEl: LongInt;
 begin
   result := Canvas.TextHeight('test') * 2;
 end;

//retourne le nombre d'el dans la liste
function tDegradeListBD.Count : longint;
 begin
   if dataSourceOuvert(fDataSource) then
    begin
      result := fDataSource.DataSet.RecordCount;
      if assigned(SurNouveau) then
         inc(result);
    end
   else
      result := 0;
 end;

//Prparation pour affichage!!
procedure tDegradeListBD.preparerAffichage;
Var Data : TDataSet;
 begin
   inherited;
   if DataSourceOuvert(FDataSource) Then
    begin
      Data := FDataSource.DataSet;
      Data.First;
    end;
 end;

//Change le champ qui est affich
procedure tDegradeListBD.SetChampSource(const Value: String);
 begin
    FChampSource := Value;
    refresh;
 end;

//Passe en mode dataSource externe
//DataSource prend la vleur du dataSource externe
procedure tDegradeListBD.SetDataSource(const Value: TDataSource);
begin
  if fQuery <> nil then
   begin
     dataSInterne.Free;
     dataSInterne := nil;
     fQuery.Free;
     fQuery := nil;
   end;
  FDataSource := Value;
  BDChange;
end;

//Cette procdure prpare le travail parallle de mise  jour de query
procedure tDegradeListBD.MiseAJourAvant;
 begin
   requete := '';
   if fQuery <> nil then
    begin
      If (fQuery.DataBaseName <> '') and (FTAbleName <> '') then
       Begin
         SelEl := AffText(fDataSource.DataSet, fChampSource);
         PreparerAffichage;
         requete := 'SELECT * from ' + FTableName;
         if FOrdreTri <> '' then
            requete := requete + ' Order by ' + FOrdreTri;
       End;
    end;
 end;

//Cette procdure effectue la requte en parallle
procedure tDegradeListBD.MiseAJourOuverture;
 begin
   if requete <> '' then
    begin
      fQuery.SQL.Clear;
      fQuery.SQL.ADD(requete);
      fQuery.open;
    end;
 end;

//Cette procdure effectue la requte en parallle
procedure tDegradeListBD.MiseAJourApres;
 begin
   Cherche(SelEl);
   refresh;
 end;

//Mise  jour des donnes affich
procedure tDegradeListBD.MiseAJour;
 begin
   MiseAjourAvant;
   MiseAjourOuverture;
   MiseAJourApres;
 end;

function tDegradeListBD.ReadDataBaseName: String;
 begin
   if fquery <> nil then
    begin
      result := fquery.DataBaseName;
    end;
 end;

//Choisi la table source
//dsactive l'utilisation du fDataSource externe
procedure tDegradeListBD.SetDataBaseName(const Value: String);
 begin
   if (Fquery = nil) then
    begin
      fQuery := tQuery.Create(Self);
      dataSInterne := tDataSource.Create(Self);
      fDataSource  := dataSInterne;
      fDataSource.DataSet := fQuery;
    end;
   if fQuery.DatabaseName <> Value then
    begin
      fQuery.DatabaseName := Value;
      MiseAJour;
    end;
 end;

//Change la table affich
procedure tDegradeListBD.SetTableName(const Value: String);
 begin
   if fTableName <> Value then
    begin
      FTableName := Value;
      MiseAJour;
    end;
 end;

//Change l'ordre de tri
//Fonctionne uniquement si query interne
procedure tDegradeListBD.SetOdreTri(Value: String);
 begin
   FOrdreTri := Value;
   MiseAjour;
 end;

//Chnge l'ordre de tri de la liste dgrad
procedure tDegradeListBD.SetOrdreTri(const Value: String);
 begin
   FOrdreTri := Value;
   MiseAjour;
 end;

//Cette procdure retourne  l'lment slectionn du dataSource aprs
//affichage
procedure tDegradeListBD.ApresAffichage;
 begin
   AllerASelection;
 end;

//recherche un lment
//retourne vrai si lment trouv est identique  l'lment cherch
function tDegradeListBD.Cherche(const Chaine: String) : Boolean;
var Data : tDataSet;
    mConcordance, concordance : LongInt;
 begin
   result := false;
   if not DataSourceOuvert(fDataSource) then
      exit;

   Selection := -1;
   mConcordance := 0;

   Data := fDataSource.DataSet;
   Data.First;
   while (not Data.Eof) do
    begin
      concordance := calculerConcordance(AffText(data, fChampSource), Chaine);
      if concordance > mConcordance then
       begin
         selection := Data.RecNo;
         mConcordance := concordance;
       end;
      Data.Next;
    end;
   Data.First;
   if (selection>=1) then
      data.MoveBy(selection-1);
   if assigned(fSurNouveau) then
      Inc(selection);
   SetSelection(selection-1);
   result := AffText(data, fChampSource) = Chaine;
   refresh;
 end;

//Cette procdure effectue une recherche  partir de donnes contenu dans
//un dataSet
//retourne vrai si trouve
function tDegradeListBD.ChercheAvance(const DataSet: tDataSet;
  const champExterne, champInterne: String) : Boolean;

  //Calcule la concordance des donnes courantes des enregistrements
  function calculerConcordance(data : tDataSet; const interne : StringArray;
           DataSet : tDataSet; const Externe : StringArray) : Byte;
  var i : LongINt;
   begin
     result := 0;
     i := 0;
     if Length(interne) <> length(externe) then
        raise Exception.Create('UN BUG!-> Tentative de comparer des lments '+
        'de base de donnes n''allant pas ensemble! '+
        '(Les longueurs ne sont pas compatibles!)');
     while i < Length(interne) do
      begin
        if data.FieldByName(interne[i]).AsString = dataSet.FieldByName(externe[i]).AsString then
           inc(result);
        inc(i);
      end;
   end;

(*$WARNINGS OFF*)
var Externe, Interne : StringArray;
    mConcordance, concordance : LongInt;
    Data : tDataSet;
 begin
   result := false;
   if not DataSourceOuvert(fDataSource) then
      exit;

   Selection := -1;
   mConcordance := 0;

   Externe := ExtraireEls(champExterne);
   Interne := ExtraireEls(champInterne);

   Data := fDataSource.DataSet;
   Data.First;
   while (not Data.Eof) do
    begin
      concordance := calculerConcordance(data, interne, DataSet, Externe);
      if concordance > mConcordance then
       begin
         selection := Data.RecNo;
         mConcordance := concordance;
       end;
      Data.Next;
    end;
   Data.First;
   if (selection>=1) then
      data.MoveBy(selection-1);
   if assigned(fSurNouveau) then
      Inc(selection);
   SetSelection(selection-1);
   refresh;
   result := mConcordance = Length(interne);

 end;
(*$WARNINGS ON*)

//Cette procdure retourne le texte correspondant  l'lment slectionn
function tDegradeListBD.Text: String;
 begin
   if DataSourceOuvert(fDataSource) then
      result := affText(fDataSource.DataSet, ChampSource)
   else
      result := 'ERREUR! DATASOURCE non ouvert!';
 end;

procedure tDegradeListBD.DoitMettreAJour(Sender: TObject);
 begin
   if Assigned(fSurDoitMettreAJour) then
      fSurDoitMettreAJour(self);
 end;

end.
