unit uAutoBDGraphique;
//--------------------------------------------------------------------
//Unti utilitaire: AutoBDGraphique
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de la dernire MAJ:28 Mai 2003
//--------------------------------------------------------------------

//Cette unit contient un systme automatis de fabrication de fiche pour
//base de donnes

// faire: rendre donnes indpendate de LIST???
//         CorrigerBugCopy??
//         CorrigerBugDataVide
//         FaireSytmeAffichageHintMsg
//         Systme aide?
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, db, dbtables, extctrls, comctrls, buttons, iniFiles, uGraphCompo,
  uJChaine, uFiltreEdit, supprimerArchiver, uBDUtils, uBDCompo,
  uGestionExecUtils, uProgresTravail, uArchiveurRecursif, uBDConvertisseur;

const
  DependanceFic = 'dependance.ini';
  existeDansArchive = 'Enregistrement dj existant. Voulez vous dsarchiver ' +
                      'cet lment';
  existeDansArchiveSupprimer = 'Voulez-vous supprimer les donnes ' +
                               'correspondante dans l''archivage?';
  existeDansArchiveAnnuler = 'Enregistrement annul';
  reellementSupprimer = 'tes vous sur de vouloir supprimer cet enregistrement?';
  IndexNonUnique = 'Enregistrement impossible, les donnes entres doivent ' +
                   'tre uniques."';

type
  TMode = (mInvalide, mVisionnement, mAjout, mEdition);
  TChampsValeurListEvent = procedure(var Valeurs : TChangementList) of object;
  TFaireRequeteEvent     = function(sender : TObject; var Valeurs : TChangementList) : String of object;
  TVerifierModifieEvent  = function(sender : TObject) : Boolean of object;

  tProcedureObjBDEdit     = procedure(Control : tFiltreBDEdit) of Object;
  tProcedureObjStr        = procedure(const Message : String) of Object;
  tProcedureObjFloat      = procedure(const Value : Single) of Object;
  tDataProcedureObjBDEdit = procedure(Control : tFiltreBDEdit; Var param) of Object;
  TModalResultProc        = function(sender : TObject) : tModalResult of object;


  tDegradeBDPanel = class(TDegradePanel)
   private
     FOnChangeModeEdition: TNotifyEvent;
     TravailParal : tRecursifOps;
     fAutoKey: Boolean;
     fSurVerifierObligatoire: TVerifierModifieEvent;
     fDataBaseInterne: Boolean;
     Procedure PourToutBD(proc : tProcedureObjBDEdit); overload;
     Procedure PourToutBD(proc : tDataProcedureObjBDEdit; Var param); overload;
     procedure ChangeDataSource(const Value: TDataSource);
     procedure FaireNouveau(Control: tFiltreBDEdit);
     procedure FaireLire(Control: tFiltreBDEdit);
     procedure FaireAvertirBDChange(Control : tFiltreBDEdit);
     Procedure FaireModifie(Control: tFiltreBDEdit; var param);
     procedure FaireSetEnable(Control: tFiltreBDEdit; var param);
     procedure FaireLireValeur(Control : tFiltreBDEdit; var param);
     procedure FaireVerifierObligatoire(Control : tFiltreBDEdit; Var param);
     procedure SetOrdreTri(const Value: String);
     procedure PeutSupprimer(SurOk : tProcedureObj);
     Procedure EffectuerSupprimer;
     procedure EffectuerArchiver;
     procedure EffectuerDeArchiver(const CleValeur : String);
     procedure SetDependance(const Value: tStrings);
     procedure SupprimerArchiver;
     procedure EffectuerArchivageRecursif;
     procedure DeArchivageRecursif(const CleValeur: String);
     Procedure SurReussiteArchivageRecursif;
     function ReadDependance: tStrings;
//     function OuvrirBDInfo(var ini: tIniFile): Boolean;
     function ReadClePrimaire: String;
     procedure SetClePrimaire(const Value: String);
     procedure ObtenirAutoKey(var Changements: tChangementList);
     procedure SetDataBase(const Value: tSuperDataBase);
     procedure SetDataBaseInterne(const Value: Boolean);
     procedure VerifierChangement(var Changement: tChangementList);
   protected
     BDList : Tlist;
     Mode         : TMode;
     query        : TSuperQuery;
     requete : String;
     RecActif : LongInt;
     AJour : Boolean;

     FClePrimaire, FChampPrincipal, FOrdreTri, FTableArchive : String;
     FTableName   : string;
     //FDependance  : tStrings;
     FErreurDependanceExiste : String;
     FDataSource, tmpDS: TDataSource;
     fPermettreArchivage, fArchivageRecursif : Boolean;
     fDataBase : tSuperDataBase;

     FOnInsererEnregistrement, FOnModifierEnregistrement : TFaireRequeteEvent;
     FOnClePrimExisteDeja, FOnChangementEtat, fOnLireValeur, fSurViderChamps,
     fOnReussieArchivageRecursif : TNotifyEvent;
     FOnRegroupeValeur : TChampsValeurListEvent;
     FOnExecuteRequete : TExecuteRequeteEvent;
     fOnSuppressionQuoiFaire : TModalResultProc;
     fSurVerifierModifie : TVerifierModifieEvent;

     procedure Paint; override;
     Procedure PreparerTParal;
     function ReadDataBaseName : string;
     procedure SetDataBaseName(const Value: string);
     procedure SetTableName(const Value: string);
     procedure MiseAjourParal;
     procedure MiseAjourParalAvant;
     procedure MiseAjourParalApres;
     procedure MiseAjourQuery;
     function InsererNEnregistrement(const Changement : TChangementList) : String; virtual;
     function ModifierEnregistrement(const Changement : TChangementList) : String; virtual;
     procedure ChangementEtat(Sender : Tobject = nil); virtual;
     procedure ChangeMode(const Value: Tmode); virtual;
     procedure SetChampPrinc(const Value: String); virtual;
     procedure ApresChangementQuery; virtual;
     procedure EffectuerRequete(const Requete : String);
     function ClePrimaireChange(const ClePrimiare : String;
          const Changement : tChangementList) : Boolean;
     function REqueteAUnEl(const REquete : String) : Boolean;
     function VerifierClePrimaire(const ClePrimiare : String;
               const Changement : tChangementList):Boolean;
   public
     procedure AfterConstruction; override;
     procedure BeforeDestruction; override;
     destructor destroy; override;
     procedure LireEnr;
     procedure Nouveau;
     procedure Editer;
     function Enregistrer : Boolean;
     procedure Supprimer;
     procedure Annuler;
     procedure ViderChamps;
     procedure ConfAuto;
     procedure EditAChanger(Sender : tObject = nil);
     procedure AjouterTomBD(BDobj : tFiltreBDEdit);
     procedure RetirerTomBD(BDobj : tFiltreBDEdit);
     function Modifie : Boolean;
     procedure BDAChanger;
     procedure EditSortie(Sender : tObject = nil);
     function ChampsObligatoireOk : Boolean;
     function ConfOk: Boolean;
     property ModeEdition : Tmode read Mode write ChangeMode;
   published
     property OnInsererEnregistrement  : TFaireRequeteEvent read FOnInsererEnregistrement write FOnInsererEnregistrement;
     property OnModifierEnregistrement : TFaireRequeteEvent read FOnModifierEnregistrement write FOnModifierEnregistrement;
     property OnClePrimExisteDeja      : TNotifyEvent read FOnClePrimExisteDeja write FOnClePrimExisteDeja;
     property OnRegroupeValeur : TChampsValeurListEvent read FOnREgroupeValeur write FOnRegroupeValeur;
     property OnChangementEtat : TNotifyEvent read FOnChangementEtat write FOnChangementEtat;
     property OnChangeModeEdition : TNotifyEvent read FOnChangeModeEdition write fOnChangeModeEdition;
     property OnExecuteRequete : TExecuteRequeteEvent read FOnExecuteRequete write FOnExecuteRequete;
     property OnLireValeur : TNotifyEvent read fOnLireValeur write fOnLireValeur;
     property OnReussieArchivageRecursif : TNotifyEvent read fOnReussieArchivageRecursif write fOnReussieArchivageRecursif;
     property SurViderChamps : TNotifyEvent read fSurViderChamps write fSurViderChamps;
     property SurVerifierModifie : TVerifierModifieEvent read fSurVerifierModifie write fSurVerifierModifie;
     property SurVerifierObligatoire : TVerifierModifieEvent read fSurVerifierObligatoire write fSurVerifierObligatoire;
     property PermettreArchivage : Boolean read fPermettreArchivage write fPermettreArchivage;
     property ArchivageRecursif : Boolean read fArchivageRecursif write fArchivageRecursif;
     property ClePrimaire      : String read ReadClePrimaire write SetClePrimaire;
     property ChampPrincipal   : String read FChampPrincipal write SetChampPrinc;
     property OrdreTri         : String read FOrdreTri write SetOrdreTri;
     property TableArchive : String read FTableArchive write FTableArchive;
     property Dependance       : tStrings read ReadDependance write SetDependance;
     property ErreurDependanceExiste : String read FErreurDependanceExiste write FErreurDependanceExiste;
     property OnSuppressionQuoiFaire : TModalResultProc read fOnSuppressionQuoiFaire write fOnSuppressionQuoiFaire;
     property AutoKey : Boolean read fAutoKey write fAutoKey;
     property DataSource   : TDataSource read fDataSource write ChangeDataSource;
     property DataBaseInterne : Boolean read fDataBaseInterne write SetDataBaseInterne;
     property DataBaseName : string read ReadDataBaseName write SetDataBaseName;
     property DataBase : tSuperDataBase read fDataBase write SetDataBase;
     property TableName    : string read FTableName write SetTableName;
  end;

  tJudoBoutons = class(TPanel)
   private
    fHauteurBtn: Byte;
     procedure CreerBoutons;
     procedure DimensionnerBTN;
     function NbVisible: Byte;
     procedure SetEspacement(const Value: Byte);
    procedure SetHauteurBtn(const Value: Byte);
   protected
     fEspacement : Byte;
     procedure resize; override;
   public
     bntNouveau, bntModifier, bntEnregistrer, bntAnnuler, bntSupprimer,
     bntAide, bntFermer : TButton;
     procedure AfterConstruction; override;
     procedure SetParent(AOwner: TWinControl); override;
     procedure AjusterEtatBouton(const mode : Tmode; const tChange, selActive : Boolean);
   published
     property Espacement : Byte read fEspacement write SetEspacement;
     property HauteurBtn : Byte read fHauteurBtn write SetHauteurBtn;
  End;

  tAutoBDEditeur = class(tDegradeBDPanel)
   private
     fOnAide: tNotifyEvent;
     procedure WMSize(var message : TWMSize); message WM_SIZE;
     procedure SetOnAide(const Value: tNotifyEvent);
     function GetBoutonsEspacement: Byte;
     procedure SetBoutonsEspacement(const Value: Byte);
   protected
     FOnFermer : TNotifyEvent;
     procedure SetChampPrinc(const Value: String); override;
     procedure ChangementEtat(Sender : TObject = nil); override;
     procedure AdjustClientRect(var Rect: TRect); override;
     procedure SetParent(AParent : TWinControl); override;
   public
     rSelecteur : tDegradeListBD;
     boutons : tJudoBoutons;
     procedure AfterConstruction; override;
     procedure ChangeMode(const Value: Tmode); override;
     procedure DemanderNouveau(sender : TObject = nil);
     procedure DemanderModifier(sender : Tobject = nil);
     procedure DemanderApercu(sender : Tobject = nil);
     procedure DemanderVideApercu(sender: Tobject);
     procedure DemanderEnregistrer(Sender : TObject);
     procedure DemanderAnnuler(Sender : TObject);
     procedure DemanderSupprimer(Sender: TObject);
     procedure DemanderFermer(Sender : TObject);
     procedure DemanderAide(Sender : TObject);
   published
     property OnFermer : TNotifyEvent read FOnFermer write FOnFermer;
     property OnAide : tNotifyEvent read fOnAide write SetOnAide;
     property BoutonsEspacement : Byte read GetBoutonsEspacement write SetBoutonsEspacement;

     property Selecteur : tDegradeListBD read rSelecteur;
     property LesBoutons : tJudoBoutons read boutons;
  end;

procedure Register;

implementation

procedure Register;
 begin
   RegisterComponents('AutoBDGraphique', [tDegradeBDPanel, tAutoBDEditeur,
   tFiltreEdit, tFiltreBDEdit, tFiltreComboBD,
   tJudoBoutons, tDegradeScrollBar, tDegradeControl, tDegradePanel,
   tFlecheBouton, tRecursifOps, tDegradeListBD]);
 end;

{ tTomBDPanel }

//Pour viter les problmes, on ne met pas  jour bd avant maintenant
//Ainsi, on est certain que tous est prt avant premier miseAJourQuery
//De plus a parait un peu mieux, on voit que a travaille!
procedure tDegradeBDPanel.Paint;
 begin
   if not AJour then
    begin
      AJour := true;
      miseAJourQuery;
    end;
   inherited;
 end;

//Cette procdure configure automatiquement les objets insrs
procedure tDegradeBDPanel.ConfAuto;
Var I, Count, ord : LongInt;
    EDIT : tFiltreBDEdit;
    setChamp : Boolean;
 Begin
   setChamp := DataSourceOuvert(FDataSource);
   Count := BDList.Count;
   I := 0;
   ord := 0;
   While I < Count Do
    Begin
      If TObject(BDList.Items[i]) is tFiltreBDEdit Then
       Begin
         Edit := TObject(BDList.Items[i]) as tFiltreBDEdit;
         Edit.DataSource := FDataSource;
         If setChamp And (Edit.ChampSource = '') And
            (ord < DataSource.DataSet.Fields.Count) Then
          Begin
            Edit.ChampSource := DataSource.DataSet.Fields[ord].FieldName;
          End;
        Inc(ord);
       End;
      Inc(I);
    End;

   if setChamp then
    begin
      if (ClePrimaire = '') and (DataSource.DataSet.FieldCount > 0) then
         ClePrimaire := DataSource.DataSet.Fields[0].FieldName;
    end;
 End;

//procedure tTomBDPanel.FermerSourceInterne;
// Begin
// End;

procedure tDegradeBDPanel.ChangeDataSource(const Value: TDataSource);
 begin
   if (tmpDS <> nil) and (Value <> tmpDS) Then
    Begin
      tmpDS.Free;
      tmpDS := nil;
    End;
   FDataSource := Value;
   ConfAuto;
 end;

//Retourne la liste des valeurs des champs ayant des TomBDEdit
//s'occupe en plus des "" pour le langage SQL
procedure tDegradeBDPanel.FaireLireValeur(Control : tFiltreBDEdit; Var param);
 Begin
   If Control.Modifie Then
      Control.ExtraireChangements(TChangementList(param));
 End;

//Cette fonction retourne vrai si la cl primaire  t modifi
function tDegradeBDPanel.ClePrimaireChange(const ClePrimiare : String;
          const Changement : tChangementList) : Boolean;
var pos : LongInt;
    lecture : String;
 begin
   pos := 1;
   while LireUnEl(ClePrimaire, lecture, pos) do
    begin
      if DansListeChangement(lecture, Changement) then
       begin
         result := true;
         exit;
       end;
    end;
   result := false;
 end;

//Cette procdure effectue la requte et retourne vrai si le rsultat comporte
//un lment ou plus. C'est utile pour dterminer s'il existe un enregistrement
//ayant tel ou tel condition
function tDegradeBDPanel.REqueteAUnEl(const REquete : String) : Boolean;
 begin
   result := uBDUtils.REqueteAUnEl(Requete, query);
 end;

//Cette procdure vrifie l'existance possible d'un enregistrement ayant
//dj cette cl primaire
//Si problme, retourne faux, lance exception ou affiche message
function tDegradeBDPanel.VerifierClePrimaire(const ClePrimiare : String;
          const Changement : tChangementList) : Boolean;
var pos, nbLect, i : LongInt;
    lecture, requete, condition : String;
 begin
   result := true;
   If ClePrimaireChange(ClePrimaire, Changement) then
    begin
      pos := 1;
      nbLect := 0;
      condition := '';
      while LireUnEl(ClePrimaire, lecture, pos) do
       begin
         if (nbLect > 0) then
            condition := condition + ' AND ';
         i := TrouveDansListeChangement(ClePrimaire, Changement);
         if (i >= 0) then
            condition := condition + Changement[i].Champs + ' = ' + Changement[i].NValeur + ' '
         else
            condition := condition + lecture + ' = ' + formatSQL(dataSource.DataSet.FieldByName(lecture));
         inc(nbLect);
       end;

      requete := 'SELECT * from ' + TableName + ' WHERE ' + condition;
      if RequeteAUnEl(Requete) then
       begin
         result := false;
         If Assigned(FOnClePrimExisteDeja) Then
            FOnClePrimExisteDeja(self)
         Else
            raise Exception.Create(IndexNonUnique);
       end
      else if PermettreArchivage then
       begin
         requete := 'SELECT * from ' + TableArchive + ' WHERE ' + condition;
         if RequeteAUnEl(Requete) then
          begin
            if MessageDlg(ExisteDansArchive, mtConfirmation, [mbYes, mbNo], 0) = mrYes then
             begin
               EffectuerDearchiver(condition);
               result := false;
             end
            else
             begin
               if MessageDlg(ExisteDansArchiveSupprimer,
               mtConfirmation, [mbYes, mbNo], 0) = mrYes then
                begin
                  requete := 'DELETE from ' + TableArchive + ' WHERE ' + Condition;
                  effectuerRequete(requete);
                end
               else
                 MessageDlg(ExisteDansArchiveAnnuler, mtError, [mbOk], 0);
                 result := false;
             end;
          end;
       end
      else
    end;
 end;

//Cette procdure cr la requte qui va
//Inserer les donnes actuelles dans un nouvel enregistrement
//Prend en paramtre la liste des changements survenus sur l'enregistrement courant
function tDegradeBDPanel.InsererNEnregistrement(const Changement : TChangementList) : String;
Var Requete, champs, valeurs : String;
    i : LongInt;
 Begin
   if Length(Changement) > 0 then
    Begin
      Champs := '"' + Changement[0].Champs + '"';
      valeurs := Changement[0].NValeur;
      i := 1;
      while i < Length(Changement) Do
       Begin
         Champs := Champs + ', "' + Changement[i].Champs + '"';
         valeurs := valeurs + ', ' + Changement[i].NValeur;
         inc(i);
       End;

      Requete := 'INSERT INTO "' + TableName + '" ';
      Requete := Requete + ' (' + Champs + ') ';
      Requete := REquete + 'VALUES (' + valeurs + ')';
      result := Requete;

    end;
 End;

//Obtient la requete ncessaire pour modifier l'enregistrement
function tDegradeBDPanel.ModifierEnregistrement(const Changement : TChangementList) : String;
Var Requete : String;
    i : LongInt;
 Begin
{   PourToutBD(FaireLireValeur, Changement);
   if Assigned(FOnRegroupeValeur) then
      OnRegroupeValeur(Changement);

   VerifierClePrimaire(fClePrimaire, Changement);}

   if Length(Changement) > 0 then
    Begin
      Requete := 'UPDATE ' + tableName + ' SET ';
      Requete := Requete + Changement[0].Champs + ' = ' + Changement[0].NValeur;
      i := 1;
      while i < Length(Changement) Do
       Begin
         Requete := Requete + ', ' + Changement[i].Champs + ' = ' + Changement[i].NValeur;
         inc(i);
       End;

      Requete := Requete + CleCondition(FClePrimaire, query.Data);
      result := requete;
    end;
 End;

//Cette procdure retourne vrai si tous les champs obligatoire sont remplis
function tDegradeBDPanel.ChampsObligatoireOk : Boolean;
 begin
   result := true;
   PourToutBD(FaireVerifierObligatoire, result);
   if Assigned(fSurVerifierObligatoire) then
      fSurVerifierObligatoire(self);
 end;

//Cette super procdure ajoute la cl primaire automatique  la liste des champs
//NOTE: Require qu'il n'y est qu'un champs de cl et que ce champs soit numrique
procedure tDegradeBDPanel.ObtenirAutoKey(var Changements : tChangementList);
var i : LongInt;
    tmpQuery : tSuperQuery;
    nKey : LongInt;
 begin
   tmpQuery := DataBase.CreerSupQuery;
   try
     tmpQuery.RequeteSelection('SELECT MAX(' + fClePrimaire + ') AS CLEMAX from ' + fTableName);
     if tmpQuery.FieldCount > 0 then
       nKey := StrToInt(tmpQuery.data.Fields[0].AsString) + 1
     else
       nKey := 0;

     //Examin de l'archive
     if self.fPermettreArchivage then
      begin
//        tmpQuery.SQL.Clear;
        tmpQuery.RequeteSelection('SELECT MAX(' + fClePrimaire + ') AS CLEMAX from ' + self.FTableArchive);
//        tmpQuery.Open;
        if (tmpQuery.FieldCount > 0) and (tmpQuery.data.Fields[0].AsString <> '') and
           (nKey >= StrToInt(tmpQuery.data.Fields[0].AsString)) then
           nKey := StrToInt(tmpQuery.data.Fields[0].AsString) + 1;
      end;

     //Ajout de la cl auto  la liste
     i := length(changements);
     setLength(changements, i + 1);
     changements[i].Champs := fClePrimaire;
     changements[i].NValeur := formatSQL(tmpQuery.data.Fields[0].DataType, IntToStr(nKey));
   finally
     tmpQuery.Free;
   end;
 end;

//Cette procdure vrifie la liste de changement pour des problmes pouvant
//entrainer plantage
//la liste de champs est corrig pour que a passe
//Si erreur critique, RAISE EXCEPTION!
procedure tDegradeBDPanel.VerifierChangement(var Changement : tChangementList);
var i : LongInt;
 begin
   for i := 0 to High(Changement) do
    begin
      if Changement[i].NValeur = '' then
       begin
         //Une valeur nulle est intolrable...
         if query.FieldByName(Changement[i].Champs).DataType in TypeChiffre then
            Changement[i].NValeur := '0'
         else
            Changement[i].NValeur := '""';
       end;
    end;
 end;

//Cette function enregistre les modifications
//Retourne vrai en cas de russite
//Dans le cas contraire: Exception ou faux
function tDegradeBDPanel.Enregistrer : Boolean;
Var Requete : String;
    Changement : tChangementList;
 begin
   result := false;
   if ClePrimaire = '' then
      raise Exception.Create('La cl primaire doit tre dfinie pour pouvoir enregistrer');
   if not modifie then
      raise Exception.Create('Aucune modification n''a t apport! on ne peut pas enregistrer');
   if not ChampsObligatoireOk then
      raise Exception.Create('Au moins un des champs obligatoires est vide');

   if AutoKey and (TrouveDansListeChangement(fClePrimaire, Changement) < 0) then
      ObtenirAutoKey(Changement);
   PourToutBD(FaireLireValeur, Changement);
   if Assigned(FOnRegroupeValeur) then
      OnRegroupeValeur(Changement);

   VerifierChangement(Changement);

   if VerifierClePrimaire(FClePrimaire, Changement) then
    begin
      If Mode = mAjout Then
       Begin
         If Assigned(FOnInsererEnregistrement) Then
           FOnInsererEnregistrement(self, Changement)
         Else
           requete := InsererNEnregistrement(Changement);
       End
      Else If Mode = mEdition Then
       Begin
         If Assigned(FOnModifierEnregistrement) Then
           FOnModifierEnregistrement(self, Changement)
         Else
           requete := ModifierEnregistrement(Changement);
       End
      Else
        raise Exception.Create('tTomBDPanel.Enregistrer-> Est ni en mode ajout ni en mode dition');

      try
        EffectuerRequete(Requete);
        mode := mVisionnement;
        BDAchanger;
        result := true;
      except
        On E:Exception Do
           MessageDlg('Erreur inconnue: "'+ e.Message +'"', mtError, [mbOk], 0);
      end;
    end;
 end;

procedure tDegradeBDPanel.FaireLire(Control : tFiltreBDEdit);
 Begin
   try
     Control.LireEnr;
   except
     On E:Exception Do
       MessageDlg(E.message, mtError, [mbOk], 0);
   end;
 End;

//Cette procdure vide tous les champs compatibles plac sur ce composant
procedure tDEgradeBDPanel.ViderChamps;
 begin
   PourToutBD(FaireNouveau);
   if assigned(fSurViderChamps) then
      fSurViderChamps(self);
 end;

//Cette fonction lit les donnes dans la base de donnes
//Tous les champs (tFiltreBDEDit) prendront la valeur de l'enregistrement courant
procedure tDegradeBDPanel.LireEnr;
 begin
   PourToutBD(FaireLire);
   if Assigned(fOnLireValeur) and (not (csLoading in ComponentState)) then
      fOnLireValeur(self);
 end;

//Est appel  chaque fois que un edit est modifi ou
//que le mode change
procedure tDegradeBDPanel.ChangementEtat(sender : TObject = nil);
 Begin
   if assigned(FOnChangementEtat) and (not (csLoading in ComponentState)) Then
      FOnChangementEtat(Self);
 End;

procedure tDegradeBDPanel.FaireNouveau(Control : tFiltreBDEdit);
 Begin
   Control.Nouveau;
 End;

//Avertit le contrle qu'il y eu des changements
procedure tDegradeBDPanel.FaireAvertirBDChange(Control : tFiltreBDEdit);
 Begin
   Control.MiseAJourBD(self);
 End;

//vrifie si le contrle  t modifi
Procedure tDegradeBDPanel.FaireModifie(Control : tFiltreBDEdit; Var param);
 Begin
   if Boolean(param) = False Then
      Boolean(param) := Control.Modifie;
 End;

//Vrification du champ obligatoire
//si un champ obligatoire contient ''
//Param vaudra FAUX
Procedure tDegradeBDPanel.FaireVerifierObligatoire(Control : tFiltreBDEdit; Var param);
 Begin
   if Boolean(param) = True Then
    begin
      Boolean(param) := (not control.Obligatoire) or (Control.Text <> '');
    end;
 End;

Procedure tDegradeBDPanel.PourToutBD(proc : tProcedureObjBDEdit);
Var I, Count : LongInt;
 Begin
   Count := BDList.Count;
   I := 0;
   While I < Count Do
    Begin
      If TObject(BDList.Items[i]) is tFiltreBDEdit Then
       Begin
         proc(TObject(BDList.Items[i]) as tFiltreBDEdit);
       End;
      Inc(I);
    End;
 End;

Procedure tDegradeBDPanel.PourToutBD(proc : tDataProcedureObjBDEdit; Var param);
Var I, Count : LongInt;
 Begin
   Count := BDList.Count;
   I := 0;
   While I < Count Do
    Begin
      If TObject(BDList.Items[i]) is tFiltreBDEdit Then
       Begin
         proc(TObject(BDList.Items[i]) as tFiltreBDEdit, Param);
       End;
      Inc(I);
    End;
 End;

//Cette fonction retourne vrai si des changements ont t apports 
function tDegradeBDPanel.Modifie: Boolean;
 begin
   if mode in [mEdition, mAjout] then
    begin
      Result := False;
      PourToutBD(FaireModifie, Result);
      if assigned(fSurVerifierModifie) then
         result := (result or fSurVerifierModifie(self));
    end
   else
      result := false;
 end;

//Initialisation
procedure tDegradeBDPanel.AfterConstruction;
 begin
   inherited;
   TravailParal := tRecursifOps.Create(self);
   BDList := tList.Create;

   //Query := TSuperQuery.Create(nil);
//   fDependance := tStringList.Create;
   fErreurDependanceExiste := 'Dsol, mais vous devez supprimer toutes les ' +
                              'dpendances de cette enregistrement avant de ' +
                              'le supprimer.';
   DataBaseInterne := true;
 end;

//retarde la destruction pour permettre  la thread de se terminer
procedure tDEgradeBDPanel.BeforeDestruction;
 begin
   if TravailParal <> nil then
    begin
      TravailParal.Free;
      TravailParal := nil;
    end;
   fDataBase.Free;
   Query.Free;
 end;

//Destruction! (Vaux mieux mettre ces actions le plus tard possible...)
destructor tDegradeBDPanel.Destroy;
 begin
   inherited;
//   fDependance.free;
   BDList.Free;
 end;

Procedure tDegradeBDPanel.FaireSetEnable(Control : tFiltreBDEdit; Var param);
 Begin
   Control.Enabled := Boolean(Param);
 End;

//procedure tTomBDPanel.SetEnabled(Value: Boolean);
// begin
//   inherited;
// end;

procedure tDegradeBDPanel.Nouveau;
 begin
   ModeEdition := mAjout;
 end;

procedure tDegradeBDPanel.Annuler;
 begin
   Mode := mVisionnement;
   ChangeMode(mVisionnement);
 end;

procedure tDegradeBDPanel.ChangeMode(const Value: Tmode);
var ena : Boolean;
 begin
   if mode > mVisionnement Then
      raise Exception.create('Il faut tre en mode visionnement pour pouvoir changer de mode');

   case Value of
     mVisionnement: Begin
        LireEnr;
        mode := mVisionnement;
        ena := False;
      End;
     mAjout: Begin
       if tmpDS = nil then
          raise exception.Create('Avant de pouvoir ajouter, la base de donnes doit tre accessible');
       ViderChamps;
       mode := mAjout;
       ena := true;
     End;
     mEdition: Begin
       if tmpDS = nil then
          raise exception.Create('Avant de pouvoir ajouter, la base de donnes doit tre accessible');
        LireEnr;
        mode := mEdition;
        ena := true;
      End;
   end;
   PourToutBD(FaireSetEnable, ena);
   if assigned(fOnChangeModeEdition) and (not (csLoading in ComponentState)) then
      fOnChangeModeEdition(self);
   ChangementEtat;
 end;

//Actions  faire quand le contenu d'un Edit change
procedure tDegradeBDPanel.EditAChanger(Sender : tObject = nil);
 begin
   ChangementEtat;
 end;

//Si le edit fait partie de la cl primaire, vrification de duplication
//archive/table actuelle
procedure tDegradeBDPanel.EditSortie(Sender : tObject = nil);
 begin
   if (sender <> nil) then
    begin
      if sender is tFiltreBDEdit then
       begin
         with sender as tFiltreBDEdit do
          begin
            //if ChampSource then
            // begin

            // end;
          end;
       end;
    end;
 end;

//Est appel  chaque changement de mode ou  chaque fois qu'un edit est modifi
procedure tAutoBDEditeur.ChangementEtat(Sender: TObject = nil);
 begin
   Boutons.AjusterEtatBouton(mode, modifie, rSelecteur.VraiIdSel > 0);
   if Boutons.bntEnregistrer.Enabled then
      boutons.bntEnregistrer.Enabled := ChampsObligatoireOk;
   inherited;
 end;

//Changement de la condition de suppression
//Enregistrement des donnes dans le fichier ini
procedure tDegradeBDPanel.SetDependance(const Value: tStrings);
var ini : tIniFile;
    i : LongInt;
 begin
   if ConfOk and OuvrirBDInfo(ini, query.DataBase) then
    begin
      try
        i := 0;
        while i < Value.Count do
         begin
           ini.WriteString(TableName, IntToStr(i), Value.Strings[i]);
           inc(i);
         end;
      finally
        ini.Free;
      end;
    end;
   //Vrification de la validit des nouvelles valeurs
   try
     PeutSupprimer(nil);
   except
     On E : Exception do
        MessageDlg(E.Message, mtError, [mbOk], 0);
   end;
 end;

//Supprimer la table en cours
procedure tDegradeBDPanel.EffectuerSupprimer;
 begin
   SupprimerEnr(fTableName, fClePrimaire, query.Data, EffectuerRequete);
   MiseAjourQuery;
 end;

//Cette procdure met  jour les champs
//Appelez cette procdure quand un changement  t fait  l'externe
//EX: quand la fiche reoit le focus, appeler...
procedure tDegradeBDPanel.BDAChanger;
 begin
   if mode = mVisionnement then
      miseAjourQuery;

   PourToutBD(FaireAvertirBDChange);
 end;

{ tJudoBoutons }
//Cette fonction retourne le nombre de bouton visible
function tJudoBoutons.NbVisible : Byte;
var i : LongInt;
 begin
   result := 0;
   for i := 0 to ControlCount - 1 do
    begin
      if Controls[i].Visible then
         inc(result);
    end;
 end;

//Modifie l'espacement entre les boutons 
procedure tJudoBoutons.SetEspacement(const Value: Byte);
 begin
   fEspacement := Value;
   DimensionnerBTN;
 end;

//Change les dimensions des boutons pour qu'ils paraissent bien
procedure tJudoBoutons.DimensionnerBTN;
var i : LongINt;
    posx, lg, blg : Single;
 begin
   if NbVisible > 0 then
    begin
      lg := Width / NbVisible;
      posx := fEspacement / 2;
      blg := lg - fEspacement;
      for i := 0 to ControlCount - 1 do
       begin
         if Controls[i].Visible then
          begin
            Controls[i].Left  := round(posx);
            Controls[i].Width := (round(posx+blg)-Controls[i].Left);
            Controls[i].Height := fHauteurBtn;
            Controls[i].Top := (Height - fHauteurBtn) div 2;
            posx:=posx+lg;
          end;
       end;
    end;
 end;

//Effectue la cration des boutons
//si il y dj des boutons, sort sans rien faire
//Effectue la cration des boutons
//si il y dj des boutons, sort sans rien faire
Procedure tJudoBoutons.CreerBoutons;
Const bntInfo : Array[0..6, 0..1] of String = (
     ('&Ajouter',     'Cre un nouvel enregistrement'),
     ('&Modifier',    'Vous permet de modifier l''enregistrement affich'),
     ('&Enregistrer', 'Enregistrer les changements que vous venez d''apporter sur l''enregistrement affich ci-haut'),
     ('&Supprimer',   'Supprime ou archive l''enregistrement affich'),
     ('A&nnuler',     'Retourne en mode visionnement. Si vous avez apport des modifications, elle ne seront pas enregistres.'),
     ('A&ide',        'Affiche l''aide pour cette fiche'),
     ('&Fermer',      'Ferme cette fiche'));
Var I : LongInt;
    tmpBTN : TButton;
 Begin
   If (ControlCount > 0) Then
      Exit;
   For I := 0 to High(bntInfo) Do
    Begin
      tmpBTN := TButton.Create(Self);
      tmpBTN.Caption := bntInfo[i, 0];
      tmpBTN.Hint    := bntInfo[i, 1];
      tmpBTN.ShowHint := True;
      tmpBTN.Parent := Self;
    End;
   bntNouveau     := Controls[0] as TButton;
   bntModifier    := Controls[1] as TButton;
   bntEnregistrer := Controls[2] as TButton;
   bntSupprimer   := Controls[3] as TButton;
   bntAnnuler     := Controls[4] as TButton;
   bntAide        := Controls[5] as TButton;
   bntFermer      := Controls[6] as TButton;

   bntFermer.TabOrder := 0;
   DimensionnerBTN;
   AjusterEtatBouton(mInvalide, false, false);
 End;

//Active ou dsactive ls boutons pour que ce soit OK
procedure tJudoBoutons.AjusterEtatBouton(const mode: Tmode;
  const tChange, selActive: Boolean);

 procedure bntChangeMode(const valeur : boolean);
  begin
    bntNouveau.Enabled := Valeur;
    bntModifier.Enabled := Valeur;
  end;

 begin
   DimensionnerBTN;
   case mode of
    mVisionnement: begin
      bntChangeMode(True);
      bntEnregistrer.Enabled := False;
      bntAnnuler.Enabled     := False;
      bntSupprimer.Enabled   := selActive;
      bntModifier.Enabled    := selActive;
    end;
    mAjout, mEdition: begin
      bntChangeMode(False);
      bntEnregistrer.Enabled := tChange;
      bntAnnuler.Enabled := True;
      bntSupprimer.Enabled   := (mode = mEdition) and (not tChange);
    end
    else begin
      bntChangeMode(False);
      bntEnregistrer.Enabled := False;
      bntAnnuler.Enabled     := False;
      bntSupprimer.Enabled   := False;
    end;
   end;
   //bntFermer.Cancel  := true;
 end;

//Bouton par dfaut
procedure tJudoBoutons.AfterConstruction;
 begin
   inherited;
   ShowHint     := true;
   Height       := 20;
   HauteurBtn   := 18
 end;

procedure tJudoBoutons.SetParent(AOwner : TWinControl);
 Begin
   inherited;
   If AOwner <> nil Then
      CreerBoutons;
 End;

procedure tJudoBoutons.resize;
 begin
   inherited;
   DimensionnerBTN;
 end;

{tDegradeBDPanel}

//Les objets descendant peuvent utiliser cette procdure pour faire des actions
//aprs la modification du Query;
procedure tDegradeBDPanel.ApresChangementQuery;
 begin
 end;

//Cette procdure vrifie que le composant est prs  tre utilis
//c'est  dire qu'il est configur correctement
function tDegradeBDPanel.ConfOk : Boolean;
 begin
   result := (query <> nil) and (database <> nil) and (tableName <> '') and
             (query.ConfOk);
 end;

//Tche synchronis CRATION de la requte
procedure tDegradeBDPanel.MiseAjourParalAvant;
 begin
   requete := '';

   if (ConfOk) then
    begin
      if query.Data.Active then
         RecActif := query.data.RecNo
      else
         RecActif := 0;
      if RecActif > 0 then
         dec(RecActif);
      requete := 'SELECT * from ' + FTableName;
      if FOrdreTri <> '' then
         requete := requete + ' Order by ' + FOrdreTri;
    end;
 end;

//Cette procdure s'occupe de la mise  jour en parallle de la requte
//ATTENTION PAS DE SYNC ICI
procedure tDegradeBDPanel.MiseAjourParal;
 begin
      if requete <> '' then
       begin
         query.RequeteSelection(Requete);
         query.First;
         query.MoveBy(RecActif);
       end;
 end;

//Est appel aprs mise  jour paral
//Cette procdure est synchronis
procedure tDegradeBDPanel.MiseAjourParalApres;
 begin
   if requete <> '' then
    begin
      if tmpDS = nil Then
       Begin
         tmpDS := tDataSource.Create(Self);
         tmpDS.DataSet := query.Data;
         FDataSource := tmpDS;
       End;
      if (FChampPrincipal = '') and (query.FieldCount > 2) then
         FChampPrincipal := query.data.Fields[1].FieldName;
      mode := mVisionnement;//Force le mode visionnement
      Changemode(mVisionnement);
      ApresChangementQuery;
      ConfAuto;
    end;
 end;

{ tDegradeBDPanel }
//Met  jour la requte, passe au mode visionnement
//Cette procdure reste sur l'enregistrement en cours si aucun changement depuis
//dernire requte
//Si on tait en train de faire un opration dans un autre mode, c'est annul
procedure tDegradeBDPanel.MiseAjourQuery;
var ancCursor : tCursor;
 Begin
   if not (csLoading in componentState) then
    begin
      ancCursor := Screen.Cursor;
      Screen.Cursor := crSQLWait;
      try
        Application.ProcessMessages;
        MiseAjourParalAvant;
        MiseAjourParal;
        MiseAjourParalApres;
      finally
        Screen.Cursor := ancCursor;
      end;
    end;
 End;

procedure tDegradeBDPanel.SetDataBaseName(const Value: string);
 Begin
   if DataBaseInterne = true then
    begin
      fDataBase.DataBaseName := value;
      if query = nil then
         query := tSuperQuery.Create(nil);
      query.DataBase := fDataBase;
      MiseAjourQuery;
    end
   else
     if not (csLoading in componentstate) then
        ShowMessage('Vous ne pouvez pas changer cette proprit sur un database externe');
 End;

Function tDegradeBDPanel.ReadDataBaseName : string;
 Begin
   result := '';
   if (query <> nil) then
      Result := query.DataBaseName;
 End;

procedure tDegradeBDPanel.SetTableName(const Value: string);
 begin
   FTableName := Value;
   if fTableArchive = '' then
      fTableArchive := 'A_' + Value;
   MiseAjourQuery;
 end;

procedure tDegradeBDPanel.Editer;
 begin
   ModeEdition := mEdition;
 end;

//Appelle une procdure pour faire excuter la requte
procedure tDegradeBDPanel.EffectuerRequete(const Requete: String);
//var tmpQuery : tQuery;
 begin
   if assigned(FOnExecuteRequete) then
      FOnExecuteRequete(Requete)
   else
      query.EffectuerRequete(requete);
 end;

//Choisi le champ principal
//(C'est le champ qui est affich pour reprsenter les donnes)
procedure tDegradeBDPanel.SetChampPrinc(const Value: String);
 begin
   FChampPrincipal := Value;
 end;

//Choisi l'odre de tri
//Important si vous dsirez que les donnes soient tri!
procedure tDegradeBDPanel.SetOrdreTri(const Value: String);
 begin
   FOrdreTri := Value;
   MiseAjourQuery;
 end;

procedure tDegradeBDPanel.AjouterTomBD(BDobj: tFiltreBDEdit);
 begin
   BDList.Add(BDObj);
   BDobj.Enabled := (mode = mAjout) or (mode = mEdition);
   if (BDObj.DataSource = nil) then
      ConfAuto;
 end;

procedure tDegradeBDPanel.RetirerTomBD(BDobj: tFiltreBDEdit);
 begin
   BDList.Remove(BDObj);
 end;

//Cette procdure configure l'objet Travail
Procedure tDegradeBDPanel.PreparerTParal;
 begin
   TravailParal.DataBase := fDataBase;
   TravailParal.MessageErreurDependance := FErreurDependanceExiste;
 end;

//Cette vrifie les dpendances de l'enregistrement en cours
//si la suppression est possible appelle la procdure pass en paramtre
//NOTE: a peut tre long, alors le travail est effectu dans un Thread  part
//      Nous nous dsactivons pour viter problmes
procedure tDegradeBDPanel.PeutSupprimer(SurOk : tProcedureObj);
 begin
   PreparerTParal;
   TravailParal.VerifierDependance(fTableName, CleValeur(fClePrimaire, query.Data), SurOk, fArchivageRecursif);
 end;

//Action  accomplir quand la sauvegarde rcursive russie
Procedure tDegradeBDPanel.SurReussiteArchivageRecursif;
 begin
   MiseAJourQuery;
   if assigned(fOnReussieArchivageRecursif) then
      fOnReussieArchivageRecursif(self);
 end;

//Cette procdure effectue l'archivage rcursif
procedure tDegradeBDPanel.EffectuerArchivageRecursif;
 begin
   PreparerTParal;
   TravailParal.Archiver(fTableName, CleValeur(fClePrimaire, query.Data),
                SurReussiteArchivageRecursif);
 end;

//Cette procdure effectue le dsarchivage rcursif
procedure tDegradeBDPanel.DeArchivageRecursif(const CleValeur : String);
 begin
   PreparerTParal;
   TravailParal.DeArchiver(fTableName, CleValeur,
                SurReussiteArchivageRecursif);
 end;

//Cette procdure archive l'enregistrement courant
//ATTENTION les validations doivent tre faites au pralable
procedure tDegradeBDPanel.EffectuerArchiver;
 begin
   if fArchivageRecursif then
      EffectuerArchivageRecursif
   else
      DeplacerEnr(fTableName, fTableArchive, fClePrimaire, query.data, EffectuerRequete);
 end;

//Cette super procdure dsarchive
procedure tDegradeBDPanel.EffectuerDeArchiver(const CleValeur : String);
 begin
   if fArchivageRecursif then
      DeArchivageRecursif(CleValeur)
   else
      DeplacerEnr(fTableArchive, fTableName, fClePrimaire, CleValeur, query.data, EffectuerRequete);
 end;

//Cette procdure affiche une boite de dialogue supprimer archiver
//aprs que la vrification PeutSuprimer ai t faite
procedure tDegradeBDPanel.SupprimerArchiver;
var reponse : LongINt;
 begin
   If PermettreArchivage then
    begin
      if assigned(fOnSuppressionQuoiFaire) then
        reponse := fOnSuppressionQuoiFaire(self)
      else
        reponse := frmSupprimerArchiver.ShowModal;
      case reponse of
        mrNo   : EffectuerArchiver;
        mrYes    : EffectuerSupprimer;
        mrCancel: begin end;
        else
          raise Exception.Create('BUG trouv!');
      end;
    end
   else
    begin
      if MessageDlg(ReellementSupprimer,
      mtConfirmation, [mbYes, mbNo], 0) =  mrYes then
         EffectuerSupprimer;
    end;
   MiseAjourQuery;
 end;

//Cette procdure s'occupe de la suppression de l'enregistrement en cours
procedure tDegradeBDPanel.Supprimer;
var reponse : Integer;
 begin
   Annuler;//Pour tre certain qu'on est en mode visionnement
   if PermettreArchivage and fArchivageRecursif then
    begin
      if assigned(fOnSuppressionQuoiFaire) then
        reponse := fOnSuppressionQuoiFaire(self)
      else
        reponse := frmSupprimerArchiver.ShowModal;
      case reponse of
       mrNo   : EffectuerArchiver;
       mrYes    : PeutSupprimer(EffectuerSupprimer);
       mrCancel: begin end;
       else
         raise Exception.Create('BUG trouv!');
       end;
    end
   else PeutSupprimer(SupprimerArchiver);
 end;

//Cette fonction ouvre le fichier ini d'information
//Avertissement: le ini pass en paramtre ne doit pas contenir d'objet
//               si cette fonction retourne vrai, Vous tre responsable
//               de la libration du ini
{function tDegradeBDPanel.OuvrirBDInfo(var ini : tIniFile) : Boolean;
 begin
   ini := nil;
   if ConfOk then
    begin
      ini := tIniFile.Create(query.Database.Directory + '\' + DependanceFic);
      result := true;
    end
   else
     result := false;
 end;}

//Lecture des donnes du fichier ini
function tDegradeBDPanel.ReadDependance: tStrings;
var ini : tIniFile;
 begin
   result := tStringList.Create;
   if ConfOk and OuvrirBDInfo(ini, query.DataBase) then
    begin
      try
        try
          uArchiveurRecursif.LireDependance(result, fClePrimaire, tableName, query.Data, ini);
        finally
          ini.Free;
        end;
      except
        On e : exception do
           result.Clear;
      end;
    end;
 end;

//La cl primaire est stock dans le fichier ini!
function tDegradeBDPanel.ReadClePrimaire: String;
 begin
   result := fClePrimaire;
 end;

//La cl primaire est stock dans le fichier ini!
procedure tDegradeBDPanel.SetClePrimaire(const Value: String);
var ini : tIniFile;
 begin
   if ConfOk and OuvrirBDInfo(ini, query.DataBase) then
    begin
      try
        ini.WriteString(tableName, 'clePrim', Value);
      finally
        ini.free;
      end;
    end;
   FClePrimaire := Value;
 end;

{ tAutoBDEditeur }

procedure tAutoBDEditeur.ChangeMode(const Value: Tmode);
 begin
   inherited;
   if DataSourceOuvert(FDataSource) then
    begin
      rSelecteur.DataSource := fDataSource;
      if rSelecteur.ChampSource = '' then
         rSelecteur.ChampSource := fDataSource.DataSet.FieldDefs[1].Name;
      rSelecteur.Visible := Value = mVisionnement;
      rSelecteur.SelLock := not (Value = mVisionnement);
      rSelecteur.DataAChange;
      if (mode in [mEdition, mAjout]) then
       begin
         SelectNext(rSelecteur, true, true);
         Boutons.bntFermer.Taborder := 10;
       end;
    end;
 end;

procedure tAutoBDEditeur.AfterConstruction;
 begin
   inherited;

   rSelecteur := TDegradeListBD.Create(self);
   rSelecteur.Align := alNone;

   rSelecteur.SurSelection  := DemanderModifier;
   rSelecteur.SurApercu     := DemanderApercu;
   rSelecteur.SurVideApercu := DemanderVideApercu;

   rSelecteur.Parent := self;
   rSelecteur.Left := 0;

   rSelecteur.Hint     := 'Choisissez dans cette liste l''enregistrement  modifier. Utilisez nouveau pour en crer un nouveau';
   rSelecteur.ShowHint := True;
   rSelecteur.SetSubComponent(true);

   Boutons := tJudoBoutons.Create(self);
   Boutons.SetSubComponent(true);

   align := alClient;
 end;

procedure tAutoBDEditeur.DemanderEnregistrer(Sender : TObject);
 begin
   Enregistrer;
 end;

procedure tAutoBDEditeur.DemanderAnnuler(Sender : TObject);
 begin
   Annuler;
 end;

procedure tAutoBDEditeur.DemanderSupprimer(Sender : TObject);
 begin
   Supprimer;
 end;

procedure tAutoBDEditeur.DemanderFermer(Sender : TObject);
 begin
   if assigned(FOnFermer) then
      FOnFermer(self);
 end;

procedure tAutoBDEditeur.SetChampPrinc(const Value: String);
 begin
   inherited;
   rSelecteur.ChampSource := Value;
 end;

procedure tAutoBDEditeur.DemanderModifier(sender: Tobject = nil);
 begin
   if mode = mVisionnement then
    begin
      LireEnr;
      ChangeMode(mEdition);
    end
   else
      raise Exception.Create('Pas en visionnement');
 end;

procedure tAutoBDEditeur.DemanderNouveau(sender: TObject = nil);
 begin
   nouveau;
 end;

//Affiche aperu
procedure tAutoBDEditeur.DemanderApercu(sender: Tobject);
 begin
   if mode = mVisionnement then
    begin
      LireEnr;
      ChangementEtat;
    end
   else
      raise Exception.Create('Pas en visionnement');
 end;

//Affiche aperu vide
procedure tAutoBDEditeur.DemanderVideApercu(sender: Tobject);
 begin
   if mode = mVisionnement then
    begin
      ViderChamps;
    end
   else
      raise Exception.Create('Pas en visionnement');
 end;

//Ajustement de la zone cliente
procedure tAutoBDEditeur.AdjustClientRect(var Rect: TRect);
 begin
   if (rSelecteur <> nil) and (rSelecteur.Visible) then
      rect.Left := rSelecteur.Width;
   inherited AdjustClientRect(Rect);
 end;

procedure tAutoBDEditeur.SetParent(AParent: TWinControl);
 begin
   inherited;
   if (Boutons.Parent = nil) and (AParent <> nil) then
    begin
      Boutons.Parent := Self;
      Boutons.Align := alBottom;
      Boutons.TabOrder := Self.ControlCount;

      Boutons.bntNouveau.OnClick     := DemanderNouveau;
      Boutons.bntModifier.OnClick    := DemanderModifier;
      Boutons.bntEnregistrer.OnClick := DemanderEnregistrer;
      Boutons.bntAnnuler.OnClick     := DemanderAnnuler;
      Boutons.bntSupprimer.OnClick   := DemanderSupprimer;
      Boutons.bntFermer.OnClick      := DemanderFermer;
      Boutons.bntAide.OnClick        := DemanderAide;

      Boutons.TabOrder := 0;
      rSelecteur.TabOrder := 1;

      boutons.bntAide.Visible := assigned(fOnAide);
      boutons.DimensionnerBTN;

    end;
 end;

//Ajustement de la hauteur du slecteur
procedure tAutoBDEditeur.WMSize(var message: TWMSize);
 begin
   inherited;
   if rSelecteur <> nil then
      rSelecteur.Height := Height;
 end;

procedure tAutoBDEditeur.DemanderAide(Sender: TObject);
 begin
   if assigned(fOnAide) then
      fOnAide(self);
 end;

procedure tAutoBDEditeur.SetOnAide(const Value: tNotifyEvent);
 begin
   fOnAide := Value;
   boutons.bntAide.Visible := assigned(fOnAide);
   boutons.DimensionnerBTN;
 end;

function tAutoBDEditeur.GetBoutonsEspacement: Byte;
 begin
   result := Boutons.Espacement;
 end;

procedure tAutoBDEditeur.SetBoutonsEspacement(const Value: Byte);
 begin
   Boutons.Espacement := Value;
 end;

procedure tJudoBoutons.SetHauteurBtn(const Value: Byte);
 begin
   fHauteurBtn := Value;
   DimensionnerBTN
 end;

procedure tDegradeBDPanel.SetDataBase(const Value: tSuperDataBase);
 begin
   if fDataBaseInterne = true then
    begin
      fDataBaseInterne :=false;
      fDataBase.Free;
    end;
   fDataBase := Value;
   if query = nil then
      query := tSuperQuery.Create(nil);
   query.DataBase := fDataBase;
   miseAJourQuery;
 end;

procedure tDegradeBDPanel.SetDataBaseInterne(const Value: Boolean);
 begin
   if fDataBaseInterne <> Value then
    begin
      fDataBaseInterne := Value;
      if fDataBaseInterne then
       begin
         fDataBase := tSuperDataBaseBDE.Create(nil);
       end
      else
       begin
         fDataBase.Free;
         fDataBase := nil;
       end;
      if query = nil then
         query := tSuperQuery.Create(nil);
      query.DataBase := fDataBase;
    end;
 end;

end.
