unit uArchiveurRecursif;
//--------------------------------------------------------------------
//Unti utilitaire: AutoBDGraphique
//                  Fait partie du composant AutoBDGraphique
//Programmeur(s): Tommy Brire
//Date de cration: 20 Dcembre 2002
//Date de la dernire MAJ:28 Mai 2003
//--------------------------------------------------------------------

//Cette unit contient un super systme d'archivage/dsarchivage rcursif avec
//en prime un systme de vrification de lien

//Pour que le systme fonctionne, la base de donnes doit contenir un fichier
//appel 'dependance.ini' ce fichier doit contenir les donnes ncessaires aux
//systme pour savoir quel table est dpendande de quel table et  partir
//de quel index

//Quand une opration d'archivage ou de dsarchivage est demand, le systme
//ouvre le fichier '.ini'.

//-ATTENTION-
//Le travail est effectu en parallle
//Avant que votre programme ne se termine, assurez-vous que le travail en
//parallle est interrompu. Si le travail continue alors que l'application est
//termin, cela occasionnera un plantage.
//Pour viter les plantages, ce bout de code copie toutes les donnes que vous
//lui donnez.

//Quand l'objet dsire vous informer de quelque chose,
//il appelle une procdure d'information que vous lui avez donnes.
//Si vous ne lui donnes pas de procdure  appeler, votre programme n'aura
//pratiquement aucun moyen de savoir ce qui se passe


//========================================================================
//STRUCURE DU FICHIER INI
//========================================================================
//Le fichier Ini doit contenir la liste de tout les tables pouvants tre
//supprimes/archiver/vrifier
//Les tables doivent tre crite entre crochet [NomTable]
//Aprs le nom de chaque table, suivent ses donnes
//Les donnes sont crites sous le format: lment=Valeur

//Premirement, spccifiez la cl primaire comme ceci
//ClePrim=Nom, Prenom
//La cl primiare peut comporter plusieur lment, il suffit de les sparer
//par des virgules
//Si vous ne spcifiez pas la cl primaire, le systme utilisera le premier
//champ. Si ce n'est pas correcte, spcifiez une cl primaire

//Ensuite, spcifiez les tables contenant des donnes en dpendance avec
//celle-ci. En cas d'archivage/dsarchivage/vrification, tous les tables
//de cette liste seront vrifi avant que la table de base puissent tre faite
//Vous devez numrot vos dpendance. La faon dons vous le faite n'est pas
//importantes, pourvu qu'il n'y est pas deux dpendances ayant le mme nom
//dans les donnes d'une table
//EX:
//[Judoka]
//ClePrim=Nom, Prenom
//d1=Graduation
//ed2=Participe
//
//[Graduation]
//[Participe]

//Avez vous remarqu, je n'ai pas spcifi quels champs forment les liens entre
//les tables
//C'est que le systme utilise automatiquement la cl primaire comme lien
//si vous dsirez utiliser d'autre champs de lien, crivez les comme ceci:

//l1=Graduation AS G, J.nopasseport = G.nopasseport

//Dans cette exemple, G est l'alias pour GRADUATION et J l'alias pour JUDOKA

interface

uses db, dbtables, iniFiles, comctrls, classes, extctrls, controls,
     uProgresTravail, sysUtils, dialogs, forms,
     uGestionExecUtils, uBDUtils, uJChaine,
     uBDConvertisseur;

const
   DefMsgAttPeutSupprimer1 = 'Veuyez patienter, judonux vrifie que la suppression';
   DefMsgAttPeutSupprimer2 = 'de cette enregistrement peut tre faites.';
   DefMsgAttPeutSupprimer3 = '';
   DefMsgAttArchiver1      = 'Archivage en cours, veuillez patienter...';
   DefMsgAttArchiver2      = 'NOTE: Si vous fermez cette fentre, l''application sera';
   DefMsgAttArchiver3      = 'paralis tant que l''opration ne sera pas termin';
   DefMsgAttDeArchiver1    = 'Darchivage en cours, veuillez patienter...';
   DefMsgAttDeArchiver2    = 'NOTE: Si vous fermez cette fentre, l''application sera';
   DefMsgAttDeArchiver3    = 'paralis tant que l''opration ne sera pas termin';

type
  tVerifierDependances = class(tCallParal)
   private
     UrgenceFerme, VerifierArchive : Boolean;
     Progression : LongInt;
     //Appeleur : tTimer;
     ini : tMemIniFile;

     procedure MessageDeFin;
     procedure MiseAjourProgression;
     procedure SurFin(sender : tObject);
   protected
     Message : String;
     reussite : Boolean;
     tmpSession : tSession;

     function ConditionOk(const condition, TableName, CleValeur, clePrimaire: String;
              query: tSuperQuery): Boolean; dynamic;
     function VerifierRequete(const Requete, Table: String;
       query: tSuperQuery): Boolean; dynamic;
     procedure Travailler(query: tSuperQuery); dynamic;
   public
     fErreurDependance, fCleValeur, fTableName : String;
     fProgresBar : tProgressBar;
     //fquery : tSuperQuery;
     fDataBase : tSuperDataBase;

     constructor Create(dataBase : tSuperDataBase;
                        const SurOk, SurFin : tProcedureObj;
                        const ProgresBar : tProgressBar;
                        const CleValeur, TableName, ErreurDependance : String;
                        const DoitVerifierArchive : Boolean);
     procedure execute; override;
  end;

  //Fonctionne comme son anctre mais archive au lieu de vrifier
  tArchiveurRecursif = class(tVerifierDependances)
   private
     function Archiver(const Table: String; query: tSuperQuery;
               const progStep : LongInt) : Boolean;
     function AppliquerMode(const Table: String): String;
     function TableArchiveDe(const Table: String): String;
     function DeAppliquerMode(const Table: String): String;
     function TableNonArchiveDe(const Table: String): String;
   protected
     fDeArchiver : Boolean;
     procedure Travailler(query : tSuperQuery); override;
     function VerifierRequete(const Requete, Table: String;
       query: tSuperQuery): Boolean; override;
  public
    constructor Create(DataBase: tSuperDataBase; const SurOk, SurFin: tProcedureObj;
      const ProgresBar: tProgressBar; const CleValeur,
      TableName : String; const DeArchiver: Boolean);
  end;

  //C'est le gestionnaire pour les systmes de travail en parallle
  //Retient les donnes pour appels multiples
  //Cette objet peut tre assign  un conteneur, alors, la libration
  //est gr automatiquement, ce qui vite les ennuis
  //Peut tre plac sur une fiche et les proprits peuvent tre dit
  //dans l'diteur d'objet
  tRecursifOps = class(tComponent)
   private
     fDataBase: tSuperDataBase;
     fMsgAttPeutSupprimer1: String;
     fMsgAttPeutSupprimer2: String;
     fMsgAttPeutSupprimer3: String;
     fMsgAttArchiver1: String;
     fMsgAttArchiver2: String;
     fMsgAttArchiver3: String;
     fMsgAttDeArchiver1: String;
     fMsgAttDeArchiver2: String;
     fMsgAttDeArchiver3: String;
     procedure LancerTravail;
     procedure SetDataBase(const Value: tSuperDataBase);
    procedure DeactiverFermeParent;
    procedure CloseQuery(Sender: TObject; var CanClose: Boolean);
   protected
     fDestPourMessage : tWinControl;
     pform : tForm;
     AncOnCloseQuery : TCloseQueryEvent;
     fMessageErreurDependance : String;

     Operation : tVerifierDependances;
     InfoBarre : tfraProgresTravail;
     UrgenceStop : Boolean;

     Procedure ApresOperation;
     procedure PreparerTravail;
   public
     function OperationEnCours : Boolean;
     Procedure AfterConstruction; override;
     Procedure BeforeDestruction; override;
     Procedure VerifierDependance(const TableName, Element : String;
               const SurCorrecte : tProcedureObj; const DoitVerifierArchive : Boolean);
     Procedure Archiver(const TableName, Element : String;
               const SurReussite : tProcedureObj);
     Procedure Dearchiver(const TableName, Element : String;
               const SurReussite : tProcedureObj);
   published
//     property DataBaseName : String read fDataBaseName write fDataBaseName;
     property DataBase : tSuperDataBase read fDataBase write SetDataBase;
     property DestPourMessage : tWinControl read fDestPourMessage write fDestPourMessage;
     property MessageErreurDependance : String read fMessageErreurDependance write fMessageErreurDependance;
     property MsgAttPeutSupprimer1 : String
              read fMsgAttPeutSupprimer1 write fMsgAttPeutSupprimer1;
     property MsgAttPeutSupprimer2 : String
              read fMsgAttPeutSupprimer2 write fMsgAttPeutSupprimer2;
     property MsgAttPeutSupprimer3 : String
              read fMsgAttPeutSupprimer3 write fMsgAttPeutSupprimer3;
     property MsgAttArchiver1 : String
              read fMsgAttArchiver1 write fMsgAttArchiver1;
     property MsgAttArchiver2 : String
              read fMsgAttArchiver2 write fMsgAttArchiver2;
     property MsgAttArchiver3 : String
              read fMsgAttArchiver3 write fMsgAttArchiver3;
     property MsgAttDeArchiver1 : String
              read fMsgAttDeArchiver1 write fMsgAttDeArchiver1;
     property MsgAttDeArchiver2 : String
              read fMsgAttDeArchiver2 write fMsgAttDeArchiver2;
     property MsgAttDeArchiver3 : String
              read fMsgAttDeArchiver3 write fMsgAttDeArchiver3;
  end;

Procedure LireDependance(var dependances : tStrings;
                         var ClePrimaire : String;
                         const table : String;
                         const data : tDataSet;
                         const Ini : TCustomIniFile);

implementation

//Cette fonction retourne la version archive de la table
function TableArchiveDe(const Table : String) : String;
 begin
   result := 'A_' + table;
 end;

//Cette fonction retourne la version archive de la table
function TableNonArchiveDe(const Table : String) : String;
 begin
   if copy(table, 1, 2) = 'A_' then
      result := copy(table, 3, high(integer))
   else
      raise exception.Create('Pas table archive alors que est suppos l''tre!');
 end;

//Cette procdure effectue la lecture de la cl primaire et des dpendances
//Fournissez un data avec des donnes valide  la table en cours pour que
//l'utilisation de la cl par dfaut fonctionne correctement
//NOTE: Plac l'appel de cette procdure dans un bloc TRY FINALLY
//      Dans le finally, librer les dpendances (dependance.free)
//      En cas d'erreur, lance une exception mais ne libre pas Dependances,
//      alors vous devez le faire.
//Dependances doit ne rien contenir et ne pas tre initialis, devrait valoir nil
//ou du garbage
Procedure LireDependance(var dependances : tStrings;
                         var ClePrimaire : String;
                         const Table : String;
                         const data : tDataSet;
                         const Ini : TCustomIniFile);
var i : LongInt;
 begin
   Dependances := nil;
   Dependances := tStringList.Create;

   if (data <> nil) and (data.FieldCount > 0) then
      ClePrimaire := data.Fields[0].FieldName;//Valeur par dfaut
   if ini.SectionExists(Table) then
    begin
      ini.ReadSection(Table, Dependances);
      //Lecture de la cl primaire
      i := Dependances.IndexOf('ClePrim');
      if (Dependances.Count > 0) and (i >= 0) then
       begin
         clePrimaire := ini.ReadString(Table, 'ClePrim', clePrimaire);
         Dependances.Delete(i);
       end
    end
   else
    begin
      raise Exception.Create('ERREUR! Aucune donne de dpendances sur la table: ' + Table);
    end;

   i := 0;
   while i < Dependances.Count do
    begin
      dependances.Strings[i] := ini.REadString(Table, dependances.Strings[i], '');
      inc(i);
    end;
 end;

//Lecture des dpendance dtail
//Ces dpendances sont utilis pour dsarchiver
Procedure LireDependanceDetail(var dependances : tStrings;
                         const Table : String;
                         const data : tDataSet;
                         const Ini : TCustomIniFile);
var i : LongInt;
    ATable : String;
 begin
   ATable := TableArchiveDe(table);
   Dependances := nil;
   Dependances := tStringList.Create;

   if ini.SectionExists(ATable) then
    begin
      ini.ReadSection(ATable, Dependances);
      //Lecture de la cl primaire
      i := Dependances.IndexOf('ClePrim');
      if (Dependances.Count > 0) and (i >= 0) then
       begin
         Dependances.Delete(i);
       end;
    end;

   i := 0;
   while i < Dependances.Count do
    begin
      dependances.Strings[i] := ini.REadString(ATable, dependances.Strings[i], '');
      inc(i);
    end;
 end;

{ tRecursifOps }

//Avant de permettre la suppression, il faut absolument arrter l'opration en
//cours
procedure tRecursifOps.BeforeDestruction;
 begin
   if Operation <> nil then
    begin
      UrgenceStop := true;
      Operation.UrgenceFerme := true;
      Operation.Terminate;
      Operation.WaitFor;
      Operation.Free;
    end;
   InfoBarre.Free;
 end;

//Quand l'opration est termin, il faut effectu la libration des ressources
//alloues
procedure tRecursifOps.ApresOperation;
 begin
   InfoBarre.free;
   InfoBarre := nil;
   Operation.FreeOnTerminate := true;
   Operation := nil;
   fDestPourMessage.enabled := true;
   pform.OnCloseQuery := self.AncOnCloseQuery;
 end;

//Cette procdure est appel par la fiche parent quand elle veut se fermer
//on lui dit "non"
procedure tRecursifOps.CloseQuery(Sender: TObject;
    var CanClose: Boolean);
 begin
   CanClose := false;
 end;

//Cette procdure modifie la Fiche parent pour quelle ne soit pas ferm...
procedure tRecursifOps.DeactiverFermeParent;
var prom : tWinControl;
 begin
   prom := self.Owner as tWinControl;
   while (prom <> nil) and not (prom is tForm) do
    begin
      prom := prom.Parent;
    end;

   self.pform := (prom as tForm);
   self.AncOnCloseQuery := (prom as tForm).OnCloseQuery;
   (prom as tForm).OnCloseQuery := Self.CloseQuery;
 end;

//Cette procdure effectue les oprations prparatoire ncessaires avant
//un travail
procedure tRecursifOps.PreparerTravail;
 begin
   UrgenceStop := true;
   if Owner = nil then
      raise Exception.Create('Pour garantir une excution sans bogues, ' +
      'tRecursifOps doit tre possd par un autre contrle');

   If (fDestPourMessage = nil) then
    begin
      if (Owner is tWinControl) then
         fDestPourMessage := Owner as tWinControl
      else
         raise Exception.Create('Aucun destinataire n''est disponible pour la barre de progression');
    end;

   fDestPourMessage.Enabled := false;
//   fDestPourMessage.
   InfoBarre := tfraProgresTravail.Create(fDestPourMessage);

   DeactiverFermeParent;
 end;

//Cette procdure lance le travail
//c'est la partie finale commune du lancement
Procedure tRecursifOps.LancerTravail;
 begin
   InfoBarre.Align := alTop;
   InfoBarre.Parent  := fDestPourMessage;
   InfoBarre.Visible := true;
   InfoBarre.pbProgression.Min := 0;
   InfoBarre.pbProgression.Position := 0;
 end;

//Cette procdure appellera SurCorrecte si l'Element de TableName n'a pas de
//dpendances
Procedure tRecursifOps.VerifierDependance(const TableName, Element : String;
               const SurCorrecte : tProcedureObj; const DoitVerifierArchive : Boolean);
 begin
   PreparerTravail;
//   InfoBarre := tfraProgresTravail.Create(fDestPourMessage);

   InfoBarre.lblLigne1.Caption := fMsgAttPeutSupprimer1;
   InfoBarre.lblLigne2.Caption := fMsgAttPeutSupprimer2;
   InfoBarre.lblLigne3.Caption := fMsgAttPeutSupprimer3;

   Operation := tVerifierDependances.Create(fDataBase, SurCorrecte, ApresOperation,
                InfoBarre.pbProgression, Element, TableName,
                fMessageErreurDependance, DoitVerifierArchive);
   LancerTravail;
 end;

//Cette procdure archivera rcursivement Element de TableName
//Appelle SurReussite en cas de russite
Procedure tRecursifOps.Archiver(const TableName, Element : String;
               const SurReussite : tProcedureObj);
 begin
   PreparerTravail;

   InfoBarre.lblLigne1.Caption := fMsgAttArchiver1;
   InfoBarre.lblLigne2.Caption := fMsgAttArchiver2;
   InfoBarre.lblLigne3.Caption := fMsgAttArchiver3;

   Operation := tArchiveurRecursif.Create(DataBase, SurReussite, ApresOperation,
                InfoBarre.pbProgression, Element, TableName, False);
   LancerTravail;
 end;

//Cette procdure archivera rcursivement Element de TableName
//Appelle SurReussite en cas de russite
Procedure tRecursifOps.Dearchiver(const TableName, Element : String;
               const SurReussite : tProcedureObj);
 begin
   PreparerTravail;
//   InfoBarre := tfraProgresTravail.Create(fDestPourMessage);
   InfoBarre.lblLigne1.Caption := fMsgAttDeArchiver1;
   InfoBarre.lblLigne2.Caption := fMsgAttDeArchiver2;
   InfoBarre.lblLigne3.Caption := fMsgAttDeArchiver3;
   Operation := tArchiveurRecursif.Create(DataBase, SurReussite, ApresOperation,
                InfoBarre.pbProgression, Element, TableName, True);
   LancerTravail;
 end;

{ tVerifierDependances }

constructor tVerifierDependances.Create(DataBase : tSuperDataBase;
  const SurOk, SurFin: tProcedureObj;
  const ProgresBar : tProgressBar;
  const CleValeur, TableName, ErreurDependance: String;
  const DoitVerifierArchive : Boolean);
 begin
   UrgenceFerme := false;
   fCleValeur        := CleValeur;
   fDataBase         := DataBase;
   fTableName        := TableName;
   fErreurDependance := ErreurDependance;
   fProgresBar := ProgresBar;
   VerifierArchive := DoitVerifierArchive;
   if (fCleValeur = '') or (DataBase = nil) then
      raise Exception.Create('Paramtre vide dans tVerifierDependances.Create');
   self.ReturnValue := 0;
   inherited Create(SurOk, SurFin);
   self.FreeOnTerminate := false;
 end;

//Affiche le messagre
procedure tVerifierDependances.MessageDeFin;
 begin
   if Message <> '' then
      MessageDlg(message, mtError, [mbOk], 0);
 end;

//Cette procdure met  jour la barre de progression
procedure tVerifierDependances.MiseAjourProgression;
 begin
   fProgresBar.Position := Progression;
 end;

//Cette procdure est ncessaire pour effectuer les oprations  la fin de l'excution
//sans risque de geler l'application
procedure tVerifierDependances.SurFin(sender : tObject);
 begin
   try
     if not UrgenceFerme then
      begin
        if reussite and assigned(CallProcedure) then
           CallProcedure
        else
           MessageDeFin;
      end;
     if assigned(CallFin) then
        CallFin;
   except
     On E : exception do
      begin
        MessageDlg('ERREUR LORS DE FERMETURE AVEC MESSAGE: "' +
        e.Message, mtError, [mbOk], 0);
      end;
   end;
 end;

//Cette fonction effectue la requte et est destin a tre surcharg
//pour pouvoir effectuer d'autres oprations...
function tVerifierDependances.VerifierRequete(const Requete, Table : String;
         query : tSuperQuery) : Boolean;
 begin
   result := not RequeteAUnEl(Requete, query);
 end;

//Cette function retourne vrai si la condition de supression est rempli
function tVerifierDependances.ConditionOk(const condition, TableName, CleValeur,
         ClePrimaire : String;
         query : tSuperQuery) : Boolean;
var Requete, lecture, aliass, TableComp : String;
    i, nbCond, pp : LongInt;
 begin
   if condition = '' then
    begin//Sortie sur condition nulle
      result := true;
      exit;
    end;

   i := 1;
   LireUnEl(condition, lecture, i, [';', ',']);
   pp := pos('AS ', UpperCase(lecture));
   if pp > 0 then
    begin
      aliass := copy(lecture, 255, pp + 3) + '.';
      TableComp := copy(lecture, 1, pp-1);
    end
   else
    begin
      aliass := 's.';
      TableComp := lecture;
      lecture := lecture + ' AS S';
    end;

   requete := 'SELECT ' + Aliass + '*  from ' + TableName + ' as j, ' + lecture + ' ';
   requete := requete + 'where ';
   nbCond := 0;
   while LireUnEl(condition, lecture, i, [';', ',']) do
    begin
      if nbCond > 0 then
         requete := requete + ' AND ';
      requete := requete + lecture;
      inc(nbCond);
    end;

   //Utilisation de la condition par dfaut...
   //c'est  dire de copier la cl primaire
   if nbCond = 0 then
    begin
      i := 1;
      while LireUnEl(ClePrimaire, lecture, i) do
       begin
         if nbCond > 0 then
            requete := requete + ' AND ';
         requete := requete + 'j.' + lecture + ' = ' + aliass + lecture;
         inc(nbCond);
       end;
    end;

   Requete := requete + ' AND ' + CleValeur;

   try
      result := VerifierRequete(requete, tableComp, query);
   except
   On E:Exception do
    begin
      result := false;
      Message := 'ERREUR DANS <' + condition + '> donnant la requte ' +
                 '<' + Requete + '> ' + e.Message;
    end;
   end;
 end;

//Cette procdure effectue l'opration importante, le gros travail
//aprs que execute est fait la prparation
procedure tVerifierDependances.Travailler(query : tSuperQuery);
var i : LongInt;
    Dependance  : tStrings;
    ClePrimaire : String;
 begin
   i := 0;
   try
     try
       LireDependance(Dependance, ClePrimaire, fTableName, query.Data, Ini);
       fProgresBar.Max      := Dependance.Count;
       while (i < dependance.Count) and
             (ConditionOk(Dependance.Strings[i], fTableName, fCleValeur, ClePrimaire, query)) and
             (Not VerifierArchive or (ConditionOk(Dependance.Strings[i], 'A_' + fTableName, fCleValeur, ClePrimaire, query))) do
        begin
          inc(Progression, 1);
          inc(i);
//          if Terminated then
//             exit;//sortie urgence
          MiseAjourProgression;
        end;
     except
       On E:Exception do
        begin
          if (i >= 0) and (i < Dependance.Count) then
             Message := 'ERREUR DANS <' + Dependance.Strings[i] + '> ' + e.Message
          else
             Message := 'ERREUR! hors boucle ' + e.Message;
        end;
     end;
   finally
     Dependance.Free;
   end;
 end;

//Vrification en parallle de si on peut supprimer
//Le grand problme c'est que je ne peut pas utiliser synchronize
//parce que la thread principal peut tre bloqu en train de nous attendre...
procedure tVerifierDependances.execute;
var Query : tSuperQuery;
    AParams: TStringList;
    dir : string;
 begin
   try
     tmpSession := tSession.Create(nil);
     Query := nil;
     try
        tmpSession.AutoSessionName := true;
        tmpSession.Open;
        query := fDataBase.CreerSupQuery;
        Progression := 0;
        Message := '';
        AParams := tStringList.Create;
        try
           tmpSession.GetAliasParams(fDataBase.DataBaseName, AParams);
           dir := copy(AParams.Strings[0], 6, high(longInt))

        finally
           AParams.free;
        end;

        ini := tMemIniFile.Create(Dir + '\' + DependanceFic);
        try
          Travailler(query);
        finally
          ini.free;
          ini := nil;
        end;

        if (Progression = fProgresBar.Max) and (message = '') then
         begin
           Reussite := true;
         end
        else
         begin
           reussite := false;
           if Message = '' then
              Message := fErreurDependance;
         end;
     finally
        Query.Free;
        tmpSession.Free;
     end;
   except
     On E:exception do
        Message := e.Message;
   end;
   OnTerminate := SurFin;
 end;

{ tArchiveurRecursif }

//Cette fonction retourne la version archive de la table
function tArchiveurRecursif.TableArchiveDe(const Table : String) : String;
 begin
   result := 'A_' + table;
 end;

//Cette fonction retourne la version archive de la table
function tArchiveurRecursif.TableNonArchiveDe(const Table : String) : String;
 begin
   if copy(table, 1, 2) = 'A_' then
      result := copy(table, 3, high(integer))
   else
      raise exception.Create('Pas table archive alors que est suppos l''tre!');
 end;

//Si on est en mode darchivage, modifie le nom de la table pour en faire une
//table de dsarchivage
function tArchiveurRecursif.AppliquerMode(const Table : String) : String;
 begin
   if fDeArchiver then
      result := TableArchiveDe(Table)
   else
      result := Table;
 end;

//Si on est en mode darchivage, modifie le nom de la table pour que ce ne soit
//plus une table d'archivage
function tArchiveurRecursif.DeAppliquerMode(const Table : String) : String;
 begin
   if fDeArchiver then
      result := TableNonArchiveDe(Table)
   else
      result := Table;
 end;

//Cette procdure archive la table TABLE
//Query contient les enregistrements  supprimer
//La cl est obtenue du fichier config
//retourne vrai quand pas de problmes
function tArchiveurRecursif.Archiver(const Table : String; query : tSuperQuery; const progStep : LongInt) : Boolean;
var i, avancement : Longint;
    LesCleValeur, Cle : String;
    BesoinOr : Boolean;
    Dependances : tStrings;

  //Archive/dsarchive les tables dpendandes
  procedure ArchiverDependance;
   begin
     i := 0;
     while (i < Dependances.Count) and
     ConditionOk(AppliquerMode(Dependances.Strings[i]),
     table, LesCleValeur, Cle, query) do
      begin
        inc(i);
        progression := avancement + i * progstep;
        MiseAjourProgression;
      end;
   end;

  //Cette function dsarchive les tables MAITRES en lien
  Function DesarchiverUnMaitre(Const Table, TableMaitre, CleValeurs : String;
                             query : tSuperQuery; ini : tMemIniFile) : Boolean;
  Var ClePrim, tb : String;
      pos : LongInt;
   begin
     Pos := 1;
     If LireUnEl(TableMaitre, tb, pos) then
      begin
        ClePrim := uBdConvertisseur.LireClePrimaire(tb, query.DataBase);
        result := ConditionOk(TableArchiveDe(TableMaitre), Table,
                              CleValeurs, clePrim, query);
      end
     else
       raise Exception.Create('DesarchiverUnMaitre->Impossible de lire le nom de la table');
   end;

  //Cette procdure dsarchive les tables Maitres ncessaire
  procedure DesarchiverMaitre;
  Var DetailDepend : tStrings;
      i : LongInt;
   begin
     //DetailDepend := tStringList.Create;
     LireDependanceDetail(DetailDepend, Table, query.Data, ini);
     try
       i := 0;
       while (i < DetailDepend.Count) and
       DesarchiverUnMaitre(Table, DetailDepend.Strings[i], LesCleValeur, query,
                           ini) do
        begin
          inc(i);
//          progression := avancement + i * progstep;
//          MiseAjourProgression;
        end;
     finally
       DetailDepend.Free;
     end;
   end;

  //Effectue le darchivage
  procedure Dearchiver;
   begin
     DesarchiverMaitre;
     try
       DeplacerEnrs(TableArchiveDe(Table), Table, LesCleValeur, query);
     except
       On E:exception do begin
          Message := 'ERREUR lors du dplacement de ' + Table + '.'+chr(13)+
                        chr(10)+'MESSAGE D''ERREUR:'+e.Message;
       end;
     end;
     ArchiverDependance;
     result := true;
   end;

 begin
   if query.Data.IsEmpty then
    begin
      result := true;
      exit;
    end;
   result := false;
   avancement := progression;
   try
     LireDependance(dependances, Cle, table, query.Data, ini);
     if progStep = 100 then
        fProgresBar.Max := dependances.Count * 100;

     LesCleValeur := '';
     query.Data.First;
     BesoinOr := false;
     while not query.Data.Eof do
      begin
        if besoinOr Then
           LesCleValeur := LesCleValeur + ' OR ';
        LesCleValeur := LesCleValeur + '(' + CleValeur(Cle, query.Data) + ')';
        query.Data.Next;
        besoinOr := true;
      end;

     if fDeArchiver Then
      begin
        Dearchiver;
      end
     else
      begin
        ArchiverDependance;
        if (i = Dependances.Count) then
         begin
           try
             DeplacerEnrs(Table, TableArchiveDe(Table), LesCleValeur, query);
             result := true;
           except
             On E:exception do begin
                Message := 'ERREUR lors du dplacement de ' + Table + '.'+chr(13)+
                chr(10)+'MESSAGE D''ERREUR:'+e.Message;
             end;
           end;
         end;
      end;

   finally
     Dependances.Free;
   end;
 end;

//Le travaille effectuer n'est videmment pas le mme...
//Que celui de notre anctre
//On fait une requte slection pour obtenir les lments
procedure tArchiveurRecursif.Travailler(query: tSuperQuery);
var Requete : String;
 begin
   Requete := 'SELECT * from ' + AppliquerMode(fTableName) + ' Where ' + fCleValeur;

   query.RequeteSelection(Requete);

   if not Archiver(fTableName, query, 100) then
      progression := -1;
 end;

//Effectue la requte et supprime tous les lments
function tArchiveurRecursif.VerifierRequete(const Requete, Table: String;
  query: tSuperQuery): Boolean;
var tmpQuery : tSuperQuery;//Modifier le query actuel n'est pas une bonne ide... on veut garder ses donnes
 begin
  // result := false;
   tmpQuery := fDataBase.CreerSupQuery;
   try
      tmpQuery.RequeteSelection(Requete);
      result := Archiver(DeAppliquerMode(Table), tmpQuery, 0);
   finally
      tmpQuery.Free;
   end;
 end;

//Initialisation de l'archiveur rcursif
constructor tArchiveurRecursif.Create(DataBase: tSuperDataBase;
  const SurOk, SurFin: tProcedureObj;
  const ProgresBar : tProgressBar;
  const CleValeur, TableName: String;
  const DeArchiver : Boolean);
 begin
   fDeArchiver := DeArchiver;
   inherited Create(DataBase, SurOk, SurFin, ProgresBar, CleValeur,
             TableName, 'Interruption trange des oprations!', false);
 end;


procedure tRecursifOps.SetDataBase(const Value: tSuperDataBase);
 begin
   fDataBase := Value;
//   Query.Free;
//   query := fDataBase.CreerSupQuery;
 end;

//Initialisation
procedure tRecursifOps.AfterConstruction;
 begin
   inherited;
   fMsgAttPeutSupprimer1 := DefMsgAttPeutSupprimer1;
   fMsgAttPeutSupprimer2 := DefMsgAttPeutSupprimer2;
   fMsgAttPeutSupprimer3 := DefMsgAttPeutSupprimer3;
   fMsgAttArchiver1      := DefMsgAttArchiver1;
   fMsgAttArchiver2      := DefMsgAttArchiver2;
   fMsgAttArchiver3      := DefMsgAttArchiver3;
   fMsgAttDeArchiver1    := DefMsgAttDeArchiver1;
   fMsgAttDeArchiver2    := DefMsgAttDeArchiver2;
   fMsgAttDeArchiver3    := DefMsgAttDeArchiver3;
 end;

//Retourne vrai si il y a une opration en parallle en cours...
function tRecursifOps.OperationEnCours: Boolean;
 begin
   result := Operation <> nil;
 end;

end.
