unit ServerUnit;

interface

uses
	csGlobals,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, ComCtrls, ExtCtrls, AIPCUnit;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Splitter1: TSplitter;
    ListView1: TListView;
    cbActive: TCheckBox;
    cbAsk: TCheckBox;
    cbDupNames: TCheckBox;
    btnSendClientList: TButton;
    btnSendBuffer: TButton;
    btnSendText: TButton;
    Edit1: TEdit;
    AIPCServer1: TAIPCServer;
    btnUnlink: TButton;
		procedure cbActiveClick(Sender: TObject);
    procedure ListView1Change(Sender: TObject; Item: TListItem;
      Change: TItemChange);
		procedure FormCreate(Sender: TObject);
    procedure btnSendClientListClick(Sender: TObject);
		procedure btnSendBufferClick(Sender: TObject);
		procedure btnSendTextClick(Sender: TObject);
		procedure AIPCServer1ClientLogIn(Sender: TObject;
			Client: TAIPCClientItem; var Accept: Boolean);
		procedure AIPCServer1ClientLogOut(Sender: TObject;
			Client: TAIPCClientItem);
    procedure AIPCServer1IPCBuffer(Sender: TObject; FromHandle: integer;
      Data: PAIPCBuffer);
    procedure AIPCServer1StringList(Sender: TObject; FromHandle: integer;
      Service: String; Strings: TStrings);
    procedure AIPCServer1TextMessage(Sender: TObject; FromHandle: integer;
      Service, Msg: String);
    procedure AIPCServer1Component(Sender: TObject; FromHandle: integer;
      Service: String; Component: TComponent; var CanDelete: Boolean);
    procedure btnUnlinkClick(Sender: TObject);
    procedure cbDupNamesClick(Sender: TObject);
	private
		procedure CheckControls;
		function GetItem(Handle: integer): integer;
		{ Private-Deklarationen }
	public
		{ Public-Deklarationen }
	end;

var
	Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.CheckControls;
var
	enable: boolean;
begin
	if AIPCServer1.Active
	and (ListView1.Items.Count > 0)
	and (ListView1.Selected <> nil) then
		enable := true
	else
		enable := false;

	btnUnlink.Enabled := enable;
	btnSendClientList.Enabled := enable;
	btnSendBuffer.Enabled := enable;
	btnSendText.Enabled := enable;
end;

function TForm1.GetItem(Handle: integer): integer;
var
	i: integer;
	s: string;
begin
	Result := -1;
	s := IntToStr(Handle);
	for i:=0 to ListView1.Items.Count - 1 do
	begin
		if ListView1.Items[i].Caption = s then
		begin
			Result := i;
			exit;
		end;
	end;
end;

procedure TForm1.cbActiveClick(Sender: TObject);
begin
	AIPCServer1.Active := cbActive.Checked;
	if not AIPCServer1.Active then
		ListView1.Items.Clear;
	CheckControls;
end;

procedure TForm1.ListView1Change(Sender: TObject; Item: TListItem;
	Change: TItemChange);
begin
	if Change = ctState then
		CheckControls;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
	CheckControls;
end;

procedure TForm1.btnUnlinkClick(Sender: TObject);
var
	hdl: integer;
begin
	hdl := StrToInt(ListView1.Selected.Caption);
	AIPCServer1.UnlinkClient(hdl);
	ListView1.Items.Delete(ListView1.Selected.Index);
end;

procedure TForm1.btnSendClientListClick(Sender: TObject);
var
	sl: TStringList;
	i: integer;
begin
	sl := TStringList.Create;
	try
		for i:=0 to ListView1.Items.Count-1 do
			sl.Add(ListView1.Items[i].SubItems[0]);

		AIPCServer1.SendIPCMessage(
			StrToInt(ListView1.Selected.Caption),sl);
	finally
		sl.Free;
	end;
end;

procedure TForm1.btnSendBufferClick(Sender: TObject);
var
	tb: TTestBuffer;
begin
	tb.i := 12345;
	tb.d := 123.45;
	tb.s := 'Testbuffer';
	AIPCServer1.SendIPCMessage(
		StrToInt(ListView1.Selected.Caption), @tb, sizeof(TTestBuffer),
		'ShowTestBuffer','TTestBuffer');
end;

procedure TForm1.btnSendTextClick(Sender: TObject);
begin
	AIPCServer1.SendIPCMessage(
		StrToInt(ListView1.Selected.Caption), Edit1.Text );
end;

procedure TForm1.AIPCServer1ClientLogIn(Sender: TObject;
	Client: TAIPCClientItem; var Accept: Boolean);
var
	s: string;
	item: TListItem;
begin
	s := Format('Client %s wants to login' + #13#10 + 'Password is %s' + #13#10 + 'Accept ?',
		[Client.Name, Client.Password] );
	if cbAsk.Checked
	and ( MessageDlg(s, mtWarning, [mbYes,mbNo], 0) = mrNo ) then
	begin
		Accept := false;
		exit;
	end;

	Accept := true;
	item := ListView1.Items.Add;
	item.Caption := IntToStr(Client.Handle);
	item.SubItems.Add(Client.Name);
	item.SubItems.Add(Client.Kind);
	item.SubItems.Add('New');
	item.SubItems.Add('0');
end;

procedure TForm1.AIPCServer1ClientLogOut(Sender: TObject;
	Client: TAIPCClientItem);
var
	i: integer;
begin
	i := GetItem(Client.Handle);
	if i >= 0 then
		ListView1.Items.Delete(i);
end;

procedure TForm1.AIPCServer1IPCBuffer(Sender: TObject; FromHandle: integer;
	Data: PAIPCBuffer);
var
	i: integer;
	p: PStatusMsg;
begin
	if (Data.DataFmt <> 'TStatusMsg')
	or (Data.Service <> 'ShowStatus') then
		exit;

	i := GetItem(FromHandle);
	if i >= 0 then
	begin
		p := PStatusMsg(@Data.Data);
		ListView1.Items[i].SubItems[2] := p.status;
		ListView1.Items[i].SubItems[3] := IntToStr(p.percent) + '%';
	end;
end;

procedure TForm1.AIPCServer1StringList(Sender: TObject; FromHandle: integer;
	Service: String; Strings: TStrings);
begin
	ShowMessage(Strings.Text);
end;

procedure TForm1.AIPCServer1TextMessage(Sender: TObject; FromHandle: integer;
	Service, Msg: String);
begin
	ShowMessage(Msg);
end;

procedure TForm1.AIPCServer1Component(Sender: TObject; FromHandle: integer;
	Service: String; Component: TComponent; var CanDelete: Boolean);
var
	tobj: TTestObject;
begin
	if Component is TTestObject then
	begin
		tobj := Component as TTestObject;
		ShowMessage( 'Component received !' + #13#10 +
			Format('int=%d double=%f string=%s',[tobj.i,tobj.d,tobj.s]) );
	end;
	canDelete := true;
end;


procedure TForm1.cbDupNamesClick(Sender: TObject);
begin
  AIPCServer1.AllowDuplicateNames :=
    cbDupNames.Checked;
end;

end.
