unit ClientUnit;

interface

uses
	csGlobals,
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, AIPCUnit;

type
	TForm2 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
		edtName: TEdit;
		Label2: TLabel;
    comboKind: TComboBox;
    cbActive: TCheckBox;
    cbConnected: TCheckBox;
    cbLoggedIn: TCheckBox;
    tbPercent: TTrackBar;
    Label3: TLabel;
    Splitter1: TSplitter;
    Memo1: TMemo;
    btnLogInOut: TButton;
    btnSendMemo: TButton;
    btnSendKinds: TButton;
    btnSendTestObject: TButton;
    comboStatus: TComboBox;
    AIPCClient1: TAIPCClient;
    btnSendStatus: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnLogInOutClick(Sender: TObject);
    procedure btnSendStatusClick(Sender: TObject);
    procedure btnSendMemoClick(Sender: TObject);
    procedure btnSendKindsClick(Sender: TObject);
    procedure btnSendTestObjectClick(Sender: TObject);
    procedure edtNameChange(Sender: TObject);
    procedure comboKindChange(Sender: TObject);
    procedure AIPCClient1ActiveChanged(Sender: TObject);
    procedure AIPCClient1LogInAccepted(Sender: TObject);
    procedure AIPCClient1LogInRefused(Sender: TObject);
    procedure AIPCClient1SendTimeOut(Sender: TObject);
    procedure AIPCClient1ServerAvailable(Sender: TObject);
    procedure AIPCClient1ServerNotAvailable(Sender: TObject);
    procedure AIPCClient1ServerShutDown(Sender: TObject);
    procedure AIPCClient1ServerStartUp(Sender: TObject);
    procedure AIPCClient1StringList(Sender: TObject; FromHandle: integer;
      Service: String; Strings: TStrings);
    procedure AIPCClient1TextMessage(Sender: TObject; FromHandle: integer;
      Service, Msg: String);
    procedure AIPCClient1Unlinked(Sender: TObject);
    procedure cbActiveClick(Sender: TObject);
    procedure tbPercentChange(Sender: TObject);
    procedure AIPCClient1IPCBuffer(Sender: TObject; FromHandle: Integer;
      Data: PAIPCBuffer);
  private
		{ Private-Deklarationen }
		procedure CheckControls;
	public
		{ Public-Deklarationen }
	end;

var
	Form2: TForm2;

implementation

{$R *.dfm}

{ TForm2 }

procedure TForm2.CheckControls;
begin
	cbConnected.Checked := AIPCClient1.Connected;
	cbLoggedIn.Checked := AIPCClient1.LoggedIn;
	btnSendStatus.Enabled := AIPCClient1.LoggedIn;
	btnSendMemo.Enabled := AIPCClient1.LoggedIn;
	btnSendKinds.Enabled := AIPCClient1.LoggedIn;
	btnSendTestObject.Enabled := AIPCClient1.LoggedIn;
	tbPercent.Enabled := AIPCClient1.LoggedIn;
	btnLogInOut.Enabled := AIPCClient1.Connected;
	if AIPCClient1.LoggedIn then
		btnLogInOut.Caption := 'Logout'
	else
		btnLogInOut.Caption := 'Login';
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
	CheckControls;
end;

procedure TForm2.edtNameChange(Sender: TObject);
begin
	AIPCClient1.ClientName := edtName.Text;
end;

procedure TForm2.comboKindChange(Sender: TObject);
begin
	AIPCClient1.Kind := comboKind.Text;
end;

procedure TForm2.btnLogInOutClick(Sender: TObject);
begin
	if AIPCClient1.LoggedIn then
		AIPCClient1.LogOut
	else
		AIPCClient1.LogIn('ABC');
	CheckControls;
end;

procedure TForm2.btnSendStatusClick(Sender: TObject);
var
	sts: TStatusMsg;
begin
	sts.status := comboStatus.Text;
	sts.percent := tbPercent.Position;
	AIPCClient1.SendIPCMessage(AIPCClient1.ServerHandle,
		@sts, sizeof(TStatusMsg), 'ShowStatus', 'TStatusMsg' );
end;

procedure TForm2.btnSendMemoClick(Sender: TObject);
begin
	AIPCClient1.SendIPCMessage(AIPCClient1.ServerHandle,
		Memo1.Lines.Text);
end;

procedure TForm2.btnSendKindsClick(Sender: TObject);
begin
	AIPCClient1.SendIPCMessage(AIPCClient1.ServerHandle,
		comboKind.Items);
end;

procedure TForm2.btnSendTestObjectClick(Sender: TObject);
var
	tobj: TTestObject;
begin
	tobj := TTestObject.Create(nil);
	try
		tobj.i := 9876;
		tobj.d := 543.21;
		tobj.s := 'Client Object';
		AIPCClient1.SendIPCMessage(AIPCClient1.ServerHandle,tobj);
	finally
		tobj.Free;
	end;
end;

procedure TForm2.AIPCClient1ActiveChanged(Sender: TObject);
begin
	Memo1.Lines.Add('Active changed to ' +
		IntToStr( Integer(AIPCClient1.Active) ) );
	CheckControls;
end;

procedure TForm2.AIPCClient1LogInAccepted(Sender: TObject);
begin
	Memo1.Lines.Add('Login accepted');
	CheckControls;
end;

procedure TForm2.AIPCClient1LogInRefused(Sender: TObject);
begin
	Memo1.Lines.Add('Login refused');
	CheckControls;
end;

procedure TForm2.AIPCClient1SendTimeOut(Sender: TObject);
begin
	Memo1.Lines.Add('TimeOut !');
	CheckControls;
end;

procedure TForm2.AIPCClient1ServerAvailable(Sender: TObject);
begin
	Memo1.Lines.Add('Server available');
	CheckControls;
end;

procedure TForm2.AIPCClient1ServerNotAvailable(Sender: TObject);
begin
	Memo1.Lines.Add('Server not available');
	CheckControls;
end;

procedure TForm2.AIPCClient1ServerShutDown(Sender: TObject);
begin
	Memo1.Lines.Add('Server has shut down');
	CheckControls;
end;

procedure TForm2.AIPCClient1ServerStartUp(Sender: TObject);
begin
	Memo1.Lines.Add('Server coming up');
	CheckControls;
end;

procedure TForm2.AIPCClient1StringList(Sender: TObject; FromHandle: integer;
  Service: String; Strings: TStrings);
begin
	Memo1.Lines.Add(Strings.Text);
	CheckControls;
end;

procedure TForm2.AIPCClient1TextMessage(Sender: TObject; FromHandle: integer;
  Service, Msg: String);
begin
	Memo1.Lines.Add(Msg);
	CheckControls;
end;

procedure TForm2.AIPCClient1Unlinked(Sender: TObject);
begin
	Memo1.Lines.Add('Server has unlinked the login');
	CheckControls;
end;

procedure TForm2.cbActiveClick(Sender: TObject);
begin
	AIPCClient1.Active := cbActive.Checked;
	if AIPCClient1.Active then
		AIPCClient1.CheckConnection;
	CheckControls;
end;

procedure TForm2.tbPercentChange(Sender: TObject);
var
	sts: TStatusMsg;
begin
	sts.status := comboStatus.Text;
	sts.percent := tbPercent.Position;
	AIPCClient1.SendIPCMessage(AIPCClient1.ServerHandle,
		@sts, sizeof(TStatusMsg), 'ShowStatus', 'TStatusMsg' );
end;

procedure TForm2.AIPCClient1IPCBuffer(Sender: TObject; FromHandle: integer;
	Data: PAIPCBuffer);
var
	pb: PTestBuffer;
begin
	pb := PTestBuffer(@Data.Data);
	memo1.Lines.Add( 'Integer: ' + IntToStr(pb.i) );
	memo1.Lines.Add( 'Float: ' + FloatToStr(pb.d) );
	memo1.Lines.Add( 'String: ' + pb.s );
end;

end.
