//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ServerUnit.h"
#include "csGlobals.cpp"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "AIPCUnit"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckControls(void)
{
  bool enable;

  if( AIPCServer1->Active
  &&  ListView1->Items->Count > 0
  &&  ListView1->Selected != NULL )
    enable = true;
  else
    enable = false;

  btnUnlinkClient->Enabled = enable;
  btnSendClientList->Enabled = enable;
  btnSendTestBuffer->Enabled = enable;
  btnSendText->Enabled = enable;
}

int __fastcall TForm1::GetItem(int Handle)
{
  int result = -1;
  AnsiString s = IntToStr(Handle);

  for( int i=0; i<ListView1->Items->Count; i++ )
  {
    if( ListView1->Items->Item[i]->Caption == s)
    {
      result = i;
      break;
    }
  }
  return result;
}
void __fastcall TForm1::FormCreate(TObject *Sender)
{
RegisterClass(__classid(TTestObject));
  CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ListView1Change(TObject *Sender, TListItem *Item,
      TItemChange Change)
{
  if( Change == ctState )
    CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::cbActiveClick(TObject *Sender)
{
  AIPCServer1->Active = cbActive->Checked;
  if( !AIPCServer1->Active )
    ListView1->Items->Clear();  
}
//---------------------------------------------------------------------------

void __fastcall TForm1::cbAllowDupNamesClick(TObject *Sender)
{
  AIPCServer1->AllowDuplicateNames = cbAllowDupNames->Checked;  
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnUnlinkClientClick(TObject *Sender)
{
  int hdl = StrToInt(ListView1->Selected->Caption);
  AIPCServer1->UnlinkClient( hdl );
  ListView1->Items->Delete(ListView1->Selected->Index);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnSendClientListClick(TObject *Sender)
{
  TStringList *sl = new TStringList;
  try
  {
    for( int i=0; i<ListView1->Items->Count; i++ )
      sl->Add(ListView1->Items->Item[i]->SubItems->Strings[0]);

    AIPCServer1->SendIPCMessage(
      StrToInt(ListView1->Selected->Caption), sl );

  }
  __finally
  {
    delete sl;
  }

}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnSendTestBufferClick(TObject *Sender)
{
  TTestBuffer tb;

  tb.i = 12345;
  tb.d = 123.45;
  strcpy( tb.s, "TestBuffer" );

  AIPCServer1->SendIPCMessage(
      StrToInt(ListView1->Selected->Caption),
      &tb, sizeof(TTestBuffer), "ShowTestBuffer", "TTestBuffer");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::btnSendTextClick(TObject *Sender)
{
  AIPCServer1->SendIPCMessage(
    StrToInt(ListView1->Selected->Caption), Edit1->Text );

}
//---------------------------------------------------------------------------

void __fastcall TForm1::AIPCServer1ClientLogIn(TObject *Sender,
      TAIPCClientItem *Client, bool &Accept)
{
  AnsiString s;

  s = "Client " + Client->Name + " wants to login\n"
    + "Password is " + Client->Password + "\nAccept ?";

  if( cbAskOnLogin->Checked
  && MessageDlg( s, mtWarning, TMsgDlgButtons() << mbYes << mbNo, 0) == mrNo)
  {
    Accept = false;
    return;
  }

  Accept = true;
  TListItem *item = ListView1->Items->Add();
  item->Caption = IntToStr(Client->Handle);
  item->SubItems->Add(Client->Name);
  item->SubItems->Add(Client->Kind);
  item->SubItems->Add("New");
  item->SubItems->Add("0");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AIPCServer1ClientLogOut(TObject *Sender,
      TAIPCClientItem *Client)
{
  int i = GetItem(Client->Handle);
  if( i >= 0 )
    ListView1->Items->Delete(i);
}
//---------------------------------------------------------------------------





void __fastcall TForm1::AIPCServer1Component(TObject *Sender,
      int FromHandle, AnsiString Service, TComponent *Component,
      bool &CanDelete)
{
  if( Component->InheritsFrom( __classid(TTestObject) ) )
  {
    TTestObject *tobj = ((TTestObject *) Component);
    AnsiString s;
    s = IntToStr(tobj->i) + "\n"
      + FloatToStr(tobj->d) + "\n"
      + tobj->s;
    ShowMessage(s);
  }
  CanDelete = true;
  
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AIPCServer1TextMessage(TObject *Sender,
      int FromHandle, AnsiString Service, AnsiString Msg)
{
  ShowMessage( Msg );

}
//---------------------------------------------------------------------------

void __fastcall TForm1::AIPCServer1StringList(TObject *Sender,
      int FromHandle, AnsiString Service, TStrings *Strings)
{
  ShowMessage( Strings->Text );

}
//---------------------------------------------------------------------------

void __fastcall TForm1::AIPCServer1IPCBuffer(TObject *Sender,
      int FromHandle, PAIPCBuffer Data)
{
  AnsiString fmt = Data->DataFmt;
  AnsiString srv = Data->Service;

  if( fmt == "TStatusMsg"
  &&  srv == "ShowStatus" )
  {
    int i = GetItem((int)FromHandle);
    if( i >= 0 )
    {
      TStatusMsg *p = (TStatusMsg *) Data->Data;
      ListView1->Items->Item[i]->SubItems->Strings[2] = p->status;
      ListView1->Items->Item[i]->SubItems->Strings[3] =
        IntToStr( p->percent ) + "%";
    }
  }
 
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  UnRegisterClass(__classid(TTestObject));  
}
//---------------------------------------------------------------------------

