//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ClientUnit.h"
#include "csGlobals.cpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "AIPCUnit"
#pragma resource "*.dfm"
TClientForm *ClientForm;
//---------------------------------------------------------------------------
__fastcall TClientForm::TClientForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------


void __fastcall TClientForm::CheckControls(void)
{

	cbConnected->Checked = AIPCClient1->Connected;
	cbLoggedIn->Checked = AIPCClient1->LoggedIn;
	btnSendStatus->Enabled = AIPCClient1->LoggedIn;
	btnSendMemo->Enabled = AIPCClient1->LoggedIn;
	btnSendKinds->Enabled = AIPCClient1->LoggedIn;
	btnSendTestObject->Enabled = AIPCClient1->LoggedIn;
	tbPercent->Enabled = AIPCClient1->LoggedIn;
	btnLogInOut->Enabled = AIPCClient1->Connected;
	if( AIPCClient1->LoggedIn )
		btnLogInOut->Caption = "Logout";
	else
		btnLogInOut->Caption = "Login";

}
void __fastcall TClientForm::FormCreate(TObject *Sender)
{
  CheckControls();  
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::edtNameChange(TObject *Sender)
{
  AIPCClient1->ClientName = edtName->Text;
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::comboKindChange(TObject *Sender)
{
  AIPCClient1->Kind = comboKind->Text;
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::tbPercentChange(TObject *Sender)
{
  TStatusMsg sts;

  strncpy( sts.status, comboStatus->Text.c_str(),31 );
  sts.percent = tbPercent->Position;
  AIPCClient1->SendIPCMessage( AIPCClient1->ServerHandle,
    &sts, sizeof(TStatusMsg), "ShowStatus", "TStatusMsg" );
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::cbActiveClick(TObject *Sender)
{
	AIPCClient1->Active = cbActive->Checked;
	if (AIPCClient1->Active)
		AIPCClient1->CheckConnection();
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::btnLogInOutClick(TObject *Sender)
{
	if( AIPCClient1->LoggedIn )
		AIPCClient1->LogOut();
	else
		AIPCClient1->LogIn("ABC");

}
//---------------------------------------------------------------------------

void __fastcall TClientForm::btnSendStatusClick(TObject *Sender)
{
  TStatusMsg sts;

  strncpy( sts.status, comboStatus->Text.c_str(),31 );
  sts.percent = tbPercent->Position;
  AIPCClient1->SendIPCMessage( AIPCClient1->ServerHandle,
    &sts, sizeof(TStatusMsg), "ShowStatus", "TStatusMsg" );
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::btnSendMemoClick(TObject *Sender)
{
	AIPCClient1->SendIPCMessage(AIPCClient1->ServerHandle,
		Memo1->Lines->Text);

}
//---------------------------------------------------------------------------

void __fastcall TClientForm::btnSendKindsClick(TObject *Sender)
{
	AIPCClient1->SendIPCMessage(AIPCClient1->ServerHandle,
		comboKind->Items);
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::btnSendTestObjectClick(TObject *Sender)
{
	TTestObject *tobj = new TTestObject();
	try
	{
  	tobj->i = 9876;
		tobj->d = 543.21;
		tobj->s = "Client Object";
		AIPCClient1->SendIPCMessage(AIPCClient1->ServerHandle,(TComponent *) tobj);
  }
  __finally
	{
  	delete tobj;
	}
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1ActiveChanged(TObject *Sender)
{
	Memo1->Lines->Add("Active changed to " +
		IntToStr( Integer(AIPCClient1->Active) ) );
	CheckControls();

}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1LogInAccepted(TObject *Sender)
{
	Memo1->Lines->Add("Login accepted");
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1LogInRefused(TObject *Sender)
{
	Memo1->Lines->Add("Login refused");
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1SendTimeOut(TObject *Sender)
{
	Memo1->Lines->Add("TimeOut !");
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1ServerAvailable(TObject *Sender)
{
	Memo1->Lines->Add("Server available");
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1ServerNotAvailable(TObject *Sender)
{
	Memo1->Lines->Add("Server not available");
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1ServerShutDown(TObject *Sender)
{
	Memo1->Lines->Add("Server has shut down");
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1ServerStartUp(TObject *Sender)
{
  Memo1->Lines->Add("Server coming up");
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1StringList(TObject *Sender,
      int FromHandle, AnsiString Service, TStrings *Strings)
{
	Memo1->Lines->Add(Strings->Text);
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1TextMessage(TObject *Sender,
      int FromHandle, AnsiString Service, AnsiString Msg)
{
	Memo1->Lines->Add(Msg);
	CheckControls();
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1IPCBuffer(TObject *Sender,
      int FromHandle, PAIPCBuffer Data)
{
	TTestBuffer *pb;

	pb = (TTestBuffer *)Data->Data;
	Memo1->Lines->Add( "Integer: " + IntToStr(pb->i) );
	Memo1->Lines->Add( "Float: " + FloatToStr(pb->d) );
	Memo1->Lines->Add( "String: " + AnsiString(pb->s) );
}
//---------------------------------------------------------------------------

void __fastcall TClientForm::AIPCClient1Unlinked(TObject *Sender)
{
	Memo1->Lines->Add("Server has unlinked the login");
	CheckControls();
}
//---------------------------------------------------------------------------

