// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'AIPCUnit.pas' rev: 6.00

#ifndef AIPCUnitHPP
#define AIPCUnitHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Contnrs.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Aipcunit
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TLastResult { lrAccepted, lrRefused, lrNotAvailable, lrNotActive, lrResponse, lrTwice };
#pragma option pop

#pragma option push -b-
enum TSendTimeOutFlag { toNormal, toBlock, toAbortIfHung, toInfinite };
#pragma option pop

#pragma pack(push, 4)
struct TAIPCBuffer
{
	System::SmallString<32>  Service;
	System::SmallString<32>  DataFmt;
	int DataLen;
	char Data[32768];
} ;
#pragma pack(pop)

typedef TAIPCBuffer *PAIPCBuffer;

typedef void __fastcall (__closure *TOnIPCBuffer)(System::TObject* Sender, int FromHandle, PAIPCBuffer Data);

typedef void __fastcall (__closure *TOnStringList)(System::TObject* Sender, int FromHandle, AnsiString Service, Classes::TStrings* Strings);

typedef void __fastcall (__closure *TOnTextMessage)(System::TObject* Sender, int FromHandle, AnsiString Service, AnsiString Msg);

typedef void __fastcall (__closure *TOnComponent)(System::TObject* Sender, int FromHandle, AnsiString Service, Classes::TComponent* Component, bool &CanDelete);

typedef void __fastcall (__closure *TOnComponentError)(System::TObject* Sender, int FromHandle, AnsiString Service, AnsiString ClassName, AnsiString Component, Sysutils::Exception* E);

typedef void __fastcall (__closure *TOnShortMessage)(System::TObject* Sender, unsigned Msg);

typedef void __fastcall (__closure *TExceptionEvent)(System::TObject* Sender, int ClientHandle, Sysutils::Exception* E);

class DELPHICLASS TAIPCBase;
class PASCALIMPLEMENTATION TAIPCBase : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	int FHandle;
	AnsiString FSessionName;
	int FSessionHandle;
	AnsiString FService;
	bool FInternalService;
	unsigned FConnectRequestMsg;
	unsigned FConnectResponseMsg;
	unsigned FLoginAcceptMsg;
	unsigned FLoginRefuseMsg;
	unsigned FRequestRefuseMsg;
	unsigned FLogOutMsg;
	unsigned FShutDownMsg;
	unsigned FStartUpMsg;
	int FSendResult;
	bool FActive;
	Classes::TNotifyEvent FOnActiveChanged;
	TOnIPCBuffer FOnIPCBuffer;
	TOnStringList FOnStringList;
	TOnTextMessage FOnTextMessage;
	TOnComponent FOnComponent;
	TOnComponentError FOnComponentError;
	TExceptionEvent FOnException;
	Classes::TNotifyEvent FOnSendTimeOut;
	TAIPCBuffer FIPCBuffer;
	Classes::TNotifyEvent FOnAfterSend;
	Classes::TNotifyEvent FOnRequestRefused;
	int FTimeOut;
	TSendTimeOutFlag FTimeOutFlag;
	TOnShortMessage FOnShortMessage;
	
protected:
	TLastResult FLastResult;
	virtual void __fastcall WndProc(Messages::TMessage &AMsg);
	virtual void __fastcall SetActive(const bool Value);
	void __fastcall DoException(Sysutils::Exception* E);
	void __fastcall SendIPCBuffer(int ToHandle, PAIPCBuffer Buffer);
	void __fastcall InternalSendWindowMessage(int ToHandle, unsigned Msg, int WParam, int LParam);
	
public:
	__property int SendResult = {read=FSendResult, nodefault};
	__property TAIPCBuffer IPCBuffer = {read=FIPCBuffer};
	__property int Handle = {read=FHandle, nodefault};
	__fastcall virtual TAIPCBase(Classes::TComponent* AOwner);
	__fastcall virtual ~TAIPCBase(void);
	void __fastcall SendIPCMessage(int ToHandle, void * Buffer, Word Length, AnsiString MsgService, AnsiString Format)/* overload */;
	void __fastcall SendIPCMessage(int ToHandle, unsigned Msg)/* overload */;
	void __fastcall SendIPCMessage(int ToHandle, AnsiString Text)/* overload */;
	void __fastcall SendIPCMessage(int ToHandle, Classes::TStrings* Strings)/* overload */;
	void __fastcall SendIPCMessage(int ToHandle, const AnsiString * Strings, const int Strings_Size)/* overload */;
	void __fastcall SendIPCMessage(int ToHandle, Classes::TComponent* Component)/* overload */;
	AnsiString __fastcall ComponentToString(Classes::TComponent* Component);
	Classes::TComponent* __fastcall StringToComponent(AnsiString Value, Classes::TComponent* Instance);
	void __fastcall RefuseRequest(int ToHandle);
	
__published:
	__property int TimeOut = {read=FTimeOut, write=FTimeOut, nodefault};
	__property TSendTimeOutFlag TimeOutFlag = {read=FTimeOutFlag, write=FTimeOutFlag, nodefault};
	__property AnsiString Service = {read=FService, write=FService};
	__property AnsiString SessionName = {read=FSessionName, write=FSessionName};
	__property bool Active = {read=FActive, write=SetActive, nodefault};
	__property Classes::TNotifyEvent OnActiveChanged = {read=FOnActiveChanged, write=FOnActiveChanged};
	__property TOnStringList OnStringList = {read=FOnStringList, write=FOnStringList};
	__property TOnTextMessage OnTextMessage = {read=FOnTextMessage, write=FOnTextMessage};
	__property TOnShortMessage OnShortMessage = {read=FOnShortMessage, write=FOnShortMessage};
	__property TOnIPCBuffer OnIPCBuffer = {read=FOnIPCBuffer, write=FOnIPCBuffer};
	__property TOnComponent OnComponent = {read=FOnComponent, write=FOnComponent};
	__property TOnComponentError OnComponentError = {read=FOnComponentError, write=FOnComponentError};
	__property TExceptionEvent OnException = {read=FOnException, write=FOnException};
	__property Classes::TNotifyEvent OnSendTimeOut = {read=FOnSendTimeOut, write=FOnSendTimeOut};
	__property Classes::TNotifyEvent OnAfterSend = {read=FOnAfterSend, write=FOnAfterSend};
	__property Classes::TNotifyEvent OnRequestRefused = {read=FOnRequestRefused, write=FOnRequestRefused};
};


class DELPHICLASS TAIPCClient;
class PASCALIMPLEMENTATION TAIPCClient : public TAIPCBase 
{
	typedef TAIPCBase inherited;
	
private:
	AnsiString FClientName;
	int FServerHandle;
	Classes::TNotifyEvent FOnServerStartUp;
	Classes::TNotifyEvent FOnServerShutDown;
	Classes::TNotifyEvent FOnServerAvailable;
	bool FLoggedIn;
	Classes::TNotifyEvent FOnLoginAccepted;
	Classes::TNotifyEvent FOnLogInRefused;
	AnsiString FKind;
	Classes::TNotifyEvent FOnServerNotAvailable;
	Classes::TNotifyEvent FOnUnlinked;
	bool __fastcall GetConnected(void);
	
protected:
	virtual void __fastcall WndProc(Messages::TMessage &AMsg);
	virtual void __fastcall SetActive(const bool Value);
	
public:
	__property bool Connected = {read=GetConnected, nodefault};
	__property int ServerHandle = {read=FServerHandle, nodefault};
	__fastcall virtual TAIPCClient(Classes::TComponent* AOwner);
	__fastcall virtual ~TAIPCClient(void);
	TLastResult __fastcall LogIn(AnsiString Password = "", int msWait = 0x0);
	void __fastcall LogOut(void);
	bool __fastcall CheckConnection(int msWait = 0x0);
	
__published:
	__property AnsiString Kind = {read=FKind, write=FKind};
	__property bool LoggedIn = {read=FLoggedIn, nodefault};
	__property AnsiString ClientName = {read=FClientName, write=FClientName};
	__property Classes::TNotifyEvent OnServerStartUp = {read=FOnServerStartUp, write=FOnServerStartUp};
	__property Classes::TNotifyEvent OnServerShutDown = {read=FOnServerShutDown, write=FOnServerShutDown};
	__property Classes::TNotifyEvent OnServerAvailable = {read=FOnServerAvailable, write=FOnServerAvailable};
	__property Classes::TNotifyEvent OnServerNotAvailable = {read=FOnServerNotAvailable, write=FOnServerNotAvailable};
	__property Classes::TNotifyEvent OnLogInAccepted = {read=FOnLoginAccepted, write=FOnLoginAccepted};
	__property Classes::TNotifyEvent OnLogInRefused = {read=FOnLogInRefused, write=FOnLogInRefused};
	__property Classes::TNotifyEvent OnUnlinked = {read=FOnUnlinked, write=FOnUnlinked};
};


class DELPHICLASS TAIPCClientItem;
class PASCALIMPLEMENTATION TAIPCClientItem : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	AnsiString Name;
	AnsiString Password;
	AnsiString Kind;
	unsigned Handle;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TAIPCClientItem(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TAIPCClientItem(void) { }
	#pragma option pop
	
};


typedef void __fastcall (__closure *TOnClientLogIn)(System::TObject* Sender, TAIPCClientItem* Client, bool &Accept);

typedef void __fastcall (__closure *TOnClientLogOut)(System::TObject* Sender, TAIPCClientItem* Client);

class DELPHICLASS TAIPCServer;
class PASCALIMPLEMENTATION TAIPCServer : public TAIPCBase 
{
	typedef TAIPCBase inherited;
	
private:
	TOnClientLogIn FOnClientLogIn;
	TOnClientLogOut FOnClientLogOut;
	Contnrs::TObjectList* FClientList;
	bool FAlwDup;
	AnsiString __fastcall GetClientName(unsigned Handle);
	int __fastcall GetClientIndex(unsigned Handle)/* overload */;
	int __fastcall GetClientIndex(AnsiString Name)/* overload */;
	bool __fastcall GetConnected(void);
	
protected:
	virtual void __fastcall WndProc(Messages::TMessage &AMsg);
	virtual void __fastcall SetActive(const bool Value);
	virtual void __fastcall Loaded(void);
	
public:
	__property Contnrs::TObjectList* ClientList = {read=FClientList};
	__property bool Connected = {read=GetConnected, nodefault};
	__fastcall virtual TAIPCServer(Classes::TComponent* AOwner);
	__fastcall virtual ~TAIPCServer(void);
	bool __fastcall UnlinkClient(int Handle);
	
__published:
	__property bool AllowDuplicateNames = {read=FAlwDup, write=FAlwDup, nodefault};
	__property TOnClientLogIn OnClientLogIn = {read=FOnClientLogIn, write=FOnClientLogIn};
	__property TOnClientLogOut OnClientLogOut = {read=FOnClientLogOut, write=FOnClientLogOut};
};


//-- var, const, procedure ---------------------------------------------------
#define MAIPCConnectRequest "AIPCConnectRequest"
#define MAIPCConnectResponse "AIPCConnectResponse"
#define MAIPCLoginAccept "AIPCLogInAccept"
#define MAIPCLogInRefuse "AIPCLogInRefuse"
#define MAIPCRequestRefuse "AIPCRequestRefused"
#define MAIPCLogOut "AIPCLogOut"
#define MAIPCShutDown "AIPCShutDown"
#define MAIPCStartUp "AIPCStartUp"
#define FMTBuffer "*Buffer"
#define FMTStrings "*Strings"
#define FMTSimpleText "*SimpleText"
#define FMTComponent "*Component"
#define SAIPCLogIn "*AIPCLogIn"
static const Word MaxAIPCDATASize = 0x7fff;
extern PACKAGE void __fastcall Register(void);

}	/* namespace Aipcunit */
using namespace Aipcunit;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// AIPCUnit
