unit UMain;

interface    

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, XLGrids, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    Edit1: TMenuItem;
    OpenEditor2: TMenuItem;
    XLGrid: TXLGrid;
    A51: TMenuItem;
    Close1: TMenuItem;
    XLStyler: TXLStyler;
    Sheet: TXLSheet;
    procedure Edit1Click(Sender: TObject);
    procedure XLGridRowDblClick(Sender: TObject; ACoord: TPoint);
    procedure XLGridColDblClick(Sender: TObject; ACoord: TPoint);
    procedure Close1Click(Sender: TObject);
    procedure Styler1Click(Sender: TObject);
    procedure Remove1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses XLSheet, XLStyler;

{$R *.DFM}

procedure TForm1.Edit1Click(Sender: TObject);
begin
  OpenXLSheetDesigner(XLGrid.Sheet);
end;

procedure TForm1.XLGridRowDblClick(Sender: TObject; ACoord: TPoint);
begin
  Sheet.RowHeights[ACoord.Y] := 20;
end;

procedure TForm1.XLGridColDblClick(Sender: TObject; ACoord: TPoint);
begin
  Sheet.ColWidths [ACoord.X] := 100;
end;

procedure TForm1.Close1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Styler1Click(Sender: TObject);
begin
  OpenXLStylerDesigner(XLStyler);
end;

procedure TForm1.Remove1Click(Sender: TObject);
begin
  Sheet.Free;
end;

end.
 