unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, webpageimage, StdCtrls, OleCtrls, SHDocVw_TLB, Spin, Buttons,
  ExtDlgs;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    ProportionalChk: TCheckBox;
    TimedUpdateChk: TCheckBox;
    SpinEdit1: TSpinEdit;
    WebPageView: TRadioGroup;
    BitBtn1: TBitBtn;
    SpinEdit2: TSpinEdit;
    SpinEdit3: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    SaveBtn: TBitBtn;
    SavePictureDialog1: TSavePictureDialog;
    BitBtn2: TBitBtn;
    Label3: TLabel;
    WebPageImage1: TWebPageImage;
    procedure wvNormalClick(Sender: TObject);
    procedure WebPageViewClick(Sender: TObject);
    procedure ProportionalChkClick(Sender: TObject);
    procedure TimedUpdateChkClick(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure WebPageImage1WebImageReady(Sender: TObject; url: String);
    procedure BitBtn1Click(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.wvNormalClick(Sender: TObject);
begin
  WebPageImage1.url := edit1.text;
end;

procedure TForm1.WebPageViewClick(Sender: TObject);
begin
  WebPageImage1.WebPageView := TWebPageView(WebPageView.Itemindex);
end;

procedure TForm1.ProportionalChkClick(Sender: TObject);
begin
  WebPageImage1.Proportional := ProportionalChk.checked;
end;

procedure TForm1.TimedUpdateChkClick(Sender: TObject);
begin
  WebPageImage1.TimedUpdate := TimedUpdateChk.checked;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  WebPageImage1.TimerInterval := SpinEdit1.value;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  WebPageView.Itemindex := integer(WebPageImage1.WebPageView);
  ProportionalChk.checked := WebPageImage1.Proportional;
  TimedUpdateChk.checked := WebPageImage1.TimedUpdate;
  if WebPageImage1.TimerInterval > 0 then
    SpinEdit1.value := WebPageImage1.TimerInterval;
end;

procedure TForm1.WebPageImage1WebImageReady(Sender: TObject; url: String);
var
 s : string;
begin

  MessageBeep(0);
  s := url;
  SpinEdit2.value := WebPageImage1.ViewWidth;
  SpinEdit3.value := WebPageImage1.ViewHeight;
  if WebPageImage1.TimedUpdate then
    exit;
  ShowMessage(url+ ' image is ready!');
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  WebPageImage1.url := edit1.text;
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
begin
  WebPageImage1.ViewWidth := SpinEdit2.value;
end;

procedure TForm1.SaveBtnClick(Sender: TObject);
begin
  if SavePictureDialog1.Execute then
  begin
    WebPageImage1.SaveToFile(SavePictureDialog1.Filename, -1, -1);
  end;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  if SavePictureDialog1.Execute then
  begin
    WebPageImage1.SaveToFile(SavePictureDialog1.Filename, 640, 480);
  end;
end;

procedure TForm1.SpinEdit3Change(Sender: TObject);
begin
  WebPageImage1.ViewHeight := SpinEdit3.value;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  WebPageImage1.width := WebPageImage1.width*2;
  WebPageImage1.height := WebPageImage1.height*2;
end;

end.
