unit USA1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, TeeProcs, TeeTree, StdCtrls, Buttons, ComCtrls;

type
  TForm1 = class(TForm)
    Tree1: TTree;
    Panel1: TPanel;
    Button1: TButton;
    ListBox1: TListBox;
    Panel2: TPanel;
    Button2: TButton;
    Label1: TLabel;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Label3: TLabel;
    TrackBar1: TTrackBar;
    CheckBox1: TCheckBox;
    CheckBox4: TCheckBox;
    Label2: TLabel;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    StatusBar1: TStatusBar;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Tree1ClickShape(Sender: TTreeNodeShape; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure Tree1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button2Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Tree1StartEditing(Shape: TTreeNodeShape;
      Var AllowEditing: Boolean);
    procedure Tree1StopEditing(Sender: TTreeNodeShape);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
  private
    { Private declarations }
    IndexEdit:Integer;
    Procedure AddRemoveMiles;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
uses TreeEd,TeCanvas;

procedure TForm1.FormCreate(Sender: TObject);


  Procedure LoadUSAMap;
  var f   : TextFile;
      s2,
      st  : String;
      p   : TTreeNodeShape;
      i   : Integer;
      Num : Integer;
  begin
    { Open file }
    if not FileExists('TreeUSA.txt') then
       raise Exception.Create('Cannot find file: TreeUSA.TXT'+#13+
                              'Copy it to the same executable folder and restart.');

    AssignFile(f,'TreeUSA.txt');
    reset(f);
    while not eof(f) do
    begin
      { Load each line of text and process... }
      ReadLn(f,st);

      { Extract the shape Text... }
      i:=Pos(',',St);
      s2:=Copy(St,1,i-1);
      Delete(St,1,i);

      { Create a shape with the previous Text... }
      p:= Tree1.AddRoot(s2);

      { Customize shape... }
      with p do
      begin
        ImageIndex:=tiNone;
        Transparent:=True;

       { Extract each line of text... }

        { X }
        i:=Pos(',',St);
        x0:=(125000+StrToInt(Copy(st,1,i-1)));
        Delete(St,1,i);

        { Y }
        i:=Pos(',',St);
        y0:=(50000+StrToInt(Copy(st,1,i-1)));
        Delete(St,1,i);

        { Number of Inhabitants }
        i:=Pos(',',St);
        Num:=StrToInt(Copy(st,1,i-1));
        Delete(St,1,i);
        Font.Size:=StrToInt(St);

       { Remove Border }
        Border.Visible:=False;

       { Change the Font color depending on size... }
        if Font.Size<8 then Font.Color:=clSilver else
        if Font.Size<12 then Font.Color:=clGray else
        if Font.Size>=26 then
        begin
          Font.Color:=clNavy;
          Brush.Color:=clAqua;
          Transparent:=False;
          Border.Visible:=True;
        end
        else
        if Font.Size>20 then Font.Color:=clNavy;
        if Random(100)<2 then Font.Color:=clLime;

        { Set the shape Tag as Number of Inhabitants }
        Tag:=Num;
      end;

      { Add cities with more than 100000 inhabitants
        to the left ListBox1 }
      if Num>100000 then ListBox1.Items.Add(s2);
    end;
    Closefile(f);
end;

begin
  { Allow navigating shapes with arrow keys
    with "go to nearest" algorithm }
  Tree1.Navigation:=tnNearest;

  { This is to speed up creating many shapes... }
  Tree1.NoOwnerShapes:=True;
  Tree1.AssignParent:=False;

  { Fill the USA cities... }
  LoadUSAMap;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  EditTree(Self,Tree1)
end;

procedure TForm1.Tree1ClickShape(Sender: TTreeNodeShape;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if CheckBox1.Checked then Tree1.CenterInView(Sender,True);
end;

procedure TForm1.FormShow(Sender: TObject);
var S:String;
begin
  TrackBar1.Position:=130;
  Tree1.View3DOptions.Zoom:=130;

  { go to Inprise... }
  With ListBox1 do
  begin
    S:='Scotts Valley';
    Items.Add(S);
    ItemIndex:=Items.IndexOf(S);
  end;
  ListBox1Click(Self);
end;

procedure TForm1.Tree1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  Tree1.Canvas.Calculate2DPosition(x,y,0);
  Label2.Caption:=IntToStr(x)+' '+IntToStr(y);
end;

{ Calculate fake routes... }
procedure TForm1.Button2Click(Sender: TObject);
var t,tt:Integer;
    dif,mindif,difx,dify:Double;
    res:Integer;
    tmp:TForm;
    tmpTrack:TProgressBar;
begin
  StatusBar1.SimpleText:='Calculating random links between USA cities...';
  CheckBox2.Enabled:=True;
  CheckBox5.Enabled:=True;

  Screen.Cursor:=crHourGlass;
  tmp:=TForm.Create(nil);
  tmp.Visible:=True;
  tmp.Caption:='Calculating routes...';
  tmpTrack:=TProgressBar.Create(tmp);
  tmpTrack.Parent:=tmp;
  tmpTrack.SetBounds(10,30,tmp.Width-30,33);
  tmp.BorderStyle:=bsDialog;
  tmpTrack.Min:=0;
  tmpTrack.Max:=Tree1.Shapes.Count-1;
  tmp.Show;
  Application.ProcessMessages;

  Tree1.Connections.Clear;

  With Tree1.Shapes do
  for t:=0 to Count-1 do
  begin
    tmpTrack.Position:=t;
    mindif:=MaxLongint;
    res:=-1;
    for tt:=t+1 to Count-1 do
    begin
      if (t<>tt) and (Items[tt].Connections.ToShape(Items[t])=nil) then
      begin
        difx:=Items[t].x0-Items[tt].x0;
        dify:=Items[t].y0-Items[tt].y0;
        dif:=sqrt(sqr(difx)+sqr(dify));
        if dif<mindif then
        begin
          mindif:=dif;
          res:=tt;
        end;
      end;
    end;
    if res<>-1 then
    With Items[t].AddConnection(Items[res]) do
    begin
      Style:=csLine;
      ArrowTo.Style:=casCircle;
      Tag:=Round(MinDif);
      if Random(100)<3 then Border.Color:=clBlue
      else
      if Random(100)<3 then Border.Color:=clRed;
    end;
  end;
  tmpTrack.Free;
  tmp.Free;

  AddRemoveMiles;

  StatusBar1.SimpleText:='';
  Screen.Cursor:=crDefault;
end;

Procedure TForm1.AddRemoveMiles;
var t:Integer;
    P0,P1:TPoint;
    DifX,DifY,L:Integer;
begin
  With Tree1 do
  for t:=0 to Connections.Count-1 do
  With Connections[t] do
  begin
    Text.Clear;
    if CheckBox2.Checked then
    begin
      FromShape.GetConnectionPos(ToShape,P0.X,P0.Y);
      ToShape.GetConnectionPos(FromShape,P1.X,P1.Y);
      DifX:=Abs(P0.X-P1.X);
      DifY:=Abs(P0.Y-P1.Y);
      if (DifX>30000) or (DifY>30000) then
         L:=0
      else
         L:=Round(Sqrt(Sqr(DifX)+Sqr(DifY)));
      Text.Add(FormatFloat('#,##0',L));
    end;
  end;
end;

procedure TForm1.ListBox1Click(Sender: TObject);
var s:String;
    t:Integer;
begin
  s:=ListBox1.Items[ListBox1.ItemIndex];
  if s<>'' then
  With Tree1 do
  for t:=0 to Shapes.Count-1 do
  if Shapes[t].Text[0]=s then   { locate the shape "s" }
  begin
    { force recalculation of node positions... }
    Draw(Canvas.ReferenceCanvas,GetRectangle);

    { now we can redraw to center the shape... }
    CenterInView(Shapes[t],False);

    { set the shape selected... }
    Selected.Clear;
    Shapes[t].Selected:=True;
    break;
  end;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  AddRemoveMiles;
end;

procedure TForm1.Tree1StartEditing(Shape: TTreeNodeShape;
  Var AllowEditing: Boolean);
begin
  Tree1.InternalMemo.Font.Color:=clBlue;
  AllowEditing:=CheckBox3.Checked;
  IndexEdit:=ListBox1.Items.IndexOf(Shape.Text[0]);
end;

procedure TForm1.Tree1StopEditing(Sender: TTreeNodeShape);
begin
  if IndexEdit<>-1 then ListBox1.Items[IndexEdit]:=Sender.Text[0];
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
var t:Integer;
    S:String;
begin
  S:='Tupelo';
  if InputQuery('Enter City or Village name:','Name?',S) then
  begin
    s:=UpperCase(s);
    With Tree1 do
    for t:=0 to Shapes.Count-1 do
    if UpperCase(Shapes[t].Text[0])=S then
    begin
      CenterInView(Shapes[t],False);
      { set the shape selected... }
      Selected.Clear;
      Shapes[t].Selected:=True;
      exit;
    end;
    ShowMessage('Sorry: '+S+' cannot be found.');
  end;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Shapes.Count-1 do
      With Shapes[t].Font do Size:=Size+1;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Shapes.Count-1 do
      With Shapes[t].Font do
           if Size>1 then Size:=Size-1;
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  Tree1.Gradient.Visible:=CheckBox4.Checked;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  Tree1.ZoomCentered(TrackBar1.Position);
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Connections.Count-1 do
      With Connections[t] do
           if CheckBox5.Checked then Style:=csSides
                                else Style:=csLine;
end;

procedure TForm1.CheckBox6Click(Sender: TObject);
begin
  Tree1.BufferedDisplay:=CheckBox6.Checked;
end;

end.
