unit TreeQRDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TeeProcs, TeeTree, TreeQR, Db, DBTables, quickrpt, Qrctrls, ExtCtrls,
  TeeDBTre, StdCtrls;

type
  TForm1 = class(TForm)
    QuickRep1: TQuickRep;
    TitleBand1: TQRBand;
    DetailBand1: TQRBand;
    QRDBText1: TQRDBText;
    Table1: TTable;
    DataSource1: TDataSource;
    Table2: TTable;
    QuickReportTree1: TQuickReportTree;
    QRTree1: TQRTree;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    QRLabel1: TQRLabel;
    Table3: TTable;
    procedure QRTree1Print(Sender: TQRTree; var PaperRect,
      TreeRect: TRect);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure QuickReportTree1NewShape(Sender: TCustomTreePanel;
      NewShape: TTreeNodeShape);
    procedure FormCreate(Sender: TObject);
  private
{ Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
Uses QRAbout,TreeEd;

procedure TForm1.QRTree1Print(Sender: TQRTree; var PaperRect,
  TreeRect: TRect);
var t:Integer;
begin
  Sender.Tree.Refresh;
  With Sender.Tree[0] do
  begin
    Text[0]:='Orders';
    for t:=0 to Childs.Count-1 do
    With Childs[t] do
      if Table3.FindKey([StrToInt(Text[0])]) then
         Text[0]:=Text[0]+' '+Table3.FieldByName('LastName').AsString;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  QuickRep1.Preview;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  TeeShowTreeAbout(True);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  With TQRAboutBox.Create(Self) do
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TForm1.QuickReportTree1NewShape(Sender: TCustomTreePanel;
  NewShape: TTreeNodeShape);
var tmp:TColor;
begin

  { random font color }
  Case Random(5) of
    0: tmp:=clRed;
    1: tmp:=clGreen;
    2: tmp:=clMaroon;
    3: tmp:=clAqua;
  else
    tmp:=clBlue;
  end;
  NewShape.Font.Color:=tmp;
  NewShape.Font.Size:=7;

  { random image }
  Case Random(5) of
    0: NewShape.ImageIndex:=tiFolderOpenClose;
    1: NewShape.ImageIndex:=tiMyPc;
    2: NewShape.ImageIndex:=tiDesktop;
    3: NewShape.ImageIndex:=tiWorld;
  else
    NewShape.ImageIndex:=tiComputer;
  end;

  { blue lines }
  if not Assigned(NewShape.Parent) then
     NewShape.ShowCross:=scNever
  else
     NewShape.Parent.Connections.ToShape(NewShape).Border.Color:=clBlue;

  if Random(10)=2 then
  With NewShape do
  begin
    Style:=tssCircle;
    Font.Color:=clWhite;
    if Random(10)<5 then Brush.Color:=clRed
                    else Brush.Color:=clBlue;
    Transparent:=False;
  end;

  NewShape.Expanded:=True;
  NewShape.Border.Visible:=False;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
{ see ObjectInspector:  QRTree1.MultiLineText:=False;}
  QRTree1.Tree.AssignParent:=False;
end;

end.
