unit UTreeGL;

interface

{ This example shows how to use OpenGL 3D rendering with a
  TeeTree component.
}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TeeTree, TeeOpenGL, TeeComma, ExtCtrls, TeeProcs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Tree1: TTree;
    TeeCommander1: TTeeCommander;
    TeeOpenGL1: TTeeOpenGL;
    TreeNodeShape1: TTreeNodeShape;
    TreeNodeShape2: TTreeNodeShape;
    TreeNodeShape3: TTreeNodeShape;
    TreeNodeShape4: TTreeNodeShape;
    TreeNodeShape5: TTreeNodeShape;
    TreeNodeShape6: TTreeNodeShape;
    TreeNodeShape7: TTreeNodeShape;
    TreeNodeShape8: TTreeNodeShape;
    TreeNodeShape9: TTreeNodeShape;
    Timer1: TTimer;
    TreeNodeShape1_TreeNodeShape2: TTreeConnection;
    TreeNodeShape2_TreeNodeShape3: TTreeConnection;
    TreeNodeShape4_TreeNodeShape5: TTreeConnection;
    TreeNodeShape5_TreeNodeShape6: TTreeConnection;
    TreeNodeShape6_TreeNodeShape7: TTreeConnection;
    TreeNodeShape7_TreeNodeShape8: TTreeConnection;
    TreeNodeShape2_TreeNodeShape4: TTreeConnection;
    Panel1: TPanel;
    Button1: TButton;
    Label1: TLabel;
    TrackBar1: TTrackBar;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Tree1AfterDraw(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Delta:Integer;
    DemoMaxZoom:Integer;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Uses GLCanvas,  { <-- High level OpenGL canvas }
     OpenGL2;   { <-- Low level OpenGL API }

procedure TForm1.FormCreate(Sender: TObject);
var t:Integer;
begin
 { Start OpenGL... }
 TeeOpenGL1.Active:=True;

 { Make default toolbar button: Rotation }
 TeeCommander1.ButtonRotate.Down:=True;
 TeeCommander1.ButtonRotate.Click;

 Tree1.AllowZoom:=False;
 Tree1.Selected.ScrollToView:=False;

 { Init 3D parameters... }
 With Tree1.View3DOptions do
 begin
   HorizOffset:=150;
   VertOffset:=50;
   Rotation:=45;
   Elevation:=326;
   DemoMaxZoom:=200;
   Zoom:=DemoMaxZoom;
   Orthogonal:=False;
 end;

 { Fill the Tree nodes... }
 With TreeNodeShape9 do
 begin
   Text[0]:='World';
   Selected:=True;
   With AddChild('Africa') do
        AddChild('South Africa');
   With AddChild('America') do
   begin
     With AddChild('North') do
     begin
       AddChild('Canada');
       AddChild('USA');
     end;
     AddChild('Argentina');
     AddChild('Brazil');
     AddChild('Mexico');
     AddChild('Panama');
   end;
   With AddChild('Asia') do
   begin
     AddChild('China');
     AddChild('India');
     AddChild('Japan');
   end;
   With AddChild('Europe') do
   begin
     AddChild('France');
     AddChild('Norway');
     AddChild('Spain');
     AddChild('UK');
   end;
 end;

 { Change all connection Arrows color... }
 With Tree1 do
 for t:=0 to Connections.Count-1 do
 With Connections[t].ArrowTo do
 begin
   Size:=6;
   if Random(10)<5 then Brush.Color:=clYellow
                   else Brush.Color:=clRed;
 end;

 { for our internal animation... }
 Delta:=1;
end;

{ Start / Stop animation... }
procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  Timer1.Enabled:=CheckBox1.Checked;
  TrackBar1.Enabled:=Timer1.Enabled;
end;

{ Rotate and Zoom the Tree randomly...
  Also randomly expand / collapse nodes...
}
procedure TForm1.Timer1Timer(Sender: TObject);
var t:Integer;
begin
  With Tree1.View3DOptions do
  begin
    { rotation }
    Rotation:=Rotation+5;
    if Rotation>359 then Rotation:=0;

    { elevation }
    Elevation:=Elevation+1;
    if Elevation>359 then Elevation:=0;

    { zoom }
    Zoom:=Zoom-Delta;
    if (Zoom<25) or (Zoom>DemoMaxZoom) then Delta:=-Delta;

    { expand / collapse }
    if Random(10)=1 then
    begin
      t:=Random(TreeNodeShape9.Childs.Count);
      With TreeNodeShape9.Childs[t] do Expanded:=not Expanded;
    end;
  end;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  TeeOpenGL1.Light.Visible:=CheckBox2.Checked;
end;

{ Draw some spheres on top of Tree1 ... }
procedure TForm1.Tree1AfterDraw(Sender: TObject);
begin
  if Tree1.Canvas is TGLCanvas then
  With (Tree1.Canvas as TGLCanvas) do
  begin
    Pen.Style:=psClear;
    Brush.Color:=$00FDF0D0;
    Sphere(100,0,-100,100);
    glPushMatrix;
    glLoadIdentity;
    Brush.Color:=$000FABD2;
    Sphere(0,-100,-100,100);
    glPopMatrix;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Close;
end;

{ Change timer animation speed... }
procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  Timer1.Interval:=2*(101-TrackBar1.Position);
end;

end.
