{**********************************************}
{   TTree Component                            }
{   Copyright (c) 1998 by David Berneda        }
{**********************************************}
unit UTreeView;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, TeeProcs, TeeTree, ComCtrls;

type
  TFormTreeView = class(TForm)
    TreeView1: TTreeView;
    Tree1: TTree;
    Label1: TLabel;
    CBShowButtons: TCheckBox;
    CBShowLines: TCheckBox;
    CBShowRoot: TCheckBox;
    Shape1: TShape;
    BitBtn1: TBitBtn;
    Button1: TButton;
    CBGradient: TCheckBox;
    Label2: TLabel;
    Label3: TLabel;
    CBArrows: TCheckBox;
    CBImages: TCheckBox;
    CBTransparent: TCheckBox;
    Memo1: TMemo;
    Label4: TLabel;
    CBBorder: TCheckBox;
    CBCursor: TCheckBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CBReadOnly: TCheckBox;
    Bevel1: TBevel;
    Label5: TLabel;
    Edit2: TEdit;
    UpDown1: TUpDown;
    Label6: TLabel;
    CheckBox3: TCheckBox;
    Label7: TLabel;
    Button2: TButton;
    Edit3: TEdit;
    UpDown2: TUpDown;
    Label8: TLabel;
    Image1: TImage;
    ImageList1: TImageList;
    procedure Shape1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure CBShowRootClick(Sender: TObject);
    procedure CBShowLinesClick(Sender: TObject);
    procedure CBShowButtonsClick(Sender: TObject);
    procedure CBGradientClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CBArrowsClick(Sender: TObject);
    procedure CBImagesClick(Sender: TObject);
    procedure CBTransparentClick(Sender: TObject);
    procedure Tree1Scroll(Sender: TObject);
    procedure Label4Click(Sender: TObject);
    procedure Tree1SelectShape(Sender: TTreeNodeShape);
    procedure Tree1ExpandedCollapsed(Sender: TTreeNodeShape);
    procedure TreeView1Expanded(Sender: TObject; Node: TTreeNode);
    procedure TreeView1Collapsed(Sender: TObject; Node: TTreeNode);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure CBBorderClick(Sender: TObject);
    procedure CBCursorClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure Tree1ClickShape(Sender: TTreeNodeShape; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure CBReadOnlyClick(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
  private
    { Private declarations }
    Procedure ScrollTree;
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}
Uses TeeAbout, PenDlg, TreeEd, BrushDlg;

procedure TFormTreeView.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TFormTreeView.BitBtn1Click(Sender: TObject);
begin
  EditTree(Self,Tree1);  { <-- Show the Tree editor }
end;

{ Show or hide the TeeTree root, by scrolling the Tree }
Procedure TFormTreeView.ScrollTree;
var tmp:Integer;
begin
  tmp:=-4;
  if not CBShowRoot.Checked then tmp:=tmp-14;
  if CBImages.Checked then tmp:=tmp+18;
  Tree1.View3DOptions.HorizOffset:=tmp;
end;

procedure TFormTreeView.CBShowRootClick(Sender: TObject);
begin
  { Show / hide the TreeView root }
  TreeView1.ShowRoot:=CBShowRoot.Checked;

  { Show / hide the TeeTree root }
  ScrollTree;
end;

procedure TFormTreeView.CBShowLinesClick(Sender: TObject);
begin
  TreeView1.ShowLines:=CBShowLines.Checked;

  Tree1.Connections.Visible:=CBShowLines.Checked;
end;

procedure TFormTreeView.CBShowButtonsClick(Sender: TObject);
begin
  TreeView1.ShowButtons:=CBShowButtons.Checked;

  Tree1.CrossBox.Visible:=CBShowButtons.Checked;
end;

procedure TFormTreeView.CBGradientClick(Sender: TObject);
begin
  Tree1.Gradient.Visible:=CBGradient.Checked;
end;

{ This procedure copies all nodes in ATreeView onto a TeeTree }
Procedure FillTreeView( ATreeView:TTreeView; ATree:TTree);

  { add a TreeView node and all its childs... }
  Procedure AddTreeNode(AShape:TTreeNodeShape; ATreeNode:TTreeNode);
  var t:Integer;
  begin
    With ATreeNode do
    for t:=0 to Count-1 do
        AddTreeNode(AShape.AddChildObject(Item[t].Text,Item[t]),Item[t]);
  end;

var tmpRoot:TTreeNodeShape;
begin
  { first clear all shapes in TeeTree... }
  ATree.Clear;
  { if treeview has nodes... }
  if ATreeView.Items.Count>0 then
  begin
    { add a "root"... }
    tmpRoot:=ATree.AddRoot(ATreeView.Items[0].Text);
    with tmpRoot do
    begin
      Tag:=Longint(ATreeView.Items[0]);  { <-- associate TreeView nodes }

      { default formatting for shapes... }
      Transparent:=True;
      Border.Visible:=False;
      ImageIndex:=tiNone;
    end;
    { add all child nodes of root... }
    AddTreeNode(tmpRoot,ATreeView.Items[0]);
  end;
end;

procedure TFormTreeView.FormShow(Sender: TObject);
begin
  { add all nodes of TreeView1 to Tree1... }
  FillTreeView(TreeView1,Tree1);

  { make both trees to show full expanded... }
  TreeView1.FullExpand;
  Tree1.FullExpandCollapse(True);

  { Set the TeeTree root to Selected state... }
  Tree1.Roots[0].Selected:=True;

  { let's hide the TeeTree connections arrows... }
  CBArrows.Checked:=False;

  { set the appropiate horizontal scroll }
  ScrollTree;
end;

procedure TFormTreeView.FormCreate(Sender: TObject);
begin
  Shape1.Cursor:=crTeeHand;
  TreeLogoSetPicture(Image1.Picture);
end;

procedure TFormTreeView.Shape1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  With Shape1.Brush do
  begin
    Color:=EditColor(Self,Color);
    Tree1.Color:=Color;
    TreeView1.Color:=Color;
    FillTreeView(TreeView1,Tree1);
  end;
end;

procedure TFormTreeView.CBArrowsClick(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Connections.Count-1 do
  if CBArrows.Checked then
     Connections[t].ArrowTo.Style:=casSolid
  else
     Connections[t].ArrowTo.Style:=casNone;
end;

{ Show TeeTree images }
procedure TFormTreeView.CBImagesClick(Sender: TObject);
var t:Integer;
begin
  { TreeView }
  if CBImages.Checked then TreeView1.Images:=ImageList1
                      else TreeView1.Images:=nil;

  { TeeTree }
  for t:=0 to Tree1.Shapes.Count-1 do
  With Tree1.Shapes[t] do
  if CBImages.Checked then ImageIndex:=tiFolderOpenClose
                      else ImageIndex:=tiNone;

  { other way to hide images...
  Tree1.ShowImages:=CBImages.Checked;
  }

  ScrollTree;
end;

{ Set TeeTree nodes transparent }
procedure TFormTreeView.CBTransparentClick(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Shapes.Count-1 do
      Shapes[t].Transparent:=CBTransparent.Checked;
end;

procedure TFormTreeView.Tree1Scroll(Sender: TObject);
begin
  Tree1.StopEditing;
end;

{ Goto our web site }
procedure TFormTreeView.Label4Click(Sender: TObject);
begin
  GotoURL(Handle,'http://'+Label4.Caption);
end;

{ Select TreeView nodes when TeeTree nodes are selected }
procedure TFormTreeView.Tree1SelectShape(Sender: TTreeNodeShape);
begin
  TTreeNode(Sender.Tag).Selected:=True;
end;

{ When a TeeTree node is expanded / collapsed,
  expand or collapse the associated TreeView node }
procedure TFormTreeView.Tree1ExpandedCollapsed(Sender: TTreeNodeShape);
begin
  TTreeNode(Sender.Tag).Expanded:=Sender.Expanded;
end;

{ this function returns the TeeTree Shape
  correspondent to a TreeView "ANode" }
Function ShapeOfNode( ATree:TCustomTree; ANode:TTreeNode):TTreeNodeShape;
var t:Integer;
begin
  With ATree do
  for t:=0 to Shapes.Count-1 do
      if TTreeNode(Shapes[t].Tag)=ANode then
      begin
        result:=Shapes[t];
        exit;
      end;
  result:=nil;
end;

{ Expand TeeTree nodes when TreeView nodes are expanded }
procedure TFormTreeView.TreeView1Expanded(Sender: TObject;
  Node: TTreeNode);
var tmp:TTreeNodeShape;
begin
  tmp:=ShapeOfNode(Tree1, Node);
  if Assigned(tmp) then tmp.Expanded:=True;
end;

{ Collapse TeeTree nodes when TreeView nodes are collapsed }
procedure TFormTreeView.TreeView1Collapsed(Sender: TObject;
  Node: TTreeNode);
var tmp:TTreeNodeShape;
begin
  tmp:=ShapeOfNode(Tree1, Node);
  if Assigned(tmp) then tmp.Expanded:=False;
end;

{ Select TeeTree shapes when TreeView nodes are selected }
procedure TFormTreeView.TreeView1Change(Sender: TObject; Node: TTreeNode);
var tmp:TTreeNodeShape;
begin
  Tree1.Selected.Clear;
  tmp:=ShapeOfNode(Tree1, Node);
  if Assigned(tmp) then tmp.Selected:=True;
end;

{ Show / hide TeeTree node borders }
procedure TFormTreeView.CBBorderClick(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Shapes.Count-1 do
      Shapes[t].Border.Visible:=CBBorder.Checked;
end;

{ Show / hide TeeTree nodes cursor }
procedure TFormTreeView.CBCursorClick(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Shapes.Count-1 do
      if CBCursor.Checked then Shapes[t].Cursor:=crHandPoint
                          else Shapes[t].Cursor:=crDefault;
end;

procedure TFormTreeView.CheckBox1Click(Sender: TObject);
begin
  { if we want flicker, then we should set BufferedDisplay to False }
  Tree1.BufferedDisplay:=not CheckBox1.Checked;
end;

{ Change TeeTree selection colors }
procedure TFormTreeView.CheckBox2Click(Sender: TObject);
begin
  with Tree1.Selected do
  if CheckBox2.Checked then
  begin
    Border.Color:=clRed;
    Color:=clNone;
    TextColor:=clNone;
  end
  else
  begin
    Border.Color:=clWhite;
    Color:=clHighLight;
    TextColor:=clHighLightText;
  end;
end;

{ Start the TeeTree inplace-editor when clicking TeeTree shapes }
procedure TFormTreeView.Tree1ClickShape(Sender: TTreeNodeShape;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (not (ssDouble in Shift)) and (Button=mbLeft) then
     if not Sender.Selected then Tree1.StopEditing
     else
     if not CBReadOnly.Checked then Tree1.StartEditing(Sender)
end;

{ Set Read-Only }
procedure TFormTreeView.CBReadOnlyClick(Sender: TObject);
begin
  TreeView1.ReadOnly:=CBReadOnly.Checked;
  Tree1.StopEditing;
end;

procedure TFormTreeView.Edit2Change(Sender: TObject);
begin
  { change TreeView indent }
  TreeView1.Indent:=UpDown1.Position;

  { Change TeeTree indent }
  TreeHorizMarginDefault:=UpDown1.Position;
  Tree1.Repaint;
end;

{ Change TeeTree shapes Font shadow size }
procedure TFormTreeView.CheckBox3Click(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Shapes.Count-1 do
  With Shapes[t].Font.Shadow do
      if CheckBox3.Checked then HorizSize:=1
                           else HorizSize:=0;
end;

{ Edit TeeTree font }
procedure TFormTreeView.Button2Click(Sender: TObject);
var t:Integer;
begin
  InternalEditFont(Self,Tree1.Shapes[0].Font);
  With Tree1 do
  for t:=1 to Shapes.Count-1 do Shapes[t].Font.Assign(Shapes[0].Font);
end;

{ Change TeeTree vertical indent }
procedure TFormTreeView.Edit3Change(Sender: TObject);
begin
  TreeVertMarginDefault:=UpDown2.Position-1;
  Tree1.Repaint;
end;

end.
