{**********************************************}
{   TTree Component                            }
{   Copyright (c) 1998 by David Berneda        }
{**********************************************}
unit UFolders;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TeeTree, ExtCtrls, TeeProcs,TreeEd, StdCtrls, Buttons, ComCtrls;

type
  TFormFolders = class(TForm)
    Tree1: TTree;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    TrackBar1: TTrackBar;
    CheckBox1: TCheckBox;
    Button1: TButton;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Panel2: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormShow(Sender: TObject);
    procedure Tree1ExpandingCollapsing(Sender: TTreeNodeShape;
      var Expand: Boolean);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure Tree1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

{ Add child nodes to "Shape", from "Path" ( c:\ ) folder... }
Procedure FillFolders(Shape:TTreeNodeShape; Const Path:String);
Var F:TSearchRec;
begin
  Screen.Cursor:=crHourGlass;
  if FindFirst(Path+'\*.*',faDirectory,F)=0 then
  begin
    Repeat
      if (F.Attr=faDirectory) and (Copy(F.Name,1,1)<>'.') then
         With Shape.AddChild(F.Name) do
         begin
           Expanded:=False;
           ShowCross:=scAlways; { <-- show the crossbox always !!! }
         end;
    Until FindNext(F)<>0;
  end;
  FindClose(F);
  { sort childs in alphabetical ascending order... }
  Shape.SortChildsText(True,True);
  Screen.Cursor:=crDefault;
end;

{ Add c:\ and the first level of folders... }
procedure TFormFolders.FormShow(Sender: TObject);
var t:Integer;
begin
  { Add root... }
  With Tree1.AddRoot('C:\') do
  begin
    Border.Visible:=False;
    Transparent:=True;
  end;
  { Add first level of C:\ folders... }
  FillFolders(Tree1.Roots[0],'C:');

  { Set the Root Expanded and Selected }
  Tree1.Roots[0].Expanded:=True;
  Tree1.Roots[0].Selected:=True;

  { Hide the connection lines "arrows" }
  With Tree1 do
  for t:=0 to Connections.Count-1 do
      Connections[t].ArrowTo.Style:=casNone;

  { set scrollbar positions... }
  TrackBar1.Position:=Tree1.View3DOptions.Zoom;
  Tree1.VertScrollBar.Automatic:=True;
end;

{ return a folder name, ie:  "c:\windows\system" }
Function GetNodePath(ANode:TTreeNodeShape):String;
begin
  result:=ANode.Text[0];
  ANode:=ANode.Parent;
  While Assigned(ANode) do
  begin
    if Copy(ANode.Text[0],Length(ANode.Text[0]),1)='\' then
       result:=ANode.Text[0]+result
    else
       result:=ANode.Text[0]+'\'+result;
    ANode:=ANode.Parent;
  end;
end;

procedure TFormFolders.Tree1ExpandingCollapsing(Sender: TTreeNodeShape;
  var Expand: Boolean);
var t:Integer;
begin
  { if first time expanded... add childs... }
  if Expand and (not Sender.HasChilds) then
  begin
    { add childs to node... }
    FillFolders(Sender,GetNodePath(Sender));
    Sender.ShowCross:=scAuto;   { <-- now we know if the node has childs... }

    { do not show small arrows in lines... }
    With Sender do
    for t:=0 to Connections.Count-1 do
        Connections[t].ArrowTo.Style:=casNone;
  end;
end;

procedure TFormFolders.BitBtn1Click(Sender: TObject);
begin
  EditTree(Self,Tree1)
end;

procedure TFormFolders.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TFormFolders.TrackBar1Change(Sender: TObject);
begin
  Tree1.View3DOptions.Zoom:=TrackBar1.Position;
end;

{ Generate random colors and fonts, just for fun... }
procedure TFormFolders.CheckBox1Click(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  begin
    Gradient.Visible:=CheckBox1.Checked;
    if CheckBox1.Checked then
    begin
      CrossBox.Brush.Color:=clLime;
      CrossBox.Border.Color:=clRed;
    end
    else
    begin
      CrossBox.Brush.Color:=clWhite;
      CrossBox.Border.Color:=clGray;
    end;
    for t:=0 to Shapes.Count-1 do
    With Shapes[t] do
    begin
      Transparent:=not CheckBox1.Checked;
      Border.Visible:=not Transparent;
      if not Transparent then
      begin
        Shadow.Color:=clGray;
        Shadow.VertSize:=3;
        Shadow.HorizSize:=3;
        Brush.Color:=ColorPalette[Random(MaxDefaultColors)+1];
        ImageIndex:=TTreeNodeImageIndex(1+Random(6));
        Font.Color:=ColorPalette[Random(MaxDefaultColors)+1];
        Font.Size:=8+Random(6);
        if Random(3)=1 then Font.Style:=[fsBold]
                       else Font.Style:=[];
      end
      else
      begin
        Shadow.HorizSize:=0;
        Shadow.VertSize:=0;
        Brush.Color:=clWhite;
        Font.Color:=clBlack;
        ImageIndex:=tiFolderOpenClose;
        Font.Size:=8;
        Font.Style:=[];
      end;
    end;
  end;
end;

procedure TFormFolders.CheckBox2Click(Sender: TObject);
begin
  Tree1.Gradient.Visible:=CheckBox2.Checked;
end;

procedure TFormFolders.CheckBox3Click(Sender: TObject);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Connections.count-1 do
  With Connections[t].ArrowTo do
  if CheckBox3.Checked then Style:=casSolid
                       else Style:=casNone;
end;

procedure TFormFolders.CheckBox4Click(Sender: TObject);
begin
  Tree1.Connections.Visible:=CheckBox4.Checked;
  CheckBox3.Enabled:=CheckBox4.Checked;
end;

procedure TFormFolders.Tree1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var tmp:TTreeNodeShape;
begin
  tmp:=Tree1.ClickedShape(x,y);
  if Assigned(tmp) then Label3.Caption:=GetNodePath(tmp)
                   else Label3.Caption:='';
end;

end.
