{**********************************************}
{   TTree Component                            }
{   Copyright (c) 1998 by David Berneda        }
{**********************************************}
unit UFiles;

interface

{ This unit shows a TeeTree component used to display folders in
  a Windows-Explorer style.
}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TeeTree, ExtCtrls, TeeProcs, StdCtrls, Buttons, ComCtrls;

type
  TFormFilesTree = class(TForm)
    Tree1: TTree;
    TreeShape0: TTreeNodeShape;
    TreeShape1: TTreeNodeShape;
    TreeShape0_TreeShape1: TTreeConnection;
    TreeShape2: TTreeNodeShape;
    TreeShape0_TreeShape2: TTreeConnection;
    TreeShape3: TTreeNodeShape;
    TreeShape0_TreeShape3: TTreeConnection;
    TreeShape4: TTreeNodeShape;
    TreeShape1_TreeShape4: TTreeConnection;
    TreeShape5: TTreeNodeShape;
    TreeShape1_TreeShape5: TTreeConnection;
    TreeShape6: TTreeNodeShape;
    TreeShape1_TreeShape6: TTreeConnection;
    TreeShape7: TTreeNodeShape;
    TreeShape2_TreeShape7: TTreeConnection;
    TreeShape8: TTreeNodeShape;
    TreeShape2_TreeShape8: TTreeConnection;
    TreeShape9: TTreeNodeShape;
    TreeShape5_TreeShape9: TTreeConnection;
    TreeShape10: TTreeNodeShape;
    TreeShape9_TreeShape10: TTreeConnection;
    TreeShape11: TTreeNodeShape;
    TreeShape9_TreeShape11: TTreeConnection;
    TreeShape12: TTreeNodeShape;
    TreeShape9_TreeShape12: TTreeConnection;
    TreeShape13: TTreeNodeShape;
    TreeShape9_TreeShape13: TTreeConnection;
    Panel1: TPanel;
    Memo1: TMemo;
    CheckBox1: TCheckBox;
    BitBtn1: TBitBtn;
    Button1: TButton;
    Label1: TLabel;
    ScrollBar1: TScrollBar;
    Label2: TLabel;
    Edit1: TEdit;
    UpDown1: TUpDown;
    Label3: TLabel;
    Edit2: TEdit;
    UpDown2: TUpDown;
    procedure Tree1ExpandedCollapsed(Sender: TTreeNodeShape);
    procedure FormShow(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Tree1AfterDraw(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}
Uses TreeEd;

{ When a Node is expanded or collapsed, change color... }
procedure TFormFilesTree.Tree1ExpandedCollapsed(Sender: TTreeNodeShape);
begin
  With Sender do
  if not Selected then  { if selected do not change color }
    if Expanded then Brush.Color:=clWhite
                else Brush.Color:=clSilver;
end;

procedure TFormFilesTree.FormShow(Sender: TObject);
var t:Integer;
begin
 { set initial colors for shapes... }
  With Tree1 do
  for t:=0 to Shapes.Count-1 do
  With Shapes[t] do
  if Expanded then Brush.Color:=clWhite
              else Brush.Color:=clSilver;
end;

procedure TFormFilesTree.ScrollBar1Change(Sender: TObject);
begin
  { change zoom amount... }
  Tree1.View3DOptions.Zoom:=ScrollBar1.Position;
end;

procedure TFormFilesTree.Button1Click(Sender: TObject);
begin
  { exit }
  Close;
end;

procedure TFormFilesTree.BitBtn1Click(Sender: TObject);
begin
  { show the Tree editor... }
  EditTree(Self,Tree1);
end;

procedure TFormFilesTree.CheckBox1Click(Sender: TObject);
begin
  { toggle between "single selection" or "multi-selection" }
  With Tree1 do
  begin
    SingleSelection:=CheckBox1.Checked;
    if SingleSelection then
       { select only one node... }
       While Selected.Count>1 do Selected[1].Selected:=False;
  end;
end;

procedure TFormFilesTree.Tree1AfterDraw(Sender: TObject);
var tmpSize:Integer;
    R:TRect;
    P:TPoint;
begin
  { Example of custom drawing...
    Draw a rectangle around the first child "crossbox".
    Use the "crossbox ClickTolerance" in pixels to
    show where the user can click to expand or collapse a node.
  }
  With Tree1 do
  begin
    { calculate the first child node "crossbox" position... }
    P:=Roots[0].Childs[0].CalcXYCross(Roots[0]);

    { calculate the rectangle where the user can click... }
    with CrossBox do tmpSize:=ClickTolerance+Border.Width+Size;
    R:=Rect(P.X-tmpSize,P.Y-tmpSize,P.X+tmpSize,P.Y+tmpSize);

    { draw a rectangle... }
    With Canvas do
    begin
      Pen.Color:=clRed;
      Pen.Width:=1;
      Pen.Style:=psSolid;
      Brush.Style:=bsClear;
      RectangleWithZ( R,0 );  { <-- support also scroll and zoom }
    end;
  end;
end;

procedure TFormFilesTree.Edit1Change(Sender: TObject);
begin
  Tree1.CrossBox.ClickTolerance:=UpDown1.Position;
  Tree1.Repaint;
end;

procedure TFormFilesTree.Edit2Change(Sender: TObject);
begin
  Tree1.CrossBox.Size:=UpDown2.Position;
end;

end.
