{**********************************************}
{   TTree Component - DataModule SQL example   }
{   Copyright (c) 1998 by David Berneda        }
{**********************************************}
unit UDataMod;

interface

{ This example shows a Tree representing a DataModule, containing
  two tables as master-detail relationship.

  The tables used in this example are Customer and Orders (located
  at DBDEMOS BDE alias).

  By clicking nodes and selecting / unselecting them, a new SQL
  statement is calculated and displayed at the Memo1 control.

  Optionally, the SQL sentence can be executed against the real
  tables, and the results displayed at DBGrid1.

}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TeeTree, ExtCtrls, TeeProcs, StdCtrls, Grids, DBGrids, Db, DBTables,
  DBCtrls;

type
  TFormDataModule = class(TForm)
    Tree1: TTree;
    Customer: TTreeNodeShape;
    Orders: TTreeNodeShape;
    TreeShape2: TTreeNodeShape;
    TreeShape0_TreeShape2: TTreeConnection;
    TreeShape3: TTreeNodeShape;
    TreeShape0_TreeShape3: TTreeConnection;
    TreeShape4: TTreeNodeShape;
    TreeShape1_TreeShape4: TTreeConnection;
    TreeShape5: TTreeNodeShape;
    TreeShape1_TreeShape5: TTreeConnection;
    TreeShape6: TTreeNodeShape;
    TreeShape0_TreeShape6: TTreeConnection;
    TreeShape5_TreeShape6: TTreeConnection;
    Button1: TButton;
    Memo1: TMemo;
    TreeShape8: TTreeNodeShape;
    TreeShape1_TreeShape8: TTreeConnection;
    Query1: TQuery;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    TreeShape9: TTreeNodeShape;
    TreeShape0_TreeShape9: TTreeConnection;
    TreeShape10: TTreeNodeShape;
    TreeShape0_TreeShape10: TTreeConnection;
    Automatic: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Tree1SelectShape(Sender: TTreeNodeShape);
    procedure Tree1UnSelectShape(Sender: TTreeNodeShape);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure RefreshSQL( Master,Detail:TTreeNodeShape;
                          Const LinkName:String);
  end;

implementation

{$R *.DFM}

procedure TFormDataModule.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TFormDataModule.FormCreate(Sender: TObject);
begin
  Tree1.SingleSelection:=False;  { Allow multi-selection of nodes }
  Memo1.Clear;
end;

{ This method will calculate the SQL statement and optionally
  it will be executed.
}
Procedure TFormDataModule.RefreshSQL( Master,Detail:TTreeNodeShape;
                                      Const LinkName:String);

  Function CreateSQL:String;

    { returns the top-most "Root" parent node for a given shape. }
    Function Root(Node:TTreeNodeShape):TTreeNodeShape;
    begin
      result:=Node;
      while result.Parent<>nil do result:=result.Parent;
    end;

  var t     : Integer;
      tmpSt : String;
      tmp   : TTreeNodeShape;
      MasterData,
      DetailData:Boolean;
  begin
    result:='';
    MasterData:=False;
    DetailData:=False;
    With Master.Tree do
    begin
      { first guess if we have master fields selected,
        detail fields or both. }
      for t:=0 to Selected.Count-1 do
      if Assigned(Selected[t].Parent) then
      begin
        tmp:=Root(Selected[t]);
        if tmp=Master then MasterData:=True else
        if tmp=Detail then DetailData:=True;
      end;

      { now, we need at least one field of "master" table }
      if MasterData then
      begin

        { create the "select" section for master fields... }
        for t:=0 to Selected.Count-1 do
        if Assigned(Selected[t].Parent) then
        if Root(Selected[t])=Master then
        begin
          tmpSt:=Selected[t].Text[0];
          if result='' then
          begin
            if DetailData then result:='select distinct '+tmpSt
                          else result:='select '+tmpSt;
          end
          else result:=result+', '+tmpSt;
        end;

        { create the "select" section for detail fields... }
        for t:=0 to Selected.Count-1 do
        if Assigned(Selected[t].Parent) then
        if Root(Selected[t])=Detail then
           result:=result+', Sum('+Selected[t].Text[0]+')';

        { create the "from" section... }
        result:=result+' from '+Master.Text[0]+' Master';
        if DetailData then
        begin
           result:=result+', '+Detail.Text[0]+' Detail';
           { create the "where" section when there is detail... }
           result:=result+' where (Master.'+LinkName+'=Detail.'+LinkName+')';
        end;

        if DetailData then
        begin
          { create the "group by" section when there is detail... }
          result:=result+' group by ';
          tmpSt:='';
          for t:=0 to Selected.Count-1 do
          if Assigned(Selected[t].Parent) then
          { "group by" only valid for master fields... }
          if Root(Selected[t])=Master then
          begin
            if tmpSt='' then result:=result+Selected[t].Text[0]
                        else result:=result+', '+Selected[t].Text[0];
            tmpSt:=Selected[t].Text[0];
          end;
        end;
      end;
    end;
  end;

Var St:String;
begin
  St:=CreateSQL;  { <-- calculate the SQL statement }

  { display memo }
  Memo1.Clear;
  Memo1.Text:=St;

  { re-execute Query... }
  Query1.Close;
  Query1.SQL.Text:=St;
  if Automatic.Checked then
     if St<>'' then
     begin
       Screen.Cursor:=crHourGlass;
       try
         Query1.Open;
       finally
         Screen.Cursor:=crDefault;
       end;
     end;
end;

procedure TFormDataModule.Tree1SelectShape(Sender: TTreeNodeShape);
begin
  RefreshSQL(Customer,Orders,'CustNo');
end;

procedure TFormDataModule.Tree1UnSelectShape(Sender: TTreeNodeShape);
begin
  RefreshSQL(Customer,Orders,'CustNo');
end;

procedure TFormDataModule.FormShow(Sender: TObject);
begin
  TreeShape3.Selected:=True;  { Company }
  TreeShape4.Selected:=True;  { AmountPaid }
end;

end.
