unit UDBCode;

{ This example shows a DBTree component automatically retrieving
  data from a Table1 dataset.

  Table1 records have a "Parent->Code" relationship to determine
  the tree.

  This example also shows how to synchronize the selected record
  and the selected DBTree node.

  When records are inserted, modified or deleted, the DBTree
  is refreshed to show the new contents.

}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, TeeProcs, TeeTree, TeeDBTre, Db, Grids, DBGrids, StdCtrls,
  DBCtrls, TreeDBEd, DBTables;

type
  TFormDBTreeCode = class(TForm)
    DBTree1: TDBTree;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Panel1: TPanel;
    DBNavigator1: TDBNavigator;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Table1: TTable;
    Table1Code: TIntegerField;
    Table1Parent: TIntegerField;
    Table1Text: TStringField;
    procedure CheckBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DataSource1UpdateData(Sender: TObject);
    procedure DBTree1SelectShape(Sender: TTreeNodeShape);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Table1AfterDelete(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
    Refreshing:Boolean;
    Function MaxCode:Integer;
  end;

var
  FormDBTreeCode: TFormDBTreeCode;

implementation

{$R *.DFM}

{ Open or Close the Table... }
procedure TFormDBTreeCode.CheckBox1Click(Sender: TObject);
begin
  Table1.Active:=CheckBox1.Checked;

  { Refresh the Tree when opening the table... }
  if Table1.Active then DataSource1UpdateData(Self)
                   else DBTree1.Clear;

  { Enable buttons... }
  Button1.Enabled:=Table1.Active;
  Button3.Enabled:=Table1.Active;
end;

procedure TFormDBTreeCode.FormCreate(Sender: TObject);
begin
  Refreshing:=False;
end;

{ When the Table is modified... refresh the DBTree... }
procedure TFormDBTreeCode.DataSource1UpdateData(Sender: TObject);
begin
  if not Refreshing then
  begin
    Refreshing:=True;
    DBTree1.Refresh;
    DBTree1.FullExpandCollapse(True);  { expand nodes }
    Refreshing:=False;
  end;
end;

{ When the user clicks a Tree node, move the Table current
  record.
}
procedure TFormDBTreeCode.DBTree1SelectShape(Sender: TTreeNodeShape);
begin
  if not Refreshing then Table1.Locate('Code',Sender.Tag,[]);
end;

{ The current record has changed because the user has
  clicked on the DBGrid or the DBNavigator.

  Locate and select the corresponding Tree node shape.
}
procedure TFormDBTreeCode.DataSource1DataChange(Sender: TObject; Field: TField);
var tmp:TTreeNodeShape;
begin
  if not Assigned(Field) then
  begin
    tmp:=DBTree1.FindNodeCode(Table1.FieldByName('Code').AsInteger);
    if Assigned(tmp) then
    begin
      Refreshing:=True;
      DBTree1.Selected.Clear;
      tmp.Selected:=True;
      Refreshing:=False;
    end;
  end;
end;

{ This generic function returns the maximum "Code" value found on
  all Tree nodes.
}
Function TFormDBTreeCode.MaxCode:Integer;
var t:Integer;
begin
  result:=0;
  With DBTree1 do
  for t:=0 to Shapes.Count-1 do
      if Shapes[t].Tag>result then result:=Shapes[t].Tag;
end;

{ Ask the user one String. Add one child node to the
  DBTree and one record to the Table }
procedure TFormDBTreeCode.Button1Click(Sender: TObject);
var tmp:TTreeNodeShape;
    St:String;
begin
  With DBTree1 do
  if Selected.Count>0 then
  begin
    St:='New';
    if InputQuery('Enter new node text','Text',St) then
    if St<>'' then
    begin
      { add a new record... }
      DataSet.Insert;
      DataSet.FieldByName(CodeField).AsInteger:=MaxCode+1;
      DataSet.FieldByName(ParentField).AsInteger:=Selected[0].Tag;
      DataSet.FieldByName(TextFields).AsString:=St;
      DataSet.Post;

      { Add a new child node... }
      tmp:=Selected[0].AddChild(St);

      { Select the new node... }
      Selected.Clear;
      tmp.Selected:=True;

      { Set focus to the Tree }
      SetFocus;
    end;
  end;
end;

procedure TFormDBTreeCode.Button2Click(Sender: TObject);
begin
  Close;
end;

{ Show the Tree editor for DBTree components }
procedure TFormDBTreeCode.Button3Click(Sender: TObject);
begin
  EditDBTree(Self,DBTree1);
end;

{ When deleting records, refresh the DBTree }
procedure TFormDBTreeCode.Table1AfterDelete(DataSet: TDataSet);
begin
  DataSource1UpdateData(DataSet);
end;

end.
