{**********************************************}
{   TTree and TDBTree Component Example        }
{   Copyright (c) 1998 by David Berneda        }
{**********************************************}
unit UCheckBo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TeeTree, ExtCtrls, TeeProcs, treeed, StdCtrls;

type
  TFormCheckBoxTree = class(TForm)
    Tree1: TTree;
    TreeShape0: TTreeNodeShape;
    TreeShape1: TTreeNodeShape;
    TreeShape0_TreeShape1: TTreeConnection;
    TreeShape2: TTreeNodeShape;
    TreeShape1_TreeShape2: TTreeConnection;
    TreeShape3: TTreeNodeShape;
    TreeShape0_TreeShape3: TTreeConnection;
    TreeShape4: TTreeNodeShape;
    TreeShape0_TreeShape4: TTreeConnection;
    TreeShape5: TTreeNodeShape;
    TreeShape0_TreeShape5: TTreeConnection;
    Panel1: TPanel;
    Button1: TButton;
    LabelNode: TLabel;
    Button2: TButton;
    CheckBox1: TCheckBox;
    Image1: TImage;
    Panel2: TPanel;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Tree1ClickShape(Sender: TTreeNodeShape; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Tree1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}

procedure TFormCheckBoxTree.FormCreate(Sender: TObject);
begin
  Tree1.MarginBottom:=10;
  Tree1.GridColor:=clNone;
  CheckBox1.Checked:=True;
end;

procedure TFormCheckBoxTree.Button1Click(Sender: TObject);
begin
  EditTree(Self,Tree1);
end;

procedure TFormCheckBoxTree.Tree1ClickShape(Sender: TTreeNodeShape;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var R:TRect;
begin
  R:=Sender.ImageRect;
  Dec(R.Right,15);
  With R do
  begin
    TopLeft:=Tree1.Canvas.Calculate3DPosition(Left,Top,0);
    BottomRight:=Tree1.Canvas.Calculate3DPosition(Right,Bottom,0);
  end;
  if PtInRect(R,Point(x,y)) then
  begin
    with Sender do
    if ImageIndex=tiFolderCloseChecked then
       ImageIndex:=tiFolderCloseUnChecked
    else
    if ImageIndex=tiFolderCloseUnChecked then
       ImageIndex:=tiFolderCloseChecked;
    Tree1.CancelMouse:=True;
  end;
end;

procedure TFormCheckBoxTree.Tree1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var tmp:TTreeNodeShape;
begin
  tmp:=Tree1.ClickedShape(x,y);
  if Assigned(tmp) then
  begin
    LabelNode.Caption:=tmp.Text[0];
    if tmp.ImageIndex=tiFolderCloseChecked then
       LabelNode.Caption:=LabelNode.Caption+' Checked'
    else
    if tmp.ImageIndex=tiFolderCloseUnChecked then
       LabelNode.Caption:=LabelNode.Caption+' UnChecked'
  end
  else
     LabelNode.Caption:='';
end;

procedure TFormCheckBoxTree.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TFormCheckBoxTree.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked then
     Tree1.BackImage.Assign(Image1.Picture)
  else
     Tree1.BackImage.Assign(nil);
  Tree1.BackImageMode:=pbmTile;
end;

end.
