{**********************************************}
{   TTree Component                            }
{   Copyright (c) 1998 by David Berneda        }
{**********************************************}
{$I teedefs.inc}
unit UAllTree;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, TeeTree, TeeProcs, Buttons, TreeFlow;

type
  TAllDemos = class(TForm)
    BClose: TBitBtn;
    Image2: TImage;
    Tree1: TTree;
    TreeShape0: TTreeNodeShape;
    TreeShape1: TTreeNodeShape;
    TreeShape0_TreeShape1: TTreeConnection;
    TreeShape2: TTreeNodeShape;
    Timer1: TTimer;
    TreeShape2_TreeShape0: TTreeConnection;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    BBasic: TBitBtn;
    BitBtn4: TBitBtn;
    BFileExplorer: TBitBtn;
    BFlowChart: TBitBtn;
    BOrgChart: TBitBtn;
    BUsedUnits: TBitBtn;
    Label2: TLabel;
    BitBtn6: TBitBtn;
    BVisualQuery: TBitBtn;
    BDataModules: TBitBtn;
    BPresentation: TBitBtn;
    BWebSites: TBitBtn;
    Button3: TBitBtn;
    BProjManager: TBitBtn;
    Button4: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn5: TBitBtn;
    Label3: TLabel;
    BDataWizard: TBitBtn;
    procedure BCloseClick(Sender: TObject);
    procedure BOrgChartClick(Sender: TObject);
    procedure BBasicClick(Sender: TObject);
    procedure BFileExplorerClick(Sender: TObject);
    procedure BFlowChartClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure BWebSitesClick(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure BProjManagerClick(Sender: TObject);
    procedure BPresentationClick(Sender: TObject);
    procedure BVisualQueryClick(Sender: TObject);
    procedure BDataModulesClick(Sender: TObject);
    procedure BUsedUnitsClick(Sender: TObject);
    procedure TreeShape2Click(Sender: TTreeNodeShape; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure TreeShape0Click(Sender: TTreeNodeShape; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Tree1ExpandedCollapsed(Sender: TTreeNodeShape);
    procedure Timer1Timer(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormShow(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BDataWizardClick(Sender: TObject);
  private
    { Private declarations }
    TeeMach:Boolean;
    Procedure ShowForm(AClass:TFormClass);
  public
    { Public declarations }
  end;

var
  AllDemos: TAllDemos;

implementation

{$R *.DFM}
Uses TeeAbout,TreeEd, OrgChart, TreeBasic, UFiles, FlowTree, UFolders,
     UWebSites, UPackage, UTreeView, UProjMgr, UIntranet, UPresent,
     UTreeForm, UFeatures, UCheckBo, TeCanvas
     {$IFNDEF NOUSE_BDE}
     ,UDBTree
     ,UDataMod
     ,UDBCode
     {$ENDIF}
     ;

procedure TAllDemos.BCloseClick(Sender: TObject);
begin
  Close;
end;

Procedure TAllDemos.ShowForm(AClass:TFormClass);
begin
  { disable animation and show example... }
  Timer1.Enabled:=False;
  With AClass.Create(Self) do
  try
    ShowModal;
  finally
    Free;
  end;
  Timer1.Enabled:=True;
end;

procedure TAllDemos.BOrgChartClick(Sender: TObject);
begin
  ShowForm(TFormOrgCharts)
end;

procedure TAllDemos.BBasicClick(Sender: TObject);
begin
  ShowForm(TFormBasicTree)
end;

procedure TAllDemos.BFileExplorerClick(Sender: TObject);
begin
  ShowForm(TFormFolders)
end;

procedure TAllDemos.BFlowChartClick(Sender: TObject);
begin
  ShowForm(TFormFlowChart)
end;

procedure TAllDemos.Button3Click(Sender: TObject);
begin
  ShowForm(TFormFilesTree)
end;

procedure TAllDemos.BWebSitesClick(Sender: TObject);
begin
  ShowForm(TFormWebSites)
end;

procedure TAllDemos.Button4Click(Sender: TObject);
begin
  ShowForm(TFormPackages)
end;

procedure TAllDemos.BProjManagerClick(Sender: TObject);
begin
  ShowForm(TFormProjects)
end;

procedure TAllDemos.BPresentationClick(Sender: TObject);
begin
  ShowForm(TFormPresentation)
end;

{ Tell the user to download the Database Demo }
{$IFDEF NOUSE_BDE}
Procedure ShowNeedBDEDemo;
begin
  ShowMessage('TeeTree Database Examples are included'+#13+
              'at the "TeeTree Database Demo", available'+#13+
              'at our web site (http://www.teemach.com).'+#13+#13+
              'The reason is to not make necessary for this demo'+#13+
              'to have the BDE installed.');
end;
{$ENDIF}

procedure TAllDemos.BVisualQueryClick(Sender: TObject);
begin
  {$IFNDEF NOUSE_BDE}
  ShowForm(TFormDBTreeDemo)
  {$ELSE}
  ShowNeedBDEDemo;
  {$ENDIF}
end;

procedure TAllDemos.BDataModulesClick(Sender: TObject);
begin
  {$IFNDEF NOUSE_BDE}
  ShowForm(TFormDataModule)
  {$ELSE}
  ShowNeedBDEDemo;
  {$ENDIF}
end;

procedure TAllDemos.BUsedUnitsClick(Sender: TObject);
begin
  ShowForm(TFormCheckBoxTree)
end;

procedure TAllDemos.TreeShape2Click(Sender: TTreeNodeShape;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
{$IFNDEF D1}
  GotoURL(Handle,Sender.Text[0]);
{$ENDIF}
end;

procedure TAllDemos.FormCreate(Sender: TObject);
begin
  { Set the Tree logo image for the left most shape... }
  TreeLogoSetPicture(TreeShape0.Image);

  { if we are running in a video mode screen of more than 256 colors,
    turn gradient visible... }
  Tree1.Gradient.Visible:=Tree1.IsScreenHighColor;
end;

procedure TAllDemos.TreeShape0Click(Sender: TTreeNodeShape;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  BitBtn1Click(Self);
end;

{ return a random basic color... }
Function RandomColor:TColor;
begin
  Case Random(5) of
    0: result:=clBlue;
    1: result:=clRed;
    2: result:=clLime;
    3: result:=clYellow;
  else result:=clAqua;
  end;
end;

{ This event is called for any shape node that is expanded
  or collapsed.  After expansion or expansion occurs, this
  event is called.  There is another event that is called
  *before* expanding or collapsing.
}
{ So, do some animation only when *expanding* the "teeTree" logo... }
procedure TAllDemos.Tree1ExpandedCollapsed(Sender: TTreeNodeShape);
var tmp   : Integer;
begin
  if Sender=TreeShape0 then  { <-- only with "tee Tree logo" shape }
  if Sender.Expanded then    { <-- if it has been expanded .... }
  with TreeShape1 do         { <-- with "teeMach SL" shape... }
  begin
    { Move "teeMach" to the logo shape... }
    tmp:=X1-X0;
    X0:=TreeShape0.X0;
    X1:=X0+tmp;

    { Now move "teeMach" to the right... }
    While X0<310 do  { <-- move to right until 310 X position }
    begin
      X0:=X0+4;  { <-- move to right 4 pixels at a time... }
      X1:=X1+4;
      Parent.Connections[0].ArrowTo.Brush.Color:=RandomColor;
      Application.ProcessMessages; { <-- allow repaint while moving shape... }
    end;
  end;
end;

procedure TAllDemos.Timer1Timer(Sender: TObject);
var Delta:Integer;
begin
  { Every 5 seconds... }
  Timer1.Enabled:=False;

  if TeeMach then
  With TreeShape0 do  { do expansion of "teeMach" shape... }
  begin
    if Expanded then Expanded:=False;
    Expanded:=True;
  end
  else
  { or move the "www" shape to the left and to the right... }
  With TreeShape2 do
  begin
    Delta:=-2;
    Repeat
      X0:=X0+Delta;
      X1:=X1+Delta;
      Application.ProcessMessages;
    Until (X1<50) or Application.Terminated;

    if not Application.Terminated then
    begin
      Delta:=2;
      Repeat
        X0:=X0+Delta;
        X1:=X1+Delta;
        Application.ProcessMessages;
      Until (X0>320) or Application.Terminated;
    end;
  end;

  TeeMach:=not TeeMach;
  Timer1.Enabled:=True;
end;

procedure TAllDemos.BitBtn1Click(Sender: TObject);
begin
  Timer1.Enabled:=False;
  TeeShowTreeAbout(True);
  Timer1.Enabled:=True;
end;

procedure TAllDemos.BitBtn2Click(Sender: TObject);
begin
  ShowForm(TFormFeatures)
end;

procedure TAllDemos.BitBtn3Click(Sender: TObject);
begin
  ShowForm(TFormIntranet)
end;

procedure TAllDemos.BitBtn4Click(Sender: TObject);
begin
  ShowForm(TFormTreeView)
end;

procedure TAllDemos.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  Timer1.Enabled:=False;
end;

procedure TAllDemos.FormShow(Sender: TObject);
begin
  { warning the user... }
  if not Tree1.IsScreenHighColor then
     ShowMessage('Warning: This demo needs more than 256 colors'+#13+
                 'video mode to obtain the best visual effects.');
end;

procedure TAllDemos.BitBtn5Click(Sender: TObject);
begin
  ShowForm(TFormControls)
end;

procedure TAllDemos.BitBtn6Click(Sender: TObject);
begin
  {$IFNDEF NOUSE_BDE}
  ShowForm(TFormDBTreeCode)
  {$ELSE}
  ShowNeedBDEDemo;
  {$ENDIF}
end;

procedure TAllDemos.BDataWizardClick(Sender: TObject);
begin
  {$IFNDEF NOUSE_BDE}
  { disable animation and show example... }
  Timer1.Enabled:=False;
  With TFormDBTreeDemo.Create(Self) do
  try
    ShowWizard:=True;
    ShowModal;
  finally
    Free;
  end;
  Timer1.Enabled:=True;
  {$ELSE}
  ShowNeedBDEDemo;
  {$ENDIF}
end;

end.
