{**********************************************}
{   TTree Component                            }
{   Copyright (c) 1998 by David Berneda        }
{**********************************************}
unit TreeBasic;

interface

{ Basic example of Tee Tree 1.0.
  Adding Tree Nodes and editing...
}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, TeeProcs, TeeTree, StdCtrls, Menus, Buttons, ComCtrls;

type
  TFormBasicTree = class(TForm)
    Tree1: TTree;
    Panel1: TPanel;
    ButtonClose: TButton;
    Panel2: TPanel;
    Label1: TLabel;
    Label3: TLabel;
    TreeShape0: TTreeNodeShape;
    TreeShape1: TTreeNodeShape;
    TreeShape2: TTreeNodeShape;
    TreeShape3: TTreeNodeShape;
    TreeShape4: TTreeNodeShape;
    TreeShape5: TTreeNodeShape;
    TreeShape6: TTreeNodeShape;
    TreeShape7: TTreeNodeShape;
    TreeShape8: TTreeNodeShape;
    TreeShape9: TTreeNodeShape;
    TreeShape10: TTreeNodeShape;
    TreeShape11: TTreeNodeShape;
    TreeShape12: TTreeNodeShape;
    TreeShape13: TTreeNodeShape;
    TreeShape14: TTreeNodeShape;
    TreeShape15: TTreeNodeShape;
    TreeShape16: TTreeNodeShape;
    TreeShape17: TTreeNodeShape;
    TreeShape18: TTreeNodeShape;
    TreeShape0_TreeShape1: TTreeConnection;
    TreeShape1_TreeShape2: TTreeConnection;
    TreeShape1_TreeShape3: TTreeConnection;
    TreeShape0_TreeShape4: TTreeConnection;
    TreeShape0_TreeShape5: TTreeConnection;
    TreeShape0_TreeShape6: TTreeConnection;
    TreeShape0_TreeShape7: TTreeConnection;
    TreeShape7_TreeShape8: TTreeConnection;
    TreeShape7_TreeShape9: TTreeConnection;
    TreeShape7_TreeShape10: TTreeConnection;
    TreeShape10_TreeShape11: TTreeConnection;
    TreeShape12_TreeShape13: TTreeConnection;
    TreeShape12_TreeShape14: TTreeConnection;
    TreeShape14_TreeShape15: TTreeConnection;
    TreeShape14_TreeShape16: TTreeConnection;
    TreeShape12_TreeShape17: TTreeConnection;
    TreeShape12_TreeShape18: TTreeConnection;
    TreeShape3_TreeShape18: TTreeConnection;
    TreeShape5_TreeShape4: TTreeConnection;
    TreeShape6_TreeShape18: TTreeConnection;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    SpeedButton1: TSpeedButton;
    Label5: TLabel;
    CenterInView: TCheckBox;
    Label2: TLabel;
    Label4: TLabel;
    TrackBar1: TTrackBar;
    procedure FormCreate(Sender: TObject);
    procedure ButtonCloseClick(Sender: TObject);
    procedure Tree1ClickShape(Sender: TTreeNodeShape;
       Button: TMouseButton; Shift: TShiftState; X,Y: Integer);
    procedure Tree1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Tree1ClickConnection(Sender: TTreeConnection;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure TrackBar1Change(Sender: TObject);
  private
    { Private declarations }
    Procedure RefreshScrollBar;
    { trick to zoom centering the tree }
    Procedure View3DChangedZoom(NewZoom:Integer);
  public
    { Public declarations }
  end;

implementation

uses TreeShEd,  { Node Shape Editor dialog }
     TreeEd,    { Editor dialog }
     TeCanvas,  { Canvas drawing methods... }
     TreeCoEd;  { Node Connection Editor dialog }

{$R *.DFM}

procedure TFormBasicTree.FormCreate(Sender: TObject);
begin
  { set private variables... }
  Label2.Caption:='';
  Label4.Caption:='';
  Label5.Caption:='';

  { Add some sample nodes if tree is empty... }
  if Tree1.Shapes.Count=0 then
  begin
    { add one "root" !  }
    With Tree1.AddRoot( 'Continents' ) do  { <-- root ! }
    begin
      { change root color... }
      Brush.Color:=clAqua;
      Cursor:=crHandPoint;

      { Add childs to root }
      With AddChild( 'Africa' ) do
      begin
        AddChild( 'Nigeria' );
        AddChild( 'Morocco' );
      end;
      AddChild( 'America' );
      With AddChild( 'Asia' ) do
      begin
        { change "Asia" font... }
        Font.Size:=12;
        Font.Style:=[fsItalic,fsBold];
      end;
      AddChild( 'Australia' );
      With AddChild( 'Europe' ) do
      begin
        Brush.Color:=clLime;
        Border.Color:=clBlue;
        AddChild( 'France' );
        AddChild( 'Norway' );
        With AddChild( 'Spain' ) do
        begin
          AddChild( 'Catalonia' );
        end;
      end;
    end;

    { Add another root with some other sample nodes... }
    With Tree1.AddRoot( 'Products' ) do  { <-- root ! }
    begin
      AddChild( 'Chairs' );
      Brush.Color:=clYellow;
      With AddChild( 'Tables' ) do
      begin
        AddChild( 'Big' );
        AddChild( 'Small' );
      end;
      With AddChild( 'Lamps' ) do
      begin
        Font.Size:=12;
        Font.Style:=[fsBold];
        Font.color:=clBlue;
      end;
      AddChild( 'Computers' );
    end;
  end;

  { Expand the first root node... }
  Tree1.Roots[0].Expanded:=True;

  { Allow only one Tree node shape selected at the same time... }
  Tree1.SingleSelection:=True;

  { Change the selection colors... }
  With Tree1.Selected do
  begin
    Color:=clNone;
    TextColor:=clNone;
    Border.Color:=clBlue;
    Border.Width:=2;
  end;

  { set our scroll bar... }
  RefreshScrollBar;
  { set trick to zoom centered... }
  Tree1.View3DOptions.OnChangedZoom:=View3DChangedZoom;
end;

{ synchronize our scroll bars with the Tree scroll... }
Procedure TFormBasicTree.RefreshScrollBar;
begin
  TrackBar1.Position:=Tree1.View3DOptions.Zoom;
  Label3.Caption:=IntToStr(TrackBar1.Position)+'%';
end;

procedure TFormBasicTree.ButtonCloseClick(Sender: TObject);
begin
  Close;  { exit }
end;

procedure TFormBasicTree.Tree1ClickShape(Sender: TTreeNodeShape;
          Button: TMouseButton; Shift: TShiftState; X,Y: Integer);
begin
  { When clicking a shape...
    first set the Tree1 focus, so the Tree can accept keystrokes... }
  Tree1.SetFocus;

  { move the shape to the Tree center... }
  if CenterInView.Checked then
  begin
    Tree1.CenterInView(Sender,True);
    RefreshScrollBar;
  end
  else
     { Show the Shape editor and Edit it ! }
     EditTreeShape(Self,Sender);
end;

procedure TFormBasicTree.Tree1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var t       : Integer;
    tmpText : String;
    tmpName : String;
begin
  tmpText:='';
  tmpName:='';
  { Check which shape node is under the mouse ... }
  with Tree1 do
    for t:=Shapes.Count-1 downto 0 do
    if Shapes[t].Clicked(x,y) then
    begin
      { eureka... }
      tmpText:=Shapes[t].Text[0];
      tmpName:=Shapes[t].Name;
      break;
    end;

  { check if mouse is over a connection line... }
  with Tree1 do
    for t:=0 to Connections.Count-1 do
    if Connections[t].Clicked(x,y) then
    begin
      { eureka... }
      tmpText:=TreeMsg_Connection+':'{Connections[t].Text[0]};
      tmpName:=Connections[t].Name;
      break;
    end;

  { set our labels... }
  if tmpText<>Label2.Caption then Label2.Caption:=tmpText;
  if tmpName<>Label4.Caption then Label4.Caption:=tmpName;
end;

procedure TFormBasicTree.Tree1ClickConnection(Sender: TTreeConnection;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  { Edit a Tree connection line... }
  EditTreeConnection(Self,Sender,False);
end;

procedure TFormBasicTree.BitBtn2Click(Sender: TObject);
begin
 { Show the Tree editor dialog ... }
  EditTree(Self,Tree1);

  { set our scroll bar... }
  RefreshScrollBar;
end;

procedure TFormBasicTree.BitBtn1Click(Sender: TObject);
begin
  TeeShowTreeAbout(True); { show about box... }
end;

procedure TFormBasicTree.SpeedButton1Click(Sender: TObject);
begin
  { set the Tree in "connecting" mode... }
  if SpeedButton1.Down then
  begin
    { start connecting two shapes... }
    BitBtn1.Visible:=False;
    BitBtn2.Visible:=False;
    ButtonClose.Visible:=False;
    CenterInView.Visible:=False;
    Label5.Caption:='Click two shapes to connect them. Press ESC key to cancel.';
    Tree1.StartConnecting;
    SpeedButton1.Down:=False;
  end
  else Tree1.StopConnecting;
  Label5.Caption:='';
  BitBtn1.Visible:=True;
  BitBtn2.Visible:=True;
  CenterInView.Visible:=True;
  ButtonClose.Visible:=True;
end;

procedure TFormBasicTree.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  Tree1.StopConnecting;
end;

procedure TFormBasicTree.TrackBar1Change(Sender: TObject);
begin
  { Zoom Tree... }
  Tree1.View3DOptions.Zoom:=TrackBar1.Position;
  Label3.Caption:=IntToStr(TrackBar1.Position)+'%';
end;

Procedure TFormBasicTree.View3DChangedZoom(NewZoom:Integer);
var P1:TPoint;
begin
  With Tree1 do
  begin
    P1.X:=ChartXCenter;
    P1.Y:=ChartYCenter;
    Canvas.Calculate2DPosition(P1.X,P1.Y,0);
    View3DOptions.HorizOffset:=-Round((0.01*NewZoom)*(P1.X-ChartXCenter));
    View3DOptions.VertOffset:=-Round((0.01*NewZoom)*(P1.Y-ChartYCenter));
  end;
end;

end.
