{**********************************************}
{   TTree Component                            }
{   Copyright (c) 1998 by David Berneda        }
{**********************************************}
unit OrgChart;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, TeeTree, TeeProcs;

type
  TFormOrgCharts = class(TForm)
    Tree1: TTree;
    TreeShape0: TTreeNodeShape;
    TreeShape1: TTreeNodeShape;
    TreeShape0_TreeShape1: TTreeConnection;
    TreeShape4: TTreeNodeShape;
    TreeShape0_TreeShape4: TTreeConnection;
    TreeShape5: TTreeNodeShape;
    TreeShape4_TreeShape5: TTreeConnection;
    TreeShape6: TTreeNodeShape;
    TreeShape1_TreeShape6: TTreeConnection;
    TreeShape7: TTreeNodeShape;
    TreeShape1_TreeShape7: TTreeConnection;
    Panel1: TPanel;
    Memo1: TMemo;
    Button1: TButton;
    CheckBox1: TCheckBox;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Tree1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.DFM}
Uses TreeEd;

procedure TFormOrgCharts.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TFormOrgCharts.CheckBox1Click(Sender: TObject);
begin
  if CheckBox1.Checked then
     Tree1.GridColor:=clSilver
  else
     Tree1.GridColor:=clNone;
end;

procedure TFormOrgCharts.Tree1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var t:Integer;
begin
  With Tree1 do
  for t:=0 to Shapes.Count-1 do
  if Shapes[t].Clicked(x,y) then
  begin
    Label3.Caption:=Shapes[t].Text[0];
    Label4.Caption:=Shapes[t].Text[1];
    break;
  end;
end;

procedure TFormOrgCharts.FormCreate(Sender: TObject);
begin
  Label3.Caption:='';
  Label4.Caption:='';
  { DO NOT fill selected shapes with blue color and white font... }
  Tree1.Selected.Color:=clNone;
  Tree1.Selected.TextColor:=clNone;
end;

procedure TFormOrgCharts.Button2Click(Sender: TObject);
begin
  EditTree(Self,Tree1);
end;

end.
