////////////////////////////////////////////////////////////////////////////////
//                                 DATASTEAD                                  //
//                   THttpScan C++Builder Component Demo                      //
//                                                                            //
//                         http://www.datastead.com                           //
//                           contact@datastead.com                            //
////////////////////////////////////////////////////////////////////////////////

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Demo_.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "HttpScan"

// DO NOT FORGET THE PRAGMA BELOW
#pragma link "inet.lib"
// DO NOT FORGET THE PRAGMA ABOVE

#pragma resource "*.dfm"
TForm1 *Form1;
int CountLinks;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
//---------------------------------------------------------------------------
        : TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
//---------------------------------------------------------------------------
{
   CheckBox1->Checked = HttpScan1->AllowRedirect;
   CheckBox3->Checked = HttpScan1->KeywordsFilterEnabled;
   CheckBox4->Checked = HttpScan1->KeywordsLimiterEnabled;
   CheckBox5->Checked = HttpScan1->TypeFilterEnabled;

   UpDown1->Position = (short) HttpScan1->DepthSearchLevel;
   UpDown2->Position = (short) HttpScan1->ConcurrentDownloads;

   RadioGroup1->ItemIndex = HttpScan1->ProxyType;
   RadioGroup2->ItemIndex = int (HttpScan1->LinkScan);
   RadioGroup3->ItemIndex = int (HttpScan1->LinkReport);

   Edit2->Text = HttpScan1->FileOfResults;
   Edit4->Text = HttpScan1->ProxyUser;
   Edit5->Text = IntToStr (HttpScan1->Retries);
   Edit7->Text = IntToStr (HttpScan1->TimeOut);
   Edit8->Text = HttpScan1->ProxyAddress;
   Edit9->Text = IntToStr (HttpScan1->ProxyPort);

   Memo9->Text = HttpScan1->KeywordsFilter;
   Memo8->Text = HttpScan1->KeywordsLimiter;
   Memo11->Text = HttpScan1->TypeFilter;

   MaskEdit1->Text = HttpScan1->ProxyPassword;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::HttpScan1PageReceived(TObject *Sender,
      AnsiString HostName, AnsiString Url, AnsiString Head,
      AnsiString Body)
//---------------------------------------------------------------------------
{
   int i;
   BOOL Done;
   BOOL Found;

   Memo2->Text = Head;
   Memo3->Text = LowerCase (Body);
   Done = false;
   Found = false;
   i = 0;
   while (! Done) {
      if (i == Memo5->Lines->Count) {
         Done = true;
      }
      else {
         if (Memo5->Lines[i].Text.Pos (Memo3->Text) > 0) {
            Found = true;
            Done = true;
         }
         i ++;
      }
   }
   if (Found) {
      Memo6->Lines->Add (Url);
   }
}

//---------------------------------------------------------------------------
void __fastcall TForm1::HttpScan1LinkFound(TObject *Sender,
      AnsiString UrlFound, AnsiString TypeLink, AnsiString FromUrl,
      AnsiString HostName, AnsiString UrlPath, AnsiString UrlPathWithFile,
      AnsiString FileName, AnsiString ExtraInfos, int Port,
      AnsiString &WriteToFile, char HrefOrSrc, int CountArea,
      bool &FollowIfHtmlLink)
{
   AnsiString asTemp, sLine, pLeft, pRight;
   // if nothing is assigned to WriteToFile, all the links are written to the result file in a default format->

   // if you want a link not to be written to the result file, add a WriteToFile = ""; E->g:
   // if TypeLink <> "mail" ) {
   //    WriteToFile = "";
   // }

   // if you want to write you own fields according to a condition of your choice, set the line to write in the WriteToFile string-> E->g:
   // WriteToFile = UrlFound + ";" + TypeLink + ";" + Hostname;

   CountLinks ++;

   if (Memo1->Lines->Count > 500) {
      Memo1->Text = "";
   }
   asTemp = asTemp.Format ("%-4s ", ARRAYOFCONST ((TypeLink + " " + UrlFound)));
   Memo1->Lines->Add (asTemp);

   StatusBar1->SimpleText = "   " + IntToStr (CountLinks) + " links found...";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::HttpScan1UpdatedStats(TObject *Sender, int InQueue,
      int Downloading, int ToAnalyze, int Done, int Retries, int Errors)
//---------------------------------------------------------------------------
{
   Memo7->Text =    "   IN QUEUE : " + IntToStr (InQueue);
   Memo7->Lines->Add ("downloading : " + IntToStr (Downloading));
   Memo7->Lines->Add (" to analyze : " + IntToStr (ToAnalyze));
   Memo7->Lines->Add ("       DONE : " + IntToStr (Done));
   Memo7->Lines->Add ("    retries : " + IntToStr (Retries));
   Memo7->Lines->Add ("     errors : " + IntToStr (Errors));
}

//---------------------------------------------------------------------------
void __fastcall TForm1::HttpScan1MetaTag(TObject *Sender, AnsiString Url,
      AnsiString ReferringUrl, AnsiString TagType, AnsiString Tag1stAttrib,
      AnsiString Tag1stValue, AnsiString Tag2ndAttrib,
      AnsiString Tag2ndValue, AnsiString Tag3rdAttrib,
      AnsiString Tag3rdValue)
//---------------------------------------------------------------------------
{
   AnsiString asTemp;

   Memo10->Lines->Add ("");
   Memo10->Lines->Add (Url);
   Memo10->Lines->Add ("----------------------------------");
   Memo10->Lines->Add (TagType);
   asTemp = asTemp.Format ("%-15s %s", ARRAYOFCONST ((Tag1stAttrib, Tag1stValue)));

   Memo10->Lines->Add (asTemp);
   if (Tag2ndAttrib.Length() > 0) {
      asTemp = asTemp.Format ("%-15s %s", ARRAYOFCONST ((Tag2ndAttrib, Tag2ndValue)));
      Memo10->Lines->Add (asTemp);
   }
   if (Tag3rdAttrib.Length() > 0) {
      asTemp = asTemp.Format ("%-15s %s", ARRAYOFCONST ((Tag3rdAttrib, Tag3rdValue)));
      Memo10->Lines->Add (asTemp);
   }
   Memo10->Tag = Memo10->Tag + 7;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   if (HttpScan1->Stop()) {
      StatusBar1->SimpleText = StatusBar1->SimpleText + "    stopping...";
   }
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   BOOL Ok;

   Button2->Enabled = false;
   HttpScan1->FileOfResults = Edit2->Text;
   Ok = HttpScan1->Start (Memo12->Text);

   if (Ok) {
      CountLinks = 0;

      Memo12->Text = HttpScan1->StartingUrl;
      Memo1->Text = "";
      Memo2->Text = "";
      Memo3->Text = "";
      Memo4->Text = "";
      Memo6->Text = "";
      Memo10->Text = "";
   }
   Button2->Enabled = true;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Button3Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   OpenDialog1->FileName = "c:\result.txt";
   if (OpenDialog1->Execute()) {
      Edit2->Text = OpenDialog1->FileName;
   }
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Edit1KeyPress(TObject *Sender, char &Key)
//---------------------------------------------------------------------------
{
   if (Key == char(13)) {
      Button2Click (this);
   }
}

//---------------------------------------------------------------------------
void __fastcall TForm1::HttpScan1Error(TObject *Sender, AnsiString Url,
      DWORD ErrorCode, AnsiString ErrorMsg)
//---------------------------------------------------------------------------
{
   Memo4->Lines->Add ("ERROR " + IntToStr (ErrorCode) + " : " + Url);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::HttpScan1Working(TObject *Sender, bool Working_)
//---------------------------------------------------------------------------
{
   if (Working_) {
      StatusBar1->SimpleText = "   Working...";
   }
   else {
      StatusBar1->SimpleText = StatusBar1->SimpleText + "     Done.";
   }
}

//---------------------------------------------------------------------------
void __fastcall TForm1::UpDown2Click(TObject *Sender, TUDBtnType Button)
//---------------------------------------------------------------------------
{
   HttpScan1->ConcurrentDownloads = StrToIntDef (Edit6->Text, 2);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::UpDown1Click(TObject *Sender, TUDBtnType Button)
//---------------------------------------------------------------------------
{
   HttpScan1->DepthSearchLevel = StrToIntDef (Edit3->Text, 3);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::RadioGroup1Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->ProxyType = TProxyType (RadioGroup1->ItemIndex);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Edit8Change(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->ProxyAddress = Edit8->Text;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Edit4Change(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->ProxyUser = Edit4->Text;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Edit9Change(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->ProxyPort = StrToIntDef (Edit9->Text, 80);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::MaskEdit1Change(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->ProxyPassword = MaskEdit1->Text;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox3Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->KeywordsFilterEnabled = CheckBox3->Checked;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox4Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->KeywordsLimiterEnabled = CheckBox4->Checked;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Memo8Change(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->KeywordsLimiter = Memo8->Text;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Memo9Change(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->KeywordsFilter = Memo9->Text;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Edit5Change(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->Retries = StrToIntDef (Edit5->Text, 3);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Edit7Change(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->TimeOut = StrToIntDef (Edit7->Text, 300);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox5Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->TypeFilterEnabled = CheckBox5->Checked;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Memo11Change(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->TypeFilter = Memo11->Text;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Edit3KeyPress(TObject *Sender, char &Key)
//---------------------------------------------------------------------------
{
   Key = char(0);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Edit6KeyPress(TObject *Sender, char &Key)
//---------------------------------------------------------------------------
{
   Key = char(0);
}

//---------------------------------------------------------------------------
void __fastcall TForm1::RadioGroup2Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   Memo1->Text = "";
   HttpScan1->LinkScan = TLinkScan (RadioGroup2->ItemIndex);
   switch (HttpScan1->LinkScan) {
     case scanAllLinks: Memo1->Lines->Add ("this option scans all the HTML links found."); break;
     case scanInitialSite: Memo1->Lines->Add ("this option scans all the HTML links found on the site of the starting URL."); break;
     case scanInitialPath : Memo1->Lines->Add ("this option scans only links with the same sub path than the starting URL. WARNING: it may scan few or no links."); break;
   }
}

//---------------------------------------------------------------------------
void __fastcall TForm1::RadioGroup3Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   Memo1->Text = "";
   HttpScan1->LinkReport = TLinkReport (RadioGroup3->ItemIndex);
   switch (HttpScan1->LinkReport) {
      case reportAllLinks: Memo1->Lines->Add ("this option reports all the links found"); break;
      case reportCurrentSiteLinks: Memo1->Lines->Add ("this option reports all the links found on the same site than the currently scanned URL."); break;
      case reportCurrentPathLinks: Memo1->Lines->Add ("this option reports only links with the same path than the currently analyzed URL. WARNING: it may report few or no links."); break;
   }
}

//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox1Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   HttpScan1->AllowRedirect = CheckBox1->Checked;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
//---------------------------------------------------------------------------
{
   Close();
}



