//  Freeware for noncommercial use

//  Copyright 1999 by Armin Cristalli, Catbytes Software
//  E-Mail: webmaster@catbytes.de
//  URL   : http://www.catbytes.de/
//
//  Demo-Project version 1.00 for "T-Euro"

//  Properties:
//  About          : Info from the programmer
//  InputCurrency  : Select your input currency                           (ic..)
//  InputValue     : Write here your rate to calculate                    (REAL)
//  OutputCurrency : Select your output currency                          (oc..)
//  OutputValue    : Calculated automatically (designtime and runtime)    (REAL)
//  Rate_ATS       : Exchange rate for ATS ("sterreichischer Schilling") (STRING)
//  Rate_BEF       : Exchange rate for BEF ("Belgische Franc")            (STRING)
//  Rate_DEM       : Exchange rate for DEM ("Deutsche Mark")              (STRING)
//  Rate_ESP       : Exchange rate for ESP ("Spanische Peseten")          (STRING)
//  Rate_FIM       : Exchange rate for FIM ("Finnische Mark")             (STRING)
//  Rate_FRF       : Exchange rate for FRF ("Franzsische Franc")         (STRING)
//  Rate_IEP       : Exchange rate for IEP ("Irische Pfund")              (STRING)
//  Rate_ITL       : Exchange rate for ITL ("Italienische Lira")          (STRING)
//  Rate_LXG       : Exchange rate for LXG ("Luxemburgische Franc")       (STRING)
//  Rate_NLG       : Exchange rate for NLG ("Hollndischer Gulden")       (STRING)
//  Rate_Other     : Exchange rate for other currency (e.g. Dollar)       (STRING)
//  Rate_PTE       : Exchange rate for PTE ("Portugisische Escudo")       (STRING)

unit Unit1;

interface

uses
 Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
 StdCtrls, Euro, Buttons, ComCtrls;

type
 TForm1 = class ( TForm )
  Euro1 : TEuro;
  GroupBox1 : TGroupBox;
  GroupBox2 : TGroupBox;
  ComboBox1 : TComboBox;
  ComboBox2 : TComboBox;
  Label1 : TLabel;
  Label2 : TLabel;
  Edit1 : TEdit;
  Edit2 : TEdit;
  BitBtn1 : TBitBtn;
    StatusBar1: TStatusBar;
  procedure FormCreate ( Sender : TObject );
  procedure Calculate ( Sender : TObject );
  procedure BitBtn1Click ( Sender : TObject );
    procedure StatusBar1Click(Sender: TObject);
 private
    { Private-Deklarationen }
 public
    { Public-Deklarationen }
 end;
 
var
 Form1 : TForm1;
 
implementation

uses Unit2;

{$R *.DFM}

procedure TForm1.FormCreate ( Sender : TObject );
begin
 ComboBox1.ItemIndex := 0; //initialize ComboBox1
 ComboBox2.ItemIndex := 0; //initialize ComboBox2
 CalCulate ( Self ); //first calculate
end;

procedure TForm1.Calculate ( Sender : TObject );
var
 InputStr : string; //used for Edit1
begin
 case ComboBox1.ItemIndex of //get InputCurrency from ic.. value
  0 : Euro1.InputCurrency := icDEM;
  1 : Euro1.InputCurrency := icBEF;
  2 : Euro1.InputCurrency := icESP;
  3 : Euro1.InputCurrency := icFRF;
  4 : Euro1.InputCurrency := icIEP;
  5 : Euro1.InputCurrency := icITL;
  6 : Euro1.InputCurrency := icLXG;
  7 : Euro1.InputCurrency := icNLG;
  8 : Euro1.InputCurrency := icATS;
  9 : Euro1.InputCurrency := icPTE;
  10 : Euro1.InputCurrency := icFIM;
  11 : Euro1.InputCurrency := icEUR;
 end;
 case ComboBox2.ItemIndex of //get OutputCurrency from oc.. value
  0 : Euro1.OutputCurrency := ocEUR;
  1 : Euro1.OutputCurrency := ocFIM;
  2 : Euro1.OutputCurrency := ocPTE;
  3 : Euro1.OutputCurrency := ocATS;
  4 : Euro1.OutputCurrency := ocNLG;
  5 : Euro1.OutputCurrency := ocLXG;
  6 : Euro1.OutputCurrency := ocITL;
  7 : Euro1.OutputCurrency := ocIEP;
  8 : Euro1.OutputCurrency := ocFRF;
  9 : Euro1.OutputCurrency := ocESP;
  10 : Euro1.OutputCurrency := ocBEF;
  11 : Euro1.OutputCurrency := ocDEM;
 end;
 InputStr := Edit1.Text;
 while Pos ( '.', InputStr ) > 0 do // value-separator for Edit1 is only comma
  InputStr [ Pos ( '.', InputStr ) ] := ',';
 if Trim ( InputStr ) <> '' then Euro1.InputValue := StrToFloat ( InputStr ); // if Edit1 is empty do nothing
 Edit2.Text := FloattoStrF ( Euro1.OutputValue, ffNumber, 18, 2 ); // gives the output results to Edit2
 Edit2.Hint := FloatToStr ( Euro1.OutputValue ); // sets the hint for Edit2 (the REAL value)
end;

procedure TForm1.BitBtn1Click ( Sender : TObject );
begin
 Close; // terminates the application
end;

procedure TForm1.StatusBar1Click(Sender: TObject);
begin
Form2.ShowModal;
end;

end.

