//******************************************************
// SPRINT - Print & Preview engine for Delphi
// WWW.SMART.CO.YU
//******************************************************

unit report5;

interface

procedure Report_5(show:Boolean);

implementation

uses Main,Sprint,Graphics,SysUtils,Classes,DBTables,Printers;

var Sp:TSprint;

//in this report we separated 3 field definitions (with styles) in
//different functions
procedure Def1;
begin
   Sp.ClearFields;
   Sp.AddField('XXXXXXXXXXXXXXXXXXXXXXX','Company',taLeftJustify);
   Sp.AddField('XXXXXXXXXXXXXXXXXXXX','Contact',taLeftJustify);
   Sp.AddField('XXXXXXXXXXX','Phone',taLeftJustify);
   Sp.AddField('XXXXXXXXXXX','Fax',taLeftJustify);
   Sp.AddField('CustNo','Cust.no',taCenter);
   Sp.Style[tsHead].Font.Size:=-12;
   Sp.Style[tsHead].BackColor:=$00E0E0E0;
   Sp.Style[tsHead].Borders:=[];
   Sp.Style[tsHead].LineSpace:=1.1;
   Sp.Style[tsText].Font.Size:=-12;
   Sp.Style[tsText].BackColor:=$00E0E0E0;
   Sp.Style[tsText].Borders:=[];
   Sp.Style[tsText].LineSpace:=1.1;
   Sp.Recalculate(-150); {15 mm from both paper edges} 
end;

procedure Def2;
begin
   Sp.ClearFields;
   //note that first field will never be used (we will allways print
   //an empty string in it
   Sp.AddField('xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx','spacer',taLeftJustify);
   Sp.AddField('00000000','Order No',taLeftJustify);
   Sp.AddField(' 00.00.0000 ','Sale Date',taCenter);
   Sp.AddField('XXXXXXXX','Ship VIA',taCenter);
   Sp.AddField('XXXXXXXX','Payment',taCenter);
   Sp.AddField('0000000000000','Price',taRightJustify);
   Sp.AddField('0000000000000','AmountPaid',taRightJustify);
   Sp.Style[tsHead].Font.Size:=-10;
   Sp.Style[tsHead].BackColor:=$00EFEFEF;
   Sp.Style[tsHead].Borders:=[boLeft,boRight,boTop];
   Sp.Style[tsHead].LineSpace:=1;
   Sp.Style[tsText].Font.Size:=-10;
   Sp.Style[tsText].BackColor:=$00EFEFEF;
   Sp.Style[tsText].Borders:=[boLeft,boRight,boBottom];
   Sp.Style[tsText].LineSpace:=1.2;
   Sp.Recalculate(-150); {15 mm from both paper edges}
end;

procedure Def3;
begin
   Sp.ClearFields;
   //note that first field will never be used (we will allways print
   //an empty string in it
   Sp.AddField('xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx','spacer',taLeftJustify);
   Sp.AddField('00000000','Part No',taLeftJustify);
   Sp.AddField('XXXXXXXXXXXXXXXXXXXXXXXX','Description',taLeftJustify);
   Sp.AddField('XXXXXX','QTY',taCenter);
   Sp.AddField('00000000000','List Price',taRightJustify);
   Sp.AddField('00000000000','Total',taRightJustify);
   Sp.Style[tsHead].Font.Size:=-9;
   Sp.Style[tsHead].BackColor:=clWhite;
   Sp.Style[tsHead].Borders:=[boBottom];
   Sp.Style[tsHead].LineSpace:=1.1;
   Sp.Style[tsText].Font.Size:=-9;
   Sp.Style[tsText].BackColor:=clWhite;
   Sp.Style[tsText].Borders:=[];
   Sp.Style[tsText].LineSpace:=1.1;
   Sp.Recalculate(-150); {15 mm from both paper edges}
end;

procedure Report_5(show:Boolean);
var
   q :TQuery;
   lastcompany,lastorder,lastitem:string;
   totalcompany,totalpaid:double;
begin
   q:=TQuery.Create(nil);
   q.Active:=False;
   q.DatabaseName:='DBDEMOS';
   q.SQL.Add('select * from customer a, orders b, items c, parts d');
   q.SQL.Add('where a.custno = b.custno');
   q.SQL.Add('  and b.orderno = c.orderno');
   q.SQL.Add('  and c.partno = d.partno');
   q.SQL.Add('order by a.company, orderno');

   q.Active:=True;

   //initialize sprint
   Sp:=form1.SPrint1;
   printer.Orientation:=poPortrait;
   Sp.BeginDoc;
   Sp.KEY:='When you purchase SPRINT you will insert received KEY here';
   Sp.ShowHeader:=False;
   //defaults change
   Sp.Style[tsSum].Font.Size:=-10;
   Sp.Style[tsSum].LineSpace:=3;
   //heading on the first page
   Sp.Style[tsDef1].Font.Name:='Arial';
   Sp.Style[tsDef1].Font.Size:=-32;
   Sp.Style[tsDef1].Font.Style:=[fsBold,fsItalic];
   Sp.Style[tsDef1].Font.Color:=clNavy;
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.Recalculate(0); {0 mm space between fields} 
   Sp.SetStyle(tsDef1);
   Sp.PrintField(2,'Customer/Orders Detailed Listing');
   Sp.SetStyle(tsText);
   Sp.CurrY:=Sp.CurrY+200;

   //query processing
   lastcompany:=''; lastorder:=''; lastitem:='';
   totalcompany:=0.0; totalpaid:=0.0;
   q.First;
   while q.Eof=False do begin
      if lastcompany<>q.FieldByName('Company').AsString then begin
         lastcompany:=q.FieldByName('Company').AsString;
         //sum orders
         if totalcompany<>0.0 then begin
            Def2;
            Sp.SetStyle(tsSum);
            Sp.Add([
               'Total: $'+floattostrf(totalcompany,ffFixed,15,2)+
               ', Paid: $'+floattostrf(totalpaid,ffFixed,15,2)
               ]);
            //does order balance or not?
            Sp.Canv.Font.Name:='Wingdings';
            Sp.Canv.Font.Size:=10;
            Sp.Canv.Font.Style:=[];
            if floattostrf(totalcompany,ffFixed,15,2)<>floattostrf(totalpaid,ffFixed,15,2) then begin
               Sp.PrintField(2,'');
            end else begin
               Sp.PrintField(2,'');
            end;
            totalcompany:=0.0; totalpaid:=0.0;
            Sp.SetStyle(tsText);
         end;
         //company data
         Def1;
         Sp.SetStyle(tsText);
         Sp.Add([
            q.FieldByName('Company').AsString,
            q.FieldByName('Contact').AsString,
            q.FieldByName('Phone').AsString,
            q.FieldByName('Fax').AsString,
            q.FieldByName('CustNo').AsString
            ]);
      end;
      if lastorder<>q.FieldByName('orderno').AsString then begin
         lastorder:=q.FieldByName('orderno').AsString;
         //
         Def2;
         Sp.SetStyle(tsHead);
         Sp.Add(['','Order No','Sale Date','Ship VIA','Payment','Price','Amount Paid']);
         //
         Sp.SetStyle(tsText);
         Sp.Add([
            '',
            q.FieldByName('orderno').AsString,
            q.FieldByName('saledate').AsString,
            q.FieldByName('shipvia').AsString,
            q.FieldByName('paymentmethod').AsString,
            '$'+floattostrf(q.FieldByName('itemstotal').Value,ffFixed,15,2),
            '$'+floattostrf(q.FieldByName('amountpaid').Value,ffFixed,15,2)
            ]);
         totalcompany:=totalcompany+q.FieldByName('itemstotal').Value;
         totalpaid:=totalpaid+q.FieldByName('amountpaid').Value;
         //
         Def3;
         Sp.SetStyle(tsHead);
         Sp.Add(['','Part No','Description','QTY','List Price','Total']);
         //
         Sp.SetStyle(tsText);
      end;
      //order items
         Sp.Add([
            '',
            q.FieldByName('partno').AsString,
            q.FieldByName('description').AsString,
            q.FieldByName('qty').AsString,
            '$'+floattostrf(q.FieldByName('listprice').Value,ffFixed,15,2),
            '$'+floattostrf(
               q.FieldByName('qty').Value*q.FieldByName('listprice').Value,
               ffFixed,15,2)
            ]);
      //
      q.Next;
   end;
   //sum last order
   Def2;
   Sp.SetStyle(tsSum);
   Sp.Add([
      'Total: $'+floattostrf(totalcompany,ffFixed,15,2)+
      ', Paid: $'+floattostrf(totalpaid,ffFixed,15,2)
      ]);
   Sp.Canv.Font.Name:='Wingdings';
   Sp.Canv.Font.Size:=10;
   Sp.Canv.Font.Style:=[];
   if floattostrf(totalcompany,ffFixed,15,2)<>floattostrf(totalpaid,ffFixed,15,2) then begin
      Sp.PrintField(2,'');
   end else begin
      Sp.PrintField(2,'');
   end;
   //print or preview?
   if show then Sp.ShowPreview else Sp.PrintAll;
   Sp.EndDoc;
   q.Active:=False;
   q.Free;
end;

end.
