//******************************************************
// SPRINT - Print & Preview engine for Delphi
// WWW.SMART.CO.YU
//******************************************************

unit report3;

interface

procedure Report_3(show:Boolean);

implementation

uses Main,Sprint,Graphics,SysUtils,Classes,DBTables,Printers;

procedure Report_3(show:Boolean);
var
   q :TQuery;
   Sp:TSprint;
   lastletter:string;
begin
   q:=TQuery.Create(nil);
   q.Active:=False;
   q.DatabaseName:='DBDEMOS';
   q.SQL.Add('select * from customer a order by a.company');
   q.Active:=True;

   //1..initialize sprint
   Sp:=form1.SPrint1;
   printer.Orientation:=poPortrait;
   Sp.BeginDoc;
   Sp.KEY:='When you purchase SPRINT you will insert received KEY here';
   //2..heading on the first page
   Sp.Style[tsDef1].Font.Name:='Arial';
   Sp.Style[tsDef1].Font.Size:=-32;
   Sp.Style[tsDef1].Font.Style:=[fsBold,fsItalic];
   Sp.Style[tsDef1].Font.Color:=clNavy;
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.AddField(' ',' ',taCenter);
   Sp.Recalculate(0); {0 mm space between fields}
   Sp.SetStyle(tsDef1);
   Sp.PrintField(2,'Grouped Customer Listing');
   Sp.SetStyle(tsText);
   Sp.CurrY:=Sp.CurrY+200;
   //3..in this report we will use tsDef2 style also
   Sp.Style[tsDef2].Font.Name:='Arial';
   Sp.Style[tsDef2].Font.Size:=-18;
   Sp.Style[tsDef2].Font.Style:=[fsBold,fsItalic];
   Sp.Style[tsDef2].Font.Color:=clNavy;
   Sp.Style[tsHead].LineSpace:=1.5;
   //4..query fields
   Sp.ClearFields;
   Sp.AddField('XXXXXXXXXXXXXXXXXXXXXXX','Company',taLeftJustify);
   Sp.AddField('XXXXXXXXXXXXXXXXXXXX','Contact',taLeftJustify);
   Sp.AddField('XXXXXXXXXXX','Phone',taLeftJustify);
   Sp.AddField('XXXXXXXXXXX','Fax',taLeftJustify);
   Sp.AddField('CustNo','Cust.no',taCenter);
   Sp.Recalculate(-150); {15 mm from both paper edges}

   //5..database processing
   lastletter:=' ';
   q.First;
   while q.Eof=False do begin
      if copy(q.FieldByName('Company').AsString,1,1)<>lastletter then begin
         lastletter:=copy(q.FieldByName('Company').AsString,1,1);
         Sp.SetStyle(tsDef2);
         Sp.Add([lastletter]);
         Sp.SetStyle(tsText);
      end;
      Sp.Add([
         q.FieldByName('Company').AsString,
         q.FieldByName('Contact').AsString,
         q.FieldByName('Phone').AsString,
         q.FieldByName('Fax').AsString,
         q.FieldByName('CustNo').AsString                  
         ]);
      q.Next;
   end;

   //6..print or preview?
   if show then Sp.ShowPreview else Sp.PrintAll;
   Sp.EndDoc;
   q.Active:=False;
   q.Free;
end;

end.
