//******************************************************
// SPRINT - Print & Preview engine for Delphi
// WWW.SMART.CO.YU
//******************************************************

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Buttons, ShellAPI,
  Report1,Report2,Report3,Report4,Report5,Report6,Report7, SPrint;

type
  TForm1 = class(TForm)
    POZADINA: TImage;
    Image1: TImage;
    Rep1: TSpeedButton;
    Rep2: TSpeedButton;
    Rep3: TSpeedButton;
    Rep4: TSpeedButton;
    Rep5: TSpeedButton;
    Rep6: TSpeedButton;
    Rep7: TSpeedButton;
    Preview: TButton;
    Print: TButton;
    ExitBtn: TBitBtn;
    TCaption: TLabel;
    Shape1: TShape;
    Shape2: TShape;
    TDetail: TLabel;
    www: TButton;
    Registration: TButton;
    Help: TBitBtn;
    SPrint1: TSPrint;
    procedure FormPaint(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure SelectReport(Sender: TObject);
    procedure Text(i:integer);
    procedure FormShow(Sender: TObject);
    procedure HelpClick(Sender: TObject);
    procedure wwwClick(Sender: TObject);
    procedure RegistrationClick(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
    procedure PrintClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormPaint(Sender: TObject);
var
   X,Y,sx1,sy1,sx2,sy2: integer;
begin
   if POZADINA.Width or POZADINA.Height = 0 then Exit;
   for X := 0 to Round(Width/POZADINA.Width) do begin
      for Y := 0 to Round(Height/POZADINA.Height) do begin
          sx1:=X*POZADINA.Width;
          sy1:=Y*POZADINA.Height;
          sx2:=sx1+POZADINA.Width;
          sy2:=sy1+POZADINA.Height;
          canvas.CopyRect( rect(sx1,sy1,sx2,sy2),
                           POZADINA.canvas,
                           rect(0,0,POZADINA.Width,POZADINA.Height));
      end;
   end;
end;

procedure TForm1.ExitBtnClick(Sender: TObject);
begin
   Application.Terminate;
end;

procedure TForm1.Text(i:integer);
begin
   if i=-1 then begin
      TCaption.Caption:='How to register?';
      TDetail.Caption:=
         'All registering and pricing related questions are'#13+
         'answered in the REGISTERING chapter of user'+chr(39)+'s manual.';
   end;
   if i=0 then begin
      TCaption.Caption:='Welcome to SPRINT Demo';
      TDetail.Caption:=
         'This demo software will demonstrate how SPRINT engine can be used to print various reports with Delphi.'#13#13+
         'With SPRINT any printing can be done with ease.'#13#13+
         'Choose report type (left), and then click preview or print to see results.'#13#13+
         'HAVE A NICE PRINT';
   end;
   if i=1 then begin
      TCaption.Caption:='Low level drawing demo report';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to work with margins'#13+
         '* how to draw lines'#13+
         '* how to draw areas'#13+
         '* how to print text with low level functions'#13+
         '* how to print bitmap or vector pictures'#13+
         '* how to draw on SPrintCanvas'#13+
         '* how to color your reports'#13#13+
         'Source: Report1.pas';
   end;
   if i=2 then begin
      TCaption.Caption:='Simple multi-column report';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to define styles'#13+
         '* how to define report fields'#13+
         '* how to use high level functions'#13+
         '* how easy report creating can be'#13#13+
         'Source: Report2.pas'#13#13+
         '(BDE + DBDEMOS required)';
   end;
   if i=3 then begin
      TCaption.Caption:='Simple multi-column, grouped report';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to define styles'#13+
         '* how to define report fields'#13+
         '* how to use high level functions'#13#13+
         '+ how to combine styles'#13#13+
         'Source: Report3.pas'#13#13+
         '(BDE + DBDEMOS required)';
   end;
   if i=4 then begin
      TCaption.Caption:='Multi-column, multi-group report';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to define styles'#13+
         '* how to define report fields'#13+
         '* how to use high level functions'#13+
         '* how to combine styles'#13#13+
         '+ how to create unlimited grouping depth'#13#13+
         'Source: Report4.pas'#13#13+
         '(BDE + DBDEMOS required)';
   end;
   if i=5 then begin
      TCaption.Caption:='We really made this one complicated';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to define styles'#13+
         '* how to define report fields'#13+
         '* how to use high level functions'#13+
         '* how to combine styles'#13+
         '* how to create unlimited grouping depth'#13#13+
         '+ how to think creative in order to create good-looking documents'#13#13+
         'Source: Report5.pas'#13#13+
         '(BDE + DBDEMOS required)';
   end;
   if i=6 then begin
      TCaption.Caption:='Let'+chr(39)+'s print our own documentation';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to envelop SPRINT engine with even more'#13+
         'sophisticated functions'#13+
         '* how to print formated (RTF) documents'#13#13+
         'Source: Report6.pas';
   end;
   if i=7 then begin
      TCaption.Caption:='Unleashed SPRINT power!';
      TDetail.Caption:=
         'NO LIMITS... EXCEPT YOUR IMAGINATION'#13#13+
         'Source: Report7.pas';
   end;
   if i<=0 then begin
      Rep1.AllowAllUp:=True;
      Rep1.Down:=False;
      Rep2.Down:=False;
      Rep3.Down:=False;
      Rep4.Down:=False;
      Rep5.Down:=False;
      Rep6.Down:=False;
      Rep7.Down:=False;
      Rep1.AllowAllUp:=False;
   end;
   Preview.Enabled:=(i>0);
   Print.Enabled:=(i>0);
end;

procedure TForm1.SelectReport(Sender: TObject);
begin
   if TSpeedButton(Sender).Name='Rep1' then text(1);
   if TSpeedButton(Sender).Name='Rep2' then text(2);
   if TSpeedButton(Sender).Name='Rep3' then text(3);
   if TSpeedButton(Sender).Name='Rep4' then text(4);
   if TSpeedButton(Sender).Name='Rep5' then text(5);
   if TSpeedButton(Sender).Name='Rep6' then text(6);
   if TSpeedButton(Sender).Name='Rep7' then text(7);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
   Text(0);
end;

procedure TForm1.HelpClick(Sender: TObject);
begin
   Text(0);
end;

procedure TForm1.wwwClick(Sender: TObject);
var WWWPATH:string;
begin
   WWWPATH:='www.smart.co.yu';
   if ShellExecute(  Application.Handle,
                     PChar('open'),
                     PChar(WWWPATH),
                     PChar(''),nil,SW_NORMAL) < 33 then
   if ShellExecute(  Application.Handle,PChar('open'),
                     PChar('netscape.exe'),
                     PChar(WWWPATH),
                     nil,SW_NORMAL) < 32 then
   if ShellExecute(  Application.Handle,PChar('open'),
                     PChar('iexplore.exe'),
                     PChar(WWWPATH),
                     nil,SW_NORMAL) < 32 then
   showmessage ('Error: starting internet browser. Go to WWW.SMART.CO.YU manually.');
end;

procedure TForm1.RegistrationClick(Sender: TObject);
begin
   Text(-1);
end;

procedure TForm1.PreviewClick(Sender: TObject);
begin
   if Rep1.Down then Report_1(True);
   if Rep2.Down then Report_2(True);
   if Rep3.Down then Report_3(True);
   if Rep4.Down then Report_4(True);
   if Rep5.Down then Report_5(True);
   if Rep6.Down then Report_6(True);
   if Rep7.Down then Report_7(True);
end;

procedure TForm1.PrintClick(Sender: TObject);
begin
   if Rep1.Down then Report_1(False);
   if Rep2.Down then Report_2(False);
   if Rep3.Down then Report_3(False);
   if Rep4.Down then Report_4(False);
   if Rep5.Down then Report_5(False);
   if Rep6.Down then Report_6(False);
   if Rep7.Down then Report_7(False);
end;

end.
       