unit demo_;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, MFTools, Buttons, ExtCtrls,
  MFSmPlay, MPlayer2;

const
   DEMOFILE = 'demo.mpeg';

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Edit1: TEdit;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    SpeedButton1: TSpeedButton;
    CheckBox1: TCheckBox;
    Button2: TButton;
    GroupBox2: TGroupBox;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    GroupBox3: TGroupBox;
    StaticText1: TStaticText;
    TrackBar1: TTrackBar;
    CheckBox2: TCheckBox;
    SmartMediaPlayer1: TSmartMediaPlayer;
    procedure TrackBar1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure SmartMediaPlayer1NewMediaSize(Sender: TObject; NewMediaWidth,
      NewMediaHeight, Zoom: Integer; var CanResize: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
   SmartMediaPlayer1.DisplayZoom := TrackBar1.Position;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   iSlash : integer;
begin
   iSlash := FindPosLastCar ('\', application.Exename);
   if iSLash > 0 then begin
      OpenDialog1.InitialDir := Copy (Application.ExeName, 1, iSlash);
      Edit1.Text := Copy (Application.ExeName, 1, iSlash) + DEMOFILE;
   end
   else begin
      OpenDialog1.InitialDir := '';
      Edit1.Text := DEMOFILE;
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   SmartMediaPlayer1.FileName := Edit1.text;
   SmartMediaPlayer1.Open;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   OpenDialog1.FileName := '*.mpg;*.mpeg;*.avi;*.mp3;*.wav';
   if OpenDialog1.Execute then begin
      Edit1.Text := OpenDialog1.FileName;
   end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
   case CheckBox1.Checked of
      true : begin
         SmartMediaPlayer1.DisplayAlign := alignClient;
         GroupBox2.visible := false;
      end;
      false: begin
         SmartMediaPlayer1.DisplayAlign := alignNone;
         GroupBox2.visible := true;
      end;
   end;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
   SmartMediaPlayer1.DisplayHPos := TAdvMpHPos (RadioGroup1.ItemIndex);
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
   SmartMediaPlayer1.DisplayVPos := TAdvMpVPos (RadioGroup2.ItemIndex);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   SmartMediaPlayer1.Close;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
   SmartMediaPlayer1.Truncate := CheckBox2.Checked;
end;

procedure TForm1.SmartMediaPlayer1NewMediaSize(Sender: TObject;
  NewMediaWidth, NewMediaHeight, Zoom: Integer; var CanResize: Boolean);
begin
   StaticText1.Caption := inttostr (Zoom) + '%';
end;

end.
