unit TestEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, StylEdit, ExtCtrls, MonEdit, Spin, ComCtrls, Mask, Buttons;

type

  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    N8MoneyEdit1: TN8MoneyEdit;
    Label1: TLabel;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    Edit1: TEdit;
    SpinEdit1: TSpinEdit;
    Label4: TLabel;
    Label5: TLabel;
    SpinEdit2: TSpinEdit;
    ComboBox1: TComboBox;
    Label6: TLabel;
    ComboBox2: TComboBox;
    Label7: TLabel;
    SpeedButton1: TSpeedButton;
    SpinEdit3: TSpinEdit;
    procedure FormCreate(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
  private
    DoChange:Boolean;
    procedure CheckAll;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  CheckAll;
end;

procedure TForm1.CheckAll;
begin
  DoChange:=False;
  with N8MoneyEdit1 do
  begin
    SpinEdit3.Value:=mDecimals;
    Edit2.Text:=mCurString;
    Edit1.Text:=mThSeparator;
    SpeedButton1.Down:=mOSDefault;
    SpinEdit1.Value:=Round(MinValue);
    SpinEdit2.Value:=Round(MaxValue);
    ComboBox1.ItemIndex:=mCurFormat;
    ComboBox2.ItemIndex:=mNegCurFormat;
  end;
  DoChange:=True;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
  if DoChange then
  begin
    N8MoneyEdit1.mCurString:=Edit2.Text;
    CheckAll;
  end;
end;

procedure TForm1.Edit1Change(Sender: TObject);
var
  s:string;
begin
  if DoChange then
  begin
    s:=Edit1.Text;
    if Length(s)>0 then N8MoneyEdit1.mThSeparator:=s[1]
    else N8MoneyEdit1.mThSeparator:=#0;
    CheckAll;
  end;
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  if DoChange then N8MoneyEdit1.MinValue:=SpinEdit1.Value;
  CheckAll;
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
begin
  if DoChange then
  begin
    N8MoneyEdit1.MaxValue:=SpinEdit2.Value;
    CheckAll;
  end;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  if DoChange then N8MoneyEdit1.mCurFormat:=ComboBox1.ItemIndex;
  CheckAll;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
  if DoChange then
  begin
    N8MoneyEdit1.mNegCurFormat:=ComboBox2.ItemIndex;
    CheckAll;
  end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if DoChange then
  begin
    N8MoneyEdit1.mOSDefault:=SpeedButton1.Down;
    CheckAll;
  end;
end;

procedure TForm1.SpinEdit3Change(Sender: TObject);
begin
  if DoChange then
  begin
    N8MoneyEdit1.mDecimals:=SpinEdit3.Value;
    CheckAll;
  end;
end;

end.
