unit _main_cursor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, ImgList, ExtDlgs,
  Menus, ActnList, StdCtrls, Spin,
  ExtEdit, Buttons, DrawComboBox,
  SchemeVisual,
  SchemeVisualCursor,
  SchemeObjects,
  SchemeObjectsExt,
  Animate, GIFCtrl;

type
  TFormMain = class(TForm)
    StatusBar1: TStatusBar;
    PageControl1: TPageControl;
    Panel1: TPanel;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    OpenPictureDialog1: TOpenPictureDialog;
    ImageList1: TImageList;
    ActionList1: TActionList;
    ActionCenter: TAction;
    ActionZoomIn: TAction;
    ActionZoomOut: TAction;
    ActionZoomActual: TAction;
    ActionPictuteA: TAction;
    PopupMenu1: TPopupMenu;
    ZoomIn1: TMenuItem;
    ZoomOut1: TMenuItem;
    ActionZoomActual1: TMenuItem;
    N2: TMenuItem;
    Center1: TMenuItem;
    TabSheet2: TTabSheet;
    Panel2: TPanel;
    CheckBox1: TCheckBox;
    FloatEdit3: TFloatEdit;
    Label2: TLabel;
    Label38: TLabel;
    FloatEdit9: TFloatEdit;
    Label3: TLabel;
    Panel3: TPanel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    CheckBox2: TCheckBox;
    FloatEdit4: TFloatEdit;
    FloatEdit5: TFloatEdit;
    BitBtn10: TBitBtn;
    SchemeVisualEditorCursor1: TSchemeVisualEditorCursor;
    SchemeVisualEditorCursor2: TSchemeVisualEditorCursor;
    SchemeDataEditorCursor1: TSchemeDataEditorCursor;
    Splitter1: TSplitter;
    ImageListImages: TImageList;
    ActionResized: TAction;
    N1: TMenuItem;
    ResizeobjectOnOff1: TMenuItem;
    ActionSelected: TAction;
    SelectedOnOff1: TMenuItem;
    Label1: TLabel;
    SpinEdit3: TSpinEdit;
    CheckBox3: TCheckBox;
    ActionReload: TAction;
    Reload1: TMenuItem;
    N3: TMenuItem;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ActionLoadFromFile: TAction;
    ActionSaveToFile: TAction;
    Load1: TMenuItem;
    Save1: TMenuItem;
    N4: TMenuItem;
    ActionAddPoint: TAction;
    ActionDeletePoint: TAction;
    N5: TMenuItem;
    Addpoint1: TMenuItem;
    Deletepoint1: TMenuItem;
    CheckBox4: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure SchemeDataEditorCursor1MouseDown(Sender, VisualSender: TObject;
      Button: TMouseButton; Shift: TShiftState;
      AObject: TSchemeObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure ActionCenterExecute(Sender: TObject);
    procedure ActionZoomInExecute(Sender: TObject);
    procedure ActionPictuteAExecute(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure FloatEdit3Change(Sender: TObject);
    procedure FloatEdit9Change(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FloatEdit4Change(Sender: TObject);
    procedure FloatEdit5Change(Sender: TObject);
    procedure SchemeVisualEditorCursor1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SchemeVisualEditorCursor1MouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure SchemeVisualEditorCursor1MouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SchemeDataEditorCursor1ObjectCanDrop(Sender,
      VisualSender: TObject; Shift: TShiftState;
      AObject: TSchemeObject; X, Y, OffsetX, OffsetY: Extended;
      var AEnabled: Boolean);
    procedure ActionResizedExecute(Sender: TObject);
    procedure ActionSelectedExecute(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure SchemeDataEditorCursor1ObjectPaint(Sender,
      VisualSender: TObject; AObject: TSchemeObject;
      AZoom: Extended; ACanvas: TCanvas; AParam: Integer);
    procedure ActionReloadExecute(Sender: TObject);
    procedure ActionLoadFromFileExecute(Sender: TObject);
    procedure ActionSaveToFileExecute(Sender: TObject);
    procedure ActionAddPointExecute(Sender: TObject);
    procedure ActionDeletePointExecute(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure SchemeDataEditorCursor1AfterLoading(Sender: TObject;
      AStrings: TStrings);
    procedure SchemeDataEditorCursor1BeforeLoading(Sender: TObject;
      AStrings: TStrings);
    procedure SchemeDataEditorCursor1LoadingProgress(Sender: TObject;
      AStrings: TStrings; ACurrentIndex: Integer);
  private
    pCurrentPoint:TPoint;
    pSelectedObject:TSchemeObject;            //  
    pSelectedSchemeVisualEditor:TSchemeVisualEditorCursor; //   
    procedure CreateAll;
    procedure CreateLayer(AId:integer);
    procedure SetLayerParams(AId:integer);
    procedure CreateZonenObjects;
    procedure CreateSmallObjects;
    procedure CreateTextObjects;
    procedure CreateLineObjects;
    procedure CreatePolylineObjects;
    procedure CreatePolylineObjects2;
    procedure CreatePictureObjects;
    procedure CreateInternalPictureObjects;
    procedure SetCurrentPoint(X,Y:integer);
    procedure SetSelectedObject(Value:TObject);
    procedure SetSelectedSchemeVisual(Value:TObject);
    procedure UpdateStatusBarInfo;
    procedure TestEnabledActions;
  public
  end;

var
  FormMain: TFormMain;

//================================================================
implementation
{$R *.DFM}
uses _cv;
const

  ciZoneLayerId       = 0;
  ciSmallLayerId      = 1;
  ciBmpLayerId        = 2;
  ciTextLayerId       = 4;
  ciArrowLayerId      = 5;
  ciEmfLayerId        = 6;

  ciZoneW         = 150;
  ciZoneH         = 150;

  ciCenterW       = 150;
  ciCenterH       = 150;

  ciSmallW        = ciCenterW div 10;
  ciSmallH        = ciCenterH div 10;

  ciBmpW          = 32;
  ciBmpH          = 32;

  ciTextH         = 14;

//-------------------------- Form -------------------------

procedure TFormMain.FormCreate(Sender: TObject);
begin
  with Constraints do
  begin
    MinHeight:=Height;
    MinWidth:=Width;
  end;
  crWindowZoomDeltaB:=1;
  StatusBar1.Panels[1].Text := Format('Zoom A:%.1f  B:%.1f',
    [SchemeVisualEditorCursor1.Zoom,
    SchemeVisualEditorCursor2.Zoom]);
  TestEnabledActions;
  CreateAll;
  WindowState:=wsMaximized;
end;

//-------------------- Common -----------------------

procedure TFormMain.CreateAll;
begin
  with SchemeDataEditorCursor1 do
  try
    BeginUpdate;
    SetSelectedObject(nil);
    CreateZonenObjects;
    CreateSmallObjects;
    CreateTextObjects;
    CreateLineObjects;
    //CreatePolylineObjects;
    CreatePolylineObjects2;
    CreatePictureObjects;
    CreateInternalPictureObjects;
  finally
    EndUpdate;
    RepaintAllVisualControls;
  end;
end;

procedure TFormMain.CreateLayer(AId:integer);
begin
  with SchemeDataEditorCursor1 do
  begin
    try
      LayerDelete(AId);
    except
    end;
    LayerAdd(AId);
    SetLayerParams(AId);
  end;
end;

procedure TFormMain.SetLayerParams(AId:integer);
begin
  with SchemeDataEditorCursor1 do
  try
    //BeginUpdate;     //if necessary
    with Layer[AId] do
    begin
      MinZoomForText:=2;//10;
      EnabledZoomForText:=true;//false;
      SetAllStateColors(aclStateColors);
    end;
  finally
    //EndUpdate;
    //RepaintAllVisualControls;
  end;
end;

procedure TFormMain.CreateZonenObjects;
begin
  with SchemeDataEditorCursor1 do
  begin
    CreateLayer(ciZoneLayerId);
    //--- create 0 zone:
    ObjectAddPolygon(ciZoneLayerId,
      0, //Id
      [Point(ciZoneW,0),Point(ciZoneW,ciZoneH),Point(0,ciZoneH)],//Points array
      0, //State
      bsDiagCross,//TBrushStyle;
      '',//Text string;
      Point(0,0));//Text string point
    Layer[ciZoneLayerId].Items[0].HintString:=
      'TSchemePolygon'#13'Object Id : 0'#13'State : 0';
    //--- create 1 zone:
    ObjectAddPolygon(ciZoneLayerId, 1,
      [Point(ciZoneW+ciCenterW,0),
        Point(ciZoneW+ciCenterW+ciZoneW,ciZoneH),
        Point(ciZoneW+ciCenterW,ciZoneH)],//Points array
      1, bsDiagCross, '', Point(0,0));
    Layer[ciZoneLayerId].Items[1].HintString:=
      'TSchemePolygon'#13'Object Id : 1'#13'State : 1';
    //--- create 2 zone:
    ObjectAddPolygon(ciZoneLayerId, 2,
      [Point(0,ciZoneH+ciCenterH),
        Point(ciZoneW,ciZoneH+ciCenterH),
        Point(ciZoneW,ciZoneH+ciCenterH+ciZoneH)],//Points array
      2, bsDiagCross, '', Point(0,0));
    Layer[ciZoneLayerId].Items[2].HintString:=
      'TSchemePolygon'#13'Object Id : 2'#13'State : 2';
    //--- create 3 zone:
    ObjectAddPolygon(ciZoneLayerId, 3,
      [Point(ciZoneW+ciCenterW,ciZoneH+ciCenterH),
        Point(ciZoneW+ciCenterW+ciZoneW,ciZoneH+ciCenterH),
        Point(ciZoneW+ciCenterW,ciZoneH+ciCenterH+ciZoneH)],
      3, bsDiagCross, '', Point(0,0));
    Layer[ciZoneLayerId].Items[3].HintString:=
      'TSchemePolygon'#13'Object Id : 3'#13'State : 3';
  end;
end;

procedure TFormMain.CreateSmallObjects;
var i,j,k:integer;
begin
  k:=0;
  with SchemeDataEditorCursor1 do
  begin
    CreateLayer(ciSmallLayerId);
    for i:=0 to 3 do
      for j:=0 to 4 do
      begin
        with ObjectAddShape(ciSmallLayerId,k,
          Bounds(
            ciCenterW+random(9)*(ciSmallW),
            ciCenterH+random(9)*(ciSmallH),
            ciSmallW,ciSmallH),
          i,stRectangle) do
        begin
          Text:=IntToStr(k);
          HintString:=Format('TSchemeShape'#13'Object Id : %d'#13'State : %d',[k,i]);
        end ;
        (* or:
        with Layer[ciSmallLayerId].Items[k] do
        begin
          ...
        end;
        *)
        Inc(k);
      end;
  end;
end;

procedure TFormMain.CreateInternalPictureObjects;
var i,j,k,d:integer;
begin
  k:=0;
  with SchemeDataEditorCursor1 do
  begin
    CreateLayer(ciBmpLayerId);
    for i:=0 to 3 do
      for j:=0 to 3 do
      begin
        d:=i-1;
        if d<0 then d:=3;
        ObjectAddDirect(ciBmpLayerId,
          TSchemeInternalPicture.Create(
            k,                 //Object Id
            Bounds(
              ciCenterW+random(9)*(ciBmpW),
              ciCenterH+random(9)*(ciBmpH),
              ciBmpW,ciBmpH),
            i,                 //State
            i+(j*4),           //Image index in ImageListImages
            ImageListImages,   //ImageList with real images
            d+(j*4),           //SelecImage index in ImageListImages
            ImageListImages    //ImageList with selected images, maybe nil
            ));
        Layer[ciBmpLayerId].Items[k].HintString:=
          Format('TSchemeInternalPicture'#13'Object Id : %d'#13'State : %d',[k,i]);
        Inc(k);
      end;
  end;
end;

procedure TFormMain.CreateTextObjects;
var i,j,k:integer;
  pText:TSchemeText;
begin
  k:=0;
  with SchemeDataEditorCursor1 do
  begin
    CreateLayer(ciTextLayerId);
    for i:=0 to 3 do
      for j:=0 to 2 do
      begin
        pText:=TSchemeText.Create
          (k,
          Point(                       //Point
            random(9)*(ciBmpW),
            ciCenterH+random(9)*(ciBmpH)),
          i,                           //State
          'Simple'#13'Text');
        ObjectAddDirect(ciTextLayerId,pText);
        pText.HintString:=
          Format('TSchemeText'#13'Object Id : %d'#13'State : %d',[k,i]);
        Inc(k);
      end;
  end;
end;

procedure TFormMain.CreateLineObjects;
var i,k:integer;
  pArrow:TSchemeLine;
begin
  k:=0;
  with SchemeDataEditorCursor1 do
  begin
    CreateLayer(ciArrowLayerId);
    for i:=0 to 3 do
    begin
      pArrow:=TSchemeLine.CreateExt(
        k,                           //Object Id
        ciCenterW + (ciCenterW div 5)*(i+1),
        ciCenterH div 4,             //Start point
        ciCenterW + (ciCenterW div 5)*(i+1),
        (ciCenterH div 4)*3,         //End point
        i+1,                         //Width
        i);                          //State
      ObjectAddDirect(ciArrowLayerId,pArrow);
      pArrow.HintString:=
        Format('TSchemeLine'#13'Object Id : %d'#13'State : %d',[k,i]);
      if i=1 then pArrow.VisibleArrow:=true;
      Inc(k);
    end;
  end;
end;

procedure TFormMain.CreatePolylineObjects;
var i,k:integer;
  pPolyline:TSchemePolyline;
begin
  k:=0;
  with SchemeDataEditorCursor1 do
  begin
    CreateLayer(ciArrowLayerId);
    for i:=0 to 3 do
    begin
      pPolyline:=TSchemePolyline.Create(
        k,                             //Object Id
        [                              //Point array
        Point(ciCenterW + (ciCenterW div 5)*(i+1),
          ciCenterH div 4),
        Point(ciCenterW + (ciCenterW div 5)*(i+1),
          (ciCenterH div 4)*3)
        ],
        i,                             //Width
        i,                             //State
        IntToStr(k),                   //Text
        Point(ciCenterW + (ciCenterW div 5)*(i+1),
          ciCenterH div 4));           //Point for text
      ObjectAddDirect(ciArrowLayerId,pPolyline);
      pPolyline.HintString:=
        Format('TSchemePolyline'#13'Object Id : %d'+
          #13'State : %d'#13'Width : %d',[k,i,i]);
      Inc(k);
    end;
  end;
end;

procedure TFormMain.CreatePolylineObjects2;
var k:integer;
  pPolyline:TSchemePolyline;
  p:TPoint;
begin
  p:=Point(round(ciCenterW*2.7),ciCenterH div 2);
  k:=0;
  with SchemeDataEditorCursor1 do
  begin
    if LayerExists(ciArrowLayerId) then
      k:=Layer[ciArrowLayerId].GetObjectMaxId + 1
    else CreateLayer(ciArrowLayerId);
    pPolyline:=TSchemePolyline.Create(
      k,                             //Object Id
      [p,                            //Point array
      Point(p.x+20,p.y-20),
      Point(p.x+50,p.y-20),
      Point(p.x+70,p.y)],
      1,                             //Width
      0,                             //State
      IntToStr(k),                   //Text
      p);                            //Point for text
    ObjectAddDirect(ciArrowLayerId,pPolyline);
    pPolyline.Resized:=true;
    pPolyline.Pen.Width:=3;
    pPolyline.VisibleArrow:=true;
    pPolyline.HintString:=
      Format('TSchemePolyline'#13'Object Id : %d'#13'State : %d',[k,0]);
  end;
end;

{$R _WMF.RES}

procedure TFormMain.CreatePictureObjects;
var
  i,k:integer;
  p:TSchemePicture;
  ps:TResourceStream;
begin
  k:=0;
  with SchemeDataEditorCursor1 do
  begin
    CreateLayer(ciEmfLayerId);
    for i:=0 to 2 do
    try
      p:=TSchemePicture.Create(
        k,                //Object Id
        Bounds(
          random(9)*(ciBmpW),
          ciCenterH+random(9)*(ciBmpH),
          ciBmpW*2,ciBmpH*2),
        i+1);            //State
      ps:=TResourceStream.Create(Hinstance,'WMF_'+IntToStr(i+1),'RT_RCDATA');
      p.Picture.MetaFile.LoadFromStream(ps);  //loading picture from _EMF.RES
      p.HintString:=
        Format('TPictureObject'#13'Object Id : %d'#13'State : %d',[k,i]);
      ObjectAddDirect(ciEmfLayerId,p);
      Inc(k);
    finally
      ps.Free;
    end;
  end;
end;

procedure TFormMain.SetCurrentPoint(X,Y:integer);
begin
  pCurrentPoint.X:=X;
  pCurrentPoint.Y:=Y;
end;

procedure TFormMain.UpdateStatusBarInfo;
var s:string;
begin
  s:='';
  if pSelectedObject<>nil then
  with pSelectedObject do
  begin
    s:=Format('For selected object: Layer Id: %d   Object Id: %d    State:%d    Type: %s',
      [Layer.Id,Id,State,ClassName]);
  end;
  StatusBar1.Panels[2].Text:=s;
end;

procedure TFormMain.SetSelectedObject(Value:TObject);
begin
  if pSelectedObject=Value then exit;
  pSelectedObject:=TSchemeObject(Value);
  UpdateStatusBarInfo;
  TestEnabledActions;
end;

procedure TFormMain.SetSelectedSchemeVisual(Value:TObject);
begin
  pSelectedSchemeVisualEditor:=TSchemeVisualEditorCursor(Value);
end;

procedure TFormMain.TestEnabledActions;
var b:boolean;
begin
  b := pSelectedObject<>nil;
  ActionResized.Enabled:=b;
  ActionSelected.Enabled:=b;
  b := (pSelectedObject is TSchemePolygon);
  ActionAddPoint.Enabled:=b;
  ActionDeletePoint.Enabled:=b;
end;

procedure TFormMain.PopupMenu1Popup(Sender: TObject);
var p:TPoint;
begin
  GetCursorPos(p);
  p:=pSelectedSchemeVisualEditor.ScreenToClient(p);
  SetCurrentPoint(p.x,p.y);
end;

//--------------------------- Mouse -------------------------

procedure TFormMain.SchemeVisualEditorCursor1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin  // MouseDown
  SetSelectedObject(nil);          //clear old selections
  SetSelectedSchemeVisual(Sender); //window Right or Left
  SetCurrentPoint(X,Y);
end;

procedure TFormMain.SchemeDataEditorCursor1MouseDown(Sender,
  VisualSender: TObject; Button: TMouseButton; Shift: TShiftState;
  AObject: TSchemeObject);
begin //SchemeData   Mouse Down  -> Object has selected!
  SetSelectedObject(AObject);
end;

procedure TFormMain.SchemeVisualEditorCursor1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var a,b:extended;
begin //Mouse Move
  SetCurrentPoint(0,0);
  a:=x; b:=y;
  TSchemeVisual(Sender).TransformZoomAndOriginXYExt(a,b);//get real
  StatusBar1.Panels[0].Text := Format('%.2f   %.2f',[a,b]);
end;

procedure TFormMain.SchemeVisualEditorCursor1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin //Mouse Up
end;

//------------------ Actions --------------------------

procedure TFormMain.ActionCenterExecute(Sender: TObject);
var
  p,p2:TSchemeVisual;
  x,y:integer;
begin //Set centre in others windows
  x:=pCurrentPoint.x;
  y:=pCurrentPoint.y;
  pSelectedSchemeVisualEditor.TransformZoomAndOriginXY(x,y);
  if pSelectedSchemeVisualEditor=SchemeVisualEditorCursor1 then
    p:=SchemeVisualEditorCursor2
  else
    p:=SchemeVisualEditorCursor1;
  p.SetCenterToPoint(Point(X,Y));
end;

procedure TFormMain.ActionZoomInExecute(Sender: TObject);
var
  delta:extended;
  x,y:integer;
  bmovetozenter:boolean;
begin// Zoom
  bmovetozenter:=(pCurrentPoint.x<>0)and(pCurrentPoint.y<>0);
  if bmovetozenter then
  begin //center
    x:=pCurrentPoint.x;
    y:=pCurrentPoint.y;
    pSelectedSchemeVisualEditor.TransformZoomAndOriginXY(x,y);
  end;
  if pSelectedSchemeVisualEditor=SchemeVisualEditorCursor1 then
    delta:=crWindowZoomDeltaA;
  if pSelectedSchemeVisualEditor=SchemeVisualEditorCursor2 then
    delta:=crWindowZoomDeltaB;
  if (TAction(Sender)=ActionZoomOut) then
    delta:=-delta;
  if (TAction(Sender)=ActionZoomActual) then
    delta:=0;
  if delta=0 then pSelectedSchemeVisualEditor.Zoom:=1
  else pSelectedSchemeVisualEditor.Zoom:=pSelectedSchemeVisualEditor.Zoom+delta;
  if bmovetozenter then
  begin //set center
    pSelectedSchemeVisualEditor.SetCenterToPoint(Point(x,y));
  end;
  StatusBar1.Panels[1].Text := Format('Zoom A:%.1f  B:%.1f',
    [SchemeVisualEditorCursor1.Zoom,
    SchemeVisualEditorCursor2.Zoom]);
end;

procedure TFormMain.ActionPictuteAExecute(Sender: TObject);
begin //Picture
  with OpenPictureDialog1 do
  begin
    if not OpenPictureDialog1.Execute then exit;
    SchemeVisualEditorCursor1.Picture.LoadFromFile(FileName);
    SchemeVisualEditorCursor2.Picture.LoadFromFile(FileName);
  end;
end;


//------------------ Page: Windows --------------------------

procedure TFormMain.CheckBox1Click(Sender: TObject);
begin //Enabled editing Window A
  SchemeVisualEditorCursor1.EditEnabled:=CheckBox1.Checked;
end;

procedure TFormMain.FloatEdit3Change(Sender: TObject);
begin //Min size for editing
  SchemeVisualEditorCursor1.MinZoomForResize:=FloatEdit3.Value;
end;

procedure TFormMain.FloatEdit9Change(Sender: TObject);
begin //Delta for zooming A window
  crWindowZoomDeltaA:=FloatEdit9.Value;
end;

procedure TFormMain.CheckBox2Click(Sender: TObject);
begin //Enabled editing Window B
  SchemeVisualEditorCursor2.EditEnabled:=CheckBox2.Checked;
end;

procedure TFormMain.FloatEdit4Change(Sender: TObject);
begin //Min size for editing
  SchemeVisualEditorCursor2.MinZoomForResize:=FloatEdit4.Value;
end;

procedure TFormMain.FloatEdit5Change(Sender: TObject);
begin //Delta for zooming B window
  crWindowZoomDeltaB:=FloatEdit5.Value;
end;

//----------------------- Drag And Drop -------------------

procedure TFormMain.SchemeDataEditorCursor1ObjectCanDrop(Sender,
  VisualSender: TObject; Shift: TShiftState; AObject: TSchemeObject;
  X, Y, OffsetX, OffsetY: Extended; var AEnabled: Boolean);
var p:TSchemeObject;
begin //Can Drop ?                          //as an example
  if AObject.Resized then exit;             //enabel if resized
  p:=SchemeDataEditorCursor1.ObjectForPoint(X,Y,
    TSchemeVisual(VisualSender).Param);
  AEnabled:=p<>nil;
  if not AEnabled then exit;
  AEnabled:=(p.State=AObject.State);        //enable for equal objects states
end;

//---------------------- Custom Drawing ---------------------

procedure TFormMain.SchemeDataEditorCursor1ObjectPaint(Sender,
  VisualSender: TObject; AObject: TSchemeObject; AZoom: Extended;
  ACanvas: TCanvas; AParam: Integer);
var t:TShapeType;
  b:boolean;
begin
  if ((AParam=0)and(AObject is TSchemeShape)) then // only for simple Shape
  with AObject as TSchemeShape do
  begin
    b:=SchemeDataEditorCursor1.BeginUpdate; // as since ShapeType:=stCircle call OnPaint itself!
    t:=ShapeType;
    ShapeType:=stCircle;
    Paint(AZoom,ACanvas,AParam);
    ShapeType:=t;
    if not b then SchemeDataEditorCursor1.EndUpdate;
  end
  else AObject.Paint(AZoom,ACanvas,AParam);
end;

procedure TFormMain.CheckBox3Click(Sender: TObject);
var i,j:integer;
  p:TSchemeObject;
begin  //DefaultDrawing
  SchemeDataEditorCursor1.DefaultDrawing:=CheckBox3.Checked;
  //--- set FullRepaintIfMoved=true for custom drawing objects
  with SchemeDataEditorCursor1 do
  for j:=0 to LayerCount-1 do
    with LayerIndex[j] do
    for i:=0 to Count-1 do
    begin
      p:=ItemsIndex[i];
      if (p is TSchemeShape) then   // only for simple Shape
        p.FullRepaintIfMoved:= not CheckBox3.Checked;
    end;
end;

procedure TFormMain.ActionResizedExecute(Sender: TObject);
begin //Resized on/off
  pSelectedObject.Resized:=not pSelectedObject.Resized;
end;

procedure TFormMain.ActionSelectedExecute(Sender: TObject);
begin //Selected on/off
  pSelectedObject.Selected:=not pSelectedObject.Selected;
end;

procedure TFormMain.SpinEdit3Change(Sender: TObject);
begin //Blink interval
  SchemeDataEditorCursor1.TimerInterval:=SpinEdit3.Value;
end;


procedure TFormMain.ActionReloadExecute(Sender: TObject);
begin //Reload
  CreateAll;
end;


procedure TFormMain.ActionLoadFromFileExecute(Sender: TObject);
begin //Load
  if not OpenDialog1.Execute then exit;
  SaveDialog1.InitialDir:=OpenDialog1.InitialDir;
  with SchemeDataEditorCursor1 do
  try
    BeginUpdate;
    SetSelectedObject(nil);
    LayerClear;
    LoadFromFile(OpenDialog1.FileName);
  finally
    EndUpdate;
    RepaintAllVisualControls;
  end;
end;

procedure TFormMain.ActionSaveToFileExecute(Sender: TObject);
begin  //Save to file
  if SaveDialog1.Execute then
  begin
    OpenDialog1.InitialDir:=SaveDialog1.InitialDir;
    SchemeDataEditorCursor1.SaveToFile(SaveDialog1.FileName);
  end;
end;

procedure TFormMain.ActionAddPointExecute(Sender: TObject);
begin //Add Point
  if pSelectedObject is  TSchemePolygon then
  with pSelectedObject as  TSchemePolygon do
  begin
    AddResizedPoint;
  end;
end;

procedure TFormMain.ActionDeletePointExecute(Sender: TObject);
begin //Delete Point
  if pSelectedObject is TSchemePolygon then
  with pSelectedObject as TSchemePolygon do
  begin
    DeleteResizedPoint;
  end;
end;

procedure TFormMain.CheckBox4Click(Sender: TObject);
begin
  SchemeVisualEditorCursor1.DoubleBuffered:=CheckBox4.Checked;
  SchemeVisualEditorCursor2.DoubleBuffered:=CheckBox4.Checked;
end;

//-------------------- Load and Save ------------------------------

procedure TFormMain.SchemeDataEditorCursor1BeforeLoading(Sender: TObject;
  AStrings: TStrings);
begin  //Before
  Screen.Cursor:=crHourglass;
end;

procedure TFormMain.SchemeDataEditorCursor1AfterLoading(Sender: TObject;
  AStrings: TStrings);
begin   //After
  Screen.Cursor:=crDefault;
  UpdateStatusBarInfo;
end;

procedure TFormMain.SchemeDataEditorCursor1LoadingProgress(Sender: TObject;
  AStrings: TStrings; ACurrentIndex: Integer);
begin
  StatusBar1.Panels[2].Text := 'Loaded: '+
    IntToStr(round(ACurrentIndex*100/AStrings.Count))+'% DATA: '+
    AStrings[ACurrentIndex];
end;

end.
