unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Borland.Vcl.StdCtrls, SCPie, SCHBar, SCMain, SCChart,
  System.ComponentModel, Borland.Vcl.ExtCtrls;

const
  Pie1BottomCaption = '<center>Exploded Slice(s): ';

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    SCChart1: TSCChart;
    SCHBar1: TSCHBar;
    SCPie1: TSCPie;
    Panel2: TPanel;
    SCChart2: TSCChart;
    ScrollBar1: TScrollBar;
    CheckBox1: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure SCPie1ClickOnChart(Sender: TObject; Shift: TShiftState;
      ASeries, APoint, ALegend: Integer);
    procedure CheckBox1Click(Sender: TObject);
    procedure ScrollBar1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.FormCreate(Sender: TObject);
var
  i, j: Integer;
  HLOC: THLOC;
begin
  with SCChart1 do
  begin
    BeginUpdate;
    AddLineSeries( yaRight, clRed, 'Series 1', msDiamond, 4, 3, psSolid );
    AddBarSeries( ckSBar, yaLeft, clBlue, 'Series 2', bsCylinder );
    AddBarSeries( ckSBar, yaLeft, clYellow, 'Series 3', bsCylinder );

    AddSeries( ckSArea, yaLeft, clGreen, 'Series 4' );
    AddSeries( ckSArea, yaLeft, clPurple, 'Series 5' );
    for i := 1 to NSeries do
      for j := 1 to NPoint do DataValues[i, j] := Random( 9 )+1;
    EndUpdate;
  end;

  with SCChart2 do
  begin
    BeginUpdate;
    AddSeries( ckCStick, yaLeft, clBlue, 'Series 1' );
    for i := 1 to NPoint do
    begin
      HLOC.Hi := 100+Random( 20 );
      HLOC.Lo := HLOC.Hi-Random( 20 );
      if Kind[NSeries] > ckHL then HLOC.Open := HLOC.Hi-Random( Round( HLOC.Hi-HLOC.Lo ) );
      if Kind[NSeries] > ckHLC then HLOC.Close := HLOC.Hi-Random( Round( HLOC.Hi-HLOC.Lo ) );
      DataHLOC[SCChart2.NSeries, i] := HLOC;
    end;
    AddLineSeries( yaRight, clRed, 'Series 2', msRound, 4, 2, psSolid );
    for i := 1 to NPoint do
      DataValues[NSeries, i] := Random( 9 )+1;
    for i := 1 to NPoint do PointLabels[i] := IntToStr( i );
    DataValues[NSeries, 4] := NValue;
    DataValues[NSeries, 8] := OValue;
    EndUpdate;
  end;

  with SCPie1 do
  begin
    BeginUpdate;
    for i := 1 to NSeries do
    begin
      for j := 1 to NPoint do DataValues[i, j] := Random( 9 )+1;
      SeriesLabels[i] := 'Slice '+IntToStr( i );
    end;
    BottomCaption := Pie1BottomCaption+FormatFloat( '0.##', 0 )+'%';
    EndUpdate;
  end;

  with SCHBar1 do
  begin
    BeginUpdate;
    AddSeries( ckSHBar, bsCone, 'Series 1', clGreen );
    AddSeries( ckSHBar, bsCone, 'Series 2', clPurple );
    for i := 1 to NSeries do
      for j := 1 to NPoint do DataValues[i, j] := Random( 10 )-Random( 9 );
    EndUpdate;
  end;
end;

procedure TForm1.SCPie1ClickOnChart(Sender: TObject; Shift: TShiftState;
  ASeries, APoint, ALegend: Integer);
var
  i: Integer;
  d: Double;
begin
  SCPie1.BeginUpdate;
  if ASeries > 0 then SCPie1.Explodes[ASeries] := not SCPie1.Explodes[ASeries];
  d := 0;
  for i := 1 to SCPie1.NSeries do
    if SCPie1.Explodes[i] then d := d+SCPie1.GetPercent( i, 1 );
  SCPie1.BottomCaption := Pie1BottomCaption+FormatFloat( '0.##', d )+'%';
  SCPie1.EndUpdate;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  SCChart1.Chart3D := CheckBox1.Checked;
end;

procedure TForm1.ScrollBar1Change(Sender: TObject);
begin
  SCChart2.LeftVisiblePoint := ScrollBar1.Position;  
end;

end.
