unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SCChart, SCMain, SCPie, ComCtrls, ExtCtrls, StdCtrls;

const
  Pie1BottomCaption = '<center>Exploded Slice(s): %g%%<br>';
  SeriesArray: array [0..8] of TChartKind = ( ckLine, ckStair, ckArea, ckBar,
    ckCBar, ckSArea, ckSBar, ckS100Area, ckS100Bar );

type
  TForm1 = class(TForm)
    SCPie1: TSCPie;
    Panel1: TPanel;
    SCChart1: TSCChart;
    Bevel1: TBevel;
    Bevel2: TBevel;
    SCPie2: TSCPie;
    SCChart2: TSCChart;
    Bevel3: TBevel;
    cbKind: TComboBox;
    CheckBox1: TCheckBox;
    cbSeries: TComboBox;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure SCPie1ClickOnChart(Sender: TObject; Shift: TShiftState;
      ASeries, APoint, ALegend: Integer);
    procedure CheckBox1Click(Sender: TObject);
    procedure cbKindClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  i, j: Integer;
  HLOC: THLOC;
begin
  with SCChart1 do
  begin
    BeginUpdate;
    AddSeries( ckLine, yaLeft, clBlue, '' );
    AddSeries( ckBar, yaLeft, clRed, '' );
    AddSeries( ckSArea, yaLeft, clGreen, '' );
    AddSeries( ckSArea, yaLeft, clPurple, '' );
    for i := 1 to NSeries do
      for j := 1 to NPoint do DataValues[i, j] := Random( 9 )+1;//-Random( 12 );
    EndUpdate;
  end;
  cbSeries.Items.Add( 'All Series' );
  for i := 1 to 4 do cbSeries.Items.Add( 'Series '+IntToStr( i ) );
  cbSeries.ItemIndex := 0;
  cbKind.ItemIndex := 0;

  with SCChart2 do
  begin
    BeginUpdate;
    AddSeries( ckCStick, yaLeft, clBlue, '' );
    for i := 1 to NPoint do
    begin
      HLOC.Hi := 100+Random( 20 );
      HLOC.Lo := HLOC.Hi-Random( 20 );
      if Kind[NSeries] > ckHL then HLOC.Open := HLOC.Hi-Random( Round( HLOC.Hi-HLOC.Lo ) );
      if Kind[NSeries] > ckHLC then HLOC.Close := HLOC.Hi-Random( Round( HLOC.Hi-HLOC.Lo ) );
      DataHLOC[SCChart2.NSeries, i] := HLOC;
    end;
    AddLineSeries( yaRight, clRed, '', msRound, 4, 2, psSolid );
    for i := 1 to NPoint do
      DataValues[SCChart2.NSeries, i] := Random( 9 )+1;
    EndUpdate;
  end;

  with SCPie1 do
  begin
    BeginUpdate;
    for i := 1 to NSeries do DataValues[i, 1] := Random( 9 )+1;
    BottomCaption := Format( Pie1BottomCaption, [0.0] );
    EndUpdate;
  end;

  with SCPie2 do
  begin
    BeginUpdate;
    for i := 1 to SCPie2.NSeries do
      for j := 1 to SCPie2.NPoint do SCPie2.DataValues[i, j] := Random( 9 )+1;
    EndUpdate;
  end;  
end;

procedure TForm1.SCPie1ClickOnChart(Sender: TObject; Shift: TShiftState;
  ASeries, APoint, ALegend: Integer);
var
  i: Integer;
  d: Double;
begin
  SCPie1.BeginUpdate;
  if ASeries > 0 then SCPie1.Explodes[ASeries] := not SCPie1.Explodes[ASeries];
  d := 0;
  for i := 1 to SCPie1.NSeries do
    if SCPie1.Explodes[i] then d := d+SCPie1.GetPercent( i, 1 );
  SCPie1.BottomCaption := Format( Pie1BottomCaption, [d] );
  SCPie1.EndUpdate;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  SCChart1.Chart3D := CheckBox1.Checked;
end;

procedure TForm1.cbKindClick(Sender: TObject);
var
  i: Integer;
begin
  if cbSeries.ItemIndex = 0 then
  begin
    with SCChart1 do
    begin
      BeginUpdate;
      for i := 1 to NSeries do Kind[i] := SeriesArray[cbKind.ItemIndex];
      EndUpdate;
    end;
  end else
    SCChart1.Kind[cbSeries.ItemIndex] := SeriesArray[cbKind.ItemIndex];
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  SCChart1.AntiAlias := not SCChart1.AntiAlias;
  SCChart2.AntiAlias := not SCChart2.AntiAlias;
  SCPie1.AntiAlias := not SCPie1.AntiAlias;
  SCPie2.AntiAlias := not SCPie2.AntiAlias;
end;

end.
