unit Demo_;

interface

uses
  Forms, Menus, RControl, StdCtrls, ComCtrls, Classes, Controls, SysUtils;

type
  TForm1 = class(TForm)
    RemoteControl1: TRemoteControl;
    Memo1: TMemo;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RemoteControl1Receive(Sender: TObject; DeviceId: Integer;
      ButtonId: TRCButtonId; ButtonName: String;
      ButtonState: TRCButtonState; ButtonRepeatCount: Integer);
    procedure CheckBox1Click(Sender: TObject);
  private
     Procedure RefreshDeviceStatus;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//______________________________________________________________________________
procedure TForm1.FormCreate(Sender: TObject);
//______________________________________________________________________________
begin
   RemoteControl1.Enabled := True;
   CheckBox1.Checked := RemoteControl1.Enabled;
end;

//______________________________________________________________________________
procedure TForm1.CheckBox1Click(Sender: TObject);
//______________________________________________________________________________
begin
   RemoteControl1.Enabled := CheckBox1.Checked;
   RefreshDeviceStatus;
end;

//______________________________________________________________________________
Procedure TForm1.RefreshDeviceStatus;
//______________________________________________________________________________
begin
   if not RemoteControl1.Enabled then begin
      Edit1.Text := 'remote control component disabled';
   end
   else begin
      if RemoteControl1.DeviceInitialized then begin
         Edit1.Text := 'remote control device successfully initialized';
      end
      else begin
         Edit1.Text := 'remote control device initalization failed';
      end;
   end;
end;

//______________________________________________________________________________
procedure TForm1.FormShow(Sender: TObject);
//______________________________________________________________________________
begin
   RefreshDeviceStatus;
end;

//______________________________________________________________________________
procedure TForm1.RemoteControl1Receive(Sender: TObject; DeviceId: Integer;
  ButtonId: TRCButtonId; ButtonName: String; ButtonState: TRCButtonState;
  ButtonRepeatCount: Integer);
//______________________________________________________________________________
var
   state: string;
begin
   case ButtonState of
      rc_On:     state := 'on ';
      rc_Off:    state := 'off';
      rc_Repeat: state := 'rpt';
   end;
   Memo1.Lines.Add (Format ('%2u           %s       %2u      %2u          %s', [DeviceId, state, integer(ButtonId), ButtonRepeatCount, ButtonName]));
   if ButtonState = rc_Off then begin
      Memo1.Lines.Add ('');
   end;
end;

//______________________________________________________________________________
procedure TForm1.Exit1Click(Sender: TObject);
//______________________________________________________________________________
begin
   Close;
end;

end.
