//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Demo_.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "RControl"
#pragma resource "*.dfm"
TForm1 *Form1;

//______________________________________________________________________________
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
//______________________________________________________________________________
{
}

//______________________________________________________________________________
void __fastcall TForm1::FormCreate(TObject *Sender)
//______________________________________________________________________________
{
   RemoteControl1->Enabled = True;
   CheckBox1->Checked = RemoteControl1->Enabled;
}

//______________________________________________________________________________
void __fastcall TForm1::CheckBox1Click(TObject *Sender)
//______________________________________________________________________________
{
   RemoteControl1->Enabled = CheckBox1->Checked;
   RefreshDeviceStatus();
}

//______________________________________________________________________________
void __fastcall TForm1::RefreshDeviceStatus (void)
//______________________________________________________________________________
{
   if (! RemoteControl1->Enabled ) {
      Edit1->Text = "remote control component disabled";
   }
   else {
      if (RemoteControl1->DeviceInitialized ) {
         Edit1->Text = "remote control device successfully initialized";
      }
      else {
         Edit1->Text = "remote control device initalization failed";
      }
   }
}

//______________________________________________________________________________
void __fastcall TForm1::FormShow(TObject *Sender)
//______________________________________________________________________________
{
   RefreshDeviceStatus();
}

//______________________________________________________________________________
void __fastcall TForm1::RemoteControl1Receive(TObject *Sender,
      int DeviceId, TRCButtonId ButtonId, AnsiString ButtonName,
      TRCButtonState ButtonState, int ButtonRepeatCount)
//______________________________________________________________________________
{
   char *state;

   switch (ButtonState) {
      case rc_On:     state = "on "; break;
      case rc_Off:    state = "off"; break;
      case rc_Repeat: state = "rpt"; break;
   }
   TVarRec SampleTimeVars[] = {DeviceId, state, ButtonId, ButtonRepeatCount, ButtonName};
   Memo1->Lines->Add (Format ("%2u           %s       %2u      %2u          %s", SampleTimeVars, (ARRAYSIZE(SampleTimeVars) - 1)));
   if (ButtonState == rc_Off ) {
      Memo1->Lines->Add ("");
   }
}

//______________________________________________________________________________
void __fastcall TForm1::Exit1Click(TObject *Sender)
//______________________________________________________________________________
{
   Close();
}


