unit PropertiesC;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, PsQrExport;

type
  TfrmProperties = class(TForm)
    PageControl1: TPageControl;
    tsHTML: TTabSheet;
    tsPDF: TTabSheet;
    tsRTF: TTabSheet;
    tsJPEG: TTabSheet;
    tsBMP: TTabSheet;
    tsEMF: TTabSheet;
    tsWMF: TTabSheet;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    gbVisibleFilters: TGroupBox;
    chbHTML: TCheckBox;
    chbPDF: TCheckBox;
    chbRTF: TCheckBox;
    chbGIF: TCheckBox;
    chbJPEG: TCheckBox;
    chbBMP: TCheckBox;
    chbEMF: TCheckBox;
    chbWMF: TCheckBox;
    tsGIF: TTabSheet;
    Panel8: TPanel;
    PsQRFilters: TPsQRFilters;
    chbHTML_Images: TCheckBox;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    cbHTML_ExFormat: TComboBox;
    Label2: TLabel;
    edHTML_ImgDir: TEdit;
    GroupBox2: TGroupBox;
    chbHTML_Single: TCheckBox;
    chbHTML_ShowNavigator: TCheckBox;
    chbHTML_WebDings: TCheckBox;
    seHTML_JPEGQual: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    edHTML_Keywords: TEdit;
    chbPDF_Images: TCheckBox;
    GroupBox3: TGroupBox;
    Label5: TLabel;
    Label7: TLabel;
    cbPDF_ExFormat: TComboBox;
    sePDF_JPEGQual: TEdit;
    Label8: TLabel;
    edPDF_Keywords: TEdit;
    chbRTF_Images: TCheckBox;
    GroupBox4: TGroupBox;
    Label6: TLabel;
    Label9: TLabel;
    cbRTF_ExFormat: TComboBox;
    seRTF_JPEGQual: TEdit;
    Label10: TLabel;
    edRTF_Keywords: TEdit;
    chbGIF_Mono: TCheckBox;
    Label11: TLabel;
    cbGIF_Pix: TComboBox;
    Label12: TLabel;
    chbJPEG_Mono: TCheckBox;
    cbJPEG_Pix: TComboBox;
    chbJPEG_ProgEncode: TCheckBox;
    Label13: TLabel;
    seJPEG_Qual: TEdit;
    Label14: TLabel;
    chbBMP_Mono: TCheckBox;
    cbBMP_Pix: TComboBox;
    chbEMF_Fill: TCheckBox;
    chbWMF_Fill: TCheckBox;
    procedure cbVisibleFilterClick(Sender: TObject);
    procedure chbHTML_ImagesClick(Sender: TObject);
    procedure cbSingleClick(Sender: TObject);
    procedure cbHTML_ExFormatChange(Sender: TObject);
    procedure seHTML_JPEGQualChange(Sender: TObject);
    procedure edHTML_ImgDirChange(Sender: TObject);
    procedure chbHTML_ShowNavigatorClick(Sender: TObject);
    procedure chbHTML_WebDingsClick(Sender: TObject);
    procedure edHTML_KeywordsChange(Sender: TObject);
    procedure chbPDF_ImagesClick(Sender: TObject);
    procedure cbPDF_ExFormatChange(Sender: TObject);
    procedure sePDF_JPEGQualChange(Sender: TObject);
    procedure edPDF_KeywordsChange(Sender: TObject);
    procedure chbRTF_ImagesClick(Sender: TObject);
    procedure cbRTF_ExFormatChange(Sender: TObject);
    procedure seRTF_JPEGQualChange(Sender: TObject);
    procedure edRTF_KeywordsChange(Sender: TObject);
    procedure chbGIF_MonoClick(Sender: TObject);
    procedure cbGIF_PixChange(Sender: TObject);
    procedure chbJPEG_MonoClick(Sender: TObject);
    procedure cbJPEG_PixChange(Sender: TObject);
    procedure chbJPEG_ProgEncodeClick(Sender: TObject);
    procedure seJPEG_QualChange(Sender: TObject);
    procedure chbBMP_MonoClick(Sender: TObject);
    procedure cbBMP_PixChange(Sender: TObject);
    procedure chbEMF_FillClick(Sender: TObject);
    procedure chbWMF_FillClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmProperties: TfrmProperties;

implementation

uses main;

{$R *.DFM}

procedure TfrmProperties.cbVisibleFilterClick(Sender: TObject);
begin
	with Sender as TCheckBox do
  	if Checked then
      PsQRFilters.VisibleFilters :=
        PsQRFilters.VisibleFilters + [TPsQRFilterKind(Tag)]
    else
      PsQRFilters.VisibleFilters :=
        PsQRFilters.VisibleFilters - [TPsQRFilterKind(Tag)];
end;

procedure TfrmProperties.chbHTML_ImagesClick(Sender: TObject);
var
	Images: Boolean;
begin
  Images := chbHTML_Images.Checked;
	cbHTML_ExFormat.Enabled := Images;
  edHTML_ImgDir.Enabled := Images;
  PsQRFilters.HTML.ExportImages := Images;
end;

procedure TfrmProperties.cbSingleClick(Sender: TObject);
var
	SingleFile: Boolean;
begin
  SingleFile := chbHtml_Single.Checked;
	chbHTML_ShowNavigator.Enabled := not SingleFile;
  chbHTML_WebDings.Enabled := not SingleFile;
  PsQRFilters.HTML.SingleFile := SingleFile;
end;

procedure TfrmProperties.cbHTML_ExFormatChange(Sender: TObject);
begin
  PsQRFilters.HTML.ExportImageFormat := TPsImageFormat(cbHTML_ExFormat.ItemIndex);
end;

procedure TfrmProperties.seHTML_JPEGQualChange(Sender: TObject);
begin
  PsQRFilters.HTML.JPEGQuality := StrToIntDef(seHTML_JPEGQual.Text, 100);
end;

procedure TfrmProperties.edHTML_ImgDirChange(Sender: TObject);
begin
  PsQRFilters.HTML.ImageDir := edHTML_ImgDir.Text;
end;

procedure TfrmProperties.chbHTML_ShowNavigatorClick(Sender: TObject);
begin
  PsQRFilters.HTML.ShowNavigator := chbHTML_ShowNavigator.Checked;
end;

procedure TfrmProperties.chbHTML_WebDingsClick(Sender: TObject);
begin
  PsQRFilters.HTML.GraphicNavUseWebdings := chbHTML_WebDings.Checked;
end;

procedure TfrmProperties.edHTML_KeywordsChange(Sender: TObject);
begin
  PsQRFilters.HTML.Keywords := edHTML_Keywords.Text;
end;

procedure TfrmProperties.chbPDF_ImagesClick(Sender: TObject);
var
	Images: Boolean;
begin
  Images := chbPDF_Images.Checked;
	cbPDF_ExFormat.Enabled := Images;
  PsQRFilters.PDF.ExportImages := Images;
end;

procedure TfrmProperties.cbPDF_ExFormatChange(Sender: TObject);
begin
  PsQRFilters.PDF.ExportImageFormat := TPsImageFormat(cbPDF_ExFormat.ItemIndex);
end;

procedure TfrmProperties.sePDF_JPEGQualChange(Sender: TObject);
begin
  PsQRFilters.PDF.JPEGQuality := StrToIntDef(sePDF_JPEGQual.Text, 100);
end;

procedure TfrmProperties.edPDF_KeywordsChange(Sender: TObject);
begin
  PsQRFilters.PDF.Keywords := edPDF_Keywords.Text;
end;

procedure TfrmProperties.chbRTF_ImagesClick(Sender: TObject);
var
	Images: Boolean;
begin
  Images := chbRTF_Images.Checked;
	cbRTF_ExFormat.Enabled := Images;
  PsQRFilters.RTF.ExportImages := Images;
end;

procedure TfrmProperties.cbRTF_ExFormatChange(Sender: TObject);
begin
  PsQRFilters.RTF.ExportImageFormat := TPsImageFormat(cbRTF_ExFormat.ItemIndex);
end;

procedure TfrmProperties.seRTF_JPEGQualChange(Sender: TObject);
begin
  PsQRFilters.RTF.JPEGQuality := StrToIntDef(seRTF_JPEGQual.Text, 100);
end;

procedure TfrmProperties.edRTF_KeywordsChange(Sender: TObject);
begin
  PsQRFilters.RTF.Keywords := edRTF_Keywords.Text;
end;

procedure TfrmProperties.chbGIF_MonoClick(Sender: TObject);
begin
  PsQRFilters.GIF.Monochrome := chbGIF_Mono.Checked;
end;

procedure TfrmProperties.cbGIF_PixChange(Sender: TObject);
begin
  PsQRFilters.GIF.PixelFormat := TPixelFormat(cbGIF_Pix.ItemIndex);
end;

procedure TfrmProperties.chbJPEG_MonoClick(Sender: TObject);
begin
  PsQRFilters.JPEG.Monochrome := chbJPEG_Mono.Checked;
end;

procedure TfrmProperties.cbJPEG_PixChange(Sender: TObject);
begin
  PsQRFilters.JPEG.PixelFormat := TPixelFormat(cbJPEG_Pix.ItemIndex);
end;

procedure TfrmProperties.chbJPEG_ProgEncodeClick(Sender: TObject);
begin
  PsQRFilters.JPEG.ProgressiveEncoding := chbJPEG_ProgEncode.Checked;
end;

procedure TfrmProperties.seJPEG_QualChange(Sender: TObject);
begin
  PsQRFilters.JPEG.Quality := StrToIntDef(seJPEG_Qual.Text, 100);
end;

procedure TfrmProperties.chbBMP_MonoClick(Sender: TObject);
begin
  PsQRFilters.BMP.Monochrome := chbBMP_Mono.Checked;
end;

procedure TfrmProperties.cbBMP_PixChange(Sender: TObject);
begin
  PsQRFilters.BMP.PixelFormat := TPixelFormat(cbBMP_Pix.ItemIndex);
end;

procedure TfrmProperties.chbEMF_FillClick(Sender: TObject);
begin
  PsQRFilters.EMF.FillUnusedArea := chbEMF_Fill.Checked;
end;

procedure TfrmProperties.chbWMF_FillClick(Sender: TObject);
begin
  PsQRFilters.WMF.FillUnusedArea := chbWMF_Fill.Checked;
end;

procedure TfrmProperties.FormHide(Sender: TObject);
begin
  frmMain.btnProps.Down := False;
end;

end.

