// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'PsQrExport.pas' rev: 5.00

#ifndef PsQrExportHPP
#define PsQrExportHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Controls.hpp>	// Pascal unit
#include <PsQrConsts.hpp>	// Pascal unit
#include <QrTee.hpp>	// Pascal unit
#include <Qrctrls.hpp>	// Pascal unit
#include <QuickRpt.hpp>	// Pascal unit
#include <QRPrntr.hpp>	// Pascal unit
#include <jpeg.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Psqrexport
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TPsQRFilterKind { fkHTML, fkPDF, fkRTF, fkGIF, fkJPEG, fkBMP, fkEMF, fkWMF };
#pragma option pop

typedef Set<TPsQRFilterKind, fkHTML, fkWMF>  TPsQRVisibleFilters;

#pragma option push -b-
enum TPsImageFormat { ifGIF, ifJPG, ifBMP };
#pragma option pop

class DELPHICLASS TPsQRExportFilter;
typedef void __fastcall (__closure *TPsQRNotifyEvent)(TPsQRExportFilter* Filter);

typedef void __fastcall (__closure *TEncodeGraphicEvent)(TPsQRExportFilter* Sender, Quickrpt::TQRPrintable* 
	AControl, bool &UniqueImage, int &ReuseImageIndex);

typedef void __fastcall (__closure *TEncodeGraphicDoneEvent)(TPsQRExportFilter* Sender, Quickrpt::TQRPrintable* 
	AControl, int ObjectImageIndex);

typedef void __fastcall (__closure *TMakeRepFileNameEvent)(TPsQRExportFilter* Sender, AnsiString &FileName
	, int PageNo);

typedef void __fastcall (__closure *TMakeImgFileNameEvent)(TPsQRExportFilter* Sender, AnsiString &FileName
	, AnsiString &AltText, int PageNo);

typedef void __fastcall (__closure *TCreateBitmapEvent)(TPsQRExportFilter* Sender, Graphics::TBitmap* 
	Bmp, Classes::TFileStream* FileStream, int PageNo, bool &Continue);

class DELPHICLASS TPsQRExportSettings;
class DELPHICLASS TPsQRHTMLSettings;
class DELPHICLASS TPsQRDocumentFilterSettings;
class PASCALIMPLEMENTATION TPsQRDocumentFilterSettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	AnsiString FAuthor;
	AnsiString FCreator;
	bool FExportImages;
	Jpeg::TJPEGQualityRange FJPEGQuality;
	AnsiString FKeywords;
	Graphics::TPixelFormat FImagePixelFormat;
	bool __fastcall IsCreatorStored(void);
	
public:
	__fastcall virtual TPsQRDocumentFilterSettings(void);
	
__published:
	__property AnsiString Author = {read=FAuthor, write=FAuthor};
	__property AnsiString Creator = {read=FCreator, write=FCreator, stored=IsCreatorStored};
	__property bool ExportImages = {read=FExportImages, write=FExportImages, default=1};
	__property Jpeg::TJPEGQualityRange JPEGQuality = {read=FJPEGQuality, write=FJPEGQuality, default=100
		};
	__property AnsiString Keywords = {read=FKeywords, write=FKeywords};
	__property Graphics::TPixelFormat ImagePixelFormat = {read=FImagePixelFormat, write=FImagePixelFormat
		, default=6};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPsQRDocumentFilterSettings(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TPsQRHTMLSettings : public TPsQRDocumentFilterSettings 
{
	typedef TPsQRDocumentFilterSettings inherited;
	
private:
	TPsImageFormat FExportImageFormat;
	AnsiString FFirstLinkText;
	AnsiString FLastLinkText;
	AnsiString FNextLinkText;
	AnsiString FPrevLinkText;
	AnsiString FImageDir;
	bool FGraphicNavUseWebdings;
	bool FSingleFile;
	bool FShowNavigator;
	bool FUseTextLinks;
	bool __fastcall IsFirstLinkTextStored(void);
	bool __fastcall IsLastLinkTextStored(void);
	bool __fastcall IsNextLinkTextStored(void);
	bool __fastcall IsPrevLinkTextStored(void);
	
public:
	__fastcall virtual TPsQRHTMLSettings(void);
	
__published:
	__property TPsImageFormat ExportImageFormat = {read=FExportImageFormat, write=FExportImageFormat, default=1
		};
	__property AnsiString FirstLinkText = {read=FFirstLinkText, write=FFirstLinkText, stored=IsFirstLinkTextStored
		};
	__property AnsiString LastLinkText = {read=FLastLinkText, write=FLastLinkText, stored=IsLastLinkTextStored
		};
	__property AnsiString NextLinkText = {read=FNextLinkText, write=FNextLinkText, stored=IsNextLinkTextStored
		};
	__property AnsiString PrevLinkText = {read=FPrevLinkText, write=FPrevLinkText, stored=IsPrevLinkTextStored
		};
	__property AnsiString ImageDir = {read=FImageDir, write=FImageDir};
	__property bool GraphicNavUseWebdings = {read=FGraphicNavUseWebdings, write=FGraphicNavUseWebdings, 
		default=0};
	__property bool SingleFile = {read=FSingleFile, write=FSingleFile, default=0};
	__property bool ShowNavigator = {read=FShowNavigator, write=FShowNavigator, default=1};
	__property bool UseTextLinks = {read=FUseTextLinks, write=FUseTextLinks, default=0};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPsQRHTMLSettings(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRPDFSettings;
class PASCALIMPLEMENTATION TPsQRPDFSettings : public TPsQRDocumentFilterSettings 
{
	typedef TPsQRDocumentFilterSettings inherited;
	
private:
	TPsImageFormat FExportImageFormat;
	
public:
	__fastcall virtual TPsQRPDFSettings(void);
	
__published:
	__property TPsImageFormat ExportImageFormat = {read=FExportImageFormat, write=FExportImageFormat, default=1
		};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPsQRPDFSettings(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRRTFSettings;
class PASCALIMPLEMENTATION TPsQRRTFSettings : public TPsQRDocumentFilterSettings 
{
	typedef TPsQRDocumentFilterSettings inherited;
	
private:
	TPsImageFormat FExportImageFormat;
	
public:
	__fastcall virtual TPsQRRTFSettings(void);
	
__published:
	__property TPsImageFormat ExportImageFormat = {read=FExportImageFormat, write=FExportImageFormat, default=1
		};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPsQRRTFSettings(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRGIFSettings;
class PASCALIMPLEMENTATION TPsQRGIFSettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FMonochrome;
	Graphics::TPixelFormat FPixelFormat;
	
public:
	__fastcall virtual TPsQRGIFSettings(void);
	
__published:
	__property bool Monochrome = {read=FMonochrome, write=FMonochrome, default=0};
	__property Graphics::TPixelFormat PixelFormat = {read=FPixelFormat, write=FPixelFormat, default=6};
		
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPsQRGIFSettings(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRJPEGSettings;
class PASCALIMPLEMENTATION TPsQRJPEGSettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FMonochrome;
	Graphics::TPixelFormat FPixelFormat;
	bool FProgressiveEncoding;
	Jpeg::TJPEGQualityRange FQuality;
	
public:
	__fastcall virtual TPsQRJPEGSettings(void);
	
__published:
	__property bool Monochrome = {read=FMonochrome, write=FMonochrome, default=0};
	__property Graphics::TPixelFormat PixelFormat = {read=FPixelFormat, write=FPixelFormat, default=6};
		
	__property bool ProgressiveEncoding = {read=FProgressiveEncoding, write=FProgressiveEncoding, default=1
		};
	__property Jpeg::TJPEGQualityRange Quality = {read=FQuality, write=FQuality, default=100};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPsQRJPEGSettings(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRBMPSettings;
class PASCALIMPLEMENTATION TPsQRBMPSettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FMonochrome;
	Graphics::TPixelFormat FPixelFormat;
	
public:
	__fastcall virtual TPsQRBMPSettings(void);
	
__published:
	__property bool Monochrome = {read=FMonochrome, write=FMonochrome, default=0};
	__property Graphics::TPixelFormat PixelFormat = {read=FPixelFormat, write=FPixelFormat, default=6};
		
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPsQRBMPSettings(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRMetafileSettings;
class PASCALIMPLEMENTATION TPsQRMetafileSettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FFillUnusedArea;
	
public:
	__fastcall virtual TPsQRMetafileSettings(void);
	
__published:
	__property bool FillUnusedArea = {read=FFillUnusedArea, write=FFillUnusedArea, default=1};
public:
	#pragma option push -w-inl
	/* TPersistent.Destroy */ inline __fastcall virtual ~TPsQRMetafileSettings(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TPsQRExportSettings : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	int FImgFileCount;
	Classes::TStrings* FImgFileNames;
	int FRepFileCount;
	Classes::TStrings* FRepFileNames;
	TPsQRVisibleFilters FVisibleFilters;
	TPsQRHTMLSettings* FHTML;
	TPsQRPDFSettings* FPDF;
	TPsQRRTFSettings* FRTF;
	TPsQRGIFSettings* FGIF;
	TPsQRJPEGSettings* FJPEG;
	TPsQRBMPSettings* FBMP;
	TPsQRMetafileSettings* FEMF;
	TPsQRMetafileSettings* FWMF;
	Extended FXFactor;
	Extended FYFactor;
	TPsQRNotifyEvent FOnBeginJob;
	TPsQRNotifyEvent FOnBeginPage;
	TPsQRNotifyEvent FOnEndJob;
	TPsQRNotifyEvent FOnEndPage;
	TCreateBitmapEvent FOnCreateBitmap;
	TEncodeGraphicEvent FOnEncodeGraphic;
	TEncodeGraphicDoneEvent FOnEncodeGraphicDone;
	TMakeRepFileNameEvent FOnMakeRepFileName;
	TMakeImgFileNameEvent FOnMakeImgFileName;
	void __fastcall SetHTML(TPsQRHTMLSettings* Value);
	void __fastcall SetPDF(TPsQRPDFSettings* Value);
	void __fastcall SetRTF(TPsQRRTFSettings* Value);
	void __fastcall SetGIF(TPsQRGIFSettings* Value);
	void __fastcall SetJPEG(TPsQRJPEGSettings* Value);
	void __fastcall SetBMP(TPsQRBMPSettings* Value);
	void __fastcall SetEMF(TPsQRMetafileSettings* Value);
	void __fastcall SetWMF(TPsQRMetafileSettings* Value);
	void __fastcall SetVisibleFilters(TPsQRVisibleFilters Value);
	
public:
	__fastcall virtual TPsQRExportSettings(void);
	__fastcall virtual ~TPsQRExportSettings(void);
	__property int ImgFileCount = {read=FImgFileCount, nodefault};
	__property Classes::TStrings* ImgFileNames = {read=FImgFileNames};
	__property int RepFileCount = {read=FRepFileCount, nodefault};
	__property Classes::TStrings* RepFileNames = {read=FRepFileNames};
	
__published:
	__property TPsQRVisibleFilters VisibleFilters = {read=FVisibleFilters, write=SetVisibleFilters, default=255
		};
	__property TPsQRHTMLSettings* HTML = {read=FHTML, write=SetHTML};
	__property TPsQRPDFSettings* PDF = {read=FPDF, write=SetPDF};
	__property TPsQRRTFSettings* RTF = {read=FRTF, write=SetRTF};
	__property TPsQRGIFSettings* GIF = {read=FGIF, write=SetGIF};
	__property TPsQRJPEGSettings* JPEG = {read=FJPEG, write=SetJPEG};
	__property TPsQRBMPSettings* BMP = {read=FBMP, write=SetBMP};
	__property TPsQRMetafileSettings* EMF = {read=FEMF, write=SetEMF};
	__property TPsQRMetafileSettings* WMF = {read=FWMF, write=SetWMF};
	__property TPsQRNotifyEvent OnBeginJob = {read=FOnBeginJob, write=FOnBeginJob};
	__property TPsQRNotifyEvent OnBeginPage = {read=FOnBeginPage, write=FOnBeginPage};
	__property TPsQRNotifyEvent OnEndJob = {read=FOnEndJob, write=FOnEndJob};
	__property TPsQRNotifyEvent OnEndPage = {read=FOnEndPage, write=FOnEndPage};
	__property TCreateBitmapEvent OnCreateBitmap = {read=FOnCreateBitmap, write=FOnCreateBitmap};
	__property TEncodeGraphicEvent OnEncodeGraphic = {read=FOnEncodeGraphic, write=FOnEncodeGraphic};
	__property TEncodeGraphicDoneEvent OnEncodeGraphicDone = {read=FOnEncodeGraphicDone, write=FOnEncodeGraphicDone
		};
	__property TMakeImgFileNameEvent OnMakeImgFileName = {read=FOnMakeImgFileName, write=FOnMakeImgFileName
		};
	__property TMakeRepFileNameEvent OnMakeRepFileName = {read=FOnMakeRepFileName, write=FOnMakeRepFileName
		};
};


#pragma option push -b-
enum TLineType { ltUnderline, ltStrikeOut };
#pragma option pop

struct TPsQrRect
{
	Extended Left;
	Extended Top;
	Extended Width;
	Extended Height;
} ;

struct TPsQrIntRect
{
	int Left;
	int Top;
	int Width;
	int Height;
} ;

struct TPsQrFontAttrib
{
	AnsiString Name;
	int Size;
	Graphics::TColor Color;
	Graphics::TFontStyles Style;
} ;

struct TPsQRSize
{
	Extended cx;
	Extended cy;
} ;

struct TPsQrTextRec
{
	Extended X;
	Extended Y;
	TPsQRSize TextSize;
	TPsQrFontAttrib Font;
	Graphics::TColor BGColor;
	Classes::TAlignment Alignment;
} ;

struct TPsQRPaperMargin
{
	Extended Left;
	Extended Top;
	Extended Right;
	Extended Bottom;
} ;

class DELPHICLASS TPsQRPrintable;
class PASCALIMPLEMENTATION TPsQRPrintable : public Quickrpt::TQRPrintable 
{
	typedef Quickrpt::TQRPrintable inherited;
	
public:
	#pragma option push -w-inl
	/* TQRPrintable.Create */ inline __fastcall virtual TPsQRPrintable(Classes::TComponent* AOwner) : Quickrpt::TQRPrintable(
		AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TQRPrintable.Destroy */ inline __fastcall virtual ~TPsQRPrintable(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TPsQRPrintable(HWND ParentWindow) : Quickrpt::TQRPrintable(
		ParentWindow) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TPsQRExportFilter : public Qrprntr::TQRExportFilter 
{
	typedef Qrprntr::TQRExportFilter inherited;
	
private:
	bool FFileError;
	AnsiString FFileName;
	int FPageNo;
	Classes::TStream* __fastcall GetBitmapAsJpgGifStream(Graphics::TBitmap* Bmp, TPsImageFormat ImgFormat
		, Jpeg::TJPEGQualityRange JPEGQuality);
	AnsiString __fastcall MakeRepFileName(int APageNo);
	AnsiString __fastcall SaveBitmapAs(Graphics::TBitmap* Bmp, TPsImageFormat ImgFormat, Jpeg::TJPEGQualityRange 
		JPEGQuality, const AnsiString BaseName);
	
protected:
	virtual AnsiString __fastcall GetDescription();
	virtual bool __fastcall GetStreaming(void);
	virtual AnsiString __fastcall GetVendorName();
	virtual void __fastcall BeginPage(void) = 0 ;
	
public:
	virtual void __fastcall NewPage(void);
	virtual void __fastcall Start(int PaperWidth, int PaperHeight, Graphics::TFont* Font);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRExportFilter(AnsiString Filename) : Qrprntr::TQRExportFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRExportFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRDocumentFilter;
class PASCALIMPLEMENTATION TPsQRDocumentFilter : public TPsQRExportFilter 
{
	typedef TPsQRExportFilter inherited;
	
private:
	Qrctrls::TQRCustomLabel* FActiveControl;
	int FActiveControlX;
	int FActiveControlY;
	bool FBandStarted;
	AnsiString FBuffer;
	int FGreatestTextWidth;
	int FPageCount;
	Extended FPaperHeight;
	TPsQRPaperMargin FPaperMargin;
	Extended FPaperWidth;
	Quickrpt::TQRFrame* FReportFrame;
	AnsiString FReportTitle;
	Classes::TStream* FStream;
	bool FTextBuffered;
	int FTextLineCount;
	Classes::TStrings* FTextLines;
	AnsiString __fastcall EncodeSimpleShape(Qrctrls::TQRShape* AControl, const TPsQrRect &R);
	Graphics::TBitmap* __fastcall GetShapeBitmap(Qrctrls::TQRShape* AControl, Graphics::TPixelFormat APixelFormat
		);
	Graphics::TBitmap* __fastcall GetImageCtlBitmap(Quickrpt::TQRPrintable* AControl, Graphics::TPixelFormat 
		APixelFormat);
	void __fastcall DoEncodeGraphic(TPsQRExportFilter* Sender, Quickrpt::TQRPrintable* AControl, bool &
		UniqueImage, int &ReuseImageIndex);
	void __fastcall DoEncodeGraphicDone(TPsQRExportFilter* Sender, Quickrpt::TQRPrintable* AControl, int 
		ObjectImageIndex);
	void __fastcall FlushTextLines(void);
	
protected:
	virtual AnsiString __fastcall EncodeImage(Quickrpt::TQRPrintable* AControl, const TPsQrRect &R) = 0 
		;
	virtual AnsiString __fastcall EncodeGraphicShape(Qrctrls::TQRShape* AControl, const TPsQrRect &R) = 0 
		;
	virtual AnsiString __fastcall EncodeShadeAndFrame(const TPsQrRect &R, Graphics::TColor Color, Quickrpt::TQRFrame* 
		Frame, bool Shade, bool IsTextCtl, bool FixHeight, bool FixWidth) = 0 ;
	virtual TPsQrRect __fastcall GetNativeRect(const TPsQrRect &Rect);
	virtual TPsQRSize __fastcall GetNativeSize(const tagSIZE &Size);
	virtual AnsiString __fastcall GetNativeText(const AnsiString Text);
	virtual Extended __fastcall GetNativeXPos(Extended X);
	virtual Extended __fastcall GetNativeYPos(Extended Y);
	virtual AnsiString __fastcall NumToStr(Extended N);
	virtual void __fastcall BeginBand(void);
	virtual void __fastcall BeginJob(void) = 0 ;
	virtual void __fastcall EncodeText(const AnsiString Text, const TPsQrTextRec &TextRec) = 0 ;
	virtual void __fastcall EndBand(Quickrpt::TQRCustomBand* ABand, const TPsQrRect &R);
	virtual void __fastcall EndJob(void);
	
public:
	virtual void __fastcall BeginText(Qrctrls::TQRCustomLabel* AControl, int X, int Y);
	virtual void __fastcall ShapeOut(Qrctrls::TQRShape* AControl, int X, int Y, bool Continued);
	virtual void __fastcall ImageOut(Quickrpt::TQRPrintable* AControl, int X, int Y, bool Continued);
	virtual void __fastcall EndText(Qrctrls::TQRCustomLabel* AControl, int X, int Y, bool Continued);
	virtual void __fastcall Finish(void);
	virtual void __fastcall Start(int PaperWidth, int PaperHeight, Graphics::TFont* Font);
	virtual void __fastcall TextOut(Extended X, Extended Y, Graphics::TFont* Font, Graphics::TColor BGColor
		, Classes::TAlignment Alignment, AnsiString Text);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRDocumentFilter(AnsiString Filename) : TPsQRExportFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRDocumentFilter(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum THTMLNavBtn { hnbFirst, hnbPrev, hnbNext, hnbLast };
#pragma option pop

typedef Set<THTMLNavBtn, hnbFirst, hnbLast>  THTMLNavBtns;

typedef AnsiString PsQrExport__41[4];

class DELPHICLASS TPsQRHTMLFilter;
class PASCALIMPLEMENTATION TPsQRHTMLFilter : public TPsQRDocumentFilter 
{
	typedef TPsQRDocumentFilter inherited;
	
private:
	AnsiString FImageDir;
	AnsiString FNavBtnChars[4];
	AnsiString FNavFontName;
	AnsiString __fastcall GetBorderInfo(Quickrpt::TQRFrame* Frame);
	AnsiString __fastcall GetImageLinkHTML(Quickrpt::TQRPrintable* AControl, const TPsQrRect &R, const 
		AnsiString AFileName, const AnsiString AAltText);
	int __fastcall GetOffsetFromTop(void);
	AnsiString __fastcall MakeImgFileName();
	void __fastcall WriteHeader(void);
	
protected:
	virtual AnsiString __fastcall EncodeImage(Quickrpt::TQRPrintable* AControl, const TPsQrRect &R);
	virtual AnsiString __fastcall EncodeGraphicShape(Qrctrls::TQRShape* AControl, const TPsQrRect &R);
	virtual AnsiString __fastcall EncodeShadeAndFrame(const TPsQrRect &R, Graphics::TColor Color, Quickrpt::TQRFrame* 
		Frame, bool Shade, bool IsTextCtl, bool FixHeight, bool FixWidth);
	virtual AnsiString __fastcall GetExtension();
	virtual AnsiString __fastcall GetFilterName();
	virtual AnsiString __fastcall GetNativeText(const AnsiString Text);
	virtual void __fastcall BeginJob(void);
	virtual void __fastcall BeginPage(void);
	virtual void __fastcall EncodeText(const AnsiString Text, const TPsQrTextRec &TextRec);
	
public:
	virtual void __fastcall EndPage(void);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRHTMLFilter(AnsiString Filename) : TPsQRDocumentFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRHTMLFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRPDFFilter;
class PASCALIMPLEMENTATION TPsQRPDFFilter : public TPsQRDocumentFilter 
{
	typedef TPsQRDocumentFilter inherited;
	
private:
	Classes::TStream* FFileStream;
	Classes::TStrings* FFontTbl;
	Classes::TStream* FImageStream;
	Classes::TStrings* FImageCtlList;
	Classes::TStrings* FImageXRefList;
	int FObjRunNo;
	int FPageObjNo;
	int FContentsObjNo;
	int FLengthObjNo;
	AnsiString FPageObjs;
	Classes::TStrings* FXRefTbl;
	AnsiString __fastcall EncodeImageObjectRef(int ImgNo, const TPsQrRect &R, Quickrpt::TQRFrame* Frame
		, bool DrawFrame);
	AnsiString __fastcall EncodeGraphic(Graphics::TBitmap* Bmp, const TPsQrRect &R, Quickrpt::TQRPrintable* 
		AControl, bool DrawFrame);
	AnsiString __fastcall GetBorderInfo(Quickrpt::TQRFrame* Frame, const TPsQrRect &R, int TextInc);
	int __fastcall GetNewObjNo(void);
	AnsiString __fastcall MakeObjHead(int ObjNo);
	AnsiString __fastcall MakeObjRef(int ObjNo);
	void __fastcall AppendXRef(int APos, int ObjNo);
	void __fastcall WriteObj(const AnsiString S, int ObjNo, bool IsObjectComplete);
	
protected:
	virtual AnsiString __fastcall EncodeImage(Quickrpt::TQRPrintable* AControl, const TPsQrRect &R);
	virtual AnsiString __fastcall EncodeGraphicShape(Qrctrls::TQRShape* AControl, const TPsQrRect &R);
	virtual AnsiString __fastcall EncodeShadeAndFrame(const TPsQrRect &R, Graphics::TColor Color, Quickrpt::TQRFrame* 
		Frame, bool Shade, bool IsTextCtl, bool FixHeight, bool FixWidth);
	virtual AnsiString __fastcall GetExtension();
	virtual AnsiString __fastcall GetFilterName();
	virtual TPsQrRect __fastcall GetNativeRect(const TPsQrRect &Rect);
	virtual TPsQRSize __fastcall GetNativeSize(const tagSIZE &Size);
	virtual AnsiString __fastcall GetNativeText(const AnsiString Text);
	virtual Extended __fastcall GetNativeXPos(Extended X);
	virtual Extended __fastcall GetNativeYPos(Extended Y);
	virtual AnsiString __fastcall NumToStr(Extended N);
	virtual void __fastcall BeginJob(void);
	virtual void __fastcall BeginPage(void);
	virtual void __fastcall EncodeText(const AnsiString Text, const TPsQrTextRec &TextRec);
	virtual void __fastcall EndJob(void);
	
public:
	virtual void __fastcall EndPage(void);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRPDFFilter(AnsiString Filename) : TPsQRDocumentFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRPDFFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRRTFFilter;
class PASCALIMPLEMENTATION TPsQRRTFFilter : public TPsQRDocumentFilter 
{
	typedef TPsQRDocumentFilter inherited;
	
private:
	Classes::TStrings* FColorTbl;
	Classes::TStrings* FFontTbl;
	AnsiString FTextAttribResetStr;
	AnsiString FTextAttribSetStr;
	AnsiString __fastcall EncodeFrame(Extended ALeft, Extended ATop, Extended ARight, Extended ABottom)
		;
	AnsiString __fastcall EncodeGraphic(Graphics::TBitmap* Bmp, const TPsQrRect &R, Quickrpt::TQRFrame* 
		Frame, bool DrawFrame);
	AnsiString __fastcall EncodeLine(Extended ALeft, Extended ATop, Extended ARight, Extended ABottom, 
		AnsiString LineAttrib);
	int __fastcall GetColorNumInColorTbl(Graphics::TColor AColor);
	AnsiString __fastcall GetGraphicBorderInfo(const TPsQrRect &R, Quickrpt::TQRFrame* Frame, AnsiString 
		LineAttrib);
	AnsiString __fastcall GetTextBorderInfo(Quickrpt::TQRFrame* Frame);
	
protected:
	virtual AnsiString __fastcall EncodeImage(Quickrpt::TQRPrintable* AControl, const TPsQrRect &R);
	virtual AnsiString __fastcall EncodeGraphicShape(Qrctrls::TQRShape* AControl, const TPsQrRect &R);
	virtual AnsiString __fastcall EncodeShadeAndFrame(const TPsQrRect &R, Graphics::TColor Color, Quickrpt::TQRFrame* 
		Frame, bool Shade, bool IsTextCtl, bool FixHeight, bool FixWidth);
	virtual AnsiString __fastcall GetExtension();
	virtual AnsiString __fastcall GetFilterName();
	virtual TPsQRSize __fastcall GetNativeSize(const tagSIZE &Size);
	virtual AnsiString __fastcall GetNativeText(const AnsiString Text);
	virtual Extended __fastcall GetNativeXPos(Extended X);
	virtual Extended __fastcall GetNativeYPos(Extended Y);
	virtual void __fastcall BeginJob(void);
	virtual void __fastcall BeginPage(void);
	virtual void __fastcall EncodeText(const AnsiString Text, const TPsQrTextRec &TextRec);
	virtual void __fastcall EndJob(void);
	
public:
	virtual void __fastcall BeginText(Qrctrls::TQRCustomLabel* AControl, int X, int Y);
	virtual void __fastcall EndPage(void);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRRTFFilter(AnsiString Filename) : TPsQRDocumentFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRRTFFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRImageFilter;
class PASCALIMPLEMENTATION TPsQRImageFilter : public TPsQRExportFilter 
{
	typedef TPsQRExportFilter inherited;
	
private:
	AnsiString FCurFileName;
	
protected:
	virtual void __fastcall BeginPage(void);
	
public:
	virtual void __fastcall Start(int PaperWidth, int PaperHeight, Graphics::TFont* Font);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRImageFilter(AnsiString Filename) : TPsQRExportFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRImageFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRGIFFilter;
class PASCALIMPLEMENTATION TPsQRGIFFilter : public TPsQRImageFilter 
{
	typedef TPsQRImageFilter inherited;
	
protected:
	virtual AnsiString __fastcall GetExtension();
	virtual AnsiString __fastcall GetFilterName();
	
public:
	virtual void __fastcall EndPage(void);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRGIFFilter(AnsiString Filename) : TPsQRImageFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRGIFFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRJPEGFilter;
class PASCALIMPLEMENTATION TPsQRJPEGFilter : public TPsQRImageFilter 
{
	typedef TPsQRImageFilter inherited;
	
protected:
	virtual AnsiString __fastcall GetExtension();
	virtual AnsiString __fastcall GetFilterName();
	
public:
	virtual void __fastcall EndPage(void);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRJPEGFilter(AnsiString Filename) : TPsQRImageFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRJPEGFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRBMPFilter;
class PASCALIMPLEMENTATION TPsQRBMPFilter : public TPsQRImageFilter 
{
	typedef TPsQRImageFilter inherited;
	
protected:
	virtual AnsiString __fastcall GetExtension();
	virtual AnsiString __fastcall GetFilterName();
	
public:
	virtual void __fastcall EndPage(void);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRBMPFilter(AnsiString Filename) : TPsQRImageFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRBMPFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRMetafileFilter;
class PASCALIMPLEMENTATION TPsQRMetafileFilter : public TPsQRImageFilter 
{
	typedef TPsQRImageFilter inherited;
	
private:
	bool FEnhanced;
	
public:
	virtual void __fastcall EndPage(void);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRMetafileFilter(AnsiString Filename) : TPsQRImageFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRMetafileFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQREMFFilter;
class PASCALIMPLEMENTATION TPsQREMFFilter : public TPsQRMetafileFilter 
{
	typedef TPsQRMetafileFilter inherited;
	
protected:
	virtual AnsiString __fastcall GetExtension();
	virtual AnsiString __fastcall GetFilterName();
	
public:
	virtual void __fastcall Start(int PaperWidth, int PaperHeight, Graphics::TFont* Font);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQREMFFilter(AnsiString Filename) : TPsQRMetafileFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQREMFFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRWMFFilter;
class PASCALIMPLEMENTATION TPsQRWMFFilter : public TPsQRMetafileFilter 
{
	typedef TPsQRMetafileFilter inherited;
	
protected:
	virtual AnsiString __fastcall GetExtension();
	virtual AnsiString __fastcall GetFilterName();
	
public:
	virtual void __fastcall Start(int PaperWidth, int PaperHeight, Graphics::TFont* Font);
public:
	#pragma option push -w-inl
	/* TQRExportFilter.Create */ inline __fastcall TPsQRWMFFilter(AnsiString Filename) : TPsQRMetafileFilter(
		Filename) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPsQRWMFFilter(void) { }
	#pragma option pop
	
};


class DELPHICLASS TPsQRFilters;
class PASCALIMPLEMENTATION TPsQRFilters : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	AnsiString __fastcall GetAbout();
	TPsQRHTMLSettings* __fastcall GetHTML(void);
	TPsQRPDFSettings* __fastcall GetPDF(void);
	TPsQRRTFSettings* __fastcall GetRTF(void);
	TPsQRGIFSettings* __fastcall GetGIF(void);
	TPsQRJPEGSettings* __fastcall GetJPEG(void);
	TPsQRBMPSettings* __fastcall GetBMP(void);
	TPsQRMetafileSettings* __fastcall GetEMF(void);
	TPsQRMetafileSettings* __fastcall GetWMF(void);
	int __fastcall GetImgFileCount(void);
	Classes::TStrings* __fastcall GetImgFileNames(void);
	int __fastcall GetRepFileCount(void);
	Classes::TStrings* __fastcall GetRepFileNames(void);
	TPsQRVisibleFilters __fastcall GetVisibleFilters(void);
	TPsQRNotifyEvent __fastcall GetOnBeginJob();
	TPsQRNotifyEvent __fastcall GetOnBeginPage();
	TPsQRNotifyEvent __fastcall GetOnEndJob();
	TPsQRNotifyEvent __fastcall GetOnEndPage();
	TCreateBitmapEvent __fastcall GetOnCreateBitmap();
	TEncodeGraphicEvent __fastcall GetOnEncodeGraphic();
	TEncodeGraphicDoneEvent __fastcall GetOnEncodeGraphicDone();
	TMakeImgFileNameEvent __fastcall GetOnMakeImgFileName();
	TMakeRepFileNameEvent __fastcall GetOnMakeRepFileName();
	void __fastcall SetAbout(const AnsiString Value);
	void __fastcall SetHTML(TPsQRHTMLSettings* Value);
	void __fastcall SetPDF(TPsQRPDFSettings* Value);
	void __fastcall SetRTF(TPsQRRTFSettings* Value);
	void __fastcall SetGIF(TPsQRGIFSettings* Value);
	void __fastcall SetJPEG(TPsQRJPEGSettings* Value);
	void __fastcall SetBMP(TPsQRBMPSettings* Value);
	void __fastcall SetEMF(TPsQRMetafileSettings* Value);
	void __fastcall SetWMF(TPsQRMetafileSettings* Value);
	void __fastcall SetVisibleFilters(TPsQRVisibleFilters Value);
	void __fastcall SetOnBeginJob(TPsQRNotifyEvent Value);
	void __fastcall SetOnBeginPage(TPsQRNotifyEvent Value);
	void __fastcall SetOnEndJob(TPsQRNotifyEvent Value);
	void __fastcall SetOnEndPage(TPsQRNotifyEvent Value);
	void __fastcall SetOnCreateBitmap(TCreateBitmapEvent Value);
	void __fastcall SetOnEncodeGraphic(TEncodeGraphicEvent Value);
	void __fastcall SetOnEncodeGraphicDone(TEncodeGraphicDoneEvent Value);
	void __fastcall SetOnMakeImgFileName(TMakeImgFileNameEvent Value);
	void __fastcall SetOnMakeRepFileName(TMakeRepFileNameEvent Value);
	
public:
	__fastcall virtual TPsQRFilters(Classes::TComponent* AOwner);
	__fastcall virtual ~TPsQRFilters(void);
	__property int ImgFileCount = {read=GetImgFileCount, nodefault};
	__property Classes::TStrings* ImgFileNames = {read=GetImgFileNames};
	__property int RepFileCount = {read=GetRepFileCount, nodefault};
	__property Classes::TStrings* RepFileNames = {read=GetRepFileNames};
	
__published:
	__property AnsiString About = {read=GetAbout, write=SetAbout, stored=false};
	__property TPsQRHTMLSettings* HTML = {read=GetHTML, write=SetHTML};
	__property TPsQRPDFSettings* PDF = {read=GetPDF, write=SetPDF};
	__property TPsQRRTFSettings* RTF = {read=GetRTF, write=SetRTF};
	__property TPsQRGIFSettings* GIF = {read=GetGIF, write=SetGIF};
	__property TPsQRJPEGSettings* JPEG = {read=GetJPEG, write=SetJPEG};
	__property TPsQRBMPSettings* BMP = {read=GetBMP, write=SetBMP};
	__property TPsQRMetafileSettings* EMF = {read=GetEMF, write=SetEMF};
	__property TPsQRMetafileSettings* WMF = {read=GetWMF, write=SetWMF};
	__property TPsQRVisibleFilters VisibleFilters = {read=GetVisibleFilters, write=SetVisibleFilters, nodefault
		};
	__property TPsQRNotifyEvent OnBeginJob = {read=GetOnBeginJob, write=SetOnBeginJob};
	__property TPsQRNotifyEvent OnBeginPage = {read=GetOnBeginPage, write=SetOnBeginPage};
	__property TPsQRNotifyEvent OnEndJob = {read=GetOnEndJob, write=SetOnEndJob};
	__property TPsQRNotifyEvent OnEndPage = {read=GetOnEndPage, write=SetOnEndPage};
	__property TCreateBitmapEvent OnCreateBitmap = {read=GetOnCreateBitmap, write=SetOnCreateBitmap};
	__property TEncodeGraphicEvent OnEncodeGraphic = {read=GetOnEncodeGraphic, write=SetOnEncodeGraphic
		};
	__property TEncodeGraphicDoneEvent OnEncodeGraphicDone = {read=GetOnEncodeGraphicDone, write=SetOnEncodeGraphicDone
		};
	__property TMakeImgFileNameEvent OnMakeImgFileName = {read=GetOnMakeImgFileName, write=SetOnMakeImgFileName
		};
	__property TMakeRepFileNameEvent OnMakeRepFileName = {read=GetOnMakeRepFileName, write=SetOnMakeRepFileName
		};
};


typedef AnsiString PsQrExport__52[4];

typedef AnsiString PsQrExport__62[4];

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE AnsiString NavWebdingsChars[4];
extern PACKAGE AnsiString NavWingdingsChars[4];
static const Shortint MaxPages = 0x2;
extern PACKAGE TPsQRExportSettings* PsQRExportSettings;

}	/* namespace Psqrexport */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Psqrexport;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// PsQrExport
