unit UDefaultRegistration;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Menus, UProt4Delphi, ClipBrd;

type
  TRegistrationForm = class(TForm)
    Panel1: TPanel;
    Label6: TLabel;
    LabelRegCode: TLabel;
    Panel2: TPanel;
    Label1: TLabel;
    EditCompany: TEdit;
    Label2: TLabel;
    EditName: TEdit;
    Label3: TLabel;
    EditEmail: TEdit;
    Label4: TLabel;
    EditAddress: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    EditPhone: TEdit;
    Panel3: TPanel;
    Label5: TLabel;
    EditRegKey: TEdit;
    BitBtn1: TBitBtn;
    PopupMenu1: TPopupMenu;
    Copiaralclipboard1: TMenuItem;
    procedure BitBtn1Click(Sender: TObject);
    procedure Copytoclipboard1Click(Sender: TObject);
    procedure EditRegKeyKeyPress(Sender: TObject; var Key: Char);
    procedure Copiaralclipboard1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    { Private declarations }
    FProt4Delphi: TProt4Delphi;
  public
    { Public declarations }
    function ShowModal(Prot4Delphi: TProt4Delphi): Integer;
    class procedure CheckAndShowIfNotReg(Prot4Delphi: TProt4Delphi);
  end;

var
  RegistrationForm: TRegistrationForm;

implementation

{$R *.DFM}
uses UProt4DelphiDefs;


class procedure TRegistrationForm.CheckAndShowIfNotReg(Prot4Delphi: TProt4Delphi);
var
  RegFrm            : TRegistrationForm;
begin
  RegFrm := TRegistrationForm.Create(Application);
  try
    Prot4Delphi.Start;
    if not Prot4Delphi.IsRegistered then
      RegFrm.ShowModal(Prot4Delphi);
  finally
    RegFrm.Free;
  end;
end;

function TRegistrationForm.ShowModal(Prot4Delphi: TProt4Delphi): Integer;
begin
  FProt4Delphi := Prot4Delphi;
  if Assigned(FProt4Delphi) then
  begin
    Caption := 'Registration form.' + '  ' + FProt4Delphi.MessageNotRegistered;
    LabelRegCode.Caption := FProt4Delphi.RegistrationCode;
    if Trim(LabelRegCode.Caption) = '' then
    begin
      ShowMessage('Error getting registration code, exiting');
      ExitProcess(0);
    end;
    result := inherited ShowModal;
  end
  else
    result := mrAbort;
end;



procedure TRegistrationForm.BitBtn1Click(Sender: TObject);
begin
  FProt4Delphi.SetRegistrationKey(EditRegKey.Text);
  if FProt4Delphi.IsRegistered then
  begin
    Caption := 'Registration form.' + '  ' + FProt4Delphi.MessageRegistered;
    Sleep(1000);
    Close;
  end;
end;

procedure TRegistrationForm.Copytoclipboard1Click(Sender: TObject);
var
  s                 : string;
begin
  s := LabelRegCode.Caption;
  Clipboard.SetTextBuf(Pchar(s));
end;

procedure TRegistrationForm.EditRegKeyKeyPress(Sender: TObject;
  var Key: Char);
begin
  // Permit backspace
  if Key = #8 then
    Exit;
  Key := ValidateCodeRegKey(Key);
  if Ord(Key) = 0 then
    Windows.Beep(2000, 50);
end;

procedure TRegistrationForm.Copiaralclipboard1Click(Sender: TObject);
var
  RegCode           : string;
  MyClip, OldClip   : TClipboard;
begin
  try
    RegCode := FProt4Delphi.RegistrationCode;
    MyClip := TClipboard.Create;
    try
      OldClip := Clipboard;
      SetClipboard(MyClip);
      MyClip.Clear;
      //    Clipboard.Open;
      MyClip.AsText := RegCode;
      SetClipboard(OldClip);
    finally
      MyClip.Free;
    end;
    //    ClipBoard.Close;
  except
  end;
end;

procedure TRegistrationForm.SpeedButton1Click(Sender: TObject);
{var
  ListaAttch        : TStringList;}
begin
{  ListaAttch := TStringList.Create;
  try
    ListaAttch.Clear;
    ListaAttch.Add(Application.ExeName + '.KEY')}
//      EMail1.AttPathNames := ListaAttch;
  try
{    EMail1.AttPathNames.Add(Application.ExeName + '.KEY');
    EMail1.NoAttachments := False;
    EMail1.Subject := '<Registration of '+ ExtractFileName(Application.ExeName) +' ~~~ '+ FProt4Delphi.RegistrationCode + ' >';
    EMail1.Text :=
      'RegCode: '+ FProt4Delphi.RegistrationCode +
      'Comp:' + EditCompany.Text + #13 + #10 +
      'Name:' + EditName.Text + #13 + #10 +
      'email:' + EditEMail.Text + #13 + #10 +
      'Address:' + EditAddress.Text + #13 + #10 +
      'Phone:' + EditPhone.Text;
    EMail1.CC.Add('rya@labs.df.uba.ar');
    EMail1.SendMail;}
  except
    
  end;
{  finally
    ListaAttch.Free;
  end;}
end;

end.

