(*
*)

unit ChatNDrawForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, ComCtrls, ToolWin, ExtCtrls, StdCtrls, PrismConnection,
  PrismUser, PrismUserInfoDialog, PrismUtils, ScktComp, ColorGrd;

type
  TfrmChatNDraw = class(TForm)
    ToolBar1: TToolBar;
    btnConnect: TToolButton;
    imToolbar: TImageList;
    status: TStatusBar;
    Splitter1: TSplitter;
    Panel1: TPanel;
    Splitter2: TSplitter;
    Panel2: TPanel;
    Edit1: TEdit;
    Memo1: TMemo;
    PaintBox1: TPaintBox;
    prism: TPrismConnection;
    btnSend: TButton;
    btnChatRoom: TToolButton;
    pnlSubject: TPanel;
    lbSubjects: TListBox;
    imFolder: TImage;
    dlgInfo: TPrismUserInfoDialog;
    ClientSocket1: TClientSocket;
    btnDisconnect: TToolButton;
    ToolButton1: TToolButton;
    colorGrid: TColorGrid;
    ToolButton2: TToolButton;
    btnErase: TToolButton;
    ToolButton4: TToolButton;
    btnColor: TToolButton;
    ToolButton5: TToolButton;
    dlgColor: TColorDialog;
    procedure Panel2Resize(Sender: TObject);
    procedure PaintBox1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBox1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnConnectClick(Sender: TObject);
    procedure prismDisconnected(Sender: TObject);
    procedure prismConnected(Sender: TObject);
    procedure prismLoginFailed(Sender: TObject; const Text: String);
    procedure prismServerError(Sender: TObject; const Text: String);
    procedure prismLoginSuccess(Sender: TObject; AUser: TPrismUser);
    procedure btnSendClick(Sender: TObject);
    procedure prismChatReceived(Sender: TObject; const Text, Id: String);
    procedure btnChatRoomClick(Sender: TObject);
    procedure prismJoinSubject(Sender: TObject; const Text: String);
    procedure prismAddSubject(Sender: TObject; const Text: String);
    procedure prismRemoveSubject(Sender: TObject; const Text: String);
    procedure prismAddUser(Sender: TObject; AUser: TPrismUser);
    procedure lbSubjectsDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure prismRemoveUser(Sender: TObject; AUser: TPrismUser);
    procedure lbSubjectsDblClick(Sender: TObject);
    procedure prismUserInfo(Sender: TObject; AUser: TPrismUser);
    procedure prismDataReceived(Sender: TObject; const Text, Id: String);
    procedure FormDestroy(Sender: TObject);
    procedure prismShout(Sender: TObject; const Text: String);
    procedure btnDisconnectClick(Sender: TObject);
    procedure btnEraseClick(Sender: TObject);
    procedure colorGridChange(Sender: TObject);
    procedure btnColorClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    BeginStroke: boolean;
    AUser: TPrismUser;
    bNewUser: boolean;
    sId, sPassword: string;
    bRequestedInfo: boolean;
    sStroke: string;
    strStrokes: TStrings;
    MyColor: TColor;
  public
    procedure processOtherStrokes;
    procedure SetEnabledButtons;
  end;

var
  frmChatNDraw: TfrmChatNDraw;

implementation

uses ConnectionInfoForm;

{$R *.DFM}

procedure TfrmChatNDraw.Panel2Resize(Sender: TObject);
begin
  edit1.Width := Panel2.Width - 8;
end;

procedure TfrmChatNDraw.PaintBox1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if BeginStroke then
  begin
    PaintBox1.Canvas.LineTo( X, Y );
    sStroke := sStroke + ',' + IntToStr( X ) + ',' + IntToStr( Y );
  end;
end;

procedure TfrmChatNDraw.FormShow(Sender: TObject);
begin
  edit1.SetFocus;
  with PaintBox1.Canvas do
  begin
    Brush.Color := clBlack;
    Brush.Style := bsSolid;
    FillRect( ClipRect );
  end;
end;

procedure TfrmChatNDraw.FormCreate(Sender: TObject);
begin
  MyColor := clRed;
  PaintBox1.Canvas.Pen.Color := clRed;
  strStrokes := TStringList.Create;
end;

procedure TfrmChatNDraw.PaintBox1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  PaintBox1.Canvas.Pen.Color := MyColor;
  BeginStroke := true;
  PaintBox1.Canvas.MoveTo( X, Y );
  sStroke := IntToStr( PaintBox1.Canvas.Pen.Color ) + ',' + IntToStr( X ) + ',' +
    IntToStr( Y );
end;

procedure TfrmChatNDraw.PaintBox1MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if BeginStroke then
    prism.SendDataMessage( sStroke );
  BeginStroke := false;
  processOtherStrokes;
end;

(* Draw other strokes that may have come in *)
procedure TfrmChatNDraw.processOtherStrokes;
var
  s, sToken: string;
  x, y: integer;
begin
  while strStrokes.Count > 0 do
  begin
    s := strStrokes[0];
    strStrokes.Delete( 0 );
    sToken := getToken( s, ',' );
    with PaintBox1.Canvas do
    begin
      Pen.Color := StrToInt( sToken );
      x := StrToInt( getToken( s, ',' ) );
      y := StrToInt( getToken( s, ',' ) );
      MoveTo( x, y );
      while s <> '' do
      begin
        x := StrToInt( getToken( s, ',' ) );
        y := StrToInt( getToken( s, ',' ) );
        LineTo( x, y );
      end;
    end;
  end;
end;

procedure TfrmChatNDraw.btnConnectClick(Sender: TObject);
begin
  frmConnectionInfo := TfrmConnectionInfo.Create( nil );
  if frmConnectionInfo.ShowModal = mrOk then
  begin
    //prism.Host := frmConnectionInfo.edtHostAddress.Text;
    prism.Port := frmConnectionInfo.spinPort.Value;
    sId := frmConnectionInfo.edtUserId.Text;
    sPassword := frmConnectionInfo.edtPassword.Text;
    bNewUser := frmConnectionInfo.bNewUser;
    AUser := frmConnectionInfo.AUser;
    prism.Active := true;
  end;
  frmConnectionInfo.Free;
end;

procedure TfrmChatNDraw.prismDisconnected(Sender: TObject);
begin
  status.SimpleText := 'You''ve been disconnected';
  SetEnabledButtons;
  lbSubjects.Clear;
end;

procedure TfrmChatNDraw.prismConnected(Sender: TObject);
begin
  status.SimpleText := 'Connected';
  if bNewUser then
    prism.LoginNew( sId, AUser.toString )
  else
    prism.Login( sId, sPassword );
end;

procedure TfrmChatNDraw.prismLoginFailed(Sender: TObject;
  const Text: String);
begin
  status.SimpleText := Text;
  prism.Active := false;
end;

procedure TfrmChatNDraw.prismServerError(Sender: TObject;
  const Text: String);
begin
  status.SimpleText := Text;
end;

procedure TfrmChatNDraw.prismLoginSuccess(Sender: TObject;
  AUser: TPrismUser);
begin
  status.SimpleText := 'You are now logged into ChatNDraw Server';
  SetEnabledButtons;
end;

procedure TfrmChatNDraw.btnSendClick(Sender: TObject);
begin
  prism.SendChatMessage( edit1.Text );
  memo1.Lines.Add( prism.CurrentUser.Id + '> ' + edit1.Text );
  edit1.Text := '';
end;

procedure TfrmChatNDraw.prismChatReceived(Sender: TObject; const Text,
  Id: String);
begin
  memo1.Lines.Add( Id + ': ' + Text );
end;

procedure TfrmChatNDraw.btnChatRoomClick(Sender: TObject);
var
  s: string;
begin
  if prism.Active then
  begin
    s := InputBox( 'Create Chat Room', 'Chat Room Name', '' );
    if s <> '' then
      prism.CreateSubject( s );
  end;
end;

procedure TfrmChatNDraw.prismJoinSubject(Sender: TObject;
  const Text: String);
var
  i: integer;
begin
  pnlSubject.Caption := 'You are in ' + Text;
  for i := lbSubjects.Items.Count - 1 downto 0 do
    if lbSubjects.Items[i][1] = 'U' then
      lbSubjects.Items.Delete( i );
  PaintBox1.Refresh;
end;

procedure TfrmChatNDraw.prismAddSubject(Sender: TObject;
  const Text: String);
begin
  lbSubjects.Items.AddObject( 'S' + Text, imFolder.Picture.Bitmap );
end;

procedure TfrmChatNDraw.prismRemoveSubject(Sender: TObject;
  const Text: String);
var
  i: integer;
begin
  i := lbSubjects.Items.IndexOf( 'S' + Text );
  if i >= 0 then
    lbSubjects.Items.Delete( i );
end;

procedure TfrmChatNDraw.prismAddUser(Sender: TObject; AUser: TPrismUser);
var
  i: integer;
begin
  i := lbSubjects.Items.IndexOf( 'S' + prism.CurrentSubject );
  if i >= 0 then
    lbSubjects.Items.InsertObject( i + 1, 'U' + AUser.Id, AUser.Glyph );
end;

procedure TfrmChatNDraw.lbSubjectsDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var
  bm: TBitmap;
  s: string;
  x, y: integer;
begin
  with lbSubjects.Canvas do
  begin
    if odSelected in State then
    begin
      Brush.Color := clHighlight;
      Font.Color := clWhite;
    end
    else
    begin
      Brush.Color := clWindow;
      Font.Color := clBlack;
    end;
    Brush.Style := bsSolid;
    FillRect( Rect );
    s := lbSubjects.Items[Index];
    bm := TBitmap( lbSubjects.Items.Objects[Index] );
    x := Rect.Left + ( 32 - bm.Width ) div 2;
    y := Rect.Top + ( 32 - bm.Height ) div 2;
    if s[1] = 'U' then
      Inc( x, 8 );
    Draw( x, y, bm );
    y := Rect.Top + ( 32 - TextHeight( s ) ) div 2;
    Inc( x, 38 );
    TextOut( x, y, Copy( s, 2, Length( s ) ) );
  end;
end;

procedure TfrmChatNDraw.prismRemoveUser(Sender: TObject;
  AUser: TPrismUser);
var
  i: integer;
begin
  i := lbSubjects.Items.IndexOf( 'U' + AUser.Id );
  if i >= 0 then
    lbSubjects.Items.Delete( i );
end;

procedure TfrmChatNDraw.lbSubjectsDblClick(Sender: TObject);
var
  s: string;
begin
  s := lbSubjects.Items[lbSubjects.ItemIndex];
  if s[1] = 'S' then
    prism.JoinSubject( Copy( s, 2, Length( s ) ) )
  else
  begin
    bRequestedInfo := true;
    prism.RequestUserInfo( Copy( s, 2, Length( s ) ) );
  end;
end;

procedure TfrmChatNDraw.prismUserInfo(Sender: TObject; AUser: TPrismUser);
var
  i: integer;
begin
  if bRequestedInfo then
  begin
    bRequestedInfo := false;
    if dlgInfo.Execute( AUser, ( AUser = prism.CurrentUser ) ) then
      prism.UpdateUserInfo;
  end;
  i := lbSubjects.Items.IndexOf( 'U' + AUser.Id );
  if i >= 0 then
  begin
    lbSubjects.Items.Objects[i] := AUser.Glyph;
    lbSubjects.Refresh;
  end;
end;

procedure TfrmChatNDraw.prismDataReceived(Sender: TObject; const Text,
  Id: String);
begin
  if Text[1] = 'E' then
    PaintBox1.Refresh
  else
  begin
    strStrokes.Add( Text );
    if not BeginStroke then
      processOtherStrokes;
  end;
end;

procedure TfrmChatNDraw.FormDestroy(Sender: TObject);
begin
  strStrokes.Free;
end;

procedure TfrmChatNDraw.prismShout(Sender: TObject; const Text: String);
begin
  Memo1.Lines.Add( 'SYSOP: ' + Text );
  MessageBeep( MB_ICONEXCLAMATION );
end;

procedure TfrmChatNDraw.btnDisconnectClick(Sender: TObject);
begin
  prism.Active := false;
  status.SimpleText := '';
  SetEnabledButtons;
  lbSubjects.Clear;
end;

procedure TfrmChatNDraw.SetEnabledButtons;
begin
  btnConnect.Enabled := not prism.Active;
  btnDisconnect.Enabled := prism.Active;
  btnChatRoom.Enabled := prism.Active;
end;

procedure TfrmChatNDraw.btnEraseClick(Sender: TObject);
begin
  PaintBox1.Refresh;
  prism.SendDataMessage( 'E' );
end;

procedure TfrmChatNDraw.colorGridChange(Sender: TObject);
begin
  MyColor := colorGrid.ForegroundColor;
end;

procedure TfrmChatNDraw.btnColorClick(Sender: TObject);
begin
  dlgColor.Color := MyColor;
  if dlgColor.Execute then
    MyColor := dlgColor.Color;
end;

procedure TfrmChatNDraw.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  prism.Active := false;
end;

end.
