unit patchmf;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, patcher, Spin;

type
  TMainform = class(TForm)
    patchmaker: Tpatchmaker;
    oldfile: TEdit;
    newfile: TEdit;
    patchfile: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    exit: TButton;
    make: TButton;
    ProgressBar: TProgressBar;
    buffsize: TSpinEdit;
    Label5: TLabel;
    scanspeed: TSpinEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    filedlg: TOpenDialog;
    Button4: TButton;
    procedure exitClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure patchmakerprogress(progress: Double);
    procedure makeClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Mainform: TMainform;

implementation

{$R *.DFM}

procedure TMainform.exitClick(Sender: TObject);
begin
close;
end;

procedure TMainform.FormShow(Sender: TObject);
begin
buffsize.value:=patchmaker.buffersize;
patchfile.text:=patchmaker.patchfile;
scanspeed.value:=patchmaker.scanspeed;
end;

procedure TMainform.patchmakerprogress(progress: Double);
begin
progressbar.position:=trunc(progress*100);
end;

procedure TMainform.makeClick(Sender: TObject);
var
tm:tdatetime;
begin
tm:=time;
progressbar.position:=0;
progressbar.visible:=true;
patchmaker.oldfile:=oldfile.text;
patchmaker.newfile:=newfile.text;
patchmaker.patchfile:=patchfile.text;
patchmaker.buffersize:=buffsize.value;
patchmaker.scanspeed:=scanspeed.value;
patchmaker.makepatch;
progressbar.visible:=false;
end;

procedure TMainform.Button1Click(Sender: TObject);
begin
filedlg.execute;
oldfile.text:=filedlg.filename;
end;

procedure TMainform.Button3Click(Sender: TObject);
begin
filedlg.execute;
newfile.text:=filedlg.filename;
end;

procedure TMainform.Button2Click(Sender: TObject);
begin
filedlg.execute;
patchfile.text:=filedlg.filename;
end;

procedure TMainform.Button4Click(Sender: TObject);
var
tm:tdatetime;
begin
tm:=time;
progressbar.position:=0;
progressbar.visible:=true;
patchmaker.oldfile:=oldfile.text;
patchmaker.newfile:=newfile.text;
patchmaker.compress;
progressbar.visible:=false;
end;

end.
