unit patchfrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  patcher, StdCtrls;

type
  TMainform = class(TForm)
    patchmaker: Tpatchmaker;
    patchfile: TEdit;
    Button1: TButton;
    Label1: TLabel;
    progressmemo: TMemo;
    Make: TButton;
    Exitbtn: TButton;
    OpenDialog: TOpenDialog;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ExitbtnClick(Sender: TObject);
    procedure MakeClick(Sender: TObject);
    procedure patchmakerorderprogress(progress: string);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Mainform: TMainform;

implementation

{$R *.DFM}

procedure TMainform.FormShow(Sender: TObject);
var
f:tsearchrec;
begin
if findfirst('*.pto',faanyfile,f)=0 then patchfile.text:=f.name;
findclose(f);
progressmemo.clear;
end;

procedure TMainform.Button1Click(Sender: TObject);
begin
if opendialog.execute then patchfile.text:=opendialog.filename;
end;

procedure TMainform.ExitbtnClick(Sender: TObject);
begin
close;
end;

procedure TMainform.MakeClick(Sender: TObject);
begin
if patchfile.text='' then exit;
patchmaker.orderfile:=patchfile.text;
progressmemo.lines.add('BEGIN...');
patchmaker.applyorder;
progressmemo.lines.add('...END');
end;

procedure TMainform.patchmakerorderprogress(progress: string);
begin
progressmemo.lines.add(progress);
end;

end.
