unit OutlTree;
{/*****************************************************************/
 /  Copyright (c) 1998 IMCA SYSTEMS                                /
 /  All Rights Reserved.
 /  Creation Date: 06.08.98                                        /
 /  Version 1.02b
 /  MODULE: TreeView width Edited data cell with Inplace Edits     /
 /          and StateButtons (Outlined Grid)                       /
 /  NOTES:                                                         /
 /  HISTORY:                                                       /
 / Knowledge Problem:
 /  1. Setting Value to PopupCheckListBox
 /*****************************************************************/}
{

   First of all, thank you for registering of the TOutlineTreeView
   package. I hope you will enjoy these components and you
   will find them useful.

   YOU MAY use the components and classes from this unit in any your
   (or your company's) FREEWARE/SHAREWARE or COMMERCIAL application.

   YOU MAY derive your own components based on components from
   this unit as you like, but ONLY with UNREGISTERED version
   of CoolMenus and if someone else will decide to use it they
   will have to register TOutlineTreeView too.

   YOU MAY NOT DISTRIBUTE REGISTERED VERSION OF COOLMENUS.
   IT WILL BE VIOLATION OF INTERNATIONAL COPYRIGHT LAWS.

   And after all please respect my copyrigt, hours of hard
   work I spent on these components and YOURSELF.


   COMPILING THE SHAREWARE vs REGISTERED , DELPHI vs C++ BUILDER VERSION
   ---------------------------------------------------------------------
   This code contains both the shareware and registered, and both
   Borland Delphi and Borland C++ Builder versions of the CoolMenus.

   To compile the registered version please make sure the following line
   is included below:

    {$define Registered}

   //All distributed source code versions should have this line by default.
   //You don't have to remove anything manually to decrease application size.


{Define Registered}
{$Define Delphi}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Commctrl,ComCtrls,mask,stdctrls,menus,CheckLst;

const
  STATE_NONESELECTED = 1;
  STATE_ALLSELECTED = 2;
  STATE_SOMESELECTED = 3;
  STATE_OPTION_ON = 4;
  STATE_OPTION_OFF = 5;

type
   EOutlineTreeError = class(EXception);
   TEditStyle = (etsSimple, etsEllipsis, etsPickList, etsCheckList, etsAuto);
   TTreeOption=(totShowLines,totShowLogic,totShowButtons,totNopaintNoChilds,totDrawGrid,totResizeCols,totEditing,totAlwaysShowEditor);
   TTreeOptions = set of TTreeOption;
   TStateChangingEvent = procedure(Node: TTreeNode; var AllowChange: Boolean ) of object;
   TStateChangeEvent = procedure(Node: TTreeNode; Oldindex : integer) of object;
   //inplace
   TTreeGetNodeDataEvent = procedure(Node: TTreeNode; Var aData : string;var PwdChar: boolean;Var MaxLength : integer ) of object;
   TTreeValidateNodeDataEvent = procedure(Node: TTreeNode; aData : string) of object;
   TTreeEditButtonClickEvent = procedure(Node: TTreeNode) of object;
   TTreeIsReadOnlyNodeEvent = procedure(Node: TTreeNode; var aReadOnly : boolean) of object;
   TTreeGetPicklistEvent = procedure(Node: TTreeNode; var aPickList : Tstrings) of object;
   TTreeGetEditStyleEvent= procedure(Node: TTreeNode; Var aEditStyle : TEditStyle) of object;

  TPopupListbox = class;
  TOutlineTreeView=class;

  TSelection = record
    StartPos, EndPos: Integer;
  end;

  TCustomInplaceEdit = class(TCustomEdit)//TCustomMaskEdit
  private
    FTree: TOutlineTreeView;
    FClickTime: Longint;
    FCancelData:boolean;
    procedure InternalMove(const Loc: TRect; Redraw: Boolean);
    //procedure SetGrid(Value: TCustomGrid);
    procedure CMShowingChanged(var Message: TMessage); message CM_SHOWINGCHANGED;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMPaste(var Message); message WM_PASTE;
    procedure WMCut(var Message); message WM_CUT;
    procedure WMClear(var Message); message WM_CLEAR;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure DblClick; override;
    function DoMouseWheel(Shift: TShiftState; WheelDelta: Integer;
      MousePos: TPoint): Boolean; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    procedure BoundsChanged; virtual;
    procedure UpdateContents; virtual;
    procedure WndProc(var Message: TMessage); override;
    procedure CreateWnd; override;
    property  Tree: TOutlineTreeView read FTree write FTree;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Deselect;
    procedure Hide;
    procedure Invalidate;
    procedure Move(const Loc: TRect);
    function PosEqual(const Rect: TRect): Boolean;
    procedure SetFocus; //reintroduce;
    procedure UpdateLoc(const Loc: TRect);
    function Visible: Boolean;
  end;

  TOutInplaceEdit = class(TCustomInplaceEdit)
  private
    FButtonWidth: Integer;

    FPickList: TCustomListbox;//TPopupListbox;
    FActiveList: TWinControl;

    FEditStyle: TEditStyle;
    FListVisible: Boolean;
    FTracking: Boolean;
    FPressed: Boolean;
    procedure ListMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SetEditStyle(Value: TEditStyle);
    procedure StopTracking;
    procedure TrackButton(X,Y: Integer);
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CancelMode;
    procedure WMCancelMode(var Message: TMessage); message WM_CancelMode;
    procedure WMKillFocus(var Message: TMessage); message WM_KillFocus;

    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk); message wm_LButtonDblClk;
    procedure WMPaint(var Message: TWMPaint); message wm_Paint;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SetCursor;
    function OverButton(const P: TPoint): Boolean;
    function ButtonRect: TRect;
    //procedure DrawEllipsisBtn(DC : HDC);
    //procedure DrawPicklistBtn(DC : HDC);

  protected
    procedure BoundsChanged; override;
    procedure CloseUp(Accept: Boolean);
    procedure DoDropDownKeys(var Key: Word; Shift: TShiftState);
    procedure DropDown;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure PaintWindow(DC: HDC); override;
    procedure UpdateContents; override;
    procedure WndProc(var Message: TMessage); override;
    property  EditStyle: TEditStyle read FEditStyle write SetEditStyle;
    property  ActiveList: TWinControl read FActiveList write FActiveList;
    procedure CreateWnd; override;
    property  PickList: TCustomListbox read FPickList;
  public
    constructor Create(Owner: TComponent); override;
  end;
  { TPopupListbox }

  TPopupListbox = class(TCustomListbox)
  private
    FSearchText: String;
    FSearchTickCount: Longint;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure KeyPress(var Key: Char); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  end;

  TPopupCheckListbox = class(TCheckListBox)
  private
    FSearchText: String;
    FSearchTickCount: Longint;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure KeyPress(var Key: Char); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    function GetStrValue : string;
    procedure SetStrValue(Value : string);
    function GetValue : LongInt;
    procedure SetValue(Value: LongInt);
  public
    property Value : Longint read GetValue write SetValue;
    property StrValue : string read GetStrValue write SetStrValue;
  end;

  TOutlineTreeView = class(TCustomTreeView)
  private
    { Private declarations }
    //inplace
    Fcursor : Hcursor;
    FInplaceEdit: TOutInplaceEdit;
    FEditedNode : TTreeNode;
    FEditorMode : boolean;
    FClickKey : TshortCut;
    FLineVisible:boolean;
    FnewSize:integer;
    FLineDC: HDC;
    FFlat : Boolean;
    FTreeOptions : TTreeOptions;
    FMouseIn : Boolean;
    FShowHeaders : Boolean;
    FWidthOutline: integer;
    FHeadersHeight : integer;
    fOnMouseLeave:TNotifyEvent;
    fOnMouseEnter:TNotifyEvent;
    FValuesText,FPropText : string;

    GetNodeData : TTreeGetNodeDataEvent;
    ValidateNodeData : TTreeValidateNodeDataEvent;
    EditButtonClick : TTreeEditButtonClickEvent;
    IsReadOnlyNode : TTreeIsReadOnlyNodeEvent;
    GetPicklist : TTreeGetPicklistEvent;
    GetEditStyle : TTreeGetEditStyleEvent;

    FonStateChanging : TStateChangingEvent;
    FonStateChange : TStateChangeEvent;
    FOldCustomDraw: TTVCustomDrawEvent;
    FOldCustomDrawItem: TTVCustomDrawItemEvent;
    FoldExpanded : TTVExpandedEvent;
    FoldCollapsed: TTVExpandedEvent;
    FButtonCheckedStored : Boolean;
    FButtonUnCheckedStored : Boolean;
    FButtonGrayedStored: boolean;
    FButtonOptionedStored : Boolean;
    FButtonUnOptionedStored : Boolean;
    FButtonCollapsedStored  : Boolean;
    FButtonExpandedStored : Boolean;
    FButtonNonChildStored : Boolean;
    FBackgroundColorStored : Boolean;
    FSelBackgroundColorStored : Boolean;
    //FButtonsizeStored : Boolean;
    FLButtonDown :Boolean;
    FButtonChecked : TBitmap;
    FButtonUnChecked : TBitmap;
    FButtonGrayed : TBitmap;
    FButtonOptioned : TBitmap;
    FButtonUnOptioned : TBitmap;
    FButtonCollapsed  : Tbitmap;
    FButtonExpanded : TBitmap;
    FButtonNonChild : TBitmap;
    FBackgroundColor : TColor;
    FSelBackgroundColor: TColor;

    procedure SetFlat(Value : Boolean);
    procedure RedrawBorder (const Clip: HRGN);


    procedure SetButtonChecked(aValue :Tbitmap);
    procedure  SetButtonUnChecked(aValue :Tbitmap);
    procedure SetButtonGrayed(aValue :Tbitmap);
    procedure  SetButtonOptioned(aValue :Tbitmap);
    procedure  SetButtonUnOptioned(aValue :Tbitmap);
    procedure  SetButtonCollapsed(aValue :Tbitmap);
    procedure  SetButtonExpanded(aValue :Tbitmap);
    procedure  SetButtonNonChild(aValue :Tbitmap);
    procedure  SetBackgroundColor(aValue :TColor);
    procedure  SetSelBackgroundColor(aValue :TColor);

    Procedure  SetWidthOutline(newvalue : integer);
    Procedure SetHeadersHeight(value : integer);
    Procedure SetShowheaders(Value : Boolean);
    Procedure SetValuesText(value : string);
    Procedure SetPropText(value : string);
    Procedure UpdateNode(Node : TTreeNode);
    function GetStateIndex(const Node: TTreeNode): Integer;
    //look & feel
    procedure CMEnabledChanged (var Message: TMessage); message CM_ENABLEDCHANGED;
    procedure aWMSetFocus(var Msg: TWMSetFocus); //message WM_SETFOCUS;
    procedure aWMKillFocus(var Msg: TWMKillFocus); //message WM_KILLFOCUS;
    procedure CMMouseEnter(var message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var message: TMessage); message CM_MOUSELEAVE;
    procedure WMNCCalcSize (var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCPaint (var Message: TMessage); message WM_NCPAINT;
    procedure WMNCMouseMove(var Message: TWMNCMouseMove); message WM_NCMOUSEMOVE;
    procedure WMNClButtonUp(var Message: TWMNCLButtonUp); message WM_NCLBUTTONUP;
    procedure WMNClButtonDown(var Message: TWMNCLButtonDown); message WM_NCLBUTTONDOWN;
    procedure WMNCHitTest(var Msg: TWMNCHitTest); message WM_NCHITTEST;
    procedure WMSetCursor(var Message: TWMSetCursor); message WM_SetCursor;
    //inplace
    procedure WMChar(var Msg: TWMChar); message WM_CHAR;
    procedure WMCommand(var Message: TWMCommand); message WM_COMMAND;
    procedure WMGetDlgCode(var Msg: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure WMKillFocus(var Msg: TWMKillFocus); message WM_KILLFOCUS;
    procedure WMLButtonDown(var Message: TMessage); message WM_LBUTTONDOWN;
    procedure WMSetFocus(var Msg: TWMSetFocus); message WM_SETFOCUS;
    procedure WMCancelMode(var Msg: TWMCancelMode); message WM_CANCELMODE;
    procedure CMCancelMode(var Msg: TMessage); message CM_CANCELMODE;
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    procedure CMWantSpecialKey(var Msg: TCMWantSpecialKey); message CM_WANTSPECIALKEY;
    procedure KeyPress(var Key: Char); override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    //sizing
    procedure StopSizing;
    procedure ReleaseLineDC;
    procedure DrawLine;
    procedure AllocateLineDC;
    //inplace
    procedure ShowEditor;
    procedure ShowEditorChar(Ch: Char);
    procedure HideEditor;
    //procedure InvalidateEditor;
    function CreateEditor: TOutInplaceEdit;
    procedure UpdateEdit;
    procedure HideEdit;
    procedure UpdateText;

  protected
    { Protected declarations }
    procedure Loaded; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    //procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;

    procedure Expanded(Sender: TObject; Node: TTreeNode);
    procedure Collapsed(Sender: TObject; Node: TTreeNode);

    Procedure DrawItem(Sender: TCustomTreeView; Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
    Procedure Draw(Sender: TCustomTreeView; const ARect: TRect; var DefaultDraw: Boolean);
    Procedure DrawSplit(Sender: TCustomTreeView; aRect : TRect);

    procedure SetTreeOptions(Value: TTreeOptions);
    //inplace
    //procedure AGetNodeData(Node: TTreeNode; Var aData : string);
    procedure GetEditText(Node: TTreeNode; Var aData: string; var aPwdChar : boolean; Var MaxLength : integer);

    procedure AValidateNodeData(Node: TTreeNode; aData : string);
    procedure AEditButtonClick(Node: TTreeNode);
    procedure AIsReadOnlyNode(Node: TTreeNode; var aReadOnly : Boolean);
    procedure AGetPicklist(Node: TTreeNode; var aPickList : Tstrings);
    procedure AGetEditStyle(Node: TTreeNode; Var aEditStyle : TEditStyle);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent);override;
    destructor  Destroy;override;

    procedure NodeStateRefreshParent(const Node: TTreeNode);
    procedure NodeStateRefreshChildren(Node: TTreeNode);
    //  OptionButton
    procedure NodeStateRefreshSiblings(const Node: TTreeNode);
    procedure NodeStateRefresh(const Node: TTreeNode);
    procedure Toggle(Node : TtreeNode);
    procedure RefreshTreeStates;
    property EditorMode : boolean read FEditorMode;
  published
    //new
    property ClickKey : TshortCut read FClickKey write FClickKey default VK_F2;
    property TreeOptions : TTreeOptions read FTreeOptions write SetTreeOptions;
    property OnMouseEnter:TNotifyEvent read fonmouseenter write fonmouseenter;
    property OnMouseLeave:TNotifyEvent read fonmouseleave write fonmouseleave;
    property Flat : Boolean read FFlat write SetFlat stored true;
    property WidthOutline: integer read FWidthOutline write SetWidthOutline;
    property ShowHeaders : Boolean read FShowHeaders write SetShowheaders;
    property HeadersHeight : integer read FHeadersHeight write SetHeadersHeight;
    property ValuesText : string read FValuesText write SetValuesText;
    property PropText : string read FPropText write SetPropText;
    property OnStateChanging : TStateChangingEvent read FonStateChanging write FonStateChanging;
    property OnStateChange : TStateChangeEvent read FonStateChange write FonStateChange;
    property OnGetNodeData : TTreeGetNodeDataEvent read GetNodeData write GetNodeData;
    property OnValidateNodeData : TTreeValidateNodeDataEvent read ValidateNodeData write ValidateNodeData;
    property OnEditButtonClick : TTreeEditButtonClickEvent read EditButtonClick write EditButtonClick;
    property OnIsReadOnlyNode : TTreeIsReadOnlyNodeEvent read IsReadOnlyNode write IsReadOnlyNode;
    property OnGetPicklist : TTreeGetPicklistEvent read GetPicklist write GetPicklist;
    property OnGetEditStyle : TTreeGetEditStyleEvent read GetEditStyle write GetEditStyle;

    property ButtonChecked : TBitmap read FButtonChecked write SetButtonChecked stored true;
    property ButtonUnChecked : TBitmap read FButtonUnChecked write SetButtonUnChecked stored true;
    property ButtonGrayed : TBitmap read FButtonGrayed write SetButtonGrayed stored true;
    property ButtonOptioned : TBitmap read FButtonOptioned write SetButtonOptioned stored true;
    property ButtonUnOptioned : TBitmap read FButtonUnOptioned write SetButtonUnOptioned stored true;
    property ButtonCollapsed  : Tbitmap read FButtonCollapsed write SetButtonCollapsed stored true;
    property ButtonExpanded : TBitmap read FButtonExpanded write SetButtonExpanded stored true;
    property ButtonNonChild : TBitmap read FButtonNonChild write SetButtonNonChild stored true;
    //property LineHorz  : TBitmap read FHorzLine write SetHorzLine;
    //property LineVert : TBitmap read FVertLine write SetVertLine;
    property BackgroundColor : TColor read FBackgroundColor write SetBackgroundColor;

    property SelectedBackgroundColor : TColor read FSelBackgroundColor write SetSelBackgroundColor;
    //property Buttonsize : integer read FButtonsize write SetButtonsize  default 11;
    { Published declarations }

    property Align;
    property Anchors;
    property AutoExpand;
    property BiDiMode;
    property BorderStyle;
    property ChangeDelay;
    property Ctl3D;
    property Constraints;
    property DragKind;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property Images;
    property Indent;
    property Items;
    property ParentBiDiMode;
    property ParentColor default False;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property SortType;
    property TabOrder;
    property TabStop default True;
    property Visible;
    property OnChange;
    property OnChanging;
    property OnClick;
    property OnCollapsing;
    property OnCollapsed;
    property OnCompare;
    property OnDblClick;
    property OnDeletion;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnExpanding;
    property OnExpanded;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;

  end;

{$R *.RES}
procedure Register;

implementation

end.

