unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, OutlTree, StdCtrls, CheckLst;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Memo1: TMemo;
    TabSheet2: TTabSheet;
    OutlineTreeView1: TOutlineTreeView;
    Label1: TLabel;
    TabSheet3: TTabSheet;
    OutlineTreeView2: TOutlineTreeView;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    TabSheet4: TTabSheet;
    OutlineTreeView3: TOutlineTreeView;
    Label5: TLabel;
    Label6: TLabel;
    TabSheet5: TTabSheet;
    OutlineTreeView4: TOutlineTreeView;
    CheckListBox1: TCheckListBox;
    Label7: TLabel;
    procedure RefreshOptions;
    procedure OutlineTreeView1GetEditStyle(Node: TTreeNode;
      var aEditStyle: TEditStyle);
    procedure OutlineTreeView1GetNodeData(Node: TTreeNode;
      var aData: String; var PwdChar: Boolean; var MaxLength: Integer);
    procedure OutlineTreeView1ValidateNodeData(Node: TTreeNode;
      aData: String);
    procedure OutlineTreeView3GetEditStyle(Node: TTreeNode;
      var aEditStyle: TEditStyle);
    procedure OutlineTreeView3GetPicklist(Node: TTreeNode;
      var aPickList: TStrings);
    procedure OutlineTreeView3IsReadOnlyNode(Node: TTreeNode;
      var aReadOnly: Boolean);
    procedure OutlineTreeView3ValidateNodeData(Node: TTreeNode;
      aData: String);
    procedure OutlineTreeView3GetNodeData(Node: TTreeNode;
      var aData: String; var PwdChar: Boolean; var MaxLength: Integer);
    procedure OutlineTreeView3EditButtonClick(Node: TTreeNode);
    procedure CheckListBox1ClickCheck(Sender: TObject);
    procedure OutlineTreeView4GetEditStyle(Node: TTreeNode;
      var aEditStyle: TEditStyle);
    procedure OutlineTreeView4GetNodeData(Node: TTreeNode;
      var aData: String; var PwdChar: Boolean; var MaxLength: Integer);
    procedure OutlineTreeView4IsReadOnlyNode(Node: TTreeNode;
      var aReadOnly: Boolean);
    procedure TabSheet5Show(Sender: TObject);
  private
    { Private declarations }
    aPwdData : string;
    apwdNode : TTreeNode;
    s1,s2,s3,s4,s5:string;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.OutlineTreeView1GetEditStyle(Node: TTreeNode;
  var aEditStyle: TEditStyle);
begin
   aEditStyle:=etssimple;
end;

procedure TForm1.OutlineTreeView1GetNodeData(Node: TTreeNode;
  var aData: String; var PwdChar: Boolean; var MaxLength: Integer);
begin
    if apwdNode<>nil then
    begin
       if Node=apwdnode then
       begin
         aData:=aPwdData;
         Pwdchar:=true;
       end;
    end
    else aData:='';
end;

procedure TForm1.OutlineTreeView1ValidateNodeData(Node: TTreeNode;
  aData: String);
begin
   if not Node.HasChildren then
   begin
   apwdnode:=Node;
   aPwdData:=aData;
   ShowMessage('Password Accepted');
   end
   else ShowMessage('Only For Departments:Access Denied');
end;

procedure TForm1.OutlineTreeView3GetEditStyle(Node: TTreeNode;
  var aEditStyle: TEditStyle);
begin
     Case Node.ImageIndex of
        3: aEditStyle:=etsPickList;
        4: aEditStyle:=etsCheckList;
        5: aEditStyle:=etsEllipsis;
        else aEditStyle:=etsSimple;
     end;
end;

procedure TForm1.OutlineTreeView3GetPicklist(Node: TTreeNode;
  var aPickList: TStrings);
begin

   Case Node.Imageindex of
     3:
     with aPickList do
     begin
         add('PickList String1');
         add('PickList String2');
         add('PickList String3');
         add('PickList String4');
         add('PickList String5');
         add('PickList String6');
     end;
     4:
     with aPickList do
     begin
         add('Check1');
         add('Check2');
         add('Check3');
         add('Check4');
         add('Check5');
         add('Check6');
         //TPopupCheckListbox(aPickList).Strvalue:=S4;
     end;

   end;
end;

procedure TForm1.OutlineTreeView3IsReadOnlyNode(Node: TTreeNode;
  var aReadOnly: Boolean);
begin
   areadOnly:= Node.Imageindex=6;
end;

procedure TForm1.OutlineTreeView3ValidateNodeData(Node: TTreeNode;
  aData: String);
begin
    Case node.Imageindex of
       1: S1:=Adata;
       2: S2:=Adata;
       3: S3:=Adata;
       4: S4:=Adata;
       5: S5:=Adata;
       6: adata:='Read Only Node!';
    end;
end;

procedure TForm1.OutlineTreeView3GetNodeData(Node: TTreeNode;
  var aData: String; var PwdChar: Boolean; var MaxLength: Integer);
begin
    Case Node.ImageIndex of
      1: aData:=S1;
      2: begin Adata:=s2; PwdChar:=true; end;
      3: aData:=S3;
      4: Adata:=S4;
      5: Adata:=S5;
      6: Adata:='Read Only Node!';
    end;
end;

procedure TForm1.OutlineTreeView3EditButtonClick(Node: TTreeNode);
begin
   S5:= inputBox('Input Value for Node:'+Node.Text,'Input String Value:',s5);
end;

procedure TForm1.RefreshOptions;
begin
 with OutlineTreeView4 do
 begin
  CheckListBox1.Checked[ord(totShowLines)]:=totShowLines in TreeOptions;
  CheckListBox1.Checked[ord(totShowLogic)]:=totShowLogic in TreeOptions;
  CheckListBox1.Checked[ord(totShowButtons)]:=totShowButtons in TreeOptions;
  CheckListBox1.Checked[ord(totNopaintNoChilds)]:=totNopaintNoChilds in TreeOptions;
  CheckListBox1.Checked[ord(totDrawGrid)]:=totDrawGrid in TreeOptions;
  CheckListBox1.Checked[ord(totResizeCols)]:=totResizeCols in TreeOptions;
  CheckListBox1.Checked[ord(totEditing)]:=totEditing in TreeOptions;
  CheckListBox1.Checked[ord(totAlwaysShowEditor)]:=totAlwaysShowEditor in TreeOptions;
 end;
 CheckListBox1.invalidate;
end;
procedure TForm1.CheckListBox1ClickCheck(Sender: TObject);
var aflag: boolean;
    i:integer;
    aTreeOptions : TTreeOptions;
begin
    For i:=0 to CheckListBox1.Items.count-1 do

    begin
        aflag:= CheckListBox1.Checked[i];
        Case i of
          Ord(totShowLines):
             if aflag then
               include(aTreeOptions,totShowLines)
             else
               exclude(aTreeOptions,totShowLines);
          Ord(totShowLogic):
             if aflag then
               include(aTreeOptions,totShowLogic)
             else
               exclude(aTreeOptions,totShowLogic);
          Ord(totShowButtons):
             if aflag then
               include(aTreeOptions,totShowButtons)
             else
               exclude(aTreeOptions,totShowButtons);
          Ord(totNopaintNoChilds):
             if aflag then
               include(aTreeOptions,totNopaintNoChilds)
             else
               exclude(aTreeOptions,totNopaintNoChilds);
          Ord(totDrawGrid):
             if aflag then
               include(aTreeOptions,totDrawGrid)
             else
               exclude(aTreeOptions,totDrawGrid);
          Ord(totResizeCols):
             if aflag then
               include(aTreeOptions,totResizeCols)
             else
               exclude(aTreeOptions,totResizeCols);
          Ord(totEditing):
             if aflag then
               include(aTreeOptions,totEditing)
             else
               exclude(aTreeOptions,totEditing);
          Ord(totAlwaysShowEditor):
             if aflag then
               include(aTreeOptions,totAlwaysShowEditor)
             else
               exclude(aTreeOptions,totAlwaysShowEditor);
        end;
    end;
    OutlineTreeView4.TreeOptions:=aTreeOptions;
end;

procedure TForm1.OutlineTreeView4GetEditStyle(Node: TTreeNode;
  var aEditStyle: TEditStyle);
begin
    Aeditstyle:=etssimple;
end;

procedure TForm1.OutlineTreeView4GetNodeData(Node: TTreeNode;
  var aData: String; var PwdChar: Boolean; var MaxLength: Integer);
begin
    aData:=Node.Text;
end;

procedure TForm1.OutlineTreeView4IsReadOnlyNode(Node: TTreeNode;
  var aReadOnly: Boolean);
begin
    areadOnly:=false;
end;

procedure TForm1.TabSheet5Show(Sender: TObject);
begin
    RefreshOptions;
end;

end.
